/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.replay;

import de.proveo.util.date.DateUtil;
import de.proveo.util.observable.interfaces.PingThreadListener;
import de.proveo.util.observable.interfaces.ServletBlocker;
import de.proveo.wwt.logic.ejb.dataOut.replay.ReplayDataFacade;
import de.proveo.wwt.logic.ejb.dataOut.replay.ReplayDataFacadeUtil;
import de.proveo.wwt.logic.ejb.general.version.WwtVersion;
import de.proveo.wwt.logic.ejb.general.version.WwtVersionUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.PingThread;
import de.proveo.wwt.logic.servlet.dataIn.stands.util.StatusChecker;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCallImpl;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.GetAPReplayUnitTreeHandler;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplayClient
implements PingThreadListener {
    private static final Log log = LogFactory.getLog(ReplayClient.class);
    protected RemoteClient client = null;
    private PingThread pingThread;
    private boolean isReplayClientDeleted = false;
    private ServletBlocker servletBlocker;
    private long toTime = 1L;
    private long fromTime = 1L;
    private ReplayDataFacade replayDataFacade;
    private WwtVersion wwtVersion = null;
    private long unitGroupId;
    private boolean isAdmin;

    public ReplayClient(ServletBlocker servlet, RemoteClient client, long unitGroupId, boolean isAdmin) {
        this.client = client;
        this.servletBlocker = servlet;
        this.isAdmin = isAdmin;
        this.unitGroupId = unitGroupId;
        this.startPingThread();
        try {
            this.replayDataFacade = ReplayDataFacadeUtil.getHome().create();
            this.wwtVersion = WwtVersionUtil.getHome().create();
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setTime(long from, long to) {
        this.fromTime = from;
        this.toTime = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectAndSendData() {
        String method = "collectAndSendData: ";
        try {
            log.debug((Object)(method + "start."));
            boolean sendUnitsData = false;
            boolean sendNotifiesData = false;
            boolean sendUseMsgsData = false;
            boolean sendInfomanMsgsData = false;
            boolean sendStandsData = false;
            String typesOfInterest = this.client.getProperties().getProperty("TypeOfInterest", "");
            if (typesOfInterest.indexOf("units") != -1) {
                sendUnitsData = true;
            }
            if (typesOfInterest.indexOf("notify_messages") != -1) {
                sendNotifiesData = true;
            }
            if (typesOfInterest.indexOf("use_messages") != -1) {
                sendUseMsgsData = true;
            }
            if (typesOfInterest.indexOf("infoman_messages") != -1) {
                sendInfomanMsgsData = true;
            }
            if (typesOfInterest.indexOf("stands") != -1 && !(sendStandsData = new StatusChecker().isRunning())) {
                log.warn((Object)"FIS server logic is deactivated but an airport map tries to retrieve FIS replay data!");
            }
            HashMap<String, Object> stamps = new HashMap<String, Object>();
            if (this.fromTime != this.toTime) {
                String sFrom = DateUtil.getDatestring4Timestamp((long)this.fromTime);
                String sTo = DateUtil.getDatestring4Timestamp((long)this.toTime);
                log.debug((Object)(method + "*** fetch ReplayData for time frame " + sFrom + " - " + sTo));
                HashMap replayData = this.replayDataFacade.getReplayData(this.unitGroupId, this.fromTime, this.toTime, this.isAdmin, sendUnitsData, sendNotifiesData, sendUseMsgsData, sendInfomanMsgsData, sendStandsData);
                if (replayData == null) {
                    log.error((Object)(method + "Replay not available on this server! Break."));
                } else {
                    stamps.putAll(replayData);
                    stamps.put("Java_Version", System.getProperty("java.version"));
                    stamps.put("RTS_Version", this.wwtVersion.getVersionInfo("implVersion"));
                    stamps.put("ServerTime", System.currentTimeMillis());
                    stamps.put("ServerTimeZone", TimeZone.getDefault().getID());
                    if (sendUnitsData) {
                        Object unitTree;
                        Object unitIdentitiesObj;
                        Set<Object> unitPermissions = new HashSet();
                        Map initialContext = (Map)replayData.get("InitialContext");
                        if (initialContext != null && (unitIdentitiesObj = initialContext.get("unitIdentityValues")) != null) {
                            HashMap unitIdentities = (HashMap)unitIdentitiesObj;
                            unitPermissions = unitIdentities.keySet();
                        }
                        ByteArrayOutputStream unitTreeXML = new ByteArrayOutputStream();
                        SimpleXMLRPCCallImpl call = new SimpleXMLRPCCallImpl();
                        GetAPReplayUnitTreeHandler handler = new GetAPReplayUnitTreeHandler();
                        call.setMethod(handler.getMethodName());
                        call.addParameter("isAdmin", this.isAdmin);
                        call.addParameter("unitGroupId", this.unitGroupId);
                        call.addParameter("permissions", unitPermissions);
                        try {
                            handler.init();
                            unitTree = handler.execute(call);
                        }
                        catch (Exception ex) {
                            IOException ioEx = new IOException();
                            ioEx.initCause(ex);
                            throw ioEx;
                        }
                        XMLEncoder resultEncoder = new XMLEncoder(unitTreeXML);
                        resultEncoder.setPersistenceDelegate(UnitTreeNode.class, new DefaultPersistenceDelegate(new String[]{"unitModelValue", "unitIdentityValue", "unitTypeIdentityValue"}));
                        resultEncoder.writeObject(unitTree);
                        resultEncoder.close();
                        stamps.put("unitTreeXML", new String(unitTreeXML.toByteArray()));
                    }
                }
            } else {
                stamps.put("ReplayData", new TreeMap());
            }
            log.debug((Object)(method + "replay data will be send"));
            this.client.sendObject(stamps);
            log.debug((Object)(method + "all data flushed"));
            this.client.closeOutputStream();
        }
        catch (RemoteException e) {
            log.error((Object)(method + "RemoteException occurs."), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)(method + "IOException occurs."), (Throwable)e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Calling deleteReplayClient() ..."));
            }
            this.deleteReplayClient();
        }
    }

    public void setServletBlocker(ServletBlocker servletBlocker) {
        this.servletBlocker = servletBlocker;
    }

    public void ping() throws JMSException {
        try {
            this.client.sendObject("p");
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ping() runs into IOException! Probably the client was shut down. ReplayClient will be shut down.");
            }
            this.deleteReplayClient();
        }
        catch (NullPointerException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)"ping() runs into NullPointerException! ReplayClient will be shut down.");
            }
            this.deleteReplayClient();
        }
    }

    public synchronized void deleteReplayClient() {
        if (!this.isReplayClientDeleted) {
            try {
                this.pingThread.stopRunning();
                this.pingThread = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"PingThread stoped... shutting down servletBlocker...");
                }
                this.servletBlocker.stopRunning();
                this.isReplayClientDeleted = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReplayClient " + this.toString() + " deleted!"));
                }
            }
            catch (NullPointerException e) {
                log.error((Object)"deleteReplayClient runs into NullPointerException!", (Throwable)e);
            }
        }
    }

    private void startPingThread() {
        this.pingThread = new PingThread();
        this.pingThread.setListener(this);
        this.pingThread.start();
    }

    public void cleanUp() {
    }

    public String getClientName() {
        return "";
    }

    public void setMarkedForShutdown(boolean markedForShutdown) {
    }
}

