/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut;

import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationClientServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ConfigurationClientServlet.class);
    ConfigurationClient cc;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public synchronized void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String key;
        String method = "doPost(): ";
        String value = "";
        response.setContentType("text/html");
        if (log.isDebugEnabled()) {
            log.debug((Object)(method + "complete request='" + request.getQueryString() + "'"));
        }
        if ((key = request.getParameter("key")) == null || key.length() < 1) {
            log.error((Object)(method + "parameter 'key' missing."));
            throw new ServletException("parameter 'key' missing.");
        }
        String def = request.getParameter("default");
        try {
            if (def == null || def.length() < 1) {
                try {
                    value = this.cc.getParameter(key);
                }
                catch (ConfigurationParameterNotFoundException ex) {
                    log.error((Object)(method + "ConfigurationClient.getParameter() runs into ConfigurationParamterNotFoundException"));
                    log.error((Object)(method + ": configuration parameter '" + key + "' not found"));
                }
            } else {
                value = this.cc.getParameter(key, def);
            }
            log.debug((Object)(method + ": found configuration parameter '" + key + "' = " + value));
        }
        catch (RemoteException ex) {
            log.error((Object)(method + "ConfigurationClient.getParameter() runs into RemoteException"));
        }
        PrintWriter out = response.getWriter();
        out.write(value);
        out.close();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.cc = new ConfigurationClient();
    }
}

