/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.threads;

import de.proveo.util.observable.interfaces.PingThreadListener;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingThread
extends Thread {
    private static final Log log = LogFactory.getLog(PingThread.class);
    private ConfigurationClient configurationClient;
    private InformantClient informantClient = null;
    private PingThreadListener pingThreadListener = null;
    private boolean isRunning = true;
    private boolean reset = false;
    private int timeToPing = 30000;
    private int timeToPingBuffer = 0;

    public PingThread() {
        log.debug((Object)"PingThread started!");
        this.informantClient = new InformantClient();
        try {
            this.configurationClient = new ConfigurationClient();
            this.timeToPingBuffer = this.timeToPing = Integer.parseInt(this.configurationClient.getParameter("observable.pingthread.latency"));
        }
        catch (RemoteException e) {
            log.error((Object)("PingThread() runs into RemoteException: " + e));
            this.informantClient.notify("AllDataThread() runs into RemoteException: " + e, "UnitErrorEvent");
        }
        catch (NumberFormatException e) {
            log.error((Object)("PingThread() runs into NumberFormatException: " + e));
            this.informantClient.notify("AllDataThread() runs into NumberFormatException: " + e, "UnitErrorEvent");
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("PingThread() runs into ConfigurationParameterNotFoundException: " + (Object)((Object)e)));
            this.informantClient.notify("AllDataThread() runs into CreateConfigurationParameterNotFoundExceptionException: " + (Object)((Object)e), "UnitErrorEvent");
        }
    }

    public void removeListener() {
        this.pingThreadListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimer() {
        this.timeToPing = this.timeToPingBuffer;
        try {
            PingThread pingThread = this;
            synchronized (pingThread) {
                this.reset = true;
                this.notify();
            }
        }
        catch (Exception e) {
            log.error((Object)"resetTimer() runs into Exception: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            this.reset = false;
            try {
                PingThread pingThread = this;
                synchronized (pingThread) {
                    double timeToPingInMinutes = (double)this.timeToPing / 60000.0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PingThread sleeping for " + timeToPingInMinutes + " minutes" + this.toString()));
                    }
                    this.wait(this.timeToPing);
                }
                if (this.isRunning && !this.reset) {
                    this.pingThreadListener.ping();
                    log.debug((Object)("run() - Thread sends a ping to the client!" + this.toString()));
                    continue;
                }
                if (this.isRunning) continue;
                log.debug((Object)("PingThread stopped. Leaving Thread-run()." + this.toString()));
            }
            catch (InterruptedException e) {
                log.warn((Object)"run() runs into InterruptedException: ", (Throwable)e);
                this.informantClient.notify("run() runs into InterruptedException: " + e, "UnitErrorEvent");
            }
            catch (JMSException e) {
                log.error((Object)("run() runs into JMSException! Probably the client was shut down. Session will be unsubscribed!" + this.toString()));
                this.pingThreadListener.setMarkedForShutdown(true);
            }
        }
    }

    public void setListener(PingThreadListener pingThreadListener) {
        this.pingThreadListener = pingThreadListener;
    }

    public void stopRunning() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping PingThread..." + this.toString()));
        }
        this.isRunning = false;
    }
}

