/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.data;

import de.proveo.util.observable.exceptions.NoAirportMapUnitException;
import de.proveo.util.observable.interfaces.UnitBulkDataUpdateListener;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacade;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClientFactory;
import de.proveo.wwt.logic.servlet.dataIn.observable.data.GSEDataUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.UnitBulkDataUpdateThread;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitBulkData
implements UnitBulkDataUpdateListener,
MessageListener {
    private Set<Map<String, Object>> allStampsByDBSet = null;
    private Map<Long, Map<String, Object>> allStampsByDBMap = null;
    UnitBulkDataUpdateThread updateBulkDataThread = null;
    private MapClientFacade mapClientFacade = null;
    private ObservableClientFactory observableClientFactory = null;
    private boolean reconnected = false;
    protected LinkedList<SerializableEventWrapper> unitEventBufferLinkedList = null;
    protected boolean unitsEventBufferActive = true;
    private static final Log log = LogFactory.getLog(UnitBulkData.class);
    String selector = "";
    GSEDataUtil gseDataUtil = null;

    public UnitBulkData(String selector) {
        this.selector = selector;
        this.gseDataUtil = new GSEDataUtil();
        this.allStampsByDBSet = new HashSet<Map<String, Object>>();
        this.allStampsByDBMap = new HashMap<Long, Map<String, Object>>();
        try {
            this.mapClientFacade = MapClientFacadeUtil.getHome().create();
        }
        catch (RemoteException e) {
            log.error((Object)"UnitDataKeeper runs into : ", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"UnitDataKeeper runs into : ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"UnitDataKeeper runs into : ", (Throwable)e);
        }
        this.updateBulkData();
        log.debug((Object)"Initial bulk data received!");
        this.establishJMSConnection();
        this.startUpdateBulkDataThread();
    }

    private void startUpdateBulkDataThread() {
        this.updateBulkDataThread = new UnitBulkDataUpdateThread();
        this.updateBulkDataThread.setListener(this);
        this.updateBulkDataThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBulkData() {
        try {
            Set<Map<String, Object>> set = this.allStampsByDBSet;
            synchronized (set) {
                this.allStampsByDBSet = this.mapClientFacade.getOnlineMapData(true, true, true, null, null, -1L);
                this.convertSetToMap();
            }
        }
        catch (RemoteException e) {
            log.error((Object)"updateBulkData runs into RemoteException: ", (Throwable)e);
        }
    }

    private void convertSetToMap() {
        for (HashMap hashMap : this.allStampsByDBSet) {
            if (!hashMap.containsKey("UnitId")) continue;
            long unitID = (Long)hashMap.get("UnitId");
            this.allStampsByDBMap.put(unitID, hashMap);
        }
    }

    public void cleanUp() {
        this.updateBulkDataThread.stopRunning();
        this.updateBulkDataThread.removeListener();
        this.updateBulkDataThread = null;
    }

    public Set getAllStampsByDB() {
        return this.allStampsByDBSet;
    }

    private void establishJMSConnection() {
        this.reconnected = false;
        try {
            InitialContext ctx = new InitialContext();
            Topic topic = null;
            TopicSession session = null;
            TopicSubscriber subscriber = null;
            TopicConnectionFactory fact = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            final TopicConnection connect = fact.createTopicConnection();
            connect.setExceptionListener(new ExceptionListener(){
                public static final int NUM_RETRIES = 3;
                boolean exceptionFlag = false;

                public synchronized void onException(JMSException ex) {
                    if (this.exceptionFlag) {
                        return;
                    }
                    this.exceptionFlag = true;
                    for (int i = 0; i < 3; ++i) {
                        log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                        try {
                            connect.close();
                        }
                        catch (Exception e2) {
                            1 v0 = this;
                            log.error((Object)"ExceptionLister is not able to close the connection!");
                        }
                        UnitBulkData.this.establishJMSConnection();
                        if (UnitBulkData.this.reconnected) {
                            log.info((Object)"Connection re-established");
                            return;
                        }
                        log.warn((Object)"Re-creating connection failed, retrying ...");
                    }
                }
            });
            session = connect.createTopicSession(false, 2);
            try {
                topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
            }
            catch (NameNotFoundException ex) {
                topic = session.createTopic("topic/proveoDataProviderTopic");
                ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
            }
            subscriber = session.createSubscriber(topic, this.selector, true);
            subscriber.setMessageListener((MessageListener)this);
            connect.start();
            this.reconnected = true;
        }
        catch (NamingException e) {
            log.error((Object)"establishJMSConnection runs into NamingException: ", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"establishJMSConnection runs into JMSException: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            Serializable _object = ((ObjectMessage)message).getObject();
            SerializableEventWrapper event = (SerializableEventWrapper)_object;
            HashMap eventMap = this.gseDataUtil.createFittingEventMap(event);
            if (eventMap == null) {
                log.error((Object)"Event map cannot be created! onMessage() cannot proceed!");
                return;
            }
            long unitID = (Long)eventMap.get("UnitId");
            Map<String, Object> stamp = null;
            Set<Map<String, Object>> set = this.allStampsByDBSet;
            synchronized (set) {
                stamp = this.allStampsByDBMap.get(unitID);
                if (stamp == null) {
                    if (eventMap.get("EventType").equals("data_type_notification_event")) {
                        eventMap = this.gseDataUtil.createStampWithNotifyMsg(eventMap, unitID);
                    } else {
                        try {
                            eventMap = (HashMap)this.mapClientFacade.addUnitIdentityBasicData(eventMap, Long.valueOf(unitID));
                        }
                        catch (RemoteException e) {
                            log.error((Object)"sendMessageToClient runs into RemoteException: ", (Throwable)e);
                        }
                        catch (NoAirportMapUnitException e) {
                            log.trace((Object)"Problems while retrieving GSE data. Is A/P map flag missing? Pls. check data!");
                        }
                    }
                    this.allStampsByDBMap.put(unitID, eventMap);
                    this.allStampsByDBSet.add(eventMap);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Unit ID " + unitID + " hasn't been found in local GSE data even with client permissions. Seems to be new - system creates a new item!"));
                    }
                } else if (eventMap.get("EventType").equals("data_type_notification_event")) {
                    TreeMap<String, HashMap> notifyEvents = (TreeMap<String, HashMap>)stamp.get("NotifyEvents");
                    if (notifyEvents == null) {
                        notifyEvents = new TreeMap<String, HashMap>();
                        stamp.put("NotifyEvents", notifyEvents);
                    }
                    Long timeStamp = (Long)eventMap.get("NotifyTimestamp");
                    Long msgID = (Long)eventMap.get("NotifyMessageID");
                    notifyEvents.put(timeStamp + "_" + msgID, eventMap);
                } else {
                    stamp.putAll(eventMap);
                }
                message.acknowledge();
            }
        }
        catch (JMSException e) {
            log.error((Object)"onMessage runs into JMSException: ", (Throwable)e);
        }
        catch (RemoteException e) {
            log.error((Object)"onMessage runs into RemoteException: ", (Throwable)e);
        }
        catch (NoAirportMapUnitException e) {
            log.error((Object)"onMessage runs into NoAirportMapUnitException: ", (Throwable)e);
        }
    }

    public boolean isVisibleByAPMapFlag(Long unitID) {
        return (Boolean)this.allStampsByDBMap.get(unitID).get("UnitAirportMapFlag");
    }

    public void setAPMapFlagByUnitID(Long unitID, boolean isVisible) {
        this.allStampsByDBMap.get(unitID).put("UnitAirportMapFlag", isVisible);
    }

    public boolean isGeoEventAvailable(Long unitID) {
        return this.allStampsByDBMap.get(unitID) != null && this.allStampsByDBMap.get(unitID).get("GpsGga") != null && this.allStampsByDBMap.get(unitID).get("GpsRmc") != null;
    }
}

