/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.wwt.logic.app.util.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteClient {
    private HttpServletRequest request = null;
    private ObjectOutputStream objectOutputStream = null;
    private Properties properties = null;
    private static final Log log = LogFactory.getLog(RemoteClient.class);
    private boolean dataCompressionEnabled = false;
    private Stopwatch stopwatch = null;
    private long lastSendObjectToClient = System.currentTimeMillis();

    public RemoteClient(HttpServletRequest request, ObjectOutputStream servletOutputStream) {
        this.request = request;
        this.objectOutputStream = servletOutputStream;
        this.properties = this.getPropertiesFromRequest(request);
        this.properties.setProperty("remoteAddress", request.getRemoteAddr());
        this.dataCompressionEnabled = Boolean.parseBoolean(this.properties.getProperty("compress"));
        this.stopwatch = new Stopwatch(this.getClass(), "StopWatch");
    }

    public synchronized void sendObject(Object obj) throws IOException {
        this.lastSendObjectToClient = System.currentTimeMillis();
        if (this.dataCompressionEnabled) {
            this.objectOutputStream.writeObject(this.compressObj(obj));
        } else {
            this.objectOutputStream.writeObject(obj);
        }
        this.objectOutputStream.flush();
        this.objectOutputStream.reset();
    }

    public Object compressObj(Object obj) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream arrayOutputStream2 = new ByteArrayOutputStream();
        byte[] compressedObj = null;
        try {
            this.stopwatch.start("Compression");
            ObjectOutputStream oos1 = new ObjectOutputStream(new GZIPOutputStream(arrayOutputStream));
            oos1.writeObject(obj);
            oos1.flush();
            oos1.close();
            compressedObj = arrayOutputStream.toByteArray();
            this.stopwatch.stop("Compression", true);
            ObjectOutputStream oos2 = new ObjectOutputStream(arrayOutputStream2);
            oos2.writeObject(obj);
            oos2.flush();
            oos2.close();
            int compressedSize = compressedObj.length;
            int uncompressedSize = arrayOutputStream2.toByteArray().length;
            int reducedPercentSize = 100 - compressedSize * 100 / uncompressedSize;
            log.debug((Object)("Data volume reduced due to compression: " + (uncompressedSize - compressedSize) + " byte (" + reducedPercentSize + "%)"));
        }
        catch (IOException e) {
            log.debug((Object)"compressObj() runs into IOException: ", (Throwable)e);
        }
        return compressedObj;
    }

    public synchronized void closeOutputStream() throws IOException {
        this.objectOutputStream.close();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    protected Properties getPropertiesFromRequest(HttpServletRequest request) {
        Properties event = new Properties();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            event.setProperty(key, request.getParameter(key));
        }
        return event;
    }

    public long getLastSendObjectToClient() {
        return this.lastSendObjectToClient;
    }
}

