/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.util.ByteUtil;
import de.proveo.util.observable.exceptions.NoAirportMapUnitException;
import de.proveo.util.observable.interfaces.ClientBulkUpdateListener;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.filter.MapFilter;
import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacade;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.Configuration;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.version.WwtVersion;
import de.proveo.wwt.logic.ejb.general.version.WwtVersionUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.data.GSEDataUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.pool.ClientBulkUpdateRunnableObj;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.pool.MapTimerTask;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCallImpl;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.GetAPVisibleUnitTreeHandler;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableUnitsClient
implements ClientBulkUpdateListener {
    private static final Log log = LogFactory.getLog(ObservableUnitsClient.class);
    private HashSet<Long> unitPermissions;
    boolean notifyPermissions = false;
    private InformantClient informantClient = null;
    private Set<HashMap<String, Object>> clientData = null;
    private ConcurrentHashMap<Long, HashMap<String, Object>> allStampsForMapClient = null;
    private MapClientFacade mapClientFacade = null;
    private MapFilter mapFilter = new MapFilter();
    private ObservableClient observableClient = null;
    private Set<Long> allClientUnitIDs = null;
    private WwtVersion wwtVersion = null;
    private Configuration serverConfiguration;
    String infomanKeepaliveTimeout;
    private LoginContextUtil loginContextUtil;
    private Map<String, Object> serverSideFilter;
    private ClientBulkUpdateRunnableObj clientBulkUpdateThread = null;
    private Timer updateTimer = null;
    private GSEDataUtil gseDataUtil = null;
    long delay = -1L;
    long period = -1L;
    boolean firstTimeExcecution = true;
    LoginContext lc = null;

    public ObservableUnitsClient(ObservableClient observableClient) {
        this.observableClient = observableClient;
        this.informantClient = new InformantClient();
        this.mapFilter = new MapFilter();
        this.allStampsForMapClient = new ConcurrentHashMap();
        this.gseDataUtil = new GSEDataUtil();
        this.delay = Long.parseLong(this.gseDataUtil.getParameter("observable.clientbulkdatathread.delay", null));
        this.period = Long.parseLong(this.gseDataUtil.getParameter("observable.clientbulkdatathread.period", null));
        this.infomanKeepaliveTimeout = this.gseDataUtil.getParameter("infoman.keepalive.timeout", "180");
        log.debug((Object)("found infoman keepalive timeout '" + this.infomanKeepaliveTimeout + "'..."));
        try {
            this.mapClientFacade = MapClientFacadeUtil.getHome().create();
            this.wwtVersion = WwtVersionUtil.getHome().create();
            this.serverConfiguration = ConfigurationUtil.getHome().create();
        }
        catch (RemoteException e) {
            log.error((Object)("ObservableUnitsClient() runs into RemoteException: " + e.toString()), (Throwable)e);
            this.informantClient.notify("ObservableUnitsClient() runs into RemoteException: " + e, "UnitErrorEvent");
        }
        catch (CreateException e) {
            log.error((Object)("ObservableUnitsClient() runs into CreateException: " + e.toString()), (Throwable)e);
            this.informantClient.notify("ObservableUnitsClient() runs into CreateException: " + (Object)((Object)e), "UnitErrorEvent");
        }
        catch (NamingException e) {
            log.error((Object)("ObservableUnitsClient() runs into NamingException: " + e.toString()), (Throwable)e);
            this.informantClient.notify("ObservableUnitsClient() runs into NamingException: " + e, "UnitErrorEvent");
        }
        try {
            this.notifyPermissions = this.getNotifyPermission();
        }
        catch (Exception e) {
            log.error((Object)"Error occured while checking notify permissions!", (Throwable)e);
        }
        this.scheduleNextUpdateThread(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAllStampsToClient() {
        if (log.isDebugEnabled()) {
            String pattern = "HH:mm:ss";
            SimpleDateFormat formater = new SimpleDateFormat(pattern);
            log.debug((Object)"******************** Sending: ObservableUNITS  *****************************");
            log.debug((Object)("******************** sendAllStampsToClient:  " + formater.format(System.currentTimeMillis())));
            log.debug((Object)"****************************************************************************");
        }
        this.doLogin(this.observableClient.getUsername(), this.observableClient.getPassword());
        this.updateClientPermissions();
        if (this.serverSideFilter == null) {
            this.setServerSideFilter();
        }
        if (!this.observableClient.isMarkedForShutdown()) {
            try {
                log.debug((Object)"sendAllStampsToClient: Start");
                this.observableClient.unitsEventBufferActive = true;
                boolean infomanMessagesNeeded = this.observableClient.selector.indexOf("InfomanMessages") != -1;
                boolean notifyMessagesNeeded = this.observableClient.selector.indexOf("InfomanNotifyMessages") != -1 && this.notifyPermissions;
                boolean useMessagesNeeded = this.observableClient.selector.indexOf("UseEvent") != -1;
                long unitGroupId = this.observableClient.getUnitGroupId();
                this.checkDataAvailability();
                Set set = this.observableClient.getUnitBulkData().getAllStampsByDB();
                synchronized (set) {
                    this.clientData = this.mapClientFacade.checkPermissionsAndRequest(this.observableClient.getUnitBulkData().getAllStampsByDB(), this.observableClient.getUsername(), this.observableClient.getPassword(), unitGroupId, infomanMessagesNeeded, notifyMessagesNeeded, useMessagesNeeded);
                }
                if (this.unitPermissions == null) {
                    log.error((Object)"sendAllStampsToClient: No unitPermissions from mapClientFacade received!!!!");
                }
                HashMap filteredTmpData = null;
                ConcurrentHashMap<Long, HashMap<String, Object>> concurrentHashMap = this.allStampsForMapClient;
                synchronized (concurrentHashMap) {
                    filteredTmpData = this.mapFilter.filterData(this.clientData);
                    this.allStampsForMapClient.clear();
                    this.allStampsForMapClient.putAll(filteredTmpData);
                }
                log.trace((Object)"All data has been updated!");
                this.allClientUnitIDs = new HashSet<Long>(this.allStampsForMapClient.keySet());
                HashMap<String, Object> mcr = new HashMap<String, Object>();
                mcr.put("Java_Version", System.getProperty("java.version"));
                mcr.put("RTS_Version", this.wwtVersion.getVersionInfo("implVersion"));
                if (filteredTmpData != null) {
                    mcr.put("Stamps", filteredTmpData);
                } else {
                    log.error((Object)"filteredTmpData is NULL and cannot be added!");
                }
                mcr.put("DataType", "units");
                this.addTreeAndServerData(unitGroupId, mcr, this.isAdmin());
                log.debug((Object)"sendAllStampsToClient: Prepare finished --> Start sending to the Client.");
                this.sendResponse(mcr);
                log.debug((Object)"sendAllStampsToClient: Sending all stamps finished.");
                if (this.observableClient.unitEventBufferLinkedList.size() > 0) {
                    log.debug((Object)"sendAllStampsToClient: Finally sending buffer content...");
                    this.observableClient.sendEventBufferToClient();
                } else {
                    this.observableClient.unitsEventBufferActive = false;
                    log.debug((Object)"sendAllStampsToClient: EventBuffer deactivated!");
                }
                log.debug((Object)"sendAllStampsToClient: All stamps sent to client!");
            }
            catch (RemoteException re) {
                log.error((Object)"sendAllStampsToClient: runs into RemoteException!", (Throwable)re);
                this.observableClient.setMarkedForShutdown(true);
            }
            catch (Exception e) {
                log.error((Object)"sendAllStampsToClient: Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!", (Throwable)e);
                this.observableClient.setMarkedForShutdown(true);
            }
        } else {
            log.warn((Object)"sendAllStampsToClient: Client is marked for Shutdown.");
            this.cleanUp();
        }
        this.doLogout();
    }

    private void addTreeAndServerData(long unitGroupId, Map<String, Object> mcr, boolean isAdmin) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream unitTreeXML = this.getUnitTree(isAdmin, unitGroupId);
        mcr.put("unitTreeXML", new String(unitTreeXML.toByteArray(), "utf-8"));
        mcr.put("ServerTime", System.currentTimeMillis());
        mcr.put("ServerTimeZone", TimeZone.getDefault().getID());
        mcr.put("ServerInfomanKeepaliveTimeout", this.infomanKeepaliveTimeout);
    }

    private boolean isAdmin() {
        boolean isAdmin = false;
        if (this.loginContextUtil == null) {
            try {
                this.loginContextUtil = new LoginContextUtil(this.observableClient.getUsername(), this.observableClient.getPassword());
                isAdmin = this.loginContextUtil.isSuperAdmin() || this.loginContextUtil.isUserInRole("section.airportmap_admin");
            }
            catch (Exception ex) {
                log.error((Object)"LoginContextUtil runs into: ", (Throwable)ex);
            }
        } else {
            isAdmin = this.loginContextUtil.isSuperAdmin() || this.loginContextUtil.isUserInRole("section.airportmap_admin");
        }
        return isAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDataAvailability() {
        Set set = this.observableClient.getUnitBulkData().getAllStampsByDB();
        synchronized (set) {
            if (this.observableClient.getUnitBulkData().getAllStampsByDB() != null) {
                return true;
            }
            ObservableUnitsClient observableUnitsClient = this;
            synchronized (observableUnitsClient) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"getFilteredUnitData runs into InterruptedException: ", (Throwable)e);
                }
                this.checkDataAvailability();
            }
        }
        return false;
    }

    private ByteArrayOutputStream getUnitTree(boolean isSuperAdmin, long unitGroupId) throws IOException {
        Object unitTree;
        ByteArrayOutputStream unitTreeXML = new ByteArrayOutputStream();
        SimpleXMLRPCCallImpl call = new SimpleXMLRPCCallImpl();
        GetAPVisibleUnitTreeHandler handler = new GetAPVisibleUnitTreeHandler();
        call.setMethod(handler.getMethodName());
        call.addParameter("isAdmin", isSuperAdmin);
        call.addParameter("unitGroupId", unitGroupId);
        try {
            handler.init();
            unitTree = handler.execute(call);
        }
        catch (Exception ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
        XMLEncoder resultEncoder = new XMLEncoder(unitTreeXML);
        resultEncoder.writeObject(unitTree);
        resultEncoder.close();
        return unitTreeXML;
    }

    private char[] plainStringToSHA1(String input) {
        MessageDigest md = null;
        byte[] byteHash = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("NoSuchAlgorithmException caught! " + e.getMessage()));
        }
        md.reset();
        md.update(input.getBytes());
        byteHash = md.digest();
        String resultString = ByteUtil.toHexString((byte[])byteHash);
        return resultString.toCharArray();
    }

    protected void cleanUp() {
        this.resetTimers();
        this.doLogout();
    }

    protected void handleMessage(SerializableEventWrapper event) throws JMSException, NoAirportMapUnitException {
        if (this.serverSideFilter == null) {
            this.setServerSideFilter();
        }
        if (this.observableClient.unitsEventBufferActive && !this.observableClient.isMarkedForShutdown()) {
            this.observableClient.unitEventBufferLinkedList.addLast(event);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.toString() + " - handleMessage(): Event sent to buffer!"));
            }
        } else {
            this.sendMessageToClient(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessageToClient(SerializableEventWrapper eventWrapper) throws JMSException, NoAirportMapUnitException {
        Map stamp;
        String method = "sendMessageToClient(): ";
        HashMap eventMap = this.gseDataUtil.createFittingEventMap(eventWrapper);
        String eventType = (String)eventMap.get("EventType");
        if (eventMap == null) {
            return;
        }
        long unitID = (Long)eventMap.get("UnitId");
        boolean permission = this.checkPermission(eventMap);
        if (!permission) {
            return;
        }
        if (!this.observableClient.getUnitBulkData().isVisibleByAPMapFlag(unitID) || !this.observableClient.getUnitBulkData().isGeoEventAvailable(unitID) && !eventMap.get("EventType").equals("GeoStruct")) {
            return;
        }
        if (this.serverSideFilter == null) {
            this.setServerSideFilter();
        }
        ConcurrentHashMap<Long, HashMap<String, Object>> concurrentHashMap = this.allStampsForMapClient;
        synchronized (concurrentHashMap) {
            stamp = this.allStampsForMapClient.get(unitID);
        }
        if (stamp == null) {
            try {
                eventMap = (HashMap)this.mapClientFacade.addUnitIdentityBasicData(eventMap, Long.valueOf(unitID));
                stamp = eventMap;
                this.allStampsForMapClient.put(unitID, eventMap);
                if (log.isInfoEnabled()) {
                    log.info((Object)(method + "Unit ID " + unitID + " hasn't been found in local GSE data even with client permissions. Seems to be new - system creates a new item!"));
                }
            }
            catch (RemoteException e) {
                log.error((Object)"sendMessageToClient runs into RemoteException: ", (Throwable)e);
            }
        } else {
            if (this.isFirstGeoEvent(stamp, eventMap, eventType)) {
                this.scheduleNextUpdateThread(true);
                return;
            }
            if (eventType.equals("data_type_notification_event")) {
                TreeMap<String, HashMap> notifyEvents = (TreeMap<String, HashMap>)stamp.get("NotifyEvents");
                if (notifyEvents == null) {
                    notifyEvents = new TreeMap<String, HashMap>();
                    stamp.put("NotifyEvents", notifyEvents);
                }
                Long timeStamp = (Long)eventMap.get("NotifyTimestamp");
                Long msgID = (Long)eventMap.get("NotifyMessageID");
                notifyEvents.put(timeStamp + "_" + msgID, eventMap);
            } else {
                stamp.putAll(eventMap);
            }
        }
        this.mapFilter.markStamp(stamp);
        boolean sendToClient = this.checkFilter(method, unitID, stamp);
        if (sendToClient) {
            eventMap.put("DataType", "SingleUnitEvent");
            this.sendResponse(eventMap);
        }
    }

    private boolean isFirstGeoEvent(Map<String, Object> stamp, HashMap<String, Object> eventMap, String eventType) {
        return eventType.equals("GeoStruct") && stamp.get("GeoBegin") == null;
    }

    private boolean checkFilter(String method, long unitID, Map<String, Object> stamp) {
        boolean matchFilter = false;
        if (stamp != null && stamp.containsKey("FilterPassed")) {
            matchFilter = (Boolean)stamp.get("FilterPassed");
        } else {
            log.error((Object)(method + "stamp does not contain key for filter marker '" + "FilterPassed" + "'"));
        }
        boolean sendToClient = true;
        if (this.mapFilter.isFilterSet()) {
            if (matchFilter) {
                this.allClientUnitIDs.add(unitID);
            } else if (this.allClientUnitIDs.contains(unitID)) {
                this.allClientUnitIDs.remove(unitID);
            } else {
                sendToClient = false;
            }
        }
        return sendToClient;
    }

    public void scheduleNextUpdateThread(boolean earlyUpdateNeeded) {
        this.clientBulkUpdateThread = new ClientBulkUpdateRunnableObj(this, true);
        MapTimerTask mapClientUpdater = new MapTimerTask(this.observableClient.getThreadPool(), this.clientBulkUpdateThread);
        long nextExecution = -1L;
        this.resetTimers();
        if (earlyUpdateNeeded) {
            if (this.firstTimeExcecution) {
                log.debug((Object)"firstTimeExcecution, assign thread pool");
                this.observableClient.getThreadPool().assign((Runnable)this.clientBulkUpdateThread);
                this.setFirstTimeExcecution(false);
            } else {
                this.updateTimer = new Timer();
                this.updateTimer.scheduleAtFixedRate((TimerTask)mapClientUpdater, this.delay, this.period);
                nextExecution = this.delay;
            }
        } else {
            this.updateTimer = new Timer();
            this.updateTimer.scheduleAtFixedRate((TimerTask)mapClientUpdater, this.period, this.period);
            nextExecution = this.period;
        }
        nextExecution /= 60000L;
        if (log.isDebugEnabled()) {
            String pattern = "HH:mm:ss";
            SimpleDateFormat formater = new SimpleDateFormat(pattern);
            log.debug((Object)"******************** Re/Scheduling: ObservableUNITS ************************");
            log.debug((Object)("Update timer (re)scheduled! Next execution time for user " + this.observableClient.getUsername() + " will be in " + nextExecution + " minutes!  now:" + formater.format(System.currentTimeMillis())));
            log.debug((Object)"****************************************************************************");
        }
    }

    protected void updateClientPermissions() {
        try {
            this.unitPermissions = this.mapClientFacade.getUnitPermissions(this.observableClient.getUnitGroupId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Permissions for user " + this.observableClient.getUsername() + " updated!"));
            }
        }
        catch (RemoteException e) {
            log.error((Object)"getClientPermissions runs into RemoteException: ", (Throwable)e);
        }
    }

    private void sendResponse(Map<String, Object> responseMap) {
        String method = "sendResponse(): ";
        try {
            this.observableClient.remoteClient.sendObject(responseMap);
            if (log.isDebugEnabled()) {
                log.debug((Object)(method + "Message sent to client."));
            }
        }
        catch (IOException e) {
            log.warn((Object)(method + "runs into IOException! Probably the client was shut down. Session will be unsubscribed!"));
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (NullPointerException e) {
            log.error((Object)(method + "runs into NullPointerException! Session will be unsubscribed!"), (Throwable)e);
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (Exception e) {
            log.error((Object)"Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!", (Throwable)e);
            this.informantClient.notify(method + "" + this.toString() + " -  runs into Exception: " + e, "UnitErrorEvent");
            this.observableClient.setMarkedForShutdown(true);
        }
    }

    private boolean checkPermission(Map<String, Object> eventMap) {
        boolean containsUnitPermission = false;
        long unitID = (Long)eventMap.get("UnitId");
        if (this.unitPermissions.contains(unitID)) {
            containsUnitPermission = true;
            String eventType = (String)eventMap.get("EventType");
            if (eventType.equals("data_type_notification_event") && !this.notifyPermissions) {
                containsUnitPermission = false;
            }
        }
        return containsUnitPermission;
    }

    public boolean hasPermissionForUnitID(Long unitID) {
        return this.unitPermissions.contains(unitID);
    }

    private boolean getNotifyPermission() throws Exception {
        String method = "getNotifyPermission(): ";
        boolean notifyPermission = false;
        this.loginContextUtil = new LoginContextUtil(this.observableClient.getUsername(), this.observableClient.getPassword());
        if (this.loginContextUtil.isSuperAdmin()) {
            notifyPermission = true;
        } else if (this.loginContextUtil.isUserInRole("section.airportmap.notification")) {
            log.debug((Object)(method + "client has permission for notifications."));
            notifyPermission = true;
        }
        return notifyPermission;
    }

    private void setServerSideFilter() {
        HttpServletRequest request = this.observableClient.getClient().getRequest();
        if (request != null) {
            Map params = request.getParameterMap();
            if (!params.containsKey("serversideFilter")) {
                return;
            }
            log.error((Object)"*** server side filter found! do not use yet!");
            this.serverSideFilter.clear();
            this.setServerSideFilterValue(params, "beginTime");
            this.setServerSideFilterValue(params, "endTime");
            this.setServerSideFilterValue(params, "unitId");
            this.setServerSideFilterValue(params, "isAlive");
            this.setServerSideFilterValue(params, "onlineState");
            this.setServerSideFilterValue(params, "unitKind");
            this.setServerSideFilterValue(params, "gseAssignmentState");
            this.setServerSideFilterValue(params, "operationState");
            this.setServerSideFilterValue(params, "motorState");
            this.setServerSideFilterValue(params, "serviceState");
            this.setServerSideFilterValue(params, "assignedState");
            this.setServerSideFilterValue(params, "fuelState");
            this.setServerSideFilterValue(params, "connectorState");
            this.setServerSideFilterValue(params, "flag1State");
            this.setServerSideFilterValue(params, "flag2State");
            this.setServerSideFilterValue(params, "flag3State");
            this.mapFilter.setFilter(this.serverSideFilter);
        } else {
            log.error((Object)"getServerSideFilter() - servlet request is null");
        }
    }

    private void setServerSideFilterValue(Map<String, Object> params, String key) {
        if (params.containsKey(key)) {
            this.serverSideFilter.put(key, params.get(key));
        }
    }

    public void setFirstTimeExcecution(boolean firstTimeExcecution) {
        this.firstTimeExcecution = firstTimeExcecution;
    }

    private void resetTimers() {
        if (this.updateTimer != null) {
            this.updateTimer.cancel();
            this.updateTimer = null;
            log.debug((Object)"Previous timer has been canceled!");
        }
    }

    public void sendAllBulkDataToClient(boolean stampData) {
        this.sendAllStampsToClient();
    }

    private void doLogin(String username, String password) {
        if (username == null) {
            log.warn((Object)"username not given!");
        } else if (password == null) {
            log.warn((Object)"password not given!");
        } else {
            try {
                if (this.lc == null) {
                    LoginCallbackHandler cbh = new LoginCallbackHandler(username, password);
                    this.lc = new LoginContext("rts", (CallbackHandler)cbh);
                    this.lc.login();
                } else {
                    this.lc.login();
                }
            }
            catch (LoginException e1) {
                log.error((Object)("Login in ObservableUnitsClient failed: " + e1));
            }
        }
    }

    private void doLogout() {
        if (this.lc != null) {
            try {
                this.lc.logout();
            }
            catch (LoginException e) {
                log.error((Object)("Logout in ObservableUnitsClient failed: " + e));
            }
        }
    }
}

