/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import java.io.IOException;
import java.util.HashMap;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableErrorClient {
    private static final Log log = LogFactory.getLog(ObservableErrorClient.class);
    private ObservableClient observableClient = null;

    public ObservableErrorClient(ObservableClient observableClient) {
        this.observableClient = observableClient;
    }

    protected void cleanUp() {
        this.observableClient = null;
    }

    protected void handleMessage(SerializableEventWrapper event) throws JMSException {
        this.sendMessageToClient(event);
    }

    protected void sendMessageToClient(SerializableEventWrapper eventWrapper) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendMessageToClient() " + this.toString() + ": sendMessageToClient() startet..."));
        }
        try {
            this.observableClient.remoteClient.sendObject(this.createValueMap(eventWrapper));
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendMessageToClient() " + this.toString() + ": Message to client sent!"));
            }
        }
        catch (IOException e) {
            log.debug((Object)"sendMessageToClient() runs into IOException! Probably the client was shut down. Session will be unsubscribed!");
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (NullPointerException e) {
            log.debug((Object)"sendMessageToClient() runs into NullPointerException! Session will be unsubscribed!");
            this.observableClient.setMarkedForShutdown(true);
        }
        catch (Exception ex) {
            log.error((Object)"sendMessageToClient() Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos", (Throwable)ex);
            this.observableClient.setMarkedForShutdown(true);
        }
    }

    private HashMap<String, Object> createValueMap(SerializableEventWrapper eventWrapper) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("DataType", "data_type_server_errors");
        valueMap.put("ErrorEvent", eventWrapper.get_cacheValue());
        valueMap.put("ServerTime", System.currentTimeMillis());
        return valueMap;
    }
}

