/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable.client;

import de.proveo.util.observable.exceptions.NoAirportMapUnitException;
import de.proveo.util.observable.interfaces.PingThreadListener;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.threadPool.ThreadPool;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.ObservableClientServlet;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.JMSObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClientFactory;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableErrorClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableStandsClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableUnitsClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.services.FISErrorMsgProvider;
import de.proveo.wwt.logic.servlet.dataIn.observable.data.GSEDataUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.data.UnitBulkData;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.pool.ClientPingRunnableObj;
import de.proveo.wwt.logic.servlet.dataIn.observable.threads.pool.MapTimerTask;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableClient
implements MessageListener,
PingThreadListener {
    private static final Log log = LogFactory.getLog(ObservableClient.class);
    private JMSObservableClient jmsClient = null;
    protected LinkedList<SerializableEventWrapper> unitEventBufferLinkedList = null;
    protected LinkedList<SerializableEventWrapper> standsEventBufferLinkedList = null;
    protected RemoteClient remoteClient = null;
    protected String selector = "";
    protected FISErrorMsgProvider serverMsgProvider = null;
    protected boolean unitsEventBufferActive = true;
    protected boolean standsEventBufferActive = true;
    ObservableErrorClient observableErrorClient = null;
    ObservableStandsClient observableStandsClient = null;
    ObservableUnitsClient observableUnitsClient = null;
    private InformantClient informantClient = null;
    private TopicSession session = null;
    private boolean lostConnectionToClient = false;
    private String clientName = null;
    private boolean markedForShutdown = false;
    private long markedForShutdownTimeStamp = 0L;
    private ObservableClientServlet parentServletThread = null;
    private String username = "";
    private String password = "";
    private long unitGroupId = -1L;
    private boolean reconnected = false;
    private UnitBulkData unitBulkData = null;
    private ThreadPool threadPool = null;
    private volatile boolean memoryRefresh = false;
    private Timer pingTimer = null;
    long period = 0L;

    public ObservableClient(String clientName, ObservableClientServlet servlet, String username, String password, UnitBulkData unitDataKeeper, ThreadPool threadPool, long unitGroupId) {
        this.clientName = clientName;
        this.parentServletThread = servlet;
        this.username = username;
        this.password = password;
        this.unitBulkData = unitDataKeeper;
        this.threadPool = threadPool;
        this.unitGroupId = unitGroupId;
        this.observableUnitsClient = new ObservableUnitsClient(this);
        this.observableStandsClient = new ObservableStandsClient(this);
        this.observableErrorClient = new ObservableErrorClient(this);
        this.unitEventBufferLinkedList = new LinkedList();
        this.standsEventBufferLinkedList = new LinkedList();
        this.informantClient = new InformantClient();
        this.jmsClient = new JMSObservableClient();
        this.serverMsgProvider = new FISErrorMsgProvider();
        if (log.isDebugEnabled()) {
            log.debug((Object)("All clients for " + this.toString() + " created!"));
        }
        GSEDataUtil gseDataUtil = new GSEDataUtil();
        this.period = Integer.parseInt(gseDataUtil.getParameter("observable.pingthread.latency", null));
        this.startPingSignalTimer();
    }

    private void startPingSignalTimer() {
        ClientPingRunnableObj clientPingRunnableObj = new ClientPingRunnableObj(this);
        MapTimerTask mapClientUpdater = new MapTimerTask(this.getThreadPool(), clientPingRunnableObj);
        this.resetTimers();
        this.pingTimer = new Timer();
        this.pingTimer.scheduleAtFixedRate((TimerTask)mapClientUpdater, this.period, this.period);
    }

    public void onMessage(Message message) {
        log.debug((Object)"onMessage() started...");
        if (!this.lostConnectionToClient && !this.isMarkedForShutdown()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"onMessage(): Message acknowleded!");
                }
                Serializable _object = ((ObjectMessage)message).getObject();
                SerializableEventWrapper event = (SerializableEventWrapper)_object;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"onMessage(): Receiving ObjectMessage:");
                }
                log.debug((Object)("EVENT TYPE: " + event.get_typeOfEvent()));
                if (event.get_typeOfEvent().equals("KeepAlive") || event.get_typeOfEvent().equals("GeoStructHistoryAndCache") || event.get_typeOfEvent().equals("StateEventHistoryAndCache") || event.get_typeOfEvent().equals("InfomanMessages") || event.get_typeOfEvent().equals("InfomanNotifyMessages") || event.get_typeOfEvent().equals("UseEvent")) {
                    this.observableUnitsClient.handleMessage(event);
                } else if (event.get_typeOfEvent().equals("AllStandData") || event.get_typeOfEvent().equals("StandEvent") || event.get_typeOfEvent().equals("GSEAllocationEvent") || event.get_typeOfEvent().equals("StaffAllocationEvent")) {
                    this.observableStandsClient.handleMessage(event);
                } else if (event.get_typeOfEvent().equals("ServerErrorEvent") || event.get_typeOfEvent().equals("StandErrorEvent") || event.get_typeOfEvent().equals("UnitErrorEvent")) {
                    this.observableErrorClient.handleMessage(event);
                }
                message.acknowledge();
            }
            catch (JMSException ex) {
                String errorMsg = "onMessage() runs into JMSException: " + (Object)((Object)ex);
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
            }
            catch (NullPointerException ex) {
                String errorMsg = "onMessage() runs into NullPointerException: " + ex;
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
            }
            catch (NoAirportMapUnitException ex) {
                log.trace((Object)"Problems while retrieving GSE data. Is A/P map flag missing? Pls. check data!");
            }
            catch (Exception ex) {
                String errorMsg = "onMessage() runs into Exception: " + ex;
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"onMessage(): Connection lost to client!");
            }
            if (this.isMarkedForShutdown()) {
                log.warn((Object)" - marked for shutdown. Client closed or Connection lost.");
                this.checkSelfDestruction();
            }
        }
    }

    public void ping() throws JMSException {
        if (!this.isMarkedForShutdown()) {
            try {
                long lastExcecute = Long.valueOf(System.currentTimeMillis()) - this.remoteClient.getLastSendObjectToClient();
                if (lastExcecute >= this.period) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("--- ping(p) request excecuted !!!  " + this.username));
                    }
                    this.remoteClient.sendObject("p");
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("ping(p) request NOT excecuted !!!  " + this.username));
                }
            }
            catch (IOException e) {
                log.debug((Object)"ping() runs into IOException! Probably the client was shut down. Session will be unsubscribed!");
                this.setMarkedForShutdown(true);
            }
            catch (NullPointerException e) {
                log.error((Object)"ping() runs into NullPointerException! Client session will be unsubscribed", (Throwable)e);
                this.informantClient.notify("ping() runs into NullPointerException! Client session will be unsubscribed!" + e, "ServerErrorEvent");
                log.warn((Object)"ping-Thread will be stopped manually");
                this.setMarkedForShutdown(true);
            }
            catch (Exception e) {
                log.error((Object)"ping() Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!", (Throwable)e);
                this.informantClient.notify("ping() runs into NullPointerException! Client session will be unsubscribed!" + e, "ServerErrorEvent");
                log.warn((Object)"ping-Thread will be stopped manually");
                this.setMarkedForShutdown(true);
            }
        } else {
            log.warn((Object)"This ObservableClient ist marked for shutdown. Ping not executed.");
            this.checkSelfDestruction();
        }
    }

    protected synchronized void deleteObserverClient() throws JMSException {
        log.debug((Object)"Deleting all connections in ObserverClient");
        try {
            this.lostConnectionToClient = true;
            this.deleteJMSClient();
            if (this.pingTimer != null) {
                this.pingTimer.cancel();
                this.pingTimer = null;
            }
            if (this.observableUnitsClient != null) {
                this.observableUnitsClient.cleanUp();
                this.observableUnitsClient = null;
            }
            if (this.observableStandsClient != null) {
                this.observableStandsClient.cleanUp();
                this.observableStandsClient = null;
            }
            if (this.observableErrorClient != null) {
                this.observableErrorClient.cleanUp();
                this.observableErrorClient = null;
            }
            log.info((Object)("ObserverClient " + this.toString() + " deleted!"));
        }
        catch (NullPointerException e) {
            log.error((Object)"deleteObserverClient runs into NullPointerException!", (Throwable)e);
            this.informantClient.notify("deleteObserverClient runs into NullPointerException! " + e, "ServerErrorEvent");
        }
    }

    private void deleteJMSClient() {
        try {
            if (null != this.jmsClient.getSubscriber()) {
                this.jmsClient.getSubscriber().close();
                log.debug((Object)"TopicSubscriber closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
        try {
            if (null != this.jmsClient.getSession()) {
                this.jmsClient.getSession().close();
                log.debug((Object)"TopicSession closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
        try {
            if (null != this.jmsClient.getConnect()) {
                this.jmsClient.getConnect().close();
                log.debug((Object)"TopicConnection closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
        try {
            if (null != this.jmsClient.getCtx()) {
                this.jmsClient.getCtx().close();
                log.debug((Object)"Context closed!");
            }
        }
        catch (Exception ex) {
            log.error((Object)("deleteJMSClient ends in Exception: " + ex));
        }
    }

    protected void sendEventBufferToClient() {
        String errorMsg;
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendEventBufferToClient()");
        }
        while (this.unitEventBufferLinkedList.size() > 0 && !this.isMarkedForShutdown()) {
            try {
                this.observableUnitsClient.sendMessageToClient(this.unitEventBufferLinkedList.poll());
            }
            catch (JMSException ex) {
                errorMsg = "sendEventBufferToClient() runs into JMSException: " + (Object)((Object)ex);
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            catch (NoAirportMapUnitException ex) {
                log.trace((Object)"Problems while retrieving GSE data. Is A/P map flag missing? Pls. check data!");
            }
            catch (Exception ex) {
                errorMsg = "sendEventBufferToClient() runs into Exception: " + ex;
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            this.unitsEventBufferActive = false;
        }
        while (this.standsEventBufferLinkedList.size() > 0 && !this.isMarkedForShutdown()) {
            try {
                this.observableStandsClient.sendMessageToClient(this.standsEventBufferLinkedList.poll());
            }
            catch (JMSException ex) {
                errorMsg = "sendEventBufferToClient() runs into JMSException: " + (Object)((Object)ex);
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            catch (Exception ex) {
                errorMsg = "sendEventBufferToClient() runs into Exception: " + ex;
                log.error((Object)errorMsg, (Throwable)ex);
                this.informantClient.notify(errorMsg, "ServerErrorEvent");
                this.setMarkedForShutdown(true);
            }
            this.standsEventBufferActive = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendEventBufferToClient(): Buffer sent to client");
        }
        if (this.isMarkedForShutdown()) {
            log.warn((Object)"Client was marked for Shutdown while sending Eventlist to the client. Sending aborded");
            this.checkSelfDestruction();
        }
        log.debug((Object)"sendMessageToClient():EventBuffer deactivated!");
    }

    public void cleanUp() {
        String method = "cleanUp(): ";
        try {
            log.debug((Object)(method + "start"));
            this.deleteObserverClient();
            log.debug((Object)(method + "end"));
        }
        catch (JMSException e) {
            log.error((Object)(method + "runs into JMSException: "), (Throwable)e);
        }
    }

    public void setMarkedForShutdown(boolean markedForShutdown) {
        this.markedForShutdown = markedForShutdown;
        this.memoryRefresh = true;
        if (this.markedForShutdownTimeStamp == 0L) {
            this.markedForShutdownTimeStamp = System.currentTimeMillis();
        }
    }

    private void checkSelfDestruction() {
        if (this.markedForShutdownTimeStamp != 0L) {
            if (System.currentTimeMillis() - this.markedForShutdownTimeStamp > 6000L) {
                log.warn((Object)"Waittime of servlet shutdown exceeded. Will force self destruction of this ObservableClient. ");
                this.parentServletThread.setRunning(false);
                log.debug((Object)"Stopflag in parent servlet set.");
                try {
                    this.deleteObserverClient();
                    log.debug((Object)"Selfdestruction finished.");
                }
                catch (JMSException e) {
                    log.error((Object)"runs into: ", (Throwable)e);
                }
                log.debug((Object)"Remove entry in ObservableClientFactory.");
                ObservableClientFactory.getInstance().removeClient(this.clientName);
            }
        } else {
            log.warn((Object)"No timestamp for self destruction set.");
        }
    }

    public UnitBulkData getUnitBulkData() {
        return this.unitBulkData;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public RemoteClient getClient() {
        return this.remoteClient;
    }

    public JMSObservableClient getJmsClient() {
        return this.jmsClient;
    }

    public void setJmsClient(JMSObservableClient jmsClient) {
        this.jmsClient = jmsClient;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isReconnected() {
        return this.reconnected;
    }

    public void setReconnected(boolean reconnected) {
        this.reconnected = reconnected;
    }

    public boolean isMarkedForShutdown() {
        return this.markedForShutdown;
    }

    public void setClient(RemoteClient client) {
        this.remoteClient = client;
    }

    public void setSession(TopicSession session) {
        this.session = session;
    }

    public long getUnitGroupId() {
        return this.unitGroupId;
    }

    public ObservableUnitsClient getObservableUnitsClient() {
        return this.observableUnitsClient;
    }

    private void resetTimers() {
        if (this.pingTimer != null) {
            this.pingTimer.cancel();
            log.debug((Object)"Previous timer has been canceled!");
        }
    }

    public void pingServerTime(long currentServerTime) throws JMSException {
        if (!this.isMarkedForShutdown()) {
            try {
                if (log.isDebugEnabled()) {
                    String pattern = "HH:mm:ss";
                    SimpleDateFormat formater = new SimpleDateFormat(pattern);
                    log.debug((Object)("************ pingServerTime ********** : " + formater.format(System.currentTimeMillis())));
                }
                this.remoteClient.sendObject(currentServerTime);
            }
            catch (IOException e) {
                log.debug((Object)"ping() runs into IOException! Probably the client was shut down. Session will be unsubscribed!");
                this.setMarkedForShutdown(true);
            }
            catch (NullPointerException e) {
                log.error((Object)"ping() runs into NullPointerException! Client session will be unsubscribed", (Throwable)e);
                this.informantClient.notify("ping() runs into NullPointerException! Client session will be unsubscribed!" + e, "ServerErrorEvent");
                log.warn((Object)"ping-Thread will be stopped manually");
                this.setMarkedForShutdown(true);
            }
            catch (Exception e) {
                log.error((Object)"ping() Unkown Exception caught!!!!! Will shutdown all Client Threads as a precaution!!! See log-files for further infos!", (Throwable)e);
                this.informantClient.notify("ping() runs into NullPointerException! Client session will be unsubscribed!" + e, "ServerErrorEvent");
                log.warn((Object)"ping-Thread will be stopped manually");
                this.setMarkedForShutdown(true);
            }
        } else {
            log.warn((Object)"This ObservableClient ist marked for shutdown. Ping not executed.");
            this.checkSelfDestruction();
        }
    }
}

