/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.observable;

import de.proveo.rts.configuration.map.AirportMapMBean;
import de.proveo.rts.configuration.map.AirportMapUtil;
import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.ejb.general.config.Configuration;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClient;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.ObservableClientFactory;
import de.proveo.wwt.logic.servlet.dataIn.observable.client.RemoteClient;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.management.MalformedObjectNameException;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableClientServlet
extends HttpServlet
implements SingleThreadModel {
    private static final long serialVersionUID = 6912602153837173070L;
    private static final String CONTENT_TYPE = "application/octet-stream";
    private final Log log = LogFactory.getLog(ObservableClientServlet.class);
    private boolean isRunning = true;
    private AirportMapMBean airportMapConfig;
    private Configuration configuration;

    public void destroy() {
        this.log.debug((Object)("destroy() is called! --> Instance: " + ((Object)((Object)this)).toString()));
        this.log.debug((Object)"Servlet instance removed.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = "doGet(): ";
        this.log.warn((Object)(method + "avoid GET, use POST instead!"));
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = "doPost(): ";
        this.log.debug((Object)(method + "POST started for instance " + ((Object)((Object)this)).toString()));
        if (this.airportMapConfig.isClientsDisabled()) {
            response.sendError(503);
            return;
        }
        try {
            this.createClient(request, response);
            this.log.debug((Object)(method + "POST finished for instance " + ((Object)((Object)this)).toString()));
        }
        catch (NullPointerException e) {
            this.log.fatal((Object)"Server was not able to create a client for the airport map!");
            response.sendError(503);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.log.debug((Object)"init()");
        super.init(config);
        try {
            this.airportMapConfig = AirportMapUtil.getMBean();
            this.configuration = ConfigurationUtil.getHome().create();
        }
        catch (MalformedObjectNameException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (NamingException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (RemoteException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (CreateException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void createClient(HttpServletRequest request, HttpServletResponse response) throws NullPointerException, IOException {
        String method = "createClient(): ";
        this.isRunning = true;
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String clientId = request.getParameter("clientId");
        String unitGroupIdStr = request.getParameter("unitGroupId");
        response.setContentType(CONTENT_TYPE);
        long unitGroupId = -1L;
        try {
            if (this.configuration.isConfigured("airport.groupId")) {
                Long airportId = Long.parseLong(this.configuration.getParameter("airport.groupId"));
                this.log.debug((Object)("Use airport id '" + airportId + "' from configuration."));
                unitGroupId = airportId;
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)"Could not get configuration parameter \"airport.groupId\"", ex);
        }
        if (unitGroupId == -1L) {
            try {
                unitGroupId = Long.valueOf(unitGroupIdStr);
                this.log.debug((Object)("Given unit group ID is: '" + unitGroupId + "'"));
            }
            catch (Throwable ex) {
                this.log.debug((Object)("Given unit group ID isn't a long value: '" + unitGroupIdStr + "'"));
            }
        }
        this.isRunning = true;
        response.setContentType(CONTENT_TYPE);
        this.doLogin(username, password);
        boolean newClientThread = false;
        ObservableClientFactory observerClientFactory = ObservableClientFactory.getInstance();
        ServletOutputStream sos = response.getOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
        this.log.debug((Object)"Streams initialized.");
        newClientThread = observerClientFactory.createObserverClient(this, clientId, username, password, unitGroupId, new RemoteClient(request, oos));
        if (!newClientThread) {
            this.removeOldClient(clientId, observerClientFactory);
            this.log.debug((Object)"Old client instance removed. Init new client thread.");
            newClientThread = observerClientFactory.createObserverClient(this, clientId, username, password, unitGroupId, new RemoteClient(request, oos));
            this.log.debug((Object)("New client established? " + newClientThread));
        } else {
            this.log.debug((Object)("ClientId " + clientId + " unknown! Will initialize new client."));
        }
        if (newClientThread) {
            this.setNewClientOnHold(clientId, observerClientFactory);
        } else {
            this.log.error((Object)"Client was already known - ServletLock skipped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldClient(String clientId, ObservableClientFactory observerClientFactory) {
        this.log.debug((Object)("The client with Id: " + clientId + " is already running in another Thread. Client will be replaced!!"));
        ObservableClient oldClient = observerClientFactory.getObservableClientByClientID(clientId);
        this.log.debug((Object)"Old client marked for shutdown. Will wait 5s until shutdown completed.");
        oldClient.setMarkedForShutdown(true);
        try {
            ObservableClientServlet observableClientServlet = this;
            synchronized (observableClientServlet) {
                ((Object)((Object)this)).wait(5000L);
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Interrupt while waiting for shutdown of the old client thread.", (Throwable)e);
        }
        observerClientFactory.removeClient(clientId);
    }

    private void doLogin(String username, String password) {
        if (username == null) {
            this.log.warn((Object)"username not given!");
        } else if (password == null) {
            this.log.warn((Object)"password not given!");
        } else {
            try {
                LoginCallbackHandler cbh = new LoginCallbackHandler(username, password);
                LoginContext lc = new LoginContext("rts", (CallbackHandler)cbh);
                lc.login();
            }
            catch (LoginException e1) {
                this.log.error((Object)("Login in ObservableClient failed: " + e1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewClientOnHold(String clientId, ObservableClientFactory observerClientFactory) {
        try {
            ObservableClientServlet observableClientServlet = this;
            synchronized (observableClientServlet) {
                this.log.debug((Object)("New ObservableClientServlet -> " + ((Object)((Object)this)).toString() + " with id " + clientId + " on hold."));
                while (this.isRunning) {
                    ((Object)((Object)this)).wait(1000L);
                    ObservableClient myClient = observerClientFactory.getObservableClientByClientID(clientId);
                    if (myClient == null || !myClient.isMarkedForShutdown()) continue;
                    this.log.debug((Object)("Client: " + clientId + " is marked for shutdown!! Doing cleanup..."));
                    myClient.cleanUp();
                    observerClientFactory.removeClient(clientId);
                    this.log.debug((Object)("cleanup of client: " + clientId + " finished."));
                    this.isRunning = false;
                }
                this.log.debug((Object)("Endless loop in ObservableClientServlet has stopped --> ServletID: " + ((Object)((Object)this)).toString()));
                this.log.debug((Object)"Terminating method createClient().");
            }
        }
        catch (InterruptedException ex) {
            this.log.error((Object)ex);
        }
    }

    public synchronized void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }
}

