/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event.udp;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.rts.configuration.monitor.MonitoringUtil;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.ASCIIRequestPayloadFormat;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.ASCIIResponsePayloadFormat;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.Filter;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.RequestPayloadFormat;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.ResponsePayloadFormat;
import de.proveo.wwt.logic.servlet.dataIn.event.udp.UDPServlet;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPEventWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(UDPEventWorker.class);
    private final int instanceNumber;
    private final DatagramSocket socket;
    private final Filter filter;
    private static int instanceCounter;
    private static final int BUFFER_SIZE = 1500;
    private final RequestPayloadFormat requestPayloadFormat = new ASCIIRequestPayloadFormat();
    private final ResponsePayloadFormat responsePayloadFormat = new ASCIIResponsePayloadFormat();
    protected final UDPServlet udpServlet;
    private final MonitoringMBean udpEventCounter;
    private final MonitoringMBean udpDoubleTransmissionCounter;
    private volatile int status = 0;
    public static final int WAITING_FOR_PACKETS = 0;
    public static final int HANDLE_EVENT = 1;
    private volatile boolean stoped;

    private static synchronized int createInstanceNumber() {
        int number = instanceCounter++;
        return number;
    }

    public UDPEventWorker(DatagramSocket socket, UDPServlet udpServlet, Filter filter) throws IllegalStateException {
        this.instanceNumber = UDPEventWorker.createInstanceNumber();
        this.socket = socket;
        this.udpServlet = udpServlet;
        this.filter = filter;
        try {
            this.udpEventCounter = MonitoringUtil.getMBean((String)"UDPEvents");
            this.udpDoubleTransmissionCounter = MonitoringUtil.getMBean((String)"UDPDoubleTransmissions");
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public void run() {
        block7: {
            byte[] buffer = new byte[1500];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                boolean stop = false;
                do {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(this.instanceNumber + ": wait for packet"));
                    }
                    this.status = 0;
                    this.socket.receive(packet);
                    this.status = 1;
                    long receiveTime = System.currentTimeMillis();
                    this.udpEventCounter.increment();
                    this.requestPayloadFormat.parse(packet.getData(), packet.getLength());
                    long eventId = this.requestPayloadFormat.getEventId();
                    long unitId = this.requestPayloadFormat.getUnitId();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(this.instanceNumber + ": received: " + eventId + " unitId: " + unitId + " from: " + packet.getSocketAddress()));
                    }
                    if (this.udpServlet.isDisabled()) {
                        EventResponse response = new EventResponse();
                        response.setEventResponse(false);
                        ArrayList<EventResponse> eventResponses = new ArrayList<EventResponse>(1);
                        eventResponses.add(response);
                        this.sendACKPacket(packet, eventId, eventResponses);
                    } else {
                        this.applyFilterAndHandleEvent(packet, eventId, unitId, receiveTime);
                    }
                    packet.setData(buffer);
                } while (!(stop = this.isStoped()));
            }
            catch (IOException ex) {
                if (this.stoped) break block7;
                throw new IllegalStateException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFilterAndHandleEvent(DatagramPacket packet, long eventId, long unitId, long receiveTime) throws IOException {
        List<EventResponse> eventResponses = null;
        switch (this.filter.isDoubleTransmitted(eventId, unitId)) {
            case 0: {
                try {
                    eventResponses = this.handleEvents(receiveTime, this.requestPayloadFormat.getEvents(), packet.getSocketAddress());
                }
                finally {
                    if (eventResponses != null) {
                        this.filter.setEventResponses(unitId, eventId, eventResponses);
                    } else {
                        this.filter.reset(unitId);
                    }
                }
            }
            case 2: {
                if (eventResponses == null) {
                    this.udpDoubleTransmissionCounter.increment();
                    eventResponses = this.filter.getEventResponses(unitId, eventId);
                    if (eventResponses == null) {
                        if (!log.isTraceEnabled()) break;
                        log.trace((Object)(this.instanceNumber + ": double transmission, no ack, eventhandling is inprogress by another worker instance. eventId: " + eventId));
                        break;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(this.instanceNumber + ": double transmission, send ack. eventId: " + eventId));
                    }
                }
                this.sendACKPacket(packet, eventId, eventResponses);
                break;
            }
            case 1: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this.instanceNumber + ": double transmission, no ack. eventId: " + eventId));
                }
                this.udpDoubleTransmissionCounter.increment();
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)"unkown filter result");
            }
        }
    }

    public void stop() {
        this.stoped = true;
    }

    protected boolean isStoped() {
        this.stoped = this.stoped || this.udpServlet.isPoolToLarge();
        return this.stoped;
    }

    protected void sendACKPacket(DatagramPacket packet, long eventId, List<EventResponse> eventResponses) throws IOException {
        byte[] responsePayload = this.formatResponsePayload(eventId, eventResponses);
        packet.setData(responsePayload);
        if (log.isTraceEnabled()) {
            StringBuffer eventResponseStr = new StringBuffer("\n");
            Iterator<EventResponse> it = eventResponses.iterator();
            while (it.hasNext()) {
                eventResponseStr.append(it.next().toString());
                eventResponseStr.append("\n");
            }
            log.trace((Object)(this.instanceNumber + ": send ack: " + eventId + eventResponseStr.toString()));
        }
        this.socket.send(packet);
    }

    protected byte[] formatResponsePayload(long eventId, List<EventResponse> responses) throws IOException {
        this.responsePayloadFormat.clear();
        this.responsePayloadFormat.setEventId(eventId);
        this.responsePayloadFormat.setEventResponses(responses);
        return this.responsePayloadFormat.getPayload();
    }

    protected List<EventResponse> handleEvents(long receiveTime, List<Properties> events, SocketAddress socketAddress) {
        ArrayList<EventResponse> eventResponses = new ArrayList<EventResponse>();
        Iterator<Properties> it = events.iterator();
        EventResponse eventResponse = null;
        while (it.hasNext() && (eventResponse == null || eventResponse.isEventResponse())) {
            Properties event = it.next();
            eventResponse = this.udpServlet.processEvent(socketAddress.toString(), event);
            eventResponses.add(eventResponse);
            if (!eventResponse.isVPN()) continue;
            this.udpServlet.resetFlags(eventResponse, event);
        }
        return eventResponses;
    }
}

