/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event.forwarder;

import de.proveo.notification.ConfigurationParameterNotify;
import de.proveo.notification.exceptions.NoSelectorException;
import de.proveo.notification.interfaces.NotifyListener;
import de.proveo.util.connection.ServletConnection;
import de.proveo.util.connection.ServletConnectionException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import javax.jms.JMSException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventForwarder
extends Thread
implements NotifyListener {
    private static final Log log = LogFactory.getLog(EventForwarder.class);
    private static EventForwarder eventForwarder = null;
    protected LinkedList<String> eventBufferLinkedList = null;
    private ConfigurationClient configurationClient = new ConfigurationClient();
    private ConfigurationParameterNotify configurationParameterNotify = null;
    private ServletConnection servletConnection = null;
    private String servletPath = null;
    private String url = "";
    private boolean isRunning = false;
    private boolean threadIsRunning = false;

    public EventForwarder() {
        this.eventBufferLinkedList = new LinkedList();
        try {
            this.configurationParameterNotify = new ConfigurationParameterNotify((NotifyListener)this);
        }
        catch (NoSelectorException e) {
            log.error((Object)"EventForwarder() runs into NoSelectorException: ", (Throwable)e);
        }
        this.startConnection();
        this.checkThread();
    }

    public void addNewQueryString(String queryString) {
        if (this.threadIsRunning) {
            this.eventBufferLinkedList.addLast(queryString);
        }
    }

    public static EventForwarder getInstance() {
        if (eventForwarder == null) {
            eventForwarder = new EventForwarder();
            eventForwarder.start();
        }
        return eventForwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            EventForwarder eventForwarder = this;
            synchronized (eventForwarder) {
                if (this.threadIsRunning && this.eventBufferLinkedList.size() > 0) {
                    this.forwardEvent(this.eventBufferLinkedList.poll());
                }
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"run() runs into InterruptedException: ", (Throwable)e);
                }
            }
        }
    }

    public void tearDownNotify() {
        this.threadIsRunning = false;
        try {
            this.configurationParameterNotify.tearDownJmsEnvironment();
        }
        catch (JMSException e) {
            log.error((Object)"Runs into JMSException while stopping ConfigurationParameterNotify.", (Throwable)e);
        }
    }

    public void update(String notifyMessage) {
        boolean isRunningBuffer = this.isRunning;
        try {
            this.isRunning = this.configurationClient.getBoolean("eventForwarder.isRunning");
        }
        catch (RemoteException e) {
            log.error((Object)"update() runs into RemoteException: ", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"update() runs into RemoteException: ConfigurationParameterNotFoundException", (Throwable)e);
        }
        if (isRunningBuffer && !this.isRunning) {
            this.threadIsRunning = false;
            log.debug((Object)"EventForwarder is deactivated!");
        } else if (!isRunningBuffer && this.isRunning) {
            this.startConnection();
            this.threadIsRunning = true;
            log.debug((Object)"EventForwarder is activated!");
        }
    }

    private void checkThread() {
        try {
            this.isRunning = this.configurationClient.getBoolean("eventForwarder.isRunning");
        }
        catch (RemoteException e) {
            log.error((Object)"init() runs into RemoteException: ", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"init() runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
        if (this.isRunning) {
            this.threadIsRunning = true;
        }
    }

    private void configureProxy() {
        String proxyHost = "";
        String proxyUser = "";
        String proxyPass = "";
        String proxyDomain = "";
        int proxyPort = 0;
        try {
            proxyHost = this.configurationClient.getParameter("eventForwarder.proxy.host");
            proxyPort = this.configurationClient.getInteger("eventForwarder.proxy.port");
            proxyUser = this.configurationClient.getParameter("eventForwarder.proxy.user");
            proxyPass = this.configurationClient.getParameter("eventForwarder.proxy.pass");
            proxyDomain = this.configurationClient.getParameter("eventForwarder.proxy.domain");
        }
        catch (RemoteException e) {
            log.error((Object)"configureProxy() runs into RemoteException: ", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"configureProxy() runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
        this.servletConnection.setupProxy(proxyHost, proxyPort, proxyUser, proxyPass, proxyDomain);
    }

    private void forwardEvent(String queryString) {
        log.debug((Object)"Forwarding new event to another server...");
        this.url = this.servletConnection.getUrl(this.servletPath, queryString);
        try {
            int state = this.servletConnection.executeMethod(this.url);
            if (state != 200 && log.isDebugEnabled()) {
                log.debug((Object)("forwardEvent() - Status Code " + state));
            }
        }
        catch (HttpException e) {
            log.debug((Object)"forwardEvent() - Status Code 86!");
        }
        catch (IOException e) {
            log.debug((Object)"forwardEvent() - Status Code 87!");
        }
        catch (ServletConnectionException e) {
            log.debug((Object)"forwardEvent() - Status Code 88!");
        }
    }

    private void startConnection() {
        this.servletPath = "datain/e";
        try {
            String host = this.configurationClient.getParameter("eventForwarder.host");
            String protocol = this.configurationClient.getParameter("eventForwarder.protocol");
            int port = this.configurationClient.getInteger("eventForwarder.port");
            this.servletConnection = new ServletConnection(host, port, "http");
            if (this.configurationClient.getBoolean("eventForwarder.proxy.use")) {
                this.configureProxy();
            }
            this.servletConnection.connect();
        }
        catch (RemoteException e) {
            log.error((Object)"initConnection() runs into RemoteException: ", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"initConnection() runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
    }
}

