/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.rts.configuration.monitor.MonitoringUtil;
import de.proveo.wwt.logic.servlet.dataIn.event.AbstractEventServlet;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UncompressedEventServlet
extends AbstractEventServlet {
    private static final long serialVersionUID = -73408726658629285L;
    private static final Log log = LogFactory.getLog(UncompressedEventServlet.class);
    private MonitoringMBean eventCounter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.eventCounter = MonitoringUtil.getMBean((String)"UncompressedEvents");
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (this.config.isHttpUncompressedEvetsDisabled()) {
            EventResponse eventResponse = new EventResponse();
            eventResponse.setEventResponse(false);
            this.sendResponse(eventResponse, new Properties(), response);
            return;
        }
        log.debug((Object)"doGet() GET mit URL Parameter verarbeiten");
        this.eventCounter.increment();
        eventForwarder.addNewQueryString(request.getQueryString());
        Properties event = this.getPropertiesFromRequest(request);
        EventResponse eventResponse = this.processEvent(request.getRemoteAddr(), event);
        this.sendResponse(eventResponse, event, response);
        log.debug((Object)"doGet() end");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        log.warn((Object)"don't use POST for sending uncompressed data, because of request size.");
        log.warn((Object)"for compressed requests (GEO e.g.) use CompressedEventServlet.");
        this.doGet(request, response);
    }

    protected Properties getPropertiesFromRequest(HttpServletRequest request) {
        Properties event = new Properties();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            event.setProperty(key, request.getParameter(key));
        }
        return event;
    }
}

