/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class PackageViewChildren
extends Children.Keys<String>
implements FileChangeListener,
ChangeListener,
Runnable {
    private static final Logger LOG = Logger.getLogger(PackageViewChildren.class.getName());
    private static final String NODE_NOT_CREATED = "NNC";
    private static final String NODE_NOT_CREATED_EMPTY = "NNC_E";
    private static final MessageFormat PACKAGE_FLAVOR = new MessageFormat("application/x-java-org-netbeans-modules-java-project-packagenodednd; class=org.netbeans.spi.java.project.support.ui.PackageViewChildren$PackageNode; mask={0}");
    static final String PRIMARY_TYPE = "application";
    static final String SUBTYPE = "x-java-org-netbeans-modules-java-project-packagenodednd";
    static final String MASK = "mask";
    private final Map<String, Object> names2nodes;
    private final FileObject root;
    private final SourceGroup group;
    private FileChangeListener wfcl;
    private ChangeListener wvqcl;
    RequestProcessor.Task task = PackageRootNode.PKG_VIEW_RP.create((Runnable)this);
    private RequestProcessor.Task refreshLazilyTask;
    private final DataFilter NO_FOLDERS_FILTER = new NoFoldersDataFilter();

    public PackageViewChildren(SourceGroup group) {
        this.names2nodes = Collections.synchronizedMap(new TreeMap());
        this.root = group.getRootFolder();
        this.group = group;
    }

    FileObject getRoot() {
        return this.root;
    }

    protected Node[] createNodes(String path) {
        FileObject fo = this.root.getFileObject(path);
        if (fo != null && fo.isValid() && fo.isFolder()) {
            DataFolder folder;
            Object o = this.names2nodes.get(path);
            try {
                folder = DataFolder.findFolder((FileObject)fo);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException(MessageFormat.format("Root: {0}, Path: {1}, Visible: {2}", FileUtil.getFileDisplayName((FileObject)this.root), path, VisibilityQuery.getDefault().isVisible(fo)), iae);
            }
            if (folder.isValid()) {
                PackageNode n = o == NODE_NOT_CREATED ? new PackageNode(this.root, folder, false) : new PackageNode(this.root, folder);
                this.names2nodes.put(path, (Object)n);
                return new Node[]{n};
            }
        }
        return new Node[0];
    }

    protected void addNotify() {
        super.addNotify();
        this.task.schedule(0);
    }

    public Node[] getNodes(boolean optimal) {
        if (optimal) {
            Node[] garbage = super.getNodes(false);
            this.task.waitFinished();
        }
        return super.getNodes(false);
    }

    public Node findChild(String name) {
        Node n;
        while ((n = super.findChild(name)) == null) {
            try {
                if (this.task.waitFinished(5000L)) {
                    return super.findChild(name);
                }
                this.refreshKeys();
                continue;
            }
            catch (InterruptedException x) {
                Exceptions.printStackTrace((Throwable)x);
                continue;
            }
            break;
        }
        return n;
    }

    @Override
    public void run() {
        this.computeKeys();
        this.refreshKeys();
        try {
            FileSystem fs = this.root.getFileSystem();
            this.wfcl = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fs);
            fs.addFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        this.wvqcl = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
        VisibilityQuery.getDefault().addChangeListener(this.wvqcl);
    }

    protected void removeNotify() {
        VisibilityQuery.getDefault().removeChangeListener(this.wvqcl);
        try {
            this.root.getFileSystem().removeFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        this.setKeys(new String[0]);
        this.names2nodes.clear();
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshKeys() {
        TreeSet<String> keys;
        Map<String, Object> map = this.names2nodes;
        synchronized (map) {
            keys = new TreeSet<String>(this.names2nodes.keySet());
        }
        this.setKeys(keys);
    }

    private void refreshKeysAsync() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PackageViewChildren.this.refreshKeys();
            }
        });
    }

    private void computeKeys() {
        this.names2nodes.clear();
        this.findNonExcludedPackages(this.root);
    }

    private void findNonExcludedPackages(FileObject fo) {
        PackageView.findNonExcludedPackages(this, null, fo, this.group, true);
    }

    private void cleanEmptyKeys(FileObject fo) {
        FileObject parent = fo.getParent();
        if (this.root.equals(parent)) {
            PackageNode n = this.get(parent);
            if (n != null && PackageDisplayUtils.isEmpty(this.root, false)) {
                this.remove(this.root);
            }
            return;
        }
        while (FileUtil.isParentOf((FileObject)this.root, (FileObject)parent)) {
            PackageNode n = this.get(parent);
            if (n != null && n.isLeaf()) {
                this.remove(parent);
            }
            parent = parent.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(FileObject fo, boolean empty, boolean refreshImmediately) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        assert (path != null) : "Adding wrong folder " + fo + "(valid=" + fo.isValid() + ")" + "under root" + this.root + "(valid=" + this.root.isValid() + ")";
        if (this.get(fo) == null) {
            this.names2nodes.put(path, empty ? NODE_NOT_CREATED_EMPTY : NODE_NOT_CREATED);
            if (refreshImmediately) {
                this.refreshKeysAsync();
            } else {
                PackageViewChildren packageViewChildren = this;
                synchronized (packageViewChildren) {
                    if (this.refreshLazilyTask == null) {
                        this.refreshLazilyTask = PackageRootNode.PKG_VIEW_RP.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                PackageViewChildren packageViewChildren = PackageViewChildren.this;
                                synchronized (packageViewChildren) {
                                    PackageViewChildren.this.refreshLazilyTask = null;
                                    PackageViewChildren.this.refreshKeysAsync();
                                }
                            }
                        }, 2500);
                    }
                }
            }
        }
    }

    private void remove(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        assert (path != null) : "Removing wrong folder" + fo;
        this.names2nodes.remove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubTree(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        assert (path != null) : "Removing wrong folder" + fo;
        Map<String, Object> map = this.names2nodes;
        synchronized (map) {
            Set<String> keys = this.names2nodes.keySet();
            keys.remove(path);
            path = path + '/';
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                if (!it.next().startsWith(path)) continue;
                it.remove();
            }
        }
    }

    private PackageNode get(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        assert (path != null) : "Asking for wrong folder" + fo;
        Object o = this.names2nodes.get(path);
        return !this.isNodeCreated(o) ? null : (PackageNode)((Object)o);
    }

    private boolean contains(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        assert (path != null) : "Asking for wrong folder" + fo;
        Object o = this.names2nodes.get(path);
        return o != null;
    }

    private boolean exists(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        return this.names2nodes.get(path) != null;
    }

    private boolean isNodeCreated(Object o) {
        return o instanceof Node;
    }

    private PackageNode updatePath(String oldPath, String newPath) {
        assert (newPath != null);
        Object o = this.names2nodes.get(oldPath);
        if (o == null) {
            return null;
        }
        this.names2nodes.remove(oldPath);
        this.names2nodes.put(newPath, o);
        return !this.isNodeCreated(o) ? null : (PackageNode)((Object)o);
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileFolderCreated(final FileEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && this.isVisible(this.root, fo)) {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                PackageRootNode.PKG_VIEW_RP.post(new Runnable(){

                    @Override
                    public void run() {
                        PackageViewChildren.this.fileFolderCreated(fe);
                    }
                });
                return;
            }
            this.cleanEmptyKeys(fo);
            this.findNonExcludedPackages(fo);
            this.refreshKeys();
        }
    }

    public void fileDataCreated(final FileEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && this.isVisible(this.root, fo)) {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                PackageRootNode.PKG_VIEW_RP.post(new Runnable(){

                    @Override
                    public void run() {
                        PackageViewChildren.this.fileDataCreated(fe);
                    }
                });
                return;
            }
            FileObject parent = fo.getParent();
            if (!parent.isFolder()) {
                throw new IllegalStateException(FileUtil.getFileDisplayName((FileObject)parent) + " is not a folder!");
            }
            if (!VisibilityQuery.getDefault().isVisible(parent)) {
                return;
            }
            PackageNode n = this.get(parent);
            if (n == null && !this.contains(parent)) {
                this.add(parent, false, true);
                this.refreshKeysAsync();
            } else if (n != null) {
                n.updateChildren();
            }
        }
    }

    public void fileDeleted(final FileEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && this.isVisible(this.root, fo)) {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                PackageRootNode.PKG_VIEW_RP.post(new Runnable(){

                    @Override
                    public void run() {
                        PackageViewChildren.this.fileDeleted(fe);
                    }
                });
                return;
            }
            if (fo.isFolder() || this.get(fo) != null) {
                this.removeSubTree(fo);
                FileObject parent = fo.getParent();
                if (!parent.isFolder()) {
                    throw new IllegalStateException(FileUtil.getFileDisplayName((FileObject)parent) + " is not a folder!");
                }
                if ((FileUtil.isParentOf((FileObject)this.root, (FileObject)parent) || this.root.equals(parent)) && this.get(parent) == null && parent.isValid() && !this.toBeRemoved(parent)) {
                    this.add(parent, true, true);
                }
                this.refreshKeysAsync();
            } else {
                FileObject parent = fo.getParent();
                final PackageNode n = this.get(parent);
                if (n != null) {
                    DataFolder df;
                    boolean empty;
                    boolean leaf = n.isLeaf();
                    if (leaf != (empty = PackageViewChildren.isEmpty(df = n.getDataFolder()))) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                n.updateChildren();
                            }
                        });
                    } else {
                        n.updateChildren();
                    }
                }
                if (this.toBeRemoved(parent)) {
                    this.remove(parent);
                    this.refreshKeysAsync();
                }
            }
        }
    }

    private boolean toBeRemoved(FileObject folder) {
        boolean ignoredOnly = true;
        boolean foldersOnly = true;
        for (FileObject kid : folder.getChildren()) {
            if (!VisibilityQuery.getDefault().isVisible(kid)) continue;
            ignoredOnly = false;
            if (kid.isFolder()) continue;
            foldersOnly = false;
            break;
        }
        if (ignoredOnly) {
            return false;
        }
        return foldersOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileRenamed(final FileRenameEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && fo.isFolder()) {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                PackageRootNode.PKG_VIEW_RP.post(new Runnable(){

                    @Override
                    public void run() {
                        PackageViewChildren.this.fileRenamed(fe);
                    }
                });
                return;
            }
            String rp = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo.getParent());
            String oldPath = rp + (rp.length() == 0 ? "" : "/") + fe.getName() + fe.getExt();
            boolean visible = VisibilityQuery.getDefault().isVisible(fo);
            boolean doUpdate = false;
            ArrayList<String> needsUpdate = new ArrayList<String>();
            Map<String, Object> map = this.names2nodes;
            synchronized (map) {
                Iterator<String> it = this.names2nodes.keySet().iterator();
                while (it.hasNext()) {
                    String p = it.next();
                    if (!p.startsWith(oldPath)) continue;
                    if (visible) {
                        needsUpdate.add(p);
                        continue;
                    }
                    it.remove();
                    doUpdate = true;
                }
            }
            if (this.get(fo) == null && visible) {
                this.cleanEmptyKeys(fo);
                this.findNonExcludedPackages(fo);
                doUpdate = true;
            }
            int oldPathLen = oldPath.length();
            String newPath = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
            for (String p : needsUpdate) {
                StringBuilder np = new StringBuilder(p);
                np.replace(0, oldPathLen, newPath);
                PackageNode n = this.updatePath(p, np.toString());
                if (n == null) continue;
                n.updateDisplayName();
            }
            if (needsUpdate.size() > 1 || doUpdate) {
                this.refreshKeys();
            }
        }
    }

    private boolean isVisible(FileObject parent, FileObject file) {
        do {
            if (VisibilityQuery.getDefault().isVisible(file)) continue;
            return false;
        } while ((file = file.getParent()) != null && file != parent);
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.computeKeys();
        this.refreshKeys();
    }

    private static boolean isEmpty(DataFolder dataFolder) {
        if (dataFolder == null) {
            return true;
        }
        return PackageDisplayUtils.isEmpty(dataFolder.getPrimaryFile());
    }

    static boolean isValidPackageName(String name) {
        if (name.length() == 0) {
            return true;
        }
        StringTokenizer tk = new StringTokenizer(name, ".", true);
        boolean delimExpected = false;
        while (tk.hasMoreTokens()) {
            String namePart = tk.nextToken();
            if (!delimExpected) {
                if (namePart.equals(".")) {
                    return false;
                }
                for (int i = 0; i < namePart.length(); ++i) {
                    char c = namePart.charAt(i);
                    if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
                    return false;
                }
            } else if (!namePart.equals(".")) {
                return false;
            }
            delimExpected = !delimExpected;
        }
        return delimExpected;
    }

    private static final class NoFoldersContainer
    implements DataObject.Container,
    PropertyChangeListener,
    NonRecursiveFolder {
        private DataFolder folder;
        private PropertyChangeSupport prop = new PropertyChangeSupport(this);

        public NoFoldersContainer(DataFolder folder) {
            this.folder = folder;
        }

        public FileObject getFolder() {
            return this.folder.getPrimaryFile();
        }

        public DataObject[] getChildren() {
            DataObject[] arr = this.folder.getChildren();
            ArrayList<DataObject> list = new ArrayList<DataObject>(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] instanceof DataFolder) continue;
                list.add(arr[i]);
            }
            return list.size() == arr.length ? arr : list.toArray(new DataObject[0]);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop.removePropertyChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("children".equals(evt.getPropertyName())) {
                this.prop.firePropertyChange("children", null, null);
            }
        }
    }

    final class NoFoldersDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    DataFilter.FileBased {
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public NoFoldersDataFilter() {
            VisibilityQuery.getDefault().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault()));
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptFileObject(obj.getPrimaryFile());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        public boolean acceptFileObject(FileObject fo) {
            return fo.isValid() && VisibilityQuery.getDefault().isVisible(fo) && fo.isData() && PackageViewChildren.this.group.contains(fo);
        }
    }

    private static class NonRecursiveFolderSet
    extends HashSet<FileObject>
    implements NonRecursiveFolder {
        private final FileObject folder;

        public NonRecursiveFolderSet(FileObject folder) {
            this.folder = folder;
            this.add(folder);
        }

        public FileObject getFolder() {
            return this.folder;
        }
    }

    final class PackageNode
    extends FilterNode {
        private Action[] actions;
        private final FileObject root;
        private DataFolder dataFolder;
        private boolean isDefaultPackage;

        public PackageNode(FileObject root, DataFolder dataFolder) {
            this(root, dataFolder, PackageViewChildren.isEmpty(dataFolder));
        }

        public PackageNode(FileObject root, DataFolder dataFolder, boolean empty) {
            super(dataFolder.getNodeDelegate(), empty ? FilterNode.Children.LEAF : dataFolder.createNodeChildren(PackageViewChildren.this.NO_FOLDERS_FILTER), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)new NoFoldersContainer(dataFolder)), dataFolder.getNodeDelegate().getLookup(), Lookups.singleton((Object)SearchInfoDefinitionFactory.createFlatSearchInfo((FileObject)dataFolder.getPrimaryFile()))}));
            this.root = root;
            this.dataFolder = dataFolder;
            this.isDefaultPackage = root.equals(dataFolder.getPrimaryFile());
        }

        FileObject getRoot() {
            return this.root;
        }

        public String getName() {
            String relativePath = FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.dataFolder.getPrimaryFile());
            return relativePath == null ? null : relativePath.replace('/', '.');
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (this.actions == null) {
                    Action[] superActions = super.getActions(context);
                    ArrayList<Action> actionList = new ArrayList<Action>(superActions.length);
                    for (int i = 0; i < superActions.length; ++i) {
                        if (i <= superActions.length - 2 && superActions[i] == null && superActions[i + 1] instanceof PropertiesAction) {
                            ++i;
                            continue;
                        }
                        if (superActions[i] instanceof PropertiesAction) continue;
                        if (superActions[i] instanceof FileSystemAction) {
                            actionList.add(null);
                            actionList.add(FileSensitiveActions.fileCommandAction((String)"compile.single", (String)Bundle.LBL_CompilePackage_Action(), null));
                        }
                        actionList.add(superActions[i]);
                    }
                    this.actions = new Action[actionList.size()];
                    actionList.toArray(this.actions);
                }
                return this.actions;
            }
            return super.getActions(context);
        }

        public boolean canRename() {
            return !this.isDefaultPackage;
        }

        public boolean canCut() {
            return !this.isDefaultPackage;
        }

        public Transferable clipboardCopy() throws IOException {
            try {
                return new PackageTransferable(this, 1);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Transferable clipboardCut() throws IOException {
            try {
                return new PackageTransferable(this, 2);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Transferable drag() throws IOException {
            try {
                return new PackageTransferable(this, 0);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public PasteType[] getPasteTypes(Transferable t) {
            if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                    boolean hasPackageFlavor = false;
                    for (int i = 0; i < mto.getCount(); ++i) {
                        DataFlavor[] flavors = mto.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(flavors)) continue;
                        hasPackageFlavor = true;
                    }
                    return hasPackageFlavor ? new PasteType[]{} : super.getPasteTypes(t);
                }
                catch (UnsupportedFlavorException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return new PasteType[0];
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return new PasteType[0];
                }
            }
            DataFlavor[] flavors = t.getTransferDataFlavors();
            if (this.isPackageFlavor(flavors)) {
                return new PasteType[0];
            }
            return super.getPasteTypes(t);
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                    boolean hasPackageFlavor = false;
                    for (int i = 0; i < mto.getCount(); ++i) {
                        DataFlavor[] flavors = mto.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(flavors)) continue;
                        hasPackageFlavor = true;
                    }
                    return hasPackageFlavor ? null : super.getDropType(t, action, index);
                }
                catch (UnsupportedFlavorException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return null;
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return null;
                }
            }
            DataFlavor[] flavors = t.getTransferDataFlavors();
            if (this.isPackageFlavor(flavors)) {
                return null;
            }
            return super.getDropType(t, action, index);
        }

        private boolean isPackageFlavor(DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!PackageViewChildren.SUBTYPE.equals(flavors[i].getSubType()) || !PackageViewChildren.PRIMARY_TYPE.equals(flavors[i].getPrimaryType())) continue;
                return true;
            }
            return false;
        }

        private synchronized PackageRenameHandler getRenameHandler() {
            Collection handlers = Lookup.getDefault().lookupAll(PackageRenameHandler.class);
            if (handlers.size() == 0) {
                return null;
            }
            if (handlers.size() > 1) {
                LOG.warning("Multiple instances of PackageRenameHandler found in Lookup; only using first one: " + handlers);
            }
            return (PackageRenameHandler)handlers.iterator().next();
        }

        public void setName(String name) {
            int index;
            int i;
            PackageRenameHandler handler = this.getRenameHandler();
            if (handler != null) {
                handler.handleRename((Node)this, name);
                return;
            }
            if (this.isDefaultPackage) {
                return;
            }
            String oldName = this.getName();
            if (oldName.equals(name)) {
                return;
            }
            if (!PackageViewChildren.isValidPackageName(name)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_InvalidPackageName(), 1));
                return;
            }
            name = name.replace('.', '/') + '/';
            oldName = oldName.replace('.', '/') + '/';
            for (i = 0; i < oldName.length() && i < name.length() && oldName.charAt(i) == name.charAt(i); ++i) {
            }
            String commonPrefix = (index = oldName.lastIndexOf(47, --i)) == -1 ? null : oldName.substring(0, index);
            String toCreate = index + 1 == name.length() ? "" : name.substring(index + 1);
            try {
                FileObject commonFolder;
                FileObject destination = commonFolder = commonPrefix == null ? this.root : this.root.getFileObject(commonPrefix);
                StringTokenizer dtk = new StringTokenizer(toCreate, "/");
                while (dtk.hasMoreTokens()) {
                    String pathElement = dtk.nextToken();
                    FileObject tmp = destination.getFileObject(pathElement);
                    if (tmp == null) {
                        tmp = destination.createFolder(pathElement);
                    }
                    destination = tmp;
                }
                FileObject source = this.dataFolder.getPrimaryFile();
                DataFolder sourceFolder = DataFolder.findFolder((FileObject)source);
                DataFolder destinationFolder = DataFolder.findFolder((FileObject)destination);
                DataObject[] children = sourceFolder.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    if (!children[j].getPrimaryFile().isData()) continue;
                    children[j].move(destinationFolder);
                }
                while (!commonFolder.equals(source) && source.getChildren().length == 0) {
                    FileObject tmp = source;
                    source = source.getParent();
                    tmp.delete();
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }

        public boolean canDestroy() {
            return !this.isDefaultPackage;
        }

        public void destroy() throws IOException {
            FileObject parent = this.dataFolder.getPrimaryFile().getParent();
            DataObject[] ch = this.dataFolder.getChildren();
            boolean empty = true;
            for (int i = 0; ch != null && i < ch.length; ++i) {
                if (!ch[i].getPrimaryFile().isFolder()) {
                    ch[i].delete();
                    continue;
                }
                empty = false;
            }
            if (empty) {
                super.destroy();
            }
            while (!parent.equals(this.root) && parent.getChildren().length == 0) {
                FileObject newParent = parent.getParent();
                parent.delete();
                parent = newParent;
            }
        }

        public String getHtmlDisplayName() {
            Object name = this.getDisplayName();
            try {
                FileObject fo = this.dataFolder.getPrimaryFile();
                NonRecursiveFolderSet set = new NonRecursiveFolderSet(fo);
                FileSystem.Status status = fo.getFileSystem().getStatus();
                name = status instanceof FileSystem.HtmlStatus ? ((FileSystem.HtmlStatus)status).annotateNameHtml((String)name, (Set)set) : (((String)name).startsWith("<") ? null : status.annotateName((String)name, (Set)set));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return name;
        }

        public String getDisplayName() {
            FileObject folder = this.dataFolder.getPrimaryFile();
            String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)folder);
            if (path == null) {
                return "";
            }
            return PackageDisplayUtils.getDisplayLabel(path.replace('/', '.'));
        }

        public String getShortDescription() {
            FileObject folder = this.dataFolder.getPrimaryFile();
            String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)folder);
            if (path == null) {
                return "";
            }
            return PackageDisplayUtils.getToolTip(folder, path.replace('/', '.'));
        }

        public Image getIcon(int type) {
            Image img = this.getMyIcon(type);
            try {
                FileObject fo = this.dataFolder.getPrimaryFile();
                NonRecursiveFolderSet set = new NonRecursiveFolderSet(fo);
                img = fo.getFileSystem().getStatus().annotateIcon(img, type, (Set)set);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = this.getMyOpenedIcon(type);
            try {
                FileObject fo = this.dataFolder.getPrimaryFile();
                NonRecursiveFolderSet set = new NonRecursiveFolderSet(fo);
                img = fo.getFileSystem().getStatus().annotateIcon(img, type, (Set)set);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return img;
        }

        private Image getMyIcon(int type) {
            FileObject folder = this.dataFolder.getPrimaryFile();
            String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)folder);
            if (path == null) {
                return ImageUtilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/package.gif");
            }
            return PackageDisplayUtils.getIcon(folder, this.isLeaf());
        }

        private Image getMyOpenedIcon(int type) {
            return this.getMyIcon(type);
        }

        public void update() {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public void updateDisplayName() {
            this.fireNameChange(null, null);
            this.fireDisplayNameChange(null, null);
            this.fireShortDescriptionChange(null, null);
        }

        public void updateChildren() {
            DataFolder df;
            boolean empty;
            boolean leaf = this.isLeaf();
            if (leaf != (empty = PackageViewChildren.isEmpty(df = this.getDataFolder()))) {
                this.setChildren(empty ? FilterNode.Children.LEAF : df.createNodeChildren(PackageViewChildren.this.NO_FOLDERS_FILTER));
                this.update();
            }
        }

        public Node.PropertySet[] getPropertySets() {
            Node.PropertySet[] properties = super.getPropertySets();
            ArrayList<Node.PropertySet> result = new ArrayList<Node.PropertySet>(properties.length);
            for (Node.PropertySet set : properties) {
                if (set == null) continue;
                if ("properties".equals(set.getName())) {
                    set = Sheet.createPropertiesSet();
                    ((Sheet.Set)set).put((Node.Property)new PropertySupport.ReadWrite<String>("name", String.class, Bundle.PROP_name(), Bundle.HINT_name()){

                        public String getValue() {
                            return PackageNode.this.getName();
                        }

                        public void setValue(String n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            if (!PackageNode.this.canRename()) {
                                throw new IllegalAccessException();
                            }
                            PackageNode.this.setName(n);
                        }

                        public boolean canWrite() {
                            return PackageNode.this.canRename();
                        }
                    });
                }
                result.add(set);
            }
            return result.toArray(new Node.PropertySet[result.size()]);
        }

        private DataFolder getDataFolder() {
            return (DataFolder)this.getCookie(DataFolder.class);
        }
    }

    static class PackagePasteType
    extends PasteType {
        private int op;
        private PackageNode[] nodes;
        private FileObject srcRoot;

        public PackagePasteType(FileObject srcRoot, PackageNode[] node, int op) {
            assert (op == 1 || op == 2 || op == 0) : "Invalid DnD operation";
            this.nodes = node;
            this.op = op;
            this.srcRoot = srcRoot;
        }

        public void setOperation(int op) {
            this.op = op;
        }

        public Transferable paste() throws IOException {
            if (SwingUtilities.isEventDispatchThread()) {
                PackageRootNode.PKG_VIEW_RP.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle h = ProgressHandleFactory.createHandle((String)PackagePasteType.this.getName());
                        h.start();
                        h.switchToIndeterminate();
                        try {
                            PackagePasteType.this.doPaste();
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace((Throwable)ioe);
                        }
                        finally {
                            h.finish();
                        }
                    }
                });
            } else {
                this.doPaste();
            }
            return ExTransferable.EMPTY;
        }

        public String getName() {
            return Bundle.TXT_PastePackage();
        }

        private void doPaste() throws IOException {
            assert (this.op != 0);
            for (int ni = 0; ni < this.nodes.length; ++ni) {
                FileObject fo = this.srcRoot;
                if (!this.nodes[ni].isDefaultPackage) {
                    String pkgName = this.nodes[ni].getName();
                    StringTokenizer tk = new StringTokenizer(pkgName, ".");
                    while (tk.hasMoreTokens()) {
                        String name = tk.nextToken();
                        FileObject tmp = fo.getFileObject(name, null);
                        if (tmp == null) {
                            tmp = fo.createFolder(name);
                        }
                        fo = tmp;
                    }
                }
                DataFolder dest = DataFolder.findFolder((FileObject)fo);
                DataObject[] children = this.nodes[ni].dataFolder.getChildren();
                boolean cantDelete = false;
                for (int i = 0; i < children.length; ++i) {
                    if (children[i].getPrimaryFile().isData() && VisibilityQuery.getDefault().isVisible(children[i].getPrimaryFile())) {
                        if (this.op == 2) {
                            children[i].move(dest);
                            continue;
                        }
                        children[i].copy(dest);
                        continue;
                    }
                    cantDelete = true;
                }
                if (this.op != 2 || cantDelete) continue;
                try {
                    FileObject tmpFo = this.nodes[ni].dataFolder.getPrimaryFile();
                    FileObject originalRoot = this.nodes[ni].root;
                    assert (tmpFo != null && originalRoot != null);
                    while (!tmpFo.equals(originalRoot) && tmpFo.getChildren().length == 0) {
                        FileObject tmpFoParent = tmpFo.getParent();
                        tmpFo.delete();
                        tmpFo = tmpFoParent;
                    }
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    static class PackageTransferable
    extends ExTransferable.Single {
        private PackageNode node;

        public PackageTransferable(PackageNode node, int operation) throws ClassNotFoundException {
            super(new DataFlavor(PACKAGE_FLAVOR.format(new Object[]{new Integer(operation)}), null, PackageNode.class.getClassLoader()));
            this.node = node;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }
}

