/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.LookupMerger;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

final class ClassPathProviderMerger
implements LookupMerger<ClassPathProvider> {
    private final ClassPathProvider defaultProvider;

    ClassPathProviderMerger(ClassPathProvider defaultProvider) {
        assert (defaultProvider != null);
        this.defaultProvider = defaultProvider;
    }

    public Class<ClassPathProvider> getMergeableClass() {
        return ClassPathProvider.class;
    }

    public ClassPathProvider merge(Lookup lookup) {
        return new CPProvider(lookup);
    }

    static FilteringPathResourceImplementation getClassPathImplementation(ClassPath path) {
        return new ProxyFilteringCPI(path);
    }

    private class CPProvider
    implements ClassPathProvider {
        private final Lookup lookup;
        private final Map<FileObject, Map<String, ClassPath>> cpCache = new HashMap<FileObject, Map<String, ClassPath>>();

        public CPProvider(Lookup lookup) {
            assert (lookup != null);
            this.lookup = lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassPath findClassPath(FileObject file, String type) {
            Map<FileObject, Map<String, ClassPath>> map = this.cpCache;
            synchronized (map) {
                ClassPath path;
                Map<String, ClassPath> cptype = this.cpCache.get(file);
                if (cptype != null && (path = cptype.get(type)) != null) {
                    return path;
                }
            }
            ProxyClassPathImplementation result = new ProxyClassPathImplementation(ClassPathProviderMerger.this.defaultProvider, this.lookup, file, type);
            if (!result.hasAnyResults()) {
                return null;
            }
            ClassPath cp = ClassPathFactory.createClassPath((ClassPathImplementation)result);
            Map<FileObject, Map<String, ClassPath>> map2 = this.cpCache;
            synchronized (map2) {
                Map<String, ClassPath> cptype = this.cpCache.get(file);
                if (cptype == null) {
                    cptype = new HashMap<String, ClassPath>();
                    this.cpCache.put(file, cptype);
                }
                cptype.put(type, cp);
            }
            return cp;
        }
    }

    class ProxyClassPathImplementation
    implements ClassPathImplementation {
        private PathResourceImplementation[] classPaths;
        private List<PathResourceImplementation> resourcesCache;
        private ArrayList<PropertyChangeListener> listeners;
        private LookupListener lookupList;
        private Lookup.Result<ClassPathProvider> providers;
        private ClassPathProvider mainProvider;
        private PropertyChangeListener classPathsListener;
        private FileObject file;
        private String type;
        private boolean hasAny = false;

        public ProxyClassPathImplementation(ClassPathProvider dominant, Lookup context, FileObject fo, String type) {
            assert (dominant != null);
            this.type = type;
            this.file = fo;
            this.mainProvider = dominant;
            this.providers = context.lookupResult(ClassPathProvider.class);
            this.classPathsListener = new DelegatesListener();
            this.checkProviders();
            this.lookupList = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    ProxyClassPathImplementation.this.checkProviders();
                }
            };
            this.providers.addLookupListener(this.lookupList);
        }

        boolean hasAnyResults() {
            return this.hasAny;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkProviders() {
            this.hasAny = false;
            ArrayList<FilteringPathResourceImplementation> impls = new ArrayList<FilteringPathResourceImplementation>();
            ClassPath mainResult = this.mainProvider.findClassPath(this.file, this.type);
            if (mainResult != null) {
                this.hasAny = true;
                impls.add(ClassPathProviderMerger.getClassPathImplementation(mainResult));
            }
            for (ClassPathProvider prvd : this.providers.allInstances()) {
                ClassPath path = prvd.findClassPath(this.file, this.type);
                if (path == null) continue;
                impls.add(ClassPathProviderMerger.getClassPathImplementation(path));
                this.hasAny = true;
            }
            ProxyClassPathImplementation i$ = this;
            synchronized (i$) {
                this.classPaths = impls.toArray(new PathResourceImplementation[impls.size()]);
            }
            PropertyChangeEvent ev = new PropertyChangeEvent(this, "resources", null, null);
            this.firePropertyChange(ev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            ProxyClassPathImplementation proxyClassPathImplementation = this;
            synchronized (proxyClassPathImplementation) {
                if (this.resourcesCache != null) {
                    return this.resourcesCache;
                }
            }
            ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>(this.classPaths.length * 10);
            for (PathResourceImplementation cpImpl : this.classPaths) {
                result.add(cpImpl);
            }
            ProxyClassPathImplementation proxyClassPathImplementation2 = this;
            synchronized (proxyClassPathImplementation2) {
                if (this.resourcesCache == null) {
                    this.resourcesCache = Collections.unmodifiableList(result);
                }
                return this.resourcesCache;
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("[");
            for (PathResourceImplementation cpImpl : this.classPaths) {
                builder.append(cpImpl.toString());
                builder.append(", ");
            }
            builder.append("]");
            return builder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePropertyChange(PropertyChangeEvent event) {
            PropertyChangeListener[] _listeners;
            ProxyClassPathImplementation proxyClassPathImplementation = this;
            synchronized (proxyClassPathImplementation) {
                this.resourcesCache = null;
                if (this.listeners == null) {
                    return;
                }
                _listeners = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
            }
            for (PropertyChangeListener l : _listeners) {
                l.propertyChange(event);
            }
        }

        private class DelegatesListener
        implements PropertyChangeListener {
            private DelegatesListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyChangeEvent event = new PropertyChangeEvent(ProxyClassPathImplementation.this, evt.getPropertyName(), null, null);
                ProxyClassPathImplementation.this.firePropertyChange(event);
            }
        }
    }

    private static class ProxyFilteringCPI
    implements FilteringPathResourceImplementation,
    PropertyChangeListener {
        private final ClassPath classpath;
        private final PropertyChangeSupport changeSupport;

        private ProxyFilteringCPI(ClassPath path) {
            assert (path != null);
            this.classpath = path;
            this.changeSupport = new PropertyChangeSupport(this);
            this.classpath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.classpath));
        }

        public boolean includes(URL root, String resource) {
            for (ClassPath.Entry ent : this.classpath.entries()) {
                if (!ent.getURL().equals(root)) continue;
                return ent.includes(resource);
            }
            return false;
        }

        public URL[] getRoots() {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (ClassPath.Entry ent : this.classpath.entries()) {
                urls.add(ent.getURL());
            }
            return urls.toArray(new URL[urls.size()]);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("entries".equals(propName)) {
                this.changeSupport.firePropertyChange("roots", null, null);
            } else if ("includes".equals(propName)) {
                this.changeSupport.firePropertyChange("includes", null, null);
            }
        }
    }
}

