/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.project.Bundle;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class BrokenReferencesModel
extends AbstractListModel {
    private static final Logger LOG = Logger.getLogger(BrokenReferencesModel.class.getName());
    private final Context ctx;
    private final boolean global;
    private List<OneReference> references;

    public BrokenReferencesModel(AntProjectHelper helper, ReferenceHelper resolver, String[] props, String[] platformsProps) {
        this(new Context(new BrokenProject(helper, resolver, helper.getStandardPropertyEvaluator(), props, platformsProps)), false);
    }

    public BrokenReferencesModel(@NonNull Context ctx, boolean global) {
        assert (ctx != null);
        this.ctx = ctx;
        this.global = global;
        this.references = new ArrayList<OneReference>();
        this.refresh();
        ctx.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BrokenReferencesModel.this.refresh();
            }
        });
    }

    public void refresh() {
        LinkedHashSet<OneReference> all = new LinkedHashSet<OneReference>();
        for (BrokenProject bprj : this.ctx.getBrokenProjects()) {
            Set<OneReference> s = BrokenReferencesModel.getReferences(bprj, false);
            all.addAll(s);
            s = BrokenReferencesModel.getPlatforms(bprj, false);
            all.addAll(s);
        }
        BrokenReferencesModel.updateReferencesList(this.references, all);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public Object getElementAt(int index) {
        OneReference or = this.getOneReference(index);
        Project prj = or.bprj.getProject();
        if (this.global && prj != null) {
            String projectName = ProjectUtils.getInformation((Project)prj).getDisplayName();
            switch (or.type) {
                case LIBRARY: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenLibrary_In_Project(or.getDisplayID(), projectName);
                }
                case DEFINABLE_LIBRARY: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenDefinableLibrary_In_Project(or.getDisplayID(), projectName);
                }
                case LIBRARY_CONTENT: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenLibraryContent_In_Project(or.getDisplayID(), projectName);
                }
                case PROJECT: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenProjectReference_In_Project(or.getDisplayID(), projectName);
                }
                case FILE: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenFileReference_In_Project(or.getDisplayID(), projectName);
                }
                case VARIABLE: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenVariable_In_Project(or.getDisplayID(), projectName);
                }
                case VARIABLE_CONTENT: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenVariableContent_In_Project(or.getDisplayID(), projectName);
                }
                case PLATFORM: {
                    return Bundle.LBL_BrokenLinksCustomizer_BrokenPlatform_In_Project(or.getDisplayID(), projectName);
                }
            }
            assert (false);
            return null;
        }
        switch (or.type) {
            case LIBRARY: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenLibrary(or.getDisplayID());
            }
            case DEFINABLE_LIBRARY: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenDefinableLibrary(or.getDisplayID());
            }
            case LIBRARY_CONTENT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenLibraryContent(or.getDisplayID());
            }
            case PROJECT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenProjectReference(or.getDisplayID());
            }
            case FILE: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenFileReference(or.getDisplayID());
            }
            case VARIABLE: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenVariable(or.getDisplayID());
            }
            case VARIABLE_CONTENT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenVariableContent(or.getDisplayID());
            }
            case PLATFORM: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenPlatform(or.getDisplayID());
            }
        }
        assert (false);
        return null;
    }

    public OneReference getOneReference(int index) {
        assert (index >= 0 && index < this.references.size());
        return this.references.get(index);
    }

    public boolean isBroken(int index) {
        return this.references.get(index).broken;
    }

    @Override
    public int getSize() {
        return this.references.size();
    }

    public static boolean isBroken(AntProjectHelper helper, ReferenceHelper refHelper, PropertyEvaluator evaluator, String[] props, String[] platformsProps) {
        BrokenProject bprj = new BrokenProject(helper, refHelper, evaluator, props, platformsProps);
        Set<OneReference> s = BrokenReferencesModel.getReferences(bprj, true);
        if (s.size() > 0) {
            return true;
        }
        s = BrokenReferencesModel.getPlatforms(bprj, true);
        return s.size() > 0;
    }

    private static Set<OneReference> getReferences(BrokenProject bprj, boolean abortAfterFirstProblem) {
        Map entries;
        LinkedHashSet<OneReference> set = new LinkedHashSet<OneReference>();
        StringBuilder all = new StringBuilder();
        LibraryManager.getDefault().getLibraries();
        AntProjectHelper helper = bprj.getAntProjectHelper();
        PropertyEvaluator evaluator = bprj.getEvaluator();
        ReferenceHelper refHelper = bprj.getReferenceHelper();
        if (helper == null || evaluator == null || refHelper == null) {
            return set;
        }
        String[] ps = bprj.getProperties();
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        for (String p : ps) {
            String[] vals;
            String prop = evaluator.getProperty(p);
            if (prop == null) continue;
            LOG.log(Level.FINE, "Evaluated {0}={1}", new Object[]{p, prop});
            for (String v : vals = PropertyUtils.tokenizePath((String)prop)) {
                if (!(v.startsWith("${file.reference.") || v.startsWith("${project.") || v.startsWith("${libs.") || v.startsWith("${var."))) {
                    all.append(v);
                    continue;
                }
                if (v.startsWith("${project.")) {
                    String val = v.substring(2, v.indexOf(125));
                    set.add(new OneReference(bprj, RefType.PROJECT, val, true));
                } else {
                    RefType type = RefType.LIBRARY;
                    if (v.startsWith("${file.reference")) {
                        type = RefType.FILE;
                    } else if (v.startsWith("${var")) {
                        type = RefType.VARIABLE;
                    }
                    String val = v.substring(2, v.length() - 1);
                    set.add(new OneReference(bprj, type, val, true));
                }
                if (abortAfterFirstProblem) break;
            }
            if (set.size() > 0 && abortAfterFirstProblem) break;
            String path = ep.getProperty(p);
            if (path == null) continue;
            for (String v : PropertyUtils.tokenizePath((String)path)) {
                File f;
                String value;
                if (v.startsWith("${file.reference.")) {
                    v = ep.getProperty(v.substring(2, v.length() - 1));
                }
                if (v == null || !v.startsWith("${var.") || (value = evaluator.evaluate(v)).startsWith("${var.") || (f = BrokenReferencesModel.getFile(helper, evaluator, value)).exists()) continue;
                set.add(new OneReference(bprj, RefType.VARIABLE_CONTENT, v, true));
            }
        }
        if ((entries = evaluator.getProperties()) == null) {
            throw new IllegalArgumentException("Properies mapping could not be computed (e.g. due to a circular definition). Evaluator: " + evaluator.toString());
        }
        for (Map.Entry entry : entries.entrySet()) {
            boolean alreadyChecked;
            File f;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("project.")) {
                if ("project.license".equals(key) || (f = BrokenReferencesModel.getFile(helper, evaluator, value)).exists() || all.indexOf(value) == -1) continue;
                set.add(new OneReference(bprj, RefType.PROJECT, key, true));
                continue;
            }
            if (!key.startsWith("file.reference")) continue;
            f = BrokenReferencesModel.getFile(helper, evaluator, value);
            String unevaluatedValue = ep.getProperty(key);
            boolean bl = alreadyChecked = unevaluatedValue != null ? unevaluatedValue.startsWith("${var.") : false;
            if (f.exists() || all.indexOf(value) == -1 || alreadyChecked) continue;
            set.add(new OneReference(bprj, RefType.FILE, key, true));
        }
        HashSet<String> usedLibraries = new HashSet<String>();
        Pattern libPattern = Pattern.compile("\\$\\{(libs\\.[-._a-zA-Z0-9]+\\.classpath)\\}");
        for (String p : ps) {
            String propertyValue = ep.getProperty(p);
            if (propertyValue == null) continue;
            for (String v : PropertyUtils.tokenizePath((String)propertyValue)) {
                Matcher m = libPattern.matcher(v);
                if (!m.matches()) continue;
                usedLibraries.add(m.group(1));
            }
        }
        block6: for (String libraryRef : usedLibraries) {
            String libraryName = libraryRef.substring(5, libraryRef.length() - 10);
            Library lib = refHelper.findLibrary(libraryName);
            if (lib == null) {
                set.add(new OneReference(bprj, RefType.LIBRARY, libraryRef, true));
                continue;
            }
            for (URI uri : lib.getURIContent("classpath")) {
                FileObject fo;
                URI uri2 = LibrariesSupport.getArchiveFile((URI)uri);
                if (uri2 == null) {
                    uri2 = uri;
                }
                if (null != (fo = LibrariesSupport.resolveLibraryEntryFileObject((URL)lib.getManager().getLocation(), (URI)uri2)) || BrokenReferencesModel.canResolveEvaluatedUri(helper.getStandardPropertyEvaluator(), lib.getManager().getLocation(), uri2)) continue;
                set.add(new OneReference(bprj, RefType.LIBRARY_CONTENT, libraryRef, true));
                continue block6;
            }
        }
        return set;
    }

    private static boolean canResolveEvaluatedUri(PropertyEvaluator eval, URL libBase, URI libUri) {
        if (libUri.isAbsolute()) {
            return false;
        }
        String path = LibrariesSupport.convertURIToFilePath((URI)libUri);
        String newPath = eval.evaluate(path);
        if (newPath.equals(path)) {
            return false;
        }
        URI newUri = LibrariesSupport.convertFilePathToURI((String)newPath);
        return null != LibrariesSupport.resolveLibraryEntryFileObject((URL)libBase, (URI)newUri);
    }

    private static File getFile(AntProjectHelper helper, PropertyEvaluator evaluator, String name) {
        if (helper != null) {
            return new File(helper.resolvePath(name));
        }
        File f = new File(name);
        if (!f.exists()) {
            String basedir = evaluator.getProperty("basedir");
            assert (basedir != null);
            f = new File(new File(basedir), name);
        }
        return f;
    }

    private static Set<OneReference> getPlatforms(BrokenProject bprj, boolean abortAfterFirstProblem) {
        LinkedHashSet<OneReference> set = new LinkedHashSet<OneReference>();
        PropertyEvaluator evaluator = bprj.getEvaluator();
        if (evaluator == null) {
            return set;
        }
        for (String pprop : bprj.getPlatformProperties()) {
            String prop = evaluator.getProperty(pprop);
            if (prop == null) continue;
            if (!BrokenReferencesModel.existPlatform(prop)) {
                if (evaluator.getProperty(pprop + ".description") != null) {
                    prop = evaluator.getProperty(pprop + ".description");
                }
                set.add(new OneReference(bprj, RefType.PLATFORM, prop, true));
            }
            if (set.size() > 0 && abortAfterFirstProblem) break;
        }
        return set;
    }

    private static void updateReferencesList(List<OneReference> oldBroken, Set<OneReference> newBroken) {
        LOG.log(Level.FINE, "References updated from {0} to {1}", new Object[]{oldBroken, newBroken});
        for (OneReference or : oldBroken) {
            if (newBroken.contains(or)) {
                or.broken = true;
                continue;
            }
            or.broken = false;
        }
        for (OneReference or : newBroken) {
            if (oldBroken.contains(or)) continue;
            oldBroken.add(or);
        }
    }

    private static boolean existPlatform(String platform) {
        if (platform.equals("default_platform")) {
            return true;
        }
        for (JavaPlatform plat : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!platform.equals(plat.getProperties().get("platform.ant.name")) || plat.getInstallFolders().size() <= 0) continue;
            return true;
        }
        return false;
    }

    void updateReference(int index, File file) {
        this.updateReference0(index, file);
        OneReference or = this.getOneReference(index);
        if (or.getType() != RefType.FILE) {
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            File f;
            if (!this.isBroken(i) || i == index || (or = this.getOneReference(i)).getType() != RefType.FILE || !(f = new File(file.getParentFile(), or.getDisplayID())).exists()) continue;
            this.updateReference0(i, f);
        }
    }

    private void updateReference0(int index, File file) {
        Project p;
        OneReference ref = this.getOneReference(index);
        final String reference = ref.ID;
        final AntProjectHelper helper = ref.bprj.getAntProjectHelper();
        if (helper == null) {
            return;
        }
        FileObject myProjDirFO = helper.getProjectDirectory();
        String propertiesFile = "nbproject/private/private.properties";
        final String path = file.getAbsolutePath();
        try {
            p = ProjectManager.getDefault().findProject(myProjDirFO);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            p = null;
        }
        final Project proj = p;
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                EditableProperties props = helper.getProperties("nbproject/private/private.properties");
                if (!path.equals(props.getProperty(reference))) {
                    props.setProperty(reference, path);
                    helper.putProperties("nbproject/private/private.properties", props);
                }
                if (proj != null) {
                    try {
                        ProjectManager.getDefault().saveProject(proj);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }

    LibraryManager getProjectLibraryManager(@NonNull OneReference or) {
        assert (or != null);
        ReferenceHelper resolver = or.bprj.getReferenceHelper();
        return resolver == null ? null : (resolver.getProjectLibraryManager() != null ? resolver.getProjectLibraryManager() : LibraryManager.getDefault());
    }

    public static final class BrokenProject {
        private final Reference<AntProjectHelper> helper;
        private final Reference<ReferenceHelper> referenceHelper;
        private final Reference<PropertyEvaluator> evaluator;
        private final String[] properties;
        private final String[] platformProperties;

        public BrokenProject(@NonNull AntProjectHelper helper, @NonNull ReferenceHelper referenceHelper, @NonNull PropertyEvaluator evaluator, @NonNull String[] properties, @NonNull String[] platformProperties) {
            assert (helper != null);
            assert (referenceHelper != null);
            assert (properties != null);
            assert (platformProperties != null);
            this.helper = new WeakReference<AntProjectHelper>(helper);
            this.referenceHelper = new WeakReference<ReferenceHelper>(referenceHelper);
            this.evaluator = new WeakReference<PropertyEvaluator>(evaluator);
            this.properties = Arrays.copyOf(properties, properties.length);
            this.platformProperties = Arrays.copyOf(platformProperties, platformProperties.length);
        }

        AntProjectHelper getAntProjectHelper() {
            return this.helper.get();
        }

        Project getProject() {
            AntProjectHelper h = this.getAntProjectHelper();
            return h == null ? null : FileOwnerQuery.getOwner((FileObject)h.getProjectDirectory());
        }

        ReferenceHelper getReferenceHelper() {
            return this.referenceHelper.get();
        }

        PropertyEvaluator getEvaluator() {
            return this.evaluator.get();
        }

        String[] getProperties() {
            return this.properties;
        }

        String[] getPlatformProperties() {
            return this.platformProperties;
        }

        public boolean equals(Object other) {
            FileObject otherDir;
            if (!(other instanceof BrokenProject)) {
                return false;
            }
            AntProjectHelper myAPH = this.getAntProjectHelper();
            AntProjectHelper otherAPH = ((BrokenProject)other).getAntProjectHelper();
            FileObject myDir = myAPH == null ? null : myAPH.getProjectDirectory();
            FileObject fileObject = otherDir = otherAPH == null ? null : otherAPH.getProjectDirectory();
            return myDir == null ? otherDir == null : myDir.equals(otherDir);
        }

        public int hashCode() {
            AntProjectHelper h = this.getAntProjectHelper();
            return h == null ? 0 : h.getProjectDirectory().hashCode();
        }
    }

    public static final class Context {
        private final List<BrokenProject> toResolve = Collections.synchronizedList(new LinkedList());
        private final ChangeSupport support = new ChangeSupport((Object)this);

        public Context() {
        }

        private Context(@NonNull BrokenProject broken) {
            this();
            this.offer(broken);
        }

        public void offer(BrokenProject broken) {
            assert (broken != null);
            this.toResolve.add(broken);
            this.support.fireChange();
        }

        public boolean isEmpty() {
            return this.toResolve.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BrokenProject[] getBrokenProjects() {
            List<BrokenProject> list = this.toResolve;
            synchronized (list) {
                return this.toResolve.toArray(new BrokenProject[this.toResolve.size()]);
            }
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            assert (listener != null);
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            assert (listener != null);
            this.support.removeChangeListener(listener);
        }
    }

    public static final class OneReference {
        private final BrokenProject bprj;
        private final RefType type;
        private boolean broken;
        private final String ID;
        private final Callable<Library> definer;

        OneReference(@NonNull BrokenProject bprj, @NonNull RefType type, @NonNull String ID, boolean broken) {
            assert (bprj != null);
            Callable<Library> _definer = null;
            if (type == RefType.LIBRARY) {
                String name = ID.substring(5, ID.length() - 10);
                for (BrokenReferencesSupport.LibraryDefiner ld : Lookup.getDefault().lookupAll(BrokenReferencesSupport.LibraryDefiner.class)) {
                    _definer = ld.missingLibrary(name);
                    if (_definer == null) continue;
                    type = RefType.DEFINABLE_LIBRARY;
                    break;
                }
            }
            this.bprj = bprj;
            this.type = type;
            this.ID = ID;
            this.broken = broken;
            this.definer = _definer;
        }

        public RefType getType() {
            return this.type;
        }

        public String getDisplayID() {
            switch (this.type) {
                case LIBRARY: 
                case DEFINABLE_LIBRARY: 
                case LIBRARY_CONTENT: {
                    return this.ID.substring(5, this.ID.length() - 10);
                }
                case PROJECT: {
                    return this.ID.substring(8);
                }
                case FILE: {
                    return this.ID.substring(15);
                }
                case PLATFORM: {
                    return this.ID;
                }
                case VARIABLE: {
                    return this.ID.substring(4, this.ID.indexOf(125));
                }
                case VARIABLE_CONTENT: {
                    return this.ID.substring(6, this.ID.indexOf(125)) + this.ID.substring(this.ID.indexOf(125) + 1);
                }
            }
            assert (false);
            return this.ID;
        }

        public Library define() throws Exception {
            return this.definer.call();
        }

        public String toString() {
            return (Object)((Object)this.type) + ":" + this.ID + (this.broken ? "" : "[fixed]");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneReference)) {
                return false;
            }
            OneReference or = (OneReference)o;
            return this.type == or.type && this.ID.equals(or.ID) && this.bprj.equals(or.bprj);
        }

        public int hashCode() {
            int result = 7 * this.type.hashCode();
            result = 31 * result + this.ID.hashCode();
            return result;
        }
    }

    static enum RefType {
        PROJECT,
        FILE,
        PLATFORM,
        LIBRARY,
        DEFINABLE_LIBRARY,
        LIBRARY_CONTENT,
        VARIABLE,
        VARIABLE_CONTENT;

    }
}

