/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.project.classpath.ProjectClassPathModifierAccessor;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class ProjectClassPathModifier {
    private ProjectClassPathModifier() {
    }

    public static boolean addLibraries(Library[] libraries, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addLibraries(libraries, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean result = false;
        for (Library library : libraries) {
            result |= extensible.pcpe.addLibrary(library);
        }
        return result;
    }

    public static boolean removeLibraries(Library[] libraries, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeLibraries(libraries, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove libraries using " + extensible);
    }

    public static boolean addRoots(URL[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Parameters.notNull((CharSequence)"classPathRoots", (Object)classPathRoots);
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean result = false;
        for (URL urlToAdd : classPathRoots) {
            FileObject fo;
            Parameters.notNull((CharSequence)"classPathRoots", (Object)urlToAdd);
            if ("jar".equals(urlToAdd.getProtocol())) {
                urlToAdd = FileUtil.getArchiveFile((URL)urlToAdd);
            }
            if ((fo = URLMapper.findFileObject((URL)urlToAdd)) == null) {
                throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
            }
            result |= extensible.pcpe.addArchiveFile(fo);
        }
        return result;
    }

    public static boolean addRoots(URI[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean result = false;
        Project project = FileOwnerQuery.getOwner((FileObject)projectArtifact);
        File projectFolderFile = FileUtil.toFile((FileObject)project.getProjectDirectory());
        for (URI uri : classPathRoots) {
            FileObject fo;
            URI urlToAdd = LibrariesSupport.getArchiveFile((URI)uri);
            if (urlToAdd == null) {
                urlToAdd = uri;
            }
            if (urlToAdd.isAbsolute()) {
                fo = FileUtil.toFileObject((File)Utilities.toFile((URI)urlToAdd));
            } else {
                File f = PropertyUtils.resolveFile((File)projectFolderFile, (String)LibrariesSupport.convertURIToFilePath((URI)urlToAdd));
                fo = FileUtil.toFileObject((File)f);
            }
            if (fo == null) {
                throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
            }
            result |= extensible.pcpe.addArchiveFile(fo);
        }
        return result;
    }

    public static boolean removeRoots(URL[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove roots from " + extensible);
    }

    public static boolean removeRoots(URI[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove roots from " + extensible);
    }

    public static boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        assert (artifacts.length == artifactElements.length);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addAntArtifacts(artifacts, artifactElements, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        boolean result = false;
        for (int i = 0; i < artifacts.length; ++i) {
            result |= extensible.pcpe.addAntArtifact(artifacts[i], artifactElements[i]);
        }
        return result;
    }

    public static boolean addProjects(Project[] projects, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.addProjects(projects, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot add project as dependency. Missing ProjectClassPathModifierImplementation service in project type.");
    }

    public static boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeAntArtifacts(artifacts, artifactElements, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove artifacts from " + extensible);
    }

    private static Extensible findExtensible(FileObject projectArtifact, String classPathType) throws UnsupportedOperationException {
        assert (projectArtifact != null);
        assert (classPathType != null);
        Project project = FileOwnerQuery.getOwner((FileObject)projectArtifact);
        if (project == null) {
            throw new UnsupportedOperationException("No project found to correspond to " + FileUtil.getFileDisplayName((FileObject)projectArtifact));
        }
        ProjectClassPathModifierImplementation pm = (ProjectClassPathModifierImplementation)project.getLookup().lookup(ProjectClassPathModifierImplementation.class);
        if (pm != null) {
            SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pm);
            assert (sgs != null) : "Class: " + pm.getClass() + " returned null as source groups.";
            for (SourceGroup sg : sgs) {
                if (projectArtifact != sg.getRootFolder() && !FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)projectArtifact) || !sg.contains(projectArtifact)) continue;
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pm, sg);
                assert (types != null) : "Class: " + pm.getClass() + " returned null as classpath types.";
                for (String type : types) {
                    if (!classPathType.equals(type)) continue;
                    String label = "ProjectClassPathModifierImplementation for " + classPathType + " on " + FileUtil.getFileDisplayName((FileObject)sg.getRootFolder());
                    return new Extensible(pm, sg, type, label);
                }
            }
            throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has a ProjectClassPathModifierImplementation but it will not handle " + classPathType + " for " + FileUtil.getFileDisplayName((FileObject)projectArtifact) + " extensible source groups: " + ProjectClassPathModifier.sourceGroupsToString(sgs));
        }
        ProjectClassPathExtender pe = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        if (pe != null) {
            if (classPathType.equals("classpath/compile")) {
                return new Extensible(pe, "ProjectClassPathExtender for " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
            }
            throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has a ProjectClassPathExtender in its lookup but no ProjectClassPathModifierImplementation to handle " + classPathType);
        }
        throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has neither a ProjectClassPathModifierImplementation nor a ProjectClassPathExtender in its lookup");
    }

    private static String sourceGroupsToString(SourceGroup[] sgs) {
        StringBuilder sb = new StringBuilder();
        for (SourceGroup sg : sgs) {
            if (sb.length() != 0) {
                sb.append(':');
            }
            sb.append(FileUtil.getFileDisplayName((FileObject)sg.getRootFolder()));
        }
        return sb.toString();
    }

    public static ProjectClassPathExtender extenderForModifier(final ProjectClassPathModifierImplementation pcpmi) {
        return new ProjectClassPathExtender(){

            @Override
            public boolean addLibrary(Library library) throws IOException {
                SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pcpmi);
                if (sgs.length == 0) {
                    return false;
                }
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pcpmi, sgs[0]);
                if (types.length == 0) {
                    return false;
                }
                try {
                    return ProjectClassPathModifierAccessor.INSTANCE.addLibraries(new Library[]{library}, pcpmi, sgs[0], types[0]);
                }
                catch (UnsupportedOperationException x) {
                    return false;
                }
            }

            @Override
            public boolean addArchiveFile(FileObject archiveFile) throws IOException {
                SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pcpmi);
                if (sgs.length == 0) {
                    return false;
                }
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pcpmi, sgs[0]);
                if (types.length == 0) {
                    return false;
                }
                URL r = archiveFile.getURL();
                if (FileUtil.isArchiveFile((URL)r)) {
                    r = FileUtil.getArchiveRoot((URL)r);
                }
                try {
                    return ProjectClassPathModifierAccessor.INSTANCE.addRoots(new URL[]{r}, pcpmi, sgs[0], types[0]);
                }
                catch (UnsupportedOperationException x) {
                    return false;
                }
            }

            @Override
            public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
                SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pcpmi);
                if (sgs.length == 0) {
                    return false;
                }
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pcpmi, sgs[0]);
                if (types.length == 0) {
                    return false;
                }
                try {
                    return ProjectClassPathModifierAccessor.INSTANCE.addAntArtifacts(new AntArtifact[]{artifact}, new URI[]{artifactElement}, pcpmi, sgs[0], types[0]);
                }
                catch (UnsupportedOperationException x) {
                    return false;
                }
            }
        };
    }

    public static ProjectClassPathExtender extenderForModifier(final Project p) {
        return new ProjectClassPathExtender(){

            @Override
            public boolean addLibrary(Library library) throws IOException {
                ProjectClassPathModifierImplementation pcpmi = (ProjectClassPathModifierImplementation)p.getLookup().lookup(ProjectClassPathModifierImplementation.class);
                return pcpmi != null ? ProjectClassPathModifier.extenderForModifier(pcpmi).addLibrary(library) : false;
            }

            @Override
            public boolean addArchiveFile(FileObject archiveFile) throws IOException {
                ProjectClassPathModifierImplementation pcpmi = (ProjectClassPathModifierImplementation)p.getLookup().lookup(ProjectClassPathModifierImplementation.class);
                return pcpmi != null ? ProjectClassPathModifier.extenderForModifier(pcpmi).addArchiveFile(archiveFile) : false;
            }

            @Override
            public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
                ProjectClassPathModifierImplementation pcpmi = (ProjectClassPathModifierImplementation)p.getLookup().lookup(ProjectClassPathModifierImplementation.class);
                return pcpmi != null ? ProjectClassPathModifier.extenderForModifier(pcpmi).addAntArtifact(artifact, artifactElement) : false;
            }
        };
    }

    private static final class Extensible {
        private final String classPathType;
        private final SourceGroup sg;
        private final ProjectClassPathModifierImplementation pcmi;
        private final ProjectClassPathExtender pcpe;
        private final String label;

        private Extensible(ProjectClassPathModifierImplementation pcmi, SourceGroup sg, String classPathType, String label) {
            assert (pcmi != null);
            assert (sg != null);
            assert (classPathType != null);
            this.pcmi = pcmi;
            this.sg = sg;
            this.classPathType = classPathType;
            this.pcpe = null;
            this.label = label;
        }

        private Extensible(ProjectClassPathExtender pcpe, String label) {
            assert (pcpe != null);
            this.pcpe = pcpe;
            this.pcmi = null;
            this.sg = null;
            this.classPathType = "classpath/compile";
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

