/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.xml.request.stateModelLayerMapping;

import de.proveo.util.dependencyInjector.Dependency;
import de.proveo.wwt.datamodel.image.ImageLayerMapping;
import de.proveo.wwt.logic.ejb.general.image.ImageTypeFacadeLocal;
import de.proveo.wwt.logic.xml.request.XmlRequestHandlerBase;
import de.proveo.wwt.logic.xml.request.XmlRequestSchema;
import de.proveo.xml.fleet_management.meta_1.MetadataList;
import de.proveo.xml.fleet_management.meta_1.MetadataValue;
import de.proveo.xml.fleet_management.statemodel_layer_mapping_1.ImageType;
import de.proveo.xml.fleet_management.statemodel_layer_mapping_1.StateModelLayerMapping;
import java.util.List;
import java.util.Map;

@XmlRequestSchema(value={"http://proveo.de/xml/fleet-management/statemodel-layer-mapping-1.0"})
public class StateModelLayerMapping_1_0_RequestHandler
extends XmlRequestHandlerBase<StateModelLayerMapping> {
    @Dependency
    private ImageTypeFacadeLocal imageTypeFacade;
    private boolean generateStatistics;

    @Override
    public StateModelLayerMapping handleRequest(String schemaNamespace, Map<String, String> parameters) {
        this.parseParameters(parameters);
        if (this.generateStatistics) {
            this.startTimer();
        }
        StateModelLayerMapping xmlLayerMapping = new StateModelLayerMapping();
        List xmlImageTypes = xmlLayerMapping.getImageType();
        List<de.proveo.wwt.datamodel.image.ImageType> imageTypes = this.imageTypeFacade.getImageTypesIncludingMappings();
        for (de.proveo.wwt.datamodel.image.ImageType imageType : imageTypes) {
            ImageType xmlImageType = new ImageType();
            xmlImageType.setId(imageType.getName());
            List mappings = xmlImageType.getMapping();
            for (ImageLayerMapping imageLayerMapping : imageType.getImageLayerMappings()) {
                ImageType.Mapping mapping = new ImageType.Mapping();
                mapping.setLayerId(imageLayerMapping.getLayerName());
                mapping.setStateModelId(imageLayerMapping.getStateModelId());
                mappings.add(mapping);
            }
            xmlImageTypes.add(xmlImageType);
        }
        if (this.generateStatistics) {
            MetadataValue duration = new MetadataValue();
            duration.setKey(this.EXECUTION_TIME_KEY);
            duration.setValue(this.stopTimer());
            xmlLayerMapping.setMeta(new MetadataList());
            xmlLayerMapping.getMeta().getValue().add(duration);
        }
        return xmlLayerMapping;
    }

    private void parseParameters(Map<String, String> parameters) {
        String value;
        this.setDefaultParameters();
        if (parameters != null && (value = parameters.get("generateStatistics")) != null) {
            this.generateStatistics = Boolean.parseBoolean(value);
        }
    }

    private void setDefaultParameters() {
        this.generateStatistics = false;
    }
}

