/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.summarizedData;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.container.ContainerUtil;
import de.proveo.wwt.datamodel.statesum.StateSummary;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateSummaryFastLaneReader;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeLocal;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeLocal;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeRemote;
import de.proveo.wwt.logic.web.summarizedData.dto.StateDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.StatusDurationsDTOList;
import de.proveo.wwt.logic.web.summarizedData.dto.SummarizedDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.SummarizedDTOList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.joda.time.DateMidnight;
import org.joda.time.Interval;

@Stateless(name="SummarizedDataFacade")
@Remote(value={SummarizedDataFacadeRemote.class})
@Local(value={SummarizedDataFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/SummarizedDataFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/SummarizedDataFacade")
@TransactionTimeout(value=900)
public class SummarizedDataFacadeBean
implements SummarizedDataFacadeLocal,
SummarizedDataFacadeRemote {
    private static final Log logger = LogFactory.getLog(SummarizedDataFacadeBean.class);
    @EJB
    private HistoryDataFacadeLocal historyDataFacadeLocal = null;
    @EJB
    private PermissionCheckerLocal permissionCheckerLocal = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private StateModelFacadeLocal stateModelFacade = null;
    private StateSummaryFastLaneReader stateSummaryFastLaneReader;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        try {
            this.stateSummaryFastLaneReader = new StateSummaryFastLaneReader();
        }
        catch (Exception ex) {
            logger.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public StatusDurationsDTOList getDurationsSummarized(ReportSelectionDTO selectionDTO, int stateModelId) {
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "durationsSummarized");
        stopwatch.start("Overall");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getDurationsSummarized1 called ");
        }
        int[] availableStates = this.getPossibleStates(stateModelId);
        StatusDurationsDTOList list = DTOListFactory.buildStatusDurationsDTOList(selectionDTO, stateModelId, availableStates);
        StateDTOList stateDtoList = this.historyDataFacadeLocal.getStateData(selectionDTO, stateModelId, null);
        this.sumToStatusDurationsDTOList(stateDtoList, list, null);
        stopwatch.stop("Overall", true);
        list.setStopwatch(stopwatch);
        return list;
    }

    @Override
    @Business(viewType="both")
    public HashMap<Integer, StatusDurationsDTOList> getDurationsSummarized(ReportSelectionDTO selectionDTO, int[] filterStateModelId) {
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "durationsSummarized");
        stopwatch.start("Overall");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getDurationsSummarized2 called ");
        }
        int[] availableStates = this.getPossibleStates(filterStateModelId);
        StatusDurationsDTOList list = DTOListFactory.buildStatusDurationsDTOList(selectionDTO, null, availableStates);
        StateDTOList stateDtoList = this.historyDataFacadeLocal.getStateData(selectionDTO, null, ExtendedDTOData.getSTATEDATA());
        HashMap<Integer, StatusDurationsDTOList> map = this.sumToStatusDurationsDTOList(stateDtoList, list, filterStateModelId);
        stopwatch.stop("Overall", true);
        list.setStopwatch(stopwatch);
        return map;
    }

    private HashMap<Integer, StatusDurationsDTOList> sumToStatusDurationsDTOList(StateDTOList stateDtoList, StatusDurationsDTOList list, int[] filterStateModelId) {
        HashMap statesHashmap;
        HashMap<Integer, StatusDurationsDTOList> map = new HashMap<Integer, StatusDurationsDTOList>();
        Integer stateModelId = stateDtoList.getStateModelId();
        Long beginTime = stateDtoList.getBeginDate();
        HashMap<SummaryDTOHelper2, HashMap> dtoHashmap = new HashMap<SummaryDTOHelper2, HashMap>();
        for (int k = 0; k < stateDtoList.size(); ++k) {
            StateDTO stateDTO = (StateDTO)stateDtoList.get(k);
            if (filterStateModelId != null && filterStateModelId.length != 0) {
                boolean passDTO = false;
                for (int i = 0; i < filterStateModelId.length; ++i) {
                    if (filterStateModelId == null || filterStateModelId[i] != stateDTO.getStateModelId()) continue;
                    passDTO = true;
                    break;
                }
                if (!passDTO) continue;
            }
            if (stateDTO == null) continue;
            statesHashmap = (HashMap)dtoHashmap.get(new SummaryDTOHelper2(stateDTO.getStateModelId(), stateDTO.getUnitId()));
            if (statesHashmap != null) {
                SummaryHelperDTO summaryHelperDTO = (SummaryHelperDTO)statesHashmap.get(stateDTO.getStateId());
                if (summaryHelperDTO == null) continue;
                summaryHelperDTO.sumDuration(stateDTO.getDuration());
                continue;
            }
            statesHashmap = new HashMap();
            for (int state : list.getStatusIds()) {
                if (state == stateDTO.getStateId()) {
                    statesHashmap.put(state, new SummaryHelperDTO(stateDTO.getStateModelId(), stateDTO.getDuration()));
                    continue;
                }
                statesHashmap.put(state, new SummaryHelperDTO(stateDTO.getStateModelId(), 0L));
            }
            dtoHashmap.put(new SummaryDTOHelper2(stateDTO.getStateModelId(), stateDTO.getUnitId()), statesHashmap);
        }
        UnitModel unitModel = null;
        for (Map.Entry unitMapEntry : dtoHashmap.entrySet()) {
            long basicUnitId = ((SummaryDTOHelper2)unitMapEntry.getKey()).getUnitId();
            stateModelId = ((SummaryDTOHelper2)unitMapEntry.getKey()).getStateModelId();
            statesHashmap = (HashMap)unitMapEntry.getValue();
            unitModel = this.unitFacade.getUnitModel(basicUnitId);
            StateDurationsDTO dto = stateModelId != 2010 ? DTOFactory.buildStateDurationsDTO(stateModelId, beginTime, DTOFactory.buildUnitDTO(unitModel)) : DTOFactory.buildRunTimeDurationsDTO(unitModel.getOperativeTimeOffset(), beginTime, DTOFactory.buildUnitDTO(unitModel));
            for (Map.Entry state : statesHashmap.entrySet()) {
                dto.setDuration((Integer)state.getKey(), ((SummaryHelperDTO)state.getValue()).getSummarizedDuration());
            }
            list.add(dto);
        }
        list.copyUnitLists(stateDtoList);
        this.permissionCheckerLocal.checkDTOList(list);
        for (int i = 0; i < list.size(); ++i) {
            StateDurationsDTO dto = (StateDurationsDTO)list.get(i);
            Integer dtoStateModelId = dto.getStateModelId();
            StatusDurationsDTOList statusDurationsDTOList = map.get(dtoStateModelId);
            if (statusDurationsDTOList == null) {
                statusDurationsDTOList = DTOListFactory.buildStatusDurationsDTOList(list.getReportSelectionDTO(), dtoStateModelId, this.getPossibleStates(dtoStateModelId));
                map.put(dtoStateModelId, statusDurationsDTOList);
            }
            statusDurationsDTOList.add(dto);
        }
        return map;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<?>[] getGroupStatusData(ReportSelectionDTO selectionDTO, int stateModelId, boolean summarized) {
        StateDTOList stateDTOList = null;
        Collection<StateSummary> summaries = null;
        int[] availableStates = this.getPossibleStates(stateModelId);
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "getDurationsSummarizedPerUnitAndDay");
        stopwatch.start("Overall");
        stopwatch.start("Database access");
        if (!summarized) {
            stateDTOList = this.historyDataFacadeLocal.getStateData(selectionDTO, stateModelId, ExtendedDTOData.getSTATEDATA());
            summaries = this.summarizeStateDTOListToStateSummary(stateDTOList);
        } else {
            stateDTOList = null;
            summaries = this.stateSummaryFastLaneReader.getStateSummary(selectionDTO, stateModelId, 0);
        }
        stopwatch.stop("Database access", true);
        stopwatch.start("Build DTO");
        SummarizedDTOList summarizedDTOList = DTOListFactory.buildSummarizedDTOList(selectionDTO, stateModelId, availableStates);
        this.summarizePerUnitPerStatePerDay(summarizedDTOList, summaries, true);
        StatusDurationsDTOList statusDurationsDTOList = DTOListFactory.buildStatusDurationsDTOList(selectionDTO, stateModelId, availableStates);
        this.summarizePerUnitPerState(statusDurationsDTOList, summaries, true);
        stopwatch.stop("Build DTO", true);
        stopwatch.stop("Overall", true);
        if (stateDTOList != null && stateDTOList.size() > this.stateSummaryFastLaneReader.getMaxRowLimit()) {
            stateDTOList.clear();
            stateDTOList.setMaxRowsLimit(this.stateSummaryFastLaneReader.getMaxRowLimit());
        }
        return new DTOListBase[]{summarizedDTOList, statusDurationsDTOList, stateDTOList};
    }

    private int[] getPossibleStates(int stateModelId) {
        List<Integer> stateIds = this.stateModelFacade.getStateIds(stateModelId);
        return ContainerUtil.convertToIntegerArray(stateIds);
    }

    private int[] getPossibleStates(int[] stateModelIds) {
        ArrayList<Integer> allStates = new ArrayList<Integer>();
        for (int stateModelId : stateModelIds) {
            allStates.addAll(this.stateModelFacade.getStateIds(stateModelId));
        }
        return ContainerUtil.convertToIntegerArray(allStates);
    }

    @Override
    @Business(viewType="both")
    public StatusDurationsDTOList getStateDurations(ReportSelectionDTO selectionDTO, Integer stateModelId, boolean includeDeleted) {
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "durationsSummarized");
        int[] statusIds = this.getPossibleStates(stateModelId);
        StatusDurationsDTOList list = DTOListFactory.buildStatusDurationsDTOList(selectionDTO, stateModelId, statusIds);
        stopwatch.start("Database access");
        Collection<StateSummary> summaries = this.stateSummaryFastLaneReader.getStateSummary(selectionDTO, stateModelId, 0);
        stopwatch.stop("Database access", true, summaries.size());
        stopwatch.start("Build DTO");
        this.summarizePerUnitPerState(list, summaries, includeDeleted);
        stopwatch.stop("Build DTO", true);
        this.permissionCheckerLocal.checkDTOList(list);
        list.setStopwatch(stopwatch);
        return list;
    }

    private void summarizePerUnitPerState(StatusDurationsDTOList list, Collection<StateSummary> summaries, boolean includeDeleted) {
        Long unitId;
        HashMap unitToStateToDurationMap = new HashMap();
        for (StateSummary stateSummary : summaries) {
            unitId = stateSummary.getPk().getUnitId();
            Integer stateId = stateSummary.getPk().getStateId();
            HashMap<Integer, Long> stateToDurationMap = (HashMap<Integer, Long>)unitToStateToDurationMap.get(unitId);
            if (stateToDurationMap == null) {
                stateToDurationMap = new HashMap<Integer, Long>();
                for (int state : list.getStatusIds()) {
                    stateToDurationMap.put(state, 0L);
                }
                unitToStateToDurationMap.put(unitId, stateToDurationMap);
            }
            Long duration = (Long)stateToDurationMap.get(stateId) + stateSummary.getDuration();
            stateToDurationMap.put(stateId, duration);
        }
        for (Map.Entry entry : unitToStateToDurationMap.entrySet()) {
            unitId = (Long)entry.getKey();
            Integer stateModelId = list.getStateModelId();
            Long beginTime = list.getBeginDate();
            UnitModel unitModel = this.unitFacade.getUnitModel(unitId);
            if (unitModel == null || unitModel.getDeleted() && !includeDeleted) continue;
            StateDurationsDTO dto = stateModelId == 2010 ? DTOFactory.buildRunTimeDurationsDTO(unitModel.getOperativeTimeOffset(), beginTime, DTOFactory.buildUnitDTO(unitModel)) : DTOFactory.buildStateDurationsDTO(stateModelId, beginTime, DTOFactory.buildUnitDTO(unitModel));
            for (Map.Entry stateEntry : ((Map)entry.getValue()).entrySet()) {
                dto.setDuration((Integer)stateEntry.getKey(), (Long)stateEntry.getValue());
            }
            list.add(dto);
        }
    }

    private void summarizePerUnitPerStatePerDay(SummarizedDTOList list, Collection<StateSummary> summaries, boolean includeDeleted) {
        HashMap<Long, SummarizedDTO> unitToSummaritedDTOMap = new HashMap<Long, SummarizedDTO>();
        Interval interval = new Interval(new DateMidnight(list.getBeginDate()).getMillis(), new DateMidnight(list.getEndDate()).plusDays(1).getMillis());
        for (long dayBegin = interval.getStart().getMillis(); dayBegin <= interval.getEndMillis(); dayBegin += 86400000L) {
            long dayEnd = dayBegin + 86400000L;
            if (dayBegin >= list.getEndDate()) continue;
            ArrayList<StateSummary> dailySummarys = new ArrayList<StateSummary>();
            for (StateSummary summary : summaries) {
                if (summary.getPk().getBeginTime() < dayBegin || summary.getPk().getBeginTime() >= dayEnd || summary.getDuration() <= 0L) continue;
                dailySummarys.add(summary);
            }
            ReportSelectionDTO selectionDTO = list.getReportSelectionDTO().copy();
            selectionDTO.setInterval(new Interval(dayBegin, dayEnd));
            StatusDurationsDTOList dailyList = DTOListFactory.buildStatusDurationsDTOList(selectionDTO, list.getStateModelId(), list.getStatusIds());
            this.summarizePerUnitPerState(dailyList, dailySummarys, includeDeleted);
            for (StateDurationsDTO sdDTO : dailyList) {
                SummarizedDTO dto = (SummarizedDTO)unitToSummaritedDTOMap.get(sdDTO.getUnitId());
                if (dto == null) {
                    dto = DTOFactory.buildSummarizedDTO(sdDTO.getUnit());
                    unitToSummaritedDTOMap.put(sdDTO.getUnitId(), dto);
                }
                dto.addStatusDurationsDTO(dayBegin, sdDTO);
            }
        }
        list.addAll(unitToSummaritedDTOMap.values());
    }

    private Collection<StateSummary> summarizeStateDTOListToStateSummary(StateDTOList list) {
        ArrayList<StateSummary> summaries = new ArrayList<StateSummary>();
        if (list == null || list.isEmpty()) {
            return summaries;
        }
        Interval interval = new Interval(new DateMidnight(list.getBeginDate()).getMillis(), new DateMidnight(list.getEndDate()).plusDays(1).getMillis());
        HashMap beginTimeToUnitToSummaryMap = new HashMap();
        for (long dayBegin = interval.getStart().getMillis(); dayBegin <= interval.getEndMillis(); dayBegin += 86400000L) {
            long dayEnd = dayBegin + 86400000L;
            HashMap unitToSummaryMap = (HashMap)beginTimeToUnitToSummaryMap.get(dayBegin);
            if (unitToSummaryMap == null) {
                unitToSummaryMap = new HashMap();
                beginTimeToUnitToSummaryMap.put(dayBegin, unitToSummaryMap);
            }
            for (StateDTO value : list) {
                StateSummary summary;
                long stateBegin = value.getBeginTime();
                long stateEnd = value.getEndTime();
                int stateModelId = value.getStateModelId();
                int stateId = value.getStateId();
                long unitId = value.getUnitId();
                long duration = value.getDuration();
                if (stateBegin >= dayEnd || stateEnd < dayBegin) continue;
                if (stateEnd > dayEnd) {
                    duration = dayEnd - stateBegin;
                }
                if (stateBegin < dayBegin) {
                    duration = stateEnd - dayBegin;
                }
                if (stateBegin < dayBegin && stateEnd > dayEnd) {
                    duration = 86400000L;
                }
                if ((summary = (StateSummary)((Object)unitToSummaryMap.get(unitId))) == null) {
                    summary = new StateSummary();
                    summary.getPk().setPeriodType(0);
                    summary.getPk().setBeginTime(dayBegin);
                    summary.getPk().setUnitId(unitId);
                    summary.getPk().setStateModelId(stateModelId);
                    summary.getPk().setStateId(stateId);
                    summary.setDuration(0L);
                    summaries.add(summary);
                }
                summary.setDuration(duration += summary.getDuration());
            }
        }
        return summaries;
    }

    public class SummaryHelperDTO {
        long stateModelId;
        long summarizedDuration;

        public SummaryHelperDTO(long stateModelId, long summarizedDuration) {
            this.stateModelId = stateModelId;
            this.summarizedDuration = summarizedDuration;
        }

        public long getStateModelId() {
            return this.stateModelId;
        }

        public void setStateModelId(long stateModelId) {
            this.stateModelId = stateModelId;
        }

        public long getSummarizedDuration() {
            return this.summarizedDuration;
        }

        public void setSummarizedDuration(long summarizedDuration) {
            this.summarizedDuration = summarizedDuration;
        }

        public void sumDuration(long duration) {
            this.summarizedDuration += duration;
        }
    }

    public class SummaryDTOHelper2 {
        private int stateModelId;
        private long unitId;

        public SummaryDTOHelper2(int stateModelId, long unitId) {
            this.stateModelId = stateModelId;
            this.unitId = unitId;
        }

        public int getStateModelId() {
            return this.stateModelId;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SummaryDTOHelper2)) {
                return false;
            }
            SummaryDTOHelper2 obj2 = (SummaryDTOHelper2)obj;
            return this.stateModelId == obj2.stateModelId && this.unitId == obj2.unitId;
        }

        public int hashCode() {
            long result = 7L;
            result = 37L * result + this.unitId + (long)this.stateModelId;
            return (int)result;
        }
    }
}

