/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.security;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.interfaces.IUnitContainer;
import de.proveo.wwt.logic.web.data.fastlanereader.PermissionFastLaneReader;
import de.proveo.wwt.logic.web.security.PermissionChecker;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerRemote;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;
import org.jboss.security.SecurityAssociation;

@Stateless(name="PermissionChecker")
@Remote(value={PermissionCheckerRemote.class})
@Local(value={PermissionCheckerLocal.class})
@JndiLocalBinding(localJndiBinding="rts/PermissionChecker")
@JndiRemoteBinding(remoteJndiBinding="rts/PermissionChecker")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class PermissionCheckerBean
implements PermissionCheckerLocal,
PermissionCheckerRemote {
    private static final long serialVersionUID = -7536275671770913511L;
    private UnitFacadeLocal unitFacadeLocal = null;
    @EJB
    private ConfigurationLocal configurationLocal = null;
    @EJB
    private UserAdminFacadeLocal userFacade;
    @Resource
    private SessionContext sessionContext;
    private static final Log logger = LogFactory.getLog(PermissionCheckerBean.class);
    private static ConcurrentHashMap<String, HashSet<Long>> unitPermissions = new ConcurrentHashMap();

    private void createEJBReferences() {
        try {
            InitialContext context = new InitialContext();
            this.unitFacadeLocal = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            this.configurationLocal = (ConfigurationLocal)context.lookup("rts/Configuration/local");
        }
        catch (NamingException e) {
            logger.error((Object)"ejbCreate runs into NamingException: ", (Throwable)e);
        }
    }

    @Override
    @Business(viewType="both")
    public HashSet<Long> getUnitPermissions() {
        Stopwatch stopwatch = new Stopwatch(PermissionCheckerBean.class, "getUnitPermissions()");
        stopwatch.start("Overall");
        if (this.unitFacadeLocal == null || this.configurationLocal == null) {
            this.createEJBReferences();
        }
        logger.debug((Object)"getUnitPermissions: entering ...");
        HashSet<Object> permissionList = new HashSet();
        String jaasUsed = this.configurationLocal.getParameter("jaasUsed", "optional");
        if (jaasUsed.equals("false")) {
            logger.debug((Object)"No JAAS used for unit permissions.");
            permissionList = new PermissionFastLaneReader().getAllUnitPermissions();
        } else {
            Principal principal = SecurityAssociation.getCallerPrincipal();
            if (principal == null) {
                if (jaasUsed.equals("optional")) {
                    logger.debug((Object)"getUnitPermissions: leaving with full permissions, Principal was NULL, JAAS optional");
                    return new PermissionFastLaneReader().getAllUnitPermissions();
                }
                logger.debug((Object)"getUnitPermissions: leaving with no permissions, Principal was NULL");
                return new HashSet<Long>();
            }
            logger.debug((Object)("getUnitPermissions: CallerPrincipal is: " + this.sessionContext.getCallerPrincipal()));
            String username = principal.getName();
            if (username == null) {
                logger.debug((Object)"getUnitPermissions: leaving with no permissions, Principal.Name was NULL");
                return new HashSet<Long>();
            }
            permissionList = this.updateUserPermissions(username);
        }
        stopwatch.stop("Overall", true);
        logger.debug((Object)("getUnitPermissions: leaving with permissions for: " + permissionList.toString()));
        return permissionList;
    }

    @Override
    @Business(viewType="both")
    public boolean isSuperAdmin() {
        try {
            boolean retVal = this.sessionContext.isCallerInRole("superadmin");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isSuperAdmin returns: " + retVal));
            }
            return retVal;
        }
        catch (Exception ex) {
            return true;
        }
    }

    @Override
    @Business(viewType="both")
    public boolean isCallerInRole(String role) {
        boolean retVal = this.sessionContext.isCallerInRole(role);
        logger.debug((Object)("isCallerInRole returns: " + retVal));
        return retVal;
    }

    @Override
    @Business(viewType="both")
    public Boolean checkDTOList(UnitContainerListBase dtoList) {
        boolean cleanedData = false;
        logger.debug((Object)"checkDTOList called");
        if (dtoList == null) {
            return null;
        }
        int fetchedDataSize = dtoList.size();
        Principal principal = SecurityAssociation.getCallerPrincipal();
        if (this.isSuperAdmin()) {
            logger.debug((Object)"all permissions granted for role=superadmin");
            return true;
        }
        if (principal != null) {
            HashSet<Long> permissionList;
            String username = principal.getName();
            if (username == null) {
                logger.debug((Object)"username = null (grant access");
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("chekDTO for username: " + username + " entries: " + dtoList.size()));
            }
            if (!unitPermissions.containsKey(username)) {
                this.updateUserPermissions(username);
            }
            if ((permissionList = unitPermissions.get(username)) != null) {
                logger.debug((Object)("unitPermissions size: " + permissionList.size()));
                for (int i = 0; i < dtoList.size(); ++i) {
                    IUnitContainer dto = (IUnitContainer)dtoList.get(i);
                    UnitDTO uniDTO = dto.getUnit();
                    if (dto == null || !uniDTO.getUnitModel().getBasic() || permissionList.contains(uniDTO.getUnitId())) continue;
                    dtoList.removeUnAuthorizedData(dto);
                    cleanedData = true;
                    --i;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cleaned list entries: " + String.valueOf(fetchedDataSize - dtoList.size())));
        }
        logger.debug((Object)"dto list checked");
        return cleanedData;
    }

    @Override
    @Business(viewType="both")
    public Boolean checkUnitModelList(List<UnitModel> list) {
        logger.debug((Object)"checkDTOList called");
        boolean cleanedData = false;
        int fetchedDataSize = list.size();
        if (list == null) {
            return null;
        }
        Principal principal = SecurityAssociation.getCallerPrincipal();
        if (this.isSuperAdmin()) {
            logger.debug((Object)"all permissions granted for role=superadmin");
            return true;
        }
        if (principal != null) {
            HashSet<Long> permissionList;
            String username = principal.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("chekDTO for username: " + username + " entries: " + list.size()));
            }
            if (!unitPermissions.containsKey(username)) {
                this.updateUserPermissions(username);
            }
            if ((permissionList = unitPermissions.get(username)) != null) {
                logger.debug((Object)("unitPermissions size: " + permissionList.size()));
                for (int i = 0; i < list.size(); ++i) {
                    UnitModel unitModel = list.get(i);
                    if (!unitModel.getBasic()) continue;
                    boolean hasPermsissons = false;
                    for (Long unitId : permissionList) {
                        if (!unitId.equals(unitModel.getUnitId())) continue;
                        hasPermsissons = true;
                        break;
                    }
                    if (hasPermsissons) continue;
                    list.remove(i);
                    cleanedData = true;
                    --i;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cleaned list entries: " + String.valueOf(fetchedDataSize - list.size())));
        }
        return cleanedData;
    }

    @Override
    @Business(viewType="both")
    public HashSet<Long> updateUserPermissions(String username) {
        if (this.isSuperAdmin()) {
            return new PermissionFastLaneReader().getAllUnitPermissions();
        }
        Account account = this.userFacade.getAccountByUsername(username);
        HashSet<Object> unitIds = account == null ? new HashSet() : new PermissionFastLaneReader().getUnitPermissions(account.getId());
        unitPermissions.put(username, unitIds);
        return unitIds;
    }

    @Override
    @Business(viewType="both")
    public void updateAllUserPermissions() {
        unitPermissions.clear();
    }

    @Override
    @Business(viewType="both")
    public PermissionChecker getPermissionChecker() {
        return new PermissionChecker(this.getUnitPermissions());
    }
}

