/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.security;

import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionChecker {
    protected Map<Long, UnitDTO> unitDTOMap = new HashMap<Long, UnitDTO>();
    protected Set<Long> allowedUnitIds;
    protected Set<Long> removedUnitIds = new HashSet<Long>();
    protected Set<Long> involvedUnitIds = new HashSet<Long>();
    protected Set<Long> involvedDeletedUnitIds = new HashSet<Long>();

    public PermissionChecker(Set<Long> allowedUnitIds) {
        this.allowedUnitIds = allowedUnitIds;
    }

    public void initialize(Map<Long, UnitDTO> unitDTOMap) {
        this.unitDTOMap = unitDTOMap;
    }

    public boolean checkPermission(Long unitId) {
        return this.checkPermission(unitId, true);
    }

    private boolean checkPermission(Long unitId, boolean addToRemovedUnitsList) {
        Long unitIdLong = unitId;
        boolean hasPermission = this.allowedUnitIds.contains(unitIdLong);
        if (hasPermission) {
            UnitDTO unitDTO = this.unitDTOMap.get(unitIdLong);
            if (unitDTO.isDeleted()) {
                this.involvedDeletedUnitIds.add(unitIdLong);
            } else {
                this.involvedUnitIds.add(unitIdLong);
            }
        } else if (!hasPermission && addToRemovedUnitsList) {
            this.removedUnitIds.add(unitIdLong);
        }
        return hasPermission;
    }

    public boolean peekPermission(Long unitId) {
        return this.checkPermission(unitId, false);
    }

    public boolean hasRemovedUnits() {
        return !this.removedUnitIds.isEmpty();
    }

    public Map<Long, UnitDTO> getUnitDTOMap() {
        return this.unitDTOMap;
    }

    public void setUnitDTOMap(Map<Long, UnitDTO> unitDTOMap) {
        this.unitDTOMap = unitDTOMap;
    }

    public Set<Long> getAllowedUnitIds() {
        return this.allowedUnitIds;
    }

    public Set<Long> getRemovedUnitIds() {
        return this.removedUnitIds;
    }

    public Set<Long> getInvolvedUnitIds() {
        return this.involvedUnitIds;
    }

    public Set<Long> getInvolvedDeletedUnitIds() {
        return this.involvedDeletedUnitIds;
    }
}

