/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.operatorReports;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeLocal;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.operatorReports.OperatorReportsFacadeLocal;
import de.proveo.wwt.logic.web.operatorReports.OperatorReportsFacadeRemote;
import de.proveo.wwt.logic.web.summarizedData.dto.StateDurationsDTO;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.jboss.annotation.ejb.TransactionTimeout;

@Stateless(name="OperatorReportsFacade")
@Remote(value={OperatorReportsFacadeRemote.class})
@Local(value={OperatorReportsFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/OperatorReportsFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/OperatorReportsFacade")
@TransactionTimeout(value=900)
public class OperatorReportsFacadeBean
implements OperatorReportsFacadeLocal,
OperatorReportsFacadeRemote {
    @Resource
    private SessionContext sessionContext;
    @EJB
    private HistoryDataFacadeLocal historyDataFacade = null;
    @EJB
    private UseUserAdminFacadeLocal useUserAdminFacade = null;
    @EJB
    private StateModelFacadeLocal stateModelFacade = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
    }

    private <T extends ReportDTOBase, L extends DTOListBase<T>> L filterData(L list) {
        for (int i = 0; i < list.size(); ++i) {
            ReportDTOBase dto = (ReportDTOBase)list.get(i);
            if (dto.getUseUser() != null) continue;
            list.remove(i--);
        }
        if (list instanceof UnitContainerListBase) {
            ((UnitContainerListBase)list).clearInvolvedUnitMaps();
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public StateDTOList getOperatorSingleStateData(ReportSelectionDTO selectionDTO, Integer stateModelId) {
        StateDTOList dataList = this.historyDataFacade.getStateData(selectionDTO, stateModelId, ExtendedDTOData.getSTATEDATA());
        return this.filterData(dataList);
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public ReportDTOListBase<StateDurationsDTO> getOperatorSummarizedStateData(ReportSelectionDTO selectionDTO, Integer stateModelId) {
        ReportDTOListBase<StateDurationsDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        StateDTOList stateDtoList = this.historyDataFacade.getStateData(selectionDTO, stateModelId, ExtendedDTOData.getSTATEDATA());
        HashMap<Long, StateDurationsDTO> operatorStateDurationMap = new HashMap<Long, StateDurationsDTO>();
        for (StateDTO stateDTO : stateDtoList) {
            if (stateDTO == null || stateDTO.getUseUser() == null) continue;
            Long useUserId = stateDTO.getUseUser().getId();
            Integer stateId = stateDTO.getStateId();
            StateDurationsDTO dto = DTOFactory.buildStateDurationsDTO(stateModelId, 0L, stateDTO.getUseUser());
            if (operatorStateDurationMap.containsKey(useUserId)) {
                dto = (StateDurationsDTO)operatorStateDurationMap.get(useUserId);
            }
            if (dto.getStateDurations().containsKey(stateId)) {
                dto.getStateDurations().put(stateId, dto.getStateDurations().get(stateId) + stateDTO.getDuration());
            } else {
                dto.getStateDurations().put(stateId, stateDTO.getDuration());
            }
            operatorStateDurationMap.put(useUserId, dto);
        }
        for (Map.Entry entry : operatorStateDurationMap.entrySet()) {
            UseUser useUser = this.useUserAdminFacade.getUseUserById((Long)entry.getKey());
            StateDurationsDTO dto = (StateDurationsDTO)entry.getValue();
            dto.addDTOAttachable(useUser);
            for (Integer stateId : this.stateModelFacade.getStateIds(stateModelId)) {
                if (dto.getStateDurations().containsKey(stateId)) continue;
                dto.setDuration(stateId, 0L);
            }
            list.add(dto);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<NotificationDTO> getOperatorNotifications(ReportSelectionDTO selectionDTO, Long messageId) {
        ReportDTOListBase<NotificationDTO> dataList = this.historyDataFacade.getNotificationData(selectionDTO, messageId, ExtendedDTOData.getSTATEDATA());
        return this.filterData(dataList);
    }
}

