/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.maintenance.facade;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventResponse;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.ActionType;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeLocal;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.maintenance.dto.MaintenanceForecastDTO;
import de.proveo.wwt.logic.web.maintenance.facade.MaintenanceFacadeLocal;
import de.proveo.wwt.logic.web.maintenance.facade.MaintenanceFacadeRemote;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeLocal;
import de.proveo.wwt.logic.web.summarizedData.dto.StateDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.StatusDurationsDTOList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;

@Stateless(name="MaintenanceFacade")
@Remote(value={MaintenanceFacadeRemote.class})
@Local(value={MaintenanceFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MaintenanceFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/MaintenanceFacade")
public class MaintenanceFacadeBean
implements MaintenanceFacadeLocal,
MaintenanceFacadeRemote {
    private static final long serialVersionUID = 579464487356469008L;
    private static final Log logger = LogFactory.getLog(MaintenanceFacadeBean.class);
    private static final ModuleType AUDIT_APPLICATION = ModuleType.WEB;
    @EJB
    private SummarizedDataFacadeLocal summarizedDataFacade = null;
    @EJB
    private CurrentDataFacadeLocal currentDataFacade = null;
    @EJB
    private InformantFacadeLocal informantFacade = null;
    @EJB
    private AuditFacadeLocal auditFacade = null;
    @EJB
    private EventFacadeLocal eventFacade = null;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    private static final int engineStateModel = 2010;
    private static final int engineStateRunsNecessarily = 2012;
    private static final int engineStateRunsUnnecessarily = 2013;
    private static final int outOfOrderStateModel = 2090;

    @Override
    @Business(viewType="both")
    public List<StateDTO> getUnitsWithCurrentState(ReportSelectionDTO selectionDTO, int stateModelId) {
        StateDTOList stateDTOs = this.currentDataFacade.getCurrentStateData(selectionDTO, stateModelId, null, ExtendedDTOData.getSTATEDATA());
        Collection<UnitModel> unitDTOs = UnitListFactory.generateUnitModelList((UnitReportSelectionDTO)selectionDTO);
        int unknownState = -1;
        long id = 0L;
        HashMap<Long, StateDTO> map = new HashMap<Long, StateDTO>();
        for (StateDTO stateDTO : stateDTOs) {
            map.put(stateDTO.getUnitId(), stateDTO);
        }
        for (UnitModel unitModel : unitDTOs) {
            if (map.containsKey(unitModel.getUnitId())) continue;
            map.put(unitModel.getUnitId(), DTOFactory.buildStateDTO(id, 0L, 0L, 0L, 0L, 0L, 0L, unknownState, stateModelId, 0, "", null, null, false, false, DTOFactory.buildUnitDTO(unitModel)));
        }
        return new ArrayList<StateDTO>(map.values());
    }

    @Override
    @Business(viewType="both")
    public List<MaintenanceForecastDTO> getMaintenanceForecastDTO(ReportSelectionDTO selectionDTO, int flashbackDays, int forecastDays) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getMaintenanceForecastDTO() called ");
        }
        long executionTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Maintenance Forecast: retrieving runtimes...");
        }
        ReportSelectionDTO totalSelectionDTO = selectionDTO.copy();
        totalSelectionDTO.setInterval(new Interval(0L, System.currentTimeMillis()));
        StatusDurationsDTOList totalRuntimeList = this.summarizedDataFacade.getStateDurations(totalSelectionDTO, 2010, false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Maintenance Forecast: generating flashback list...");
        }
        DateTime dateTimeNow = new DateTime();
        DateTime dateTimeFlashback = dateTimeNow.minusDays(flashbackDays);
        ReportSelectionDTO flashSelectionDTO = selectionDTO.copy();
        flashSelectionDTO.setInterval(new Interval(dateTimeFlashback.getMillis(), System.currentTimeMillis()));
        StatusDurationsDTOList flashbackList = this.summarizedDataFacade.getStateDurations(flashSelectionDTO, 2010, false);
        HashMap<Long, StateDurationsDTO> unitFlashbackMap = new HashMap<Long, StateDurationsDTO>();
        for (int i = 0; i < flashbackList.size(); ++i) {
            StateDurationsDTO dto = (StateDurationsDTO)flashbackList.get(i);
            unitFlashbackMap.put(dto.getUnitId(), dto);
        }
        UnitContainerListBase<MaintenanceForecastDTO> forecastDtoList = DTOListFactory.buildUnitContainerListBase(selectionDTO);
        for (int i = 0; i < totalRuntimeList.size(); ++i) {
            StateDurationsDTO totalRuntimeDto = (StateDurationsDTO)totalRuntimeList.get(i);
            UnitModel unitModel = totalRuntimeDto.getUnitModel();
            if (unitModel == null) continue;
            float averageRuntimeHours = 0.0f;
            StateDurationsDTO dtoFlashback = (StateDurationsDTO)unitFlashbackMap.get(unitModel.getUnitId());
            if (dtoFlashback != null) {
                averageRuntimeHours = ((float)dtoFlashback.getDuration(2013) + (float)dtoFlashback.getDuration(2012)) / (float)flashbackDays / 3600000.0f;
                averageRuntimeHours = (float)Math.round(averageRuntimeHours * 100.0f) / 100.0f;
            }
            long totalRuntime = totalRuntimeDto.getDuration(2013) + totalRuntimeDto.getDuration(2012) + unitModel.getOperativeTimeOffset();
            long totalRuntimeHours = Math.round((float)totalRuntime / 3600000.0f);
            long availableRuntimeHours = (long)unitModel.getNextMaintenance() - totalRuntimeHours;
            boolean overdue = (float)availableRuntimeHours <= 0.0f;
            int daysToMaintenance = 9999;
            long maintenanceDateMillis = 0L;
            if (averageRuntimeHours != 0.0f) {
                daysToMaintenance = Math.round((float)availableRuntimeHours / averageRuntimeHours);
                DateTime maintenanceDate = dateTimeNow.plusDays(daysToMaintenance);
                maintenanceDateMillis = maintenanceDate.getMillis();
            } else if (overdue) {
                daysToMaintenance = 0;
                maintenanceDateMillis = dateTimeNow.getMillis();
            }
            if (daysToMaintenance > forecastDays) continue;
            MaintenanceForecastDTO forecastDTO = DTOFactory.buildMaintenanceForecastDTO(unitModel, totalRuntimeHours, availableRuntimeHours, overdue, averageRuntimeHours, daysToMaintenance, maintenanceDateMillis);
            forecastDtoList.add(forecastDTO);
        }
        forecastDtoList.setExecutionTime(System.currentTimeMillis() - executionTime);
        return forecastDtoList;
    }

    private boolean updateCurrentStateCache(StateDTO dto) {
        boolean successful = false;
        StateCache cache = this.currentStateFacade.findByPrimaryKey(new StateCache.PK(dto.getUnitId(), dto.getStateModelId()));
        if (cache == null) {
            return false;
        }
        if (cache.getStateId() != dto.getStateId()) {
            return false;
        }
        StateHistory hist = this.currentStateFacade.findByPrimaryKey(cache.getHistoryId());
        if (dto.getStateId() == cache.getStateId()) {
            cache.setRemark(dto.getRemark());
            SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)cache), (Serializable)((Object)hist));
            wrapper.set_typeOfEvent("StateEventHistoryAndCache");
            try {
                this.informantFacade.notify(wrapper, "StateEventHistoryAndCache");
                successful = true;
            }
            catch (Exception e) {
                logger.error((Object)"handleStateEvent runs into Exception: ", (Throwable)e);
            }
        }
        return successful;
    }

    @Override
    @Business(viewType="both")
    public boolean generateStateEvent(StateDTO dto) {
        if (!dto.getUnit().isBasic()) {
            return false;
        }
        boolean successful = this.updateCurrentStateCache(dto);
        if (successful) {
            StateCache cache = this.currentStateFacade.findByPrimaryKey(new StateCache.PK(dto.getUnit().getUnitId(), 2090));
            StringBuilder pkBuilder = new StringBuilder("[");
            pkBuilder.append(String.valueOf(dto.getUnitId()));
            pkBuilder.append(".");
            pkBuilder.append(String.valueOf(dto.getStateModelId()));
            pkBuilder.append("] ");
            pkBuilder.append(dto.getUnitName());
            StringBuilder changesBuilder = new StringBuilder();
            if (cache != null) {
                changesBuilder.append("${stateId}: -");
                changesBuilder.append(String.valueOf(cache.getStateId()));
                changesBuilder.append(", +");
                changesBuilder.append(String.valueOf(dto.getStateId()));
                changesBuilder.append("; ${remark}: -");
                changesBuilder.append(cache.getRemark());
                changesBuilder.append(", +");
                changesBuilder.append(dto.getRemark());
                changesBuilder.append(";");
            }
            this.auditFacade.logEvent(AUDIT_APPLICATION, ActionType.Update, "ServiceChange", pkBuilder.toString(), changesBuilder.toString());
        } else {
            EventResponse eventResponse = this.eventFacade.handleEvent(this.buildEvent(dto));
            successful = eventResponse.isEventResponse();
        }
        return successful;
    }

    private Properties buildEvent(StateDTO value) {
        Properties event = new Properties();
        event.setProperty("u", String.valueOf(value.getUnitId()));
        event.setProperty("m", String.valueOf(value.getStateModelId()));
        event.setProperty("s", String.valueOf(value.getStateId()));
        event.setProperty("c", value.getRemark());
        return event;
    }
}

