/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.historyData;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseOutFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.infoman.AdminInfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBaseComparator;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.common.dto.event.EventCountDTO;
import de.proveo.wwt.logic.web.common.dto.event.EventType;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.EventFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.GdataFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.KeepAliveFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.NotificationFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.ScanmanMessageFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.UseFastLaneReader;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCounterEvaluatorBase;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCounterProcessor;
import de.proveo.wwt.logic.web.data.processors.stateCounter.peak.StackedStatusPeakEvaluator;
import de.proveo.wwt.logic.web.data.processors.stateCounter.peak.StatusPeakEvaluator;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeLocal;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeRemote;
import de.proveo.wwt.logic.web.historyData.dto.AccidentReconstructionDTO;
import de.proveo.wwt.logic.web.historyData.dto.FlightRotationDTO;
import de.proveo.wwt.logic.web.historyData.dto.GseProductivityDTO;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PeakDataDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.ScanmanMessageDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateAssignmentDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import de.proveo.wwt.logic.web.security.PermissionChecker;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeBean;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeLocal;
import de.proveo.wwt.logic.web.summarizedData.dto.StateDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.StatusDurationsDTOList;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeaksDTOList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.joda.time.DateMidnight;

@Stateless(name="HistoryDataFacade")
@Remote(value={HistoryDataFacadeRemote.class})
@Local(value={HistoryDataFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/HistoryDataFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/HistoryDataFacade")
@TransactionTimeout(value=900)
public class HistoryDataFacadeBean
implements HistoryDataFacadeLocal,
HistoryDataFacadeRemote {
    @Resource
    private SessionContext sessionContext;
    private static final long serialVersionUID = 6676485569783138919L;
    private static final Log log = LogFactory.getLog(HistoryDataFacadeBean.class);
    private static final String CONFIG_PARAM_GEO_MPH = "geo.speedUnit.Mph";
    @EJB
    private ConfigurationLocal configuration = null;
    @EJB
    private PermissionCheckerLocal permissionChecker = null;
    @EJB
    private AdminInfomanSetupFacadeLocal adminInfomanSetupFacadeLocal = null;
    @EJB
    private KeepAliveOutFacadeLocal keepAliveFacade = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private ScanmanMsgFacadeLocal scanmanFacade = null;
    @EJB
    private MeasurementFacadeLocal measurementFacade = null;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade = null;
    @EJB
    private UseOutFacadeLocal useOutFacade = null;
    private boolean geoSpeedMph = false;
    private int gseArrivalSetupStartTime;
    private int gseArrivalSetupEndTimePax;
    private int gseArrivalSetupEndTimeCgo;
    private int gseDepartureSetupStartTime;
    private int gseDepartureSetupEndTime;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        try {
            String param = this.configuration.getParameter(CONFIG_PARAM_GEO_MPH, "false");
            if (param.length() > 0) {
                this.geoSpeedMph = Boolean.parseBoolean(param);
            }
            if ((param = this.configuration.getParameter("gseArrival.SetupStartTime", "15")).length() > 0) {
                this.gseArrivalSetupStartTime = Integer.parseInt(param);
            }
            if ((param = this.configuration.getParameter("gseArrival.SetupEndTimePax", "60")).length() > 0) {
                this.gseArrivalSetupEndTimePax = Integer.parseInt(param);
            }
            if ((param = this.configuration.getParameter("gseArrival.SetupEndTimeCgo", "90")).length() > 0) {
                this.gseArrivalSetupEndTimeCgo = Integer.parseInt(param);
            }
            if ((param = this.configuration.getParameter("gseDeparture.SetupStartTime", "15")).length() > 0) {
                this.gseDepartureSetupStartTime = Integer.parseInt(param);
            }
            if ((param = this.configuration.getParameter("gseDeparture.SetupEndTime", "15")).length() > 0) {
                this.gseDepartureSetupEndTime = Integer.parseInt(param);
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    @TransactionTimeout(value=3600)
    public PeakDataDTO getPeakData(ReportSelectionDTO selectionDTO, int stateModelId, String intervalString, String peakModelStates) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacadeBean.class, "getPeakData()");
        stopwatch.start("Overall");
        int interval = Integer.valueOf(intervalString);
        StateCounterEvaluatorBase[] evaluators = new StateCounterEvaluatorBase[]{new StatusPeakEvaluator(selectionDTO, interval), new StackedStatusPeakEvaluator(selectionDTO, interval, peakModelStates)};
        this.executeStateCounter(selectionDTO, stateModelId, interval, evaluators);
        StatusPeaksDTOList statusPeaks = ((StatusPeakEvaluator)evaluators[0]).evaluate();
        StatusPeaksDTOList stackedPeaks = ((StackedStatusPeakEvaluator)evaluators[1]).evaluate();
        stopwatch.stop("Overall", true);
        return new PeakDataDTO(stackedPeaks, statusPeaks);
    }

    @Override
    @Business(viewType="both")
    public StatusPeaksDTOList getStatusPeakDTOList(ReportSelectionDTO selectionDTO, int stateModelId, String intervalString) {
        int interval = Integer.valueOf(intervalString);
        StateCounterEvaluatorBase[] evaluators = new StateCounterEvaluatorBase[]{new StatusPeakEvaluator(selectionDTO, interval)};
        this.executeStateCounter(selectionDTO, stateModelId, interval, evaluators);
        StatusPeaksDTOList statusPeaks = ((StatusPeakEvaluator)evaluators[0]).evaluate();
        return statusPeaks;
    }

    @Override
    @Business(viewType="both")
    public StatusPeaksDTOList getStackedStatusPeakDTOList(ReportSelectionDTO selectionDTO, int stateModelId, String intervalString, String peakModelStates) {
        int interval = Integer.valueOf(intervalString);
        StateCounterEvaluatorBase[] evaluators = new StateCounterEvaluatorBase[]{new StackedStatusPeakEvaluator(selectionDTO, interval, peakModelStates)};
        this.executeStateCounter(selectionDTO, stateModelId, interval, evaluators);
        StatusPeaksDTOList stackedPeaks = ((StackedStatusPeakEvaluator)evaluators[0]).evaluate();
        return stackedPeaks;
    }

    private void executeStateCounter(ReportSelectionDTO selectionDTO, int stateModelId, int interval, StateCounterEvaluatorBase[] evaluators) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacadeBean.class, "executeEventCounter()");
        stopwatch.start("Overall");
        log.debug((Object)"StateCounter processing");
        long current = System.currentTimeMillis();
        long beginTime = selectionDTO.getBeginTime();
        long endTime = Math.min(current, selectionDTO.getEndTime());
        StateCounterProcessor stateCounter = new StateCounterProcessor(evaluators, beginTime, endTime, interval, stateModelId);
        PermissionChecker permissionChecker = this.permissionChecker.getPermissionChecker();
        new StateFastLaneReader().processStateHistory(permissionChecker, stateCounter, selectionDTO, stateModelId, null, FastLaneReaderOrder.ByBeginTime, new ExtendedDTOData[0]);
        stopwatch.stop("Overall", true);
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public StateDTOList getStateData(Long unitId, Integer stateModelId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData[] extData) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacadeBean.class, "getStateData", this.sessionContext);
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStateData called with stateModelId=" + stateModelId + "  unitId=" + unitId + " beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        StateDTOList list = DTOListFactory.buildStateDTOList(null, stateModelId);
        if (endTime < beginTime) {
            return list;
        }
        long current = System.currentTimeMillis();
        endTime = Math.min(current, endTime);
        stopwatch.start("Database access");
        new StateFastLaneReader().getHistory((DTOListBase<StateDTO>)list, unitId, stateModelId, null, beginTime, endTime, useGroupHistory, FastLaneReaderOrder.ByNothing, extData);
        stopwatch.stop("Database access", true, list.size());
        stopwatch.start("Build DTO");
        this.permissionChecker.checkDTOList(list);
        stopwatch.stop("Overall", true);
        list.setStopwatch(stopwatch);
        return list;
    }

    @Override
    @Business(viewType="both")
    public StateDTOList getStateData(ReportSelectionDTO selectionDTO, Integer stateModelId, ExtendedDTOData[] extData) {
        return this.getStateData(selectionDTO, stateModelId, null, extData);
    }

    @Override
    @Business(viewType="both")
    public StateDTOList getStateData(ReportSelectionDTO selectionDTO, Integer stateModelId, Integer stateFilterId, ExtendedDTOData[] extData) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacadeBean.class, "getStateData", this.sessionContext);
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStateData called with stateModelId=" + stateModelId + "  dto=" + selectionDTO));
        }
        StateDTOList list = DTOListFactory.buildStateDTOList(selectionDTO, stateModelId);
        stopwatch.start("Database access");
        new StateFastLaneReader().getHistory((DTOListBase<StateDTO>)list, selectionDTO, stateModelId, stateFilterId, FastLaneReaderOrder.ByNothing, extData);
        stopwatch.stop("Database access", true, list.size());
        stopwatch.start("Build DTO");
        this.permissionChecker.checkDTOList(list);
        stopwatch.stop("Overall", true);
        list.setStopwatch(stopwatch);
        return list;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public ReportDTOListBase<PositionDTO> getPositionData(Long unitId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData[] extData) {
        if (unitId != null && unitId == -1L) {
            return null;
        }
        Stopwatch stopwatch = new Stopwatch(this.getClass(), "getPostionData");
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPostionData called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        ReportDTOListBase<PositionDTO> list = DTOListFactory.buildReportDTOListBase(null);
        stopwatch.start("addCurrentGdataCache");
        stopwatch.stop("addCurrentGdataCache", false, list.size());
        new GdataFastLaneReader().getHistory(list, unitId, beginTime, endTime, useGroupHistory, extData);
        this.permissionChecker.checkDTOList(list);
        stopwatch.stop("Overall", true);
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<PositionDTO> getPositionData(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        Stopwatch stopwatch = new Stopwatch(this.getClass(), "getPostionData");
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)"getPostionData called ");
        }
        ReportDTOListBase<PositionDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new GdataFastLaneReader().getHistory(list, selectionDTO, extData);
        this.permissionChecker.checkDTOList(list);
        stopwatch.stop("Overall", true);
        return list;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public ReportDTOListBase<KeepAliveDTO> getKeepAliveData(Long unitId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData[] extData) {
        if (unitId != null && unitId == -1L) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getKeepAliveData called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        ReportDTOListBase<KeepAliveDTO> list = DTOListFactory.buildReportDTOListBase(null);
        if (endTime < beginTime) {
            return list;
        }
        long current = System.currentTimeMillis();
        endTime = Math.min(current, endTime);
        new KeepAliveFastLaneReader().getHistory(list, unitId, beginTime, endTime, useGroupHistory, extData);
        this.permissionChecker.checkDTOList(list);
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<KeepAliveDTO> getKeepAliveData(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getKeepAliveData called ");
        }
        ReportDTOListBase<KeepAliveDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new KeepAliveFastLaneReader().getHistory(list, selectionDTO, extData);
        this.permissionChecker.checkDTOList(list);
        return list;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public ReportDTOListBase<NotificationDTO> getNotificationData(Long unitId, Long messageId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData[] extData) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacadeBean.class, "getNotifications");
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifications called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        ReportDTOListBase<NotificationDTO> list = DTOListFactory.buildReportDTOListBase(null);
        log.debug((Object)"notificationHistory databaseAccess...");
        stopwatch.start("Database access");
        new NotificationFastLaneReader().getHistory(list, unitId, messageId, beginTime, endTime, useGroupHistory, extData);
        stopwatch.stop("Database access", true, list.size());
        this.permissionChecker.checkDTOList(list);
        if (log.isDebugEnabled() && list != null) {
            log.debug((Object)("values found: " + list.size()));
        }
        stopwatch.stop("Overall", true);
        if (list != null) {
            list.setStopwatch(stopwatch);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<NotificationDTO> getNotificationData(ReportSelectionDTO selectionDTO, Long messageId, ExtendedDTOData[] extData) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacadeBean.class, "getNotifications");
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)"getNotifications called ");
        }
        ReportDTOListBase<NotificationDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        log.debug((Object)"notificationHistory databaseAccess...");
        stopwatch.start("Database access");
        new NotificationFastLaneReader().getHistory(list, selectionDTO, messageId, extData);
        stopwatch.stop("Database access", true, list.size());
        this.permissionChecker.checkDTOList(list);
        if (log.isDebugEnabled() && list != null) {
            log.debug((Object)("values found: " + list.size()));
        }
        stopwatch.stop("Overall", true);
        if (list != null) {
            list.setStopwatch(stopwatch);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public StateDTOList getGseUsageDataCompressed(ReportSelectionDTO selectionDTO, int stateModelId, Integer[] startStates, Integer[] stopStates) {
        DTOListBase<StateDTO> list = DTOListFactory.buildDTOListBase(selectionDTO);
        new StateFastLaneReader().getHistory(list, selectionDTO, (Integer)stateModelId, null, FastLaneReaderOrder.ByUnitIdAndBeginTime, ExtendedDTOData.getSTATEDATA());
        HashMap<Long, ArrayList> unitIdMap = new HashMap<Long, ArrayList>();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList arr;
            StateDTO stateDTO = (StateDTO)list.get(i);
            Long unitId = stateDTO.getUnitId();
            if (unitIdMap.containsKey(unitId)) {
                arr = (ArrayList)unitIdMap.get(unitId);
                arr.add(stateDTO);
                continue;
            }
            arr = new ArrayList();
            arr.add(stateDTO);
            unitIdMap.put(unitId, arr);
        }
        StateDTOList gseListCompressed = DTOListFactory.buildStateDTOList(selectionDTO, stateModelId);
        for (Map.Entry unitValues : unitIdMap.entrySet()) {
            long basicUnitId = (Long)unitValues.getKey();
            ArrayList states = (ArrayList)unitValues.getValue();
            for (int i = 0; i < states.size(); ++i) {
                StateDTO dto = (StateDTO)states.get(i);
                if (startStates != null && !ArrayUtils.contains((Object[])startStates, (Object)dto.getStateId()) || stopStates != null && ArrayUtils.contains((Object[])stopStates, (Object)dto.getStateId())) continue;
                for (int j = i + 1; j < states.size(); ++j) {
                    StateDTO dtoStop = (StateDTO)states.get(j);
                    if ((stopStates != null || basicUnitId != dtoStop.getUnitId()) && (!ArrayUtils.contains((Object[])stopStates, (Object)dtoStop.getStateId()) || basicUnitId != dtoStop.getUnitId())) continue;
                    dto.mergeWithStateDTO(dtoStop);
                    gseListCompressed.add(dto);
                    break;
                }
                if (i != states.size() - 1 || stopStates != null && !ArrayUtils.contains((Object[])stopStates, (Object)dto.getStateId())) continue;
                dto.correctTimes(selectionDTO.getBeginTime(), selectionDTO.getEndTime());
                gseListCompressed.add(dto);
            }
        }
        this.permissionChecker.checkDTOList(gseListCompressed);
        return gseListCompressed;
    }

    @Override
    @Business(viewType="both")
    public StateDTOList getGseUsageDataUseUserChange(ReportSelectionDTO selectionDTO, int stateModelId) {
        StateDTOList gseListComplete = this.getGseUsageDataCompressed(selectionDTO, stateModelId, null, null);
        StateDTOList gseListCompressed = new StateDTOList(gseListComplete.getReportSelectionDTO(), stateModelId);
        block0: for (int i = 0; i < gseListComplete.size(); ++i) {
            StateDTO dto = (StateDTO)gseListComplete.get(i);
            UseUser useUser = dto.getUseUser();
            long useUserId = -100L;
            if (useUser != null) {
                useUserId = useUser.getId();
            }
            long basicUnitId = dto.getUnitId();
            StateDTO newdto = dto;
            for (int j = i + 1; j < gseListComplete.size(); ++j) {
                StateDTO dtoNext = (StateDTO)gseListComplete.get(j);
                UseUser useUserNext = dtoNext.getUseUser();
                long useUserIdNext = -100L;
                if (useUserNext != null) {
                    useUserIdNext = useUserNext.getId();
                }
                long basicUnitIdNext = dtoNext.getUnitId();
                if (useUser == null || basicUnitId == basicUnitIdNext && useUserId == useUserIdNext && j != gseListComplete.size() - 1) continue;
                i = j - 1;
                StateDTO dtoBefore = (StateDTO)gseListComplete.get(i);
                newdto.mergeWithStateDTO(dtoBefore);
                if (dtoNext.getEndArea() == null) {
                    newdto.mergeWithStateDTO(dtoNext);
                    newdto.setEndTime(System.currentTimeMillis());
                    i = j;
                }
                gseListCompressed.add(newdto);
                continue block0;
            }
        }
        this.permissionChecker.checkDTOList(gseListCompressed);
        return gseListCompressed;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public ReportDTOListBase<UseDTO> getUseHistoryData(Long unitId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData[] extData) {
        if (unitId != null && unitId == -1L) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUseHistoryData called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        ReportDTOListBase<UseDTO> list = DTOListFactory.buildReportDTOListBase(null);
        if (endTime < beginTime) {
            return list;
        }
        long current = System.currentTimeMillis();
        endTime = Math.min(current, endTime);
        new UseFastLaneReader().getHistory(list, unitId, beginTime, endTime, useGroupHistory, extData);
        this.permissionChecker.checkDTOList(list);
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<UseDTO> getUseHistoryData(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getUseHistoryData called ");
        }
        ReportDTOListBase<UseDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new UseFastLaneReader().getHistory(list, selectionDTO, extData);
        this.permissionChecker.checkDTOList(list);
        return list;
    }

    @Override
    @Business(viewType="both")
    public boolean isGeoSpeedMph() {
        return this.geoSpeedMph;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<AccidentReconstructionDTO> getAccidentReconstructions(ReportSelectionDTO selectionDTO, Long messageId, Integer assignedModelId, boolean totalRuntimes, long beginTimeTotalRuntimes) {
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "getAccidentReconstructions");
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAccidentReconstructions called ");
        }
        ReportDTOListBase<AccidentReconstructionDTO> list = null;
        list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        ReportDTOListBase<NotificationDTO> messageList = this.getNotificationData(selectionDTO, messageId, ExtendedDTOData.getSTATEDATA());
        if (messageList.size() == 0) {
            return list;
        }
        long beginTimeMidnight = new DateMidnight((Object)selectionDTO.getBeginTime()).getMillis();
        ReportSelectionDTO midnightSelectionDTO = selectionDTO.copy();
        midnightSelectionDTO.setBeginTime(beginTimeMidnight);
        StateDTOList stateList = this.getStateData(midnightSelectionDTO, assignedModelId, ExtendedDTOData.getNOTHING());
        StateDTOList runtimeList = null;
        if (totalRuntimes) {
            runtimeList = this.getStateData(midnightSelectionDTO, 2010, ExtendedDTOData.getNOTHING());
        }
        ReportDTOListBase<PositionDTO> positionList = this.getPositionData(selectionDTO, ExtendedDTOData.getNOTHING());
        if (log.isDebugEnabled()) {
            log.debug((Object)"!!! TODO !!! bad performace in gdata_history , kai is working on this issue !!! ");
        }
        StatusDurationsDTOList summaryList = null;
        if (totalRuntimes && beginTimeTotalRuntimes < beginTimeMidnight) {
            SummarizedDataFacadeLocal summarizedDataFacadeLocal = null;
            try {
                InitialContext context = new InitialContext();
                summarizedDataFacadeLocal = (SummarizedDataFacadeLocal)context.lookup("rts/SummarizedDataFacade/local");
            }
            catch (NamingException e1) {
                log.error((Object)"runs into", (Throwable)e1);
            }
            ReportSelectionDTO summarySelectionDTO = selectionDTO.copy();
            summarySelectionDTO.setBeginTime(0L);
            summarySelectionDTO.setEndTime(beginTimeMidnight);
            summaryList = summarizedDataFacadeLocal.getStateDurations(summarySelectionDTO, 2010, true);
        }
        for (int index = 0; index != messageList.size(); ++index) {
            NotificationDTO notification = (NotificationDTO)messageList.get(index);
            long unitModelId = notification.getUnitId();
            long accidentTime = notification.getCreateTime();
            StateDTO state = null;
            for (int i = 0; i < stateList.size() && (accidentTime < (state = (StateDTO)stateList.get(i)).getActualBeginTime() || accidentTime > state.getActualEndTime() || state.getUnitId() != unitModelId); ++i) {
                state = null;
            }
            long totalRuntimeDuration = 0L;
            if (totalRuntimes) {
                totalRuntimeDuration = this.totalRunTimeFromListUntilTimestamp(unitModelId, runtimeList, accidentTime);
            }
            if (totalRuntimes && summaryList != null) {
                for (int i = 0; i != summaryList.size(); ++i) {
                    StateDurationsDTO dtoTotalRuntime = (StateDurationsDTO)summaryList.get(i);
                    if (dtoTotalRuntime.getUnitId() != unitModelId) continue;
                    UnitModel currentUnitUnitModel = this.unitFacade.getUnitModel(unitModelId);
                    totalRuntimeDuration += dtoTotalRuntime.getDuration(2013) + dtoTotalRuntime.getDuration(2012) + currentUnitUnitModel.getOperativeTimeOffset();
                    break;
                }
            }
            long totalRuntimeHours = totalRuntimeDuration / 3600000L;
            PositionDTO position = this.getBestPositionDtoForTimestamp(unitModelId, positionList, accidentTime);
            UnitModel unitModelBasic = this.unitFacade.getUnitModel(notification.getUnitId());
            AccidentReconstructionDTO dto = DTOFactory.buildAccidentReconstructionDTO(unitModelBasic, notification, state, position, totalRuntimeHours);
            list.add(dto);
        }
        this.permissionChecker.checkDTOList(list);
        if (log.isDebugEnabled()) {
            log.debug((Object)("values found: " + list.size()));
        }
        stopwatch.stop("Overall", true);
        list.setStopwatch(stopwatch);
        return list;
    }

    @Override
    @Business(viewType="both")
    public UnitContainerListBase<GseProductivityDTO> getProductivityDataForFlightRotations(long beginTime, long endTime, DTOListBase<FlightRotationDTO> rotations, boolean mustHaveOnblOffbl, boolean useGroupHistory) {
        UnitContainerListBase<GseProductivityDTO> list = DTOListFactory.buildUnitContainerListBase(null);
        if (rotations == null) {
            rotations = this.getFlightRotationData(beginTime, endTime, mustHaveOnblOffbl);
        }
        for (int j = 0; j < rotations.size(); ++j) {
            FlightRotationDTO rotationDTO = (FlightRotationDTO)rotations.get(j);
            HashMap unitToAssignment = new HashMap();
            List<StateHistory> hValues = this.currentStateFacade.findHistoryByRotationAssignment(rotationDTO.getRotationKey(), 2120, 2121);
            hValues.addAll(this.currentStateFacade.findHistoryByRotationAssignment(rotationDTO.getRotationKey(), 2120, 2122));
            StateHistory[] histArr = hValues.toArray(new StateHistory[hValues.size()]);
            for (int k = 0; k != histArr.length; ++k) {
                StateHistory stateValue = histArr[k];
                long unitId = stateValue.getUnitId();
                DTOListBase arr = (DTOListBase)unitToAssignment.get(unitId);
                if (arr == null) {
                    arr = DTOListFactory.buildDTOListBase(null);
                }
                arr.add(DTOFactory.buildStateAssignmentDTO(rotationDTO, histArr[k]));
                unitToAssignment.put(unitId, arr);
            }
            List<StateCache> currentStateCaches = this.currentStateFacade.findCacheByRotationAssignment(rotationDTO.getRotationKey(), 2120, 2121);
            currentStateCaches.addAll(this.currentStateFacade.findCacheByRotationAssignment(rotationDTO.getRotationKey(), 2120, 2122));
            StateCache[] currArr = currentStateCaches.toArray(new StateCache[currentStateCaches.size()]);
            for (int k = 0; k != currArr.length; ++k) {
                StateCache stateValue = currArr[k];
                long unitId = stateValue.getPk().getUnitId();
                DTOListBase arr = (DTOListBase)unitToAssignment.get(unitId);
                if (arr == null) {
                    arr = DTOListFactory.buildDTOListBase(null);
                }
                arr.add(DTOFactory.buildStateAssignmentDTO(rotationDTO, currArr[k]));
                unitToAssignment.put(unitId, arr);
            }
            StateAssignmentDTO assignmentDto = null;
            for (Map.Entry e : unitToAssignment.entrySet()) {
                long unitId = (Long)e.getKey();
                UnitModel uModel = this.unitFacade.getUnitModel(unitId);
                DTOListBase unitAssignments = (DTOListBase)e.getValue();
                ArrayList<StateDTOList> arrStateDTOList = new ArrayList<StateDTOList>();
                long totalDuration2012 = 0L;
                long totalDuration2013 = 0L;
                for (int k = 0; k != unitAssignments.size(); ++k) {
                    assignmentDto = (StateAssignmentDTO)unitAssignments.get(k);
                    long st = assignmentDto.getStateDTO().getBeginTime();
                    long et = assignmentDto.getStateDTO().getEndTime();
                    StateDTOList stateList = this.getStateData(unitId, 2010, st, et, useGroupHistory, ExtendedDTOData.getSTATEDATA());
                    arrStateDTOList.add(stateList);
                    StateDTO dto = null;
                    for (int l = 0; l < stateList.size(); ++l) {
                        dto = (StateDTO)stateList.get(l);
                        if (dto == null) continue;
                        if (dto.getStateId() == 2012) {
                            totalDuration2012 += dto.getDuration();
                        }
                        if (dto.getStateId() != 2013) continue;
                        totalDuration2013 += dto.getDuration();
                    }
                }
                list.add(DTOFactory.buildGseProductivityDTO(uModel, rotationDTO, arrStateDTOList, totalDuration2012, totalDuration2013));
            }
        }
        this.permissionChecker.checkDTOList(list);
        return list;
    }

    @Override
    @Business(viewType="both")
    public DTOListBase<FlightRotationDTO> getFlightRotationData(long beginTime, long endTime, boolean mustHaveOnblOffbl) {
        DTOListBase<FlightRotationDTO> list = DTOListFactory.buildDTOListBase(null);
        return list;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public ReportDTOListBase<ScanmanMessageDTO> getScanmanMessageData(Long unitId, Integer msgFilterId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData[] extData) {
        if (unitId != null && unitId == -1L) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getScanManMessages called with unitId=" + unitId + " beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        ReportDTOListBase<ScanmanMessageDTO> list = DTOListFactory.buildReportDTOListBase(null);
        if (endTime < beginTime) {
            return list;
        }
        long current = System.currentTimeMillis();
        endTime = Math.min(current, endTime);
        new ScanmanMessageFastLaneReader().getHistory(list, unitId, msgFilterId, beginTime, endTime, useGroupHistory, extData);
        this.permissionChecker.checkDTOList(list);
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<ScanmanMessageDTO> getScanmanMessageData(ReportSelectionDTO selectionDTO, Integer msgFilterId, ExtendedDTOData[] extData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getScanManMessages called ");
        }
        ReportDTOListBase<ScanmanMessageDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new ScanmanMessageFastLaneReader().getHistory(list, selectionDTO, msgFilterId, extData);
        this.permissionChecker.checkDTOList(list);
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<ReportDTOBase> getAllData(ReportSelectionDTO selectionDTO) {
        ReportDTOListBase<ReportDTOBase> list = null;
        try {
            list = DTOListFactory.buildReportDTOListBase(selectionDTO);
            list.addAll(this.getStateData(selectionDTO, null, ExtendedDTOData.getSTATEDATA()));
            list.addAll(this.getPositionData(selectionDTO, ExtendedDTOData.getSTATEDATA()));
            list.addAll(this.getNotificationData(selectionDTO, null, ExtendedDTOData.getSTATEDATA()));
            list.addAll(this.getUseHistoryData(selectionDTO, ExtendedDTOData.getSTATEDATA()));
            list.addAll(this.getKeepAliveData(selectionDTO, ExtendedDTOData.getSTATEDATA()));
            list.addAll(this.measurementFacade.getMeasurementHistory(selectionDTO, ExtendedDTOData.getSTATEDATA()));
            if (this.sessionContext.isCallerInRole("superadmin")) {
                list.addAll(this.adminInfomanSetupFacadeLocal.getConfigurationHistory(selectionDTO));
                list.addAll(this.getScanmanMessageData(selectionDTO, null, ExtendedDTOData.getSTATEDATA()));
            }
        }
        catch (FinderException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        this.permissionChecker.checkDTOList(list);
        Collections.sort(list, new ReportDTOBaseComparator(ReportDTOBaseComparator.CompareType.BEGIN_TIME));
        return list;
    }

    @Override
    @Business(viewType="both")
    public long totalRunTimeFromListUntilTimestamp(long unitModelId, StateDTOList runtimeList, long endTimeForRuntTime) {
        long totalRuntime = 0L;
        for (int i = 0; i < runtimeList.size(); ++i) {
            StateDTO engineState = (StateDTO)runtimeList.get(i);
            if (engineState.getUnitId() != unitModelId) continue;
            if (endTimeForRuntTime >= engineState.getBeginTime() && endTimeForRuntTime <= engineState.getEndTime()) {
                if (engineState.getStateId() != 2012 && engineState.getStateId() != 2013) break;
                totalRuntime += endTimeForRuntTime - engineState.getBeginTime();
                break;
            }
            if (engineState.getStateId() != 2012 && engineState.getStateId() != 2013) continue;
            totalRuntime += engineState.getDuration();
        }
        return totalRuntime;
    }

    @Override
    @Business(viewType="both")
    public UnitContainerListBase<EventCountDTO> getEventCounts(ReportSelectionDTO selectionDTO, EventType[] types) {
        UnitContainerListBase<EventCountDTO> list = DTOListFactory.buildUnitContainerListBase(selectionDTO);
        new EventFastLaneReader().getEventCountList(list, selectionDTO, types);
        return list;
    }

    @Override
    @Business(viewType="both")
    public PositionDTO getBestPositionDtoForTimestamp(long unitModelId, ReportDTOListBase<PositionDTO> positionList, long timestamp) {
        int bestIndex = -1;
        boolean searchNext = true;
        PositionDTO position = null;
        for (int j = 0; j != positionList.size(); ++j) {
            position = (PositionDTO)positionList.get(j);
            if (timestamp == position.getActualBeginTime() && position.getUnitId() == unitModelId) {
                bestIndex = j;
                break;
            }
            if (timestamp >= position.getActualBeginTime() && timestamp <= position.getActualEndTime() && position.getUnitId() == unitModelId) {
                bestIndex = j;
            } else {
                position = null;
            }
            if (bestIndex < 0) continue;
            if (!searchNext) break;
            searchNext = false;
        }
        position = bestIndex == -1 ? null : (PositionDTO)positionList.get(bestIndex);
        return position;
    }
}

