/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto;

import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.ejb.general.tree.TreeNode;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitNodeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitTreeNode
extends TreeNode<UnitTreeNode, UnitDTO> {
    private static final long serialVersionUID = -1941187981866048788L;
    private static final Log log = LogFactory.getLog(UnitTreeNode.class);

    public UnitTreeNode() {
        this.setData(DTOFactory.buildUnitDTO());
    }

    public UnitTreeNode(UnitModel unitModel, UnitIdentity unitIdentity, UnitTypeIdentity unitTypeIdentity) {
        this.setData(DTOFactory.buildUnitDTO(unitModel, unitIdentity, unitTypeIdentity));
    }

    public boolean isBasic() {
        return ((UnitDTO)this.getData()).getUnitModel().getBasic();
    }

    @Override
    public void addChild(UnitTreeNode node) {
        if (node != null) {
            if (!((UnitDTO)this.getData()).getUnitModel().getBasic()) {
                node.setParent(this);
                this.getChildren().add(node);
            } else {
                log.error((Object)"addChild(): Tried to add child to basic unit! Skipped.");
            }
        }
    }

    public void setBasic(boolean basic) {
        ((UnitDTO)this.getData()).getUnitModel().setBasic(basic);
    }

    public void removeUnauthorizedUnits(Set<Long> authorizedUnits) {
        List allNodes = this.getAllNodes(false);
        for (int i = allNodes.size() - 1; i >= 0; --i) {
            UnitTreeNode currentNode = (UnitTreeNode)allNodes.get(i);
            UnitDTO unitDto = (UnitDTO)currentNode.getData();
            if (!unitDto.isBasic() || authorizedUnits.contains(unitDto.getUnitId())) continue;
            currentNode.remove();
        }
        this.removeEmptyGroups();
    }

    public void removeEmptyGroups() {
        List allNodes = this.getAllNodes(false);
        for (int i = allNodes.size() - 1; i >= 0; --i) {
            UnitTreeNode currentNode = (UnitTreeNode)allNodes.get(i);
            if (((UnitDTO)currentNode.getData()).isBasic() || currentNode.hasChildren()) continue;
            currentNode.remove();
        }
    }

    public List<UnitTreeNode> getSubnodes(UnitNodeType unitNodeType) {
        ArrayList<UnitTreeNode> subnodes = new ArrayList<UnitTreeNode>();
        for (UnitTreeNode node : this.getNodes(true)) {
            boolean basic = node.isBasic();
            if (unitNodeType != UnitNodeType.DontCare && (unitNodeType != UnitNodeType.Group || basic) && (unitNodeType != UnitNodeType.Unit || !basic)) continue;
            subnodes.add(node);
        }
        return subnodes;
    }
}

