/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.processors.stateCounter.peak;

import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCountSnapshot;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCountSnapshotReason;
import de.proveo.wwt.logic.web.data.processors.stateCounter.peak.PeakStatusEvaluatorBase;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;

public class StatusPeakEvaluator
extends PeakStatusEvaluatorBase {
    public StatusPeakEvaluator(ReportSelectionDTO selectionDTO, int interval) {
        super(selectionDTO, interval);
    }

    @Override
    public void processSnapshot(Collection<StateCountSnapshot> snapshots, StateCountSnapshotReason reason) {
        for (StateCountSnapshot snapshot : snapshots) {
            int intervalIndex = this.getIntervalIndex(snapshot.time);
            if (intervalIndex == -1 || intervalIndex >= this.intervalCount) {
                return;
            }
            StateCountSnapshot bufferedSnapshot = ((StateCountSnapshot[])this.snapshotMap.get(snapshot.stateId))[intervalIndex];
            if (bufferedSnapshot.count >= snapshot.count) continue;
            bufferedSnapshot.count = snapshot.count;
            bufferedSnapshot.time = snapshot.time;
            bufferedSnapshot.unitDTOs = new TreeSet<UnitDTO>((SortedSet<UnitDTO>)snapshot.unitDTOs);
        }
    }
}

