/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.performanceCounter;

import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterResult;
import de.proveo.wwt.logic.ejb.general.tableMappings.PerformanceCounterTransmissionDelayTableMapping;
import de.proveo.wwt.logic.ejb.general.tableMappings.readers.PerformanceCounterAnnotationReader;
import de.proveo.wwt.logic.web.data.performanceCounter.PerformanceCounterStatisticsBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class TransmissionDelayFastLane
extends PerformanceCounterStatisticsBase<PerformanceCounterTransmissionDelayTableMapping> {
    protected TransmissionDelayFastLane(Class<PerformanceCounterTransmissionDelayTableMapping> typeClass) {
        super(PerformanceCounterTransmissionDelayTableMapping.class);
    }

    @Override
    protected Object getUpdateSyncObject() {
        return null;
    }

    @Override
    protected int getLastTimestamp() {
        return -1;
    }

    @Override
    protected void setLastTimestamp(int timestamp) {
    }

    @Override
    protected String[] buildCustomStatisticsSql(long beginTime, long endTime, Enum<PerformanceCounterTransmissionDelayTableMapping>[] selectedTableMappings, long intervalMillis, Long unitId) {
        String[] statements = new String[selectedTableMappings.length];
        for (int i = 0; i != selectedTableMappings.length; ++i) {
            StringBuilder sb = new StringBuilder();
            Enum<PerformanceCounterTransmissionDelayTableMapping> currentEnum = selectedTableMappings[i];
            String column = PerformanceCounterAnnotationReader.getColumn(currentEnum);
            String table = PerformanceCounterAnnotationReader.getTable(currentEnum);
            String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(currentEnum);
            String aggregationSql = PerformanceCounterAnnotationReader.getAggregationSql(currentEnum);
            sb = new StringBuilder("SELECT FLOOR(");
            sb.append(column);
            sb.append(" / ");
            sb.append(String.valueOf(intervalMillis));
            sb.append(") AS ");
            sb.append("timestamp");
            sb.append(", ");
            sb.append(aggregationSql);
            sb.append(" AS ");
            sb.append(counterColumn);
            sb.append(" FROM ");
            sb.append(table);
            sb.append(" WHERE ");
            sb.append(column);
            sb.append(" >= ");
            sb.append(String.valueOf(beginTime * intervalMillis));
            sb.append(" AND ");
            sb.append(column);
            sb.append(" < ");
            sb.append(String.valueOf(endTime * intervalMillis));
            sb.append(" ORDER BY ");
            sb.append("timestamp");
            sb.append(", ");
            sb.append(counterColumn);
            statements[i] = sb.toString();
        }
        return statements;
    }

    @Override
    protected List<Long> processCustomStatisticsQuery(long intervalMillis, Enum<PerformanceCounterTransmissionDelayTableMapping> tableMapping, ArrayList<Long> timestamps, ResultSet resultSet) throws SQLException {
        ArrayList<Long> dataList = new ArrayList<Long>(timestamps.size());
        int timestampColumnIdx = resultSet.findColumn("timestamp");
        String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(tableMapping);
        int counterColumnIdx = resultSet.findColumn(counterColumn);
        long currentMedianTimestamp = 0L;
        long currentDbTimestamp = Long.MAX_VALUE;
        boolean rowAvailable = resultSet.next();
        if (rowAvailable) {
            currentDbTimestamp = (long)resultSet.getInt(timestampColumnIdx) * intervalMillis;
        }
        ArrayList<Double> medianList = new ArrayList<Double>();
        int size = timestamps.size();
        for (int dataIdx = 0; dataIdx != size; ++dataIdx) {
            long currentTime = timestamps.get(dataIdx);
            if (currentDbTimestamp < currentTime) {
                currentDbTimestamp = resultSet.next() ? (long)resultSet.getInt(timestampColumnIdx) * intervalMillis : Long.MAX_VALUE;
            }
            if (currentTime == currentDbTimestamp) {
                medianList.clear();
                currentMedianTimestamp = currentDbTimestamp;
                while ((currentDbTimestamp = (long)resultSet.getInt(timestampColumnIdx) * intervalMillis) == currentMedianTimestamp) {
                    medianList.add(resultSet.getDouble(counterColumnIdx));
                    if (resultSet.next()) continue;
                }
                int idx = medianList.size() == 1 ? 0 : medianList.size() / 2;
                dataList.add(((Double)medianList.get(idx)).longValue());
                continue;
            }
            dataList.add(0L);
        }
        return dataList;
    }

    @Override
    protected void calculateSum(PerformanceCounterResult<PerformanceCounterTransmissionDelayTableMapping> result) {
        Set keySet = result.statisticsMap.keySet();
        Enum[] enums = keySet.toArray(new Enum[keySet.size()]);
        int size = result.timestampRows.size();
        result.sumRows = new ArrayList<Long>(size);
        result.eventSumTotalMap = new HashMap();
        long eventSumTotal = 0L;
        List[] columns = new List[enums.length];
        for (int enumIdx = 0; enumIdx != enums.length; ++enumIdx) {
            List<Long> columnData;
            columns[enumIdx] = columnData = result.statisticsMap.get(enums[enumIdx]);
            long columnSum = 0L;
            for (int i = 0; i != size; ++i) {
                long value = columnData.get(i);
                if (value <= 0L) continue;
                columnSum += value;
            }
            eventSumTotal += columnSum;
            result.eventSumTotalMap.put(enums[enumIdx], columnSum / (long)size);
        }
        result.eventSumTotal = eventSumTotal / (long)(size * enums.length);
        for (int i = 0; i != size; ++i) {
            long sum = 0L;
            for (int columnIdx = 0; columnIdx != columns.length; ++columnIdx) {
                long value = (Long)columns[columnIdx].get(i);
                if (value <= 0L) continue;
                sum += value;
            }
            result.sumRows.add(sum / (long)columns.length);
        }
    }
}

