/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.performanceCounter;

import de.proveo.util.database.DatabaseUtil;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterInterval;
import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterIntervalResult;
import de.proveo.wwt.logic.ejb.general.performanceCounter.PerformanceCounterResult;
import de.proveo.wwt.logic.ejb.general.performanceCounter.UnitEventStatisticsDto;
import de.proveo.wwt.logic.ejb.general.tableMappings.readers.PerformanceCounterAnnotationReader;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.UnitTreeFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.performanceCounter.PerformanceCounterFastLaneBase;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitIdNodeMatcher;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitNodeType;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PerformanceCounterStatisticsBase<E extends Enum<E>>
extends PerformanceCounterFastLaneBase<E> {
    static final Log log = LogFactory.getLog(PerformanceCounterStatisticsBase.class);
    private final long INTERVAL_DURATION;
    private final Object UPDATE_SYNC_OBJECT;
    protected static final String FIND_INITIAL_TIME_STAMP_SQL = "SELECT MIN(%s) FROM %s WHERE %s >= %d";
    protected final String CLEAR_PERFORMANCE_COUNTER_TABLE_SQL;
    protected final String PERFORMANCE_COUNTER_ROW_COUNT_SQL;
    protected final String FILL_DATA_SQL;
    protected final String FIND_MAX_TIMESTAMP;
    protected static final String EVENTS_PER_UNIT_PER_INTERVAL = "SELECT %s, COUNT(*) AS %s FROM %s WHERE %s >= %d AND %s < %d GROUP BY FLOOR(%s / %d), %s";

    protected PerformanceCounterStatisticsBase(Class<E> typeClass) {
        super(typeClass);
        this.typeClass = typeClass;
        this.INTERVAL_DURATION = PerformanceCounterAnnotationReader.getIntervalDuration(typeClass);
        this.UPDATE_SYNC_OBJECT = this.getUpdateSyncObject();
        this.CLEAR_PERFORMANCE_COUNTER_TABLE_SQL = PerformanceCounterStatisticsBase.appendStrings("DELETE FROM ", this.TABLE_NAME);
        this.PERFORMANCE_COUNTER_ROW_COUNT_SQL = PerformanceCounterStatisticsBase.appendStrings("SELECT COUNT(*) FROM ", this.TABLE_NAME);
        this.FILL_DATA_SQL = PerformanceCounterStatisticsBase.appendStrings("INSERT INTO ", this.TABLE_NAME, "(", "timestamp", ", %s) (SELECT FLOOR(%s / 3600000) AS _stamp, COUNT(*) AS _cnt FROM %s WHERE %s >= %d AND %s < %d GROUP BY _stamp) ON DUPLICATE KEY UPDATE %s = VALUES(%s)");
        this.FIND_MAX_TIMESTAMP = PerformanceCounterStatisticsBase.appendStrings("SELECT MAX(", "timestamp", ") FROM ", this.TABLE_NAME);
    }

    protected abstract Object getUpdateSyncObject();

    protected abstract int getLastTimestamp();

    protected abstract void setLastTimestamp(int var1);

    public static <T extends Enum<T>> PerformanceCounterStatisticsBase<T> getInstance(Class<T> typeClass) {
        PerformanceCounterStatisticsBase instance = null;
        try {
            Class<?> pfcClass = PerformanceCounterAnnotationReader.getTypeClass(typeClass);
            Class[] parameters = new Class[]{Class.class};
            Constructor<?> constructor = pfcClass.getDeclaredConstructor(parameters);
            constructor.setAccessible(true);
            instance = (PerformanceCounterStatisticsBase)constructor.newInstance(typeClass);
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return instance;
    }

    private String generateFirstTimeStampSql(Enum<E> tableMapping) {
        String column = PerformanceCounterAnnotationReader.getColumn(tableMapping);
        String table = PerformanceCounterAnnotationReader.getTable(tableMapping);
        return String.format(FIND_INITIAL_TIME_STAMP_SQL, column, table, column, 946681200000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getInitialTimeStamp() {
        log.info((Object)"Looking for initial performance counter timestamp...");
        long initialStamp = Long.MAX_VALUE;
        Connection connection = null;
        try {
            Enum<E>[] mappings;
            connection = this.getConnection();
            for (Enum mapping : mappings = this.getAllTableMappings()) {
                Long value = DatabaseUtil.executeCustomQuery((Connection)connection, (String)this.generateFirstTimeStampSql(mapping), (Long)-1L);
                if (value == null || value == -1L || value >= initialStamp) continue;
                initialStamp = value;
            }
        }
        catch (SQLException e) {
            log.error((Object)"getInitialTimeStamp() runs into", (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        if (initialStamp == Long.MAX_VALUE) {
            initialStamp = -1L;
        }
        return initialStamp;
    }

    private long getPerformanceCounterRowCount(Connection connection) {
        return DatabaseUtil.executeCustomQuery((Connection)connection, (String)this.PERFORMANCE_COUNTER_ROW_COUNT_SQL, (Long)-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(Connection connection, long beginTime, long endTime) {
        Enum<E>[] mappings;
        boolean result = true;
        if (beginTime > endTime) {
            return true;
        }
        int endStamp = this.unixTime2TimeStamp(endTime);
        for (Enum mapping : mappings = this.getAllTableMappings()) {
            Statement statement = null;
            try {
                String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(mapping);
                String column = PerformanceCounterAnnotationReader.getColumn(mapping);
                String table = PerformanceCounterAnnotationReader.getTable(mapping);
                String sql = String.format(this.FILL_DATA_SQL, counterColumn, column, table, column, beginTime, column, this.timeStamp2UnixTime(endStamp + 1), counterColumn, counterColumn);
                statement = connection.createStatement();
                statement.executeUpdate(sql);
            }
            catch (SQLException e) {
                log.error((Object)("Cannot fill rows with data: " + e.getMessage()));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"runs into: ", (Throwable)e);
                }
            }
        }
        return result;
    }

    public void run() {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean update() {
        if (!this.compatible()) {
            log.warn((Object)"Performance counter not available for currently used DBMS");
            return false;
        }
        Object object = this.UPDATE_SYNC_OBJECT;
        synchronized (object) {
            log.info((Object)"Performance counter update...");
            boolean result = true;
            Connection connection = null;
            try {
                int currentStamp;
                connection = this.getConnection();
                if ((long)this.getLastTimestamp() == -1L) {
                    long rowCount = this.getPerformanceCounterRowCount(connection);
                    if (rowCount == 0L) {
                        this.setLastTimestamp(this.unixTime2TimeStamp(this.getInitialTimeStamp()));
                    } else {
                        log.info((Object)"Looking for latest timestamp...");
                        Long startStamp = DatabaseUtil.executeCustomQuery((Connection)connection, (String)this.FIND_MAX_TIMESTAMP, (Long)-1L);
                        if (startStamp != null) {
                            Long l = startStamp;
                            Long l2 = startStamp = Long.valueOf(startStamp + 1L);
                        }
                        if ((long)this.getLastTimestamp() == -1L && startStamp == null) {
                            log.error((Object)"Error retrieving start stamp!");
                            boolean bl = false;
                            return bl;
                        }
                        this.setLastTimestamp(startStamp.intValue());
                    }
                    currentStamp = this.getCurrentTimeStamp();
                } else {
                    currentStamp = this.getCurrentTimeStamp();
                    int lastTimestamp = this.getLastTimestamp();
                    if (lastTimestamp >= currentStamp) {
                        log.info((Object)"Performance counter entries are already up to date");
                        boolean bl = true;
                        return bl;
                    }
                    this.setLastTimestamp(++lastTimestamp);
                }
                if ((long)this.getLastTimestamp() != -1L) {
                    String msg = StringUtil.appendStrings((String[])new String[]{"Updating ", this.TABLE_NAME, " now..."});
                    log.info((Object)msg);
                    Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "updatePerformanceCounterTable");
                    stopwatch.start("Overall");
                    this.insert(connection, this.timeStamp2UnixTime(this.getLastTimestamp()), this.timeStamp2UnixTime(currentStamp));
                    this.setLastTimestamp(currentStamp);
                    stopwatch.stop("Overall", true);
                } else {
                    log.info((Object)"No valid timestamp found. Skipping update.");
                }
                log.info((Object)"Performance Counter table update complete!");
            }
            catch (SQLException e) {
                log.error((Object)("Error updating performance counter table: " + e.getMessage()));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"runs into: ", (Throwable)e);
                }
            }
            return result;
        }
    }

    public PerformanceCounterResult<E> getEventStatistics(long beginTime, long endTime, PerformanceCounterInterval interval) {
        return this.getEventStatistics(beginTime, endTime, interval, this.getAllTableMappings());
    }

    public PerformanceCounterResult<E> getEventStatistics(long beginTime, long endTime, PerformanceCounterInterval interval, Enum<E>[] columnIds) {
        long intervalMillis = 3600000L;
        switch (interval) {
            case Second: {
                intervalMillis = 1000L;
                break;
            }
            case Minute: {
                intervalMillis = 60000L;
                break;
            }
            case Hour: {
                intervalMillis = 3600000L;
                break;
            }
            case Day: {
                intervalMillis = 86400000L;
            }
        }
        return this.getEventStatistics(beginTime, endTime, intervalMillis, columnIds, (Long)null);
    }

    public PerformanceCounterResult<E> getEventStatistics(long beginTime, long endTime, int loadFactor) {
        return this.getEventStatistics(beginTime, endTime, loadFactor, this.getAllTableMappings(), (Long)null);
    }

    public PerformanceCounterResult<E> getEventStatistics(long beginTime, long endTime, int loadFactor, Long unitId) {
        return this.getEventStatistics(beginTime, endTime, loadFactor, this.getAllTableMappings(), unitId);
    }

    public PerformanceCounterResult<E> getEventStatistics(long beginTime, long endTime, int loadFactor, Enum<E>[] columnIds) {
        return this.getEventStatistics(beginTime, endTime, loadFactor, columnIds, (Long)null);
    }

    public PerformanceCounterResult<E> getEventStatistics(long beginTime, long endTime, int loadFactor, Enum<E>[] columnIds, Long unitId) {
        long intervalMillis = PerformanceCounterStatisticsBase.intervalMillisFromLoadFactor(beginTime, endTime, loadFactor);
        return this.getEventStatistics(beginTime, endTime, intervalMillis, columnIds, unitId);
    }

    public HashMap<Long, PerformanceCounterResult<E>> getEventStatistics(long beginTime, long endTime, int loadFactor, long[] unitIds) {
        return this.getEventStatistics(beginTime, endTime, loadFactor, this.getAllTableMappings(), unitIds);
    }

    public HashMap<Long, PerformanceCounterResult<E>> getEventStatistics(long beginTime, long endTime, int loadFactor, Enum<E>[] columnIds, long[] unitIds) {
        return this.getEventStatistics(beginTime, endTime, PerformanceCounterStatisticsBase.intervalMillisFromLoadFactor(beginTime, endTime, loadFactor), columnIds, unitIds);
    }

    public HashMap<Long, PerformanceCounterResult<E>> getEventStatistics(long beginTime, long endTime, long intervalMillis, Enum<E>[] columnIds, long[] unitIds) {
        HashMap<Long, PerformanceCounterResult<E>> result = new HashMap<Long, PerformanceCounterResult<E>>();
        for (int i = 0; i != unitIds.length; ++i) {
            long currentUnitId = unitIds[i];
            if (!this.isBasicUnit(currentUnitId)) continue;
            result.put(currentUnitId, this.getEventStatistics(beginTime, endTime, intervalMillis, columnIds, (Long)currentUnitId));
        }
        return result;
    }

    public PerformanceCounterResult<E> getEventStatistics(long beginTime, long endTime, long intervalMillis, Enum<E>[] columnIds, Long unitId) {
        if (!this.compatible()) {
            log.warn((Object)"Performance counter not available for currently used DBMS");
            return null;
        }
        if (beginTime > endTime) {
            log.error((Object)"getEventStatistics(): begin time must not be greater than end time");
            return null;
        }
        if (columnIds == null || columnIds.length == 0) {
            log.error((Object)"getEventStatistics(): no valid column ids specified");
            return null;
        }
        long beginStamp = beginTime / intervalMillis;
        long endStamp = endTime % intervalMillis == 0L ? endTime / intervalMillis : endTime / intervalMillis + 1L;
        return this.retrieveStatisticsData(beginStamp, endStamp, intervalMillis, columnIds, unitId);
    }

    private PerformanceCounterResult<E> retrieveStatisticsData(long beginStamp, long endStamp, long intervalMillis, Enum<E>[] selectedTableMappings, Long unitId) {
        PerformanceCounterResult<E> result = null;
        result = intervalMillis >= this.INTERVAL_DURATION && unitId == null && this.fullyCompatible() && this instanceof Runnable ? this.executeStatisticsQuery(beginStamp, endStamp, intervalMillis, selectedTableMappings) : this.executeCustomStatisticsQuery(beginStamp, endStamp, intervalMillis, selectedTableMappings, unitId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceCounterResult<E> executeCustomStatisticsQuery(long beginStamp, long endStamp, long intervalMillis, Enum<E>[] selectedTableMappings, Long unitId) {
        String[] statements = this.buildCustomStatisticsSql(beginStamp, endStamp, selectedTableMappings, intervalMillis, unitId);
        ArrayList<Long> timestampArray = new ArrayList<Long>();
        long endCondition = endStamp * intervalMillis;
        for (long time = beginStamp * intervalMillis; time < endCondition; time += intervalMillis) {
            timestampArray.add(time);
        }
        HashMap<Enum<E>, List<Long>> statisticsMap = new HashMap<Enum<E>, List<Long>>();
        PerformanceCounterResult result = null;
        Connection connection = null;
        Statement statement = null;
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "executeCustomStatisticsQuery");
        stopwatch.start("Overall");
        try {
            for (int statementIdx = 0; statementIdx != statements.length; ++statementIdx) {
                connection = this.getConnection();
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                log.debug((Object)statements[statementIdx]);
                ResultSet resultSet = statement.executeQuery(statements[statementIdx]);
                log.debug((Object)"finished");
                List<Long> dataList = this.processCustomStatisticsQuery(intervalMillis, selectedTableMappings[statementIdx], timestampArray, resultSet);
                resultSet.close();
                statisticsMap.put(selectedTableMappings[statementIdx], dataList);
            }
            result = new PerformanceCounterResult(intervalMillis);
            result.timestampRows = timestampArray;
            result.statisticsMap = statisticsMap;
            this.calculateSum(result);
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return result;
    }

    protected List<Long> processCustomStatisticsQuery(long intervalMillis, Enum<E> tableMapping, ArrayList<Long> timestampArray, ResultSet resultSet) throws SQLException {
        int timestampColumnIdx = resultSet.findColumn("timestamp");
        String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(tableMapping);
        int counterColumnIdx = resultSet.findColumn(counterColumn);
        int size = timestampArray.size();
        ArrayList<Long> dataList = new ArrayList<Long>(size);
        long currentDbTimestamp = Long.MAX_VALUE;
        boolean rowAvailable = resultSet.next();
        if (rowAvailable) {
            currentDbTimestamp = (long)resultSet.getInt(timestampColumnIdx) * intervalMillis;
        }
        for (int dataIdx = 0; dataIdx != size; ++dataIdx) {
            long currentTime = timestampArray.get(dataIdx);
            if (currentDbTimestamp < currentTime) {
                currentDbTimestamp = resultSet.next() ? (long)resultSet.getInt(timestampColumnIdx) * intervalMillis : Long.MAX_VALUE;
            }
            if (currentTime == currentDbTimestamp) {
                long eventCount = resultSet.getLong(counterColumnIdx);
                dataList.add(eventCount);
                continue;
            }
            dataList.add(0L);
        }
        return dataList;
    }

    protected void calculateSum(PerformanceCounterResult<E> result) {
        Set keySet = result.statisticsMap.keySet();
        Enum[] enums = keySet.toArray(new Enum[keySet.size()]);
        int size = result.timestampRows.size();
        result.sumRows = new ArrayList<Long>(size);
        result.eventSumTotalMap = new HashMap();
        long eventSumTotal = 0L;
        List[] columns = new List[enums.length];
        for (int enumIdx = 0; enumIdx != enums.length; ++enumIdx) {
            List<Long> columnData;
            columns[enumIdx] = columnData = result.statisticsMap.get(enums[enumIdx]);
            long columnSum = 0L;
            for (int i = 0; i != size; ++i) {
                long value = columnData.get(i);
                if (value <= 0L) continue;
                columnSum += value;
            }
            eventSumTotal += columnSum;
            result.eventSumTotalMap.put(enums[enumIdx], columnSum);
        }
        result.eventSumTotal = eventSumTotal;
        for (int i = 0; i != size; ++i) {
            long sum = 0L;
            for (int columnIdx = 0; columnIdx != columns.length; ++columnIdx) {
                long value = (Long)columns[columnIdx].get(i);
                if (value <= 0L) continue;
                sum += value;
            }
            result.sumRows.add(sum);
        }
    }

    protected String[] buildCustomStatisticsSql(long beginStamp, long endStamp, Enum<E>[] selectedTableMappings, long intervalMillis, Long unitId) {
        PerformanceCounterFastLaneBase.QueryType queryType = this.queryType(unitId);
        String[] statements = new String[selectedTableMappings.length];
        for (int i = 0; i != selectedTableMappings.length; ++i) {
            String table = PerformanceCounterAnnotationReader.getTable(selectedTableMappings[i]);
            String column = PerformanceCounterAnnotationReader.getColumn(selectedTableMappings[i]);
            String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(selectedTableMappings[i]);
            String unitIdColumn = PerformanceCounterAnnotationReader.getUnitIdColumn(selectedTableMappings[i]);
            String aggregationSql = PerformanceCounterAnnotationReader.getAggregationSql(selectedTableMappings[i]);
            StringBuilder sb = new StringBuilder("SELECT ");
            StringBuilder sbFloor = new StringBuilder();
            sbFloor.append("FLOOR(h.");
            sbFloor.append(column);
            sbFloor.append(" / ");
            sbFloor.append(String.valueOf(intervalMillis));
            sbFloor.append(")");
            sb.append((CharSequence)sbFloor);
            sb.append(" AS ");
            sb.append("timestamp");
            sb.append(", ");
            sb.append(aggregationSql);
            sb.append(" AS ");
            sb.append(counterColumn);
            sb.append(" FROM ");
            sb.append(table);
            sb.append(" h ");
            sb.append(" WHERE h.");
            sb.append(column);
            sb.append(" >= ");
            sb.append(String.valueOf(beginStamp * intervalMillis));
            sb.append(" AND h.");
            sb.append(column);
            sb.append(" < ");
            sb.append(String.valueOf(endStamp * intervalMillis));
            String whereClause = PerformanceCounterAnnotationReader.getWhereClause(selectedTableMappings[i]);
            if (whereClause != null && !whereClause.isEmpty()) {
                sb.append(" AND ");
                sb.append(whereClause.replaceAll("\\{table\\}", "h"));
            }
            if (queryType == PerformanceCounterFastLaneBase.QueryType.Unit && !unitIdColumn.isEmpty()) {
                sb.append(" AND h.");
                sb.append(unitIdColumn);
                sb.append(" = ");
                sb.append(String.valueOf(unitId));
            }
            if (queryType == PerformanceCounterFastLaneBase.QueryType.Group && !unitIdColumn.isEmpty()) {
                List<UnitTreeNode> basicNodes;
                UnitTreeNode root = new UnitTreeFastLaneReader().buildUnitTree(false, false);
                List nodes = root.getNodes(false, new UnitIdNodeMatcher(unitId));
                UnitTreeNode group = nodes.size() == 1 ? (UnitTreeNode)nodes.get(0) : null;
                List<UnitTreeNode> list = basicNodes = group == null ? null : group.getSubnodes(UnitNodeType.Unit);
                if (basicNodes != null && basicNodes.size() > 0) {
                    sb.append(" AND h.");
                    sb.append(unitIdColumn);
                    sb.append(" IN (");
                    boolean first = true;
                    for (UnitTreeNode basicUnit : basicNodes) {
                        if (!first) {
                            sb.append(",");
                        }
                        sb.append(String.valueOf(((UnitDTO)basicUnit.getData()).getUnitId()));
                        first = false;
                    }
                    sb.append(")");
                }
            }
            sb.append(" GROUP BY ");
            sb.append((CharSequence)sbFloor);
            sb.append(" ORDER BY ");
            sb.append((CharSequence)sbFloor);
            statements[i] = sb.toString();
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceCounterResult<E> executeStatisticsQuery(long beginStamp, long endStamp, long intervalMillis, Enum<E>[] selectedTableMappings) {
        PerformanceCounterResult result = null;
        String sql = this.buildStatisticsSql(beginStamp, endStamp, intervalMillis, selectedTableMappings);
        Connection connection = null;
        Statement statement = null;
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "executeStatisticsQuery");
        stopwatch.start("Overall");
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            int timestampColumnIdx = resultSet.findColumn("timestamp");
            HashMap<Enum<E>, Integer> counterColumnMap = new HashMap<Enum<E>, Integer>();
            long currentTime = beginStamp * intervalMillis;
            long endTime = endStamp * intervalMillis;
            HashMap<Enum, Long> sumPerEvent = new HashMap<Enum, Long>();
            HashMap statisticsMap = new HashMap();
            for (int i = 0; i != selectedTableMappings.length; ++i) {
                Enum<E> currentEnumValue = selectedTableMappings[i];
                sumPerEvent.put(currentEnumValue, 0L);
                statisticsMap.put(currentEnumValue, new ArrayList());
                String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(selectedTableMappings[i]);
                counterColumnMap.put(currentEnumValue, resultSet.findColumn(counterColumn));
            }
            Collection dataCollection = statisticsMap.values();
            Set dataSet = statisticsMap.entrySet();
            ArrayList<Long> rowSumArray = new ArrayList<Long>();
            ArrayList<Long> timestampArray = new ArrayList<Long>();
            long currentDbTimestamp = Long.MAX_VALUE;
            boolean rowAvailable = resultSet.next();
            if (rowAvailable) {
                currentDbTimestamp = (long)resultSet.getInt(timestampColumnIdx) * intervalMillis;
            }
            long sumTotal = 0L;
            while (currentTime <= endTime) {
                timestampArray.add(currentTime);
                if (currentDbTimestamp < currentTime) {
                    currentDbTimestamp = resultSet.next() ? (long)resultSet.getInt(timestampColumnIdx) * intervalMillis : Long.MAX_VALUE;
                }
                if (currentTime == currentDbTimestamp) {
                    long sum = 0L;
                    for (Map.Entry entry : dataSet) {
                        Enum currentId = (Enum)entry.getKey();
                        long value = resultSet.getLong((Integer)counterColumnMap.get(currentId));
                        ((List)entry.getValue()).add(value);
                        sum += value;
                        Long tempSum = (Long)sumPerEvent.get(currentId);
                        tempSum = tempSum + value;
                        sumPerEvent.put(currentId, tempSum);
                    }
                    rowSumArray.add(sum);
                    sumTotal += sum;
                } else {
                    for (List array : dataCollection) {
                        array.add(0L);
                    }
                    rowSumArray.add(0L);
                }
                currentTime += intervalMillis;
            }
            resultSet.close();
            result = new PerformanceCounterResult(intervalMillis);
            result.sumRows = rowSumArray;
            result.timestampRows = timestampArray;
            result.statisticsMap = statisticsMap;
            result.eventSumTotal = sumTotal;
            result.eventSumTotalMap = sumPerEvent;
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return result;
    }

    private String buildStatisticsSql(long beginStamp, long endStamp, long intervalMillis, Enum<E>[] selectedTableMappings) {
        StringBuilder sb = new StringBuilder("SELECT ");
        for (int i = 0; i != selectedTableMappings.length; ++i) {
            String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(selectedTableMappings[i]);
            sb.append("SUM(");
            sb.append(counterColumn);
            sb.append(") as '");
            sb.append(counterColumn);
            sb.append("', ");
        }
        long factor = intervalMillis / this.INTERVAL_DURATION;
        String strFactor = String.valueOf(factor);
        sb.append("FLOOR(");
        sb.append("timestamp");
        sb.append(" / ");
        sb.append(strFactor);
        sb.append(") as ");
        sb.append("timestamp");
        sb.append(" FROM ");
        sb.append(this.TABLE_NAME);
        sb.append(" WHERE ");
        sb.append("timestamp");
        sb.append(" >= ");
        sb.append(String.valueOf(beginStamp * factor));
        sb.append(" AND ");
        sb.append("timestamp");
        sb.append(" <= ");
        sb.append(String.valueOf(endStamp * factor + (factor - 1L)));
        sb.append(" GROUP BY FLOOR(");
        sb.append("timestamp");
        sb.append(" / ");
        sb.append(strFactor);
        sb.append(") ORDER BY ");
        sb.append("timestamp");
        return sb.toString();
    }

    public PerformanceCounterIntervalResult<E> getIntervalStatistics(long timestamp, long interval) {
        return this.getIntervalStatistics(timestamp, interval, this.getAllTableMappings());
    }

    public PerformanceCounterIntervalResult<E> getIntervalStatistics(long timestamp, long interval, Enum<E>[] columnIds) {
        if (!this.compatible()) {
            log.warn((Object)"Performance counter not available for currently used DBMS");
            return null;
        }
        if (timestamp <= 0L) {
            log.error((Object)"getIntervalStatistics(): timestamp must be greater than zero");
            return null;
        }
        if (interval <= 0L) {
            log.error((Object)"getIntervalStatistics(): interval must be greater than zero");
            return null;
        }
        if (columnIds == null || columnIds.length == 0) {
            log.error((Object)"getIntervalStatistics(): no valid column ids specified");
            return null;
        }
        HashMap unitEventMap = new HashMap();
        HashMap eventSumTotal = new HashMap();
        long totalEvents = 0L;
        for (Enum<E> tableMapping : columnIds) {
            UnitStatisticsResult usr = this.executeIntervalStatisticsQuery(timestamp, interval, tableMapping);
            if (usr == null) {
                log.error((Object)("getIntervalStatistics(): cannot retrieve statistics data for " + tableMapping.name()));
                continue;
            }
            unitEventMap.put(tableMapping, usr.eventList);
            eventSumTotal.put(tableMapping, usr.eventSum);
            totalEvents += usr.eventSum;
        }
        return new PerformanceCounterIntervalResult(timestamp, interval, unitEventMap, eventSumTotal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnitStatisticsResult executeIntervalStatisticsQuery(long timestamp, long interval, Enum<E> tableMapping) {
        String table = PerformanceCounterAnnotationReader.getTable(tableMapping);
        String column = PerformanceCounterAnnotationReader.getColumn(tableMapping);
        String counterColumn = PerformanceCounterAnnotationReader.getCounterColumn(tableMapping);
        String unitIdColumn = PerformanceCounterAnnotationReader.getUnitIdColumn(tableMapping);
        String sql = String.format(EVENTS_PER_UNIT_PER_INTERVAL, unitIdColumn, counterColumn, table, column, timestamp, column, timestamp + interval, column, interval, unitIdColumn);
        UnitStatisticsResult result = null;
        Connection connection = null;
        Statement statement = null;
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "executeIntervalStatisticsQuery");
        stopwatch.start("Overall");
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            int unitColumnIdx = resultSet.findColumn(unitIdColumn);
            int countColumnIdx = resultSet.findColumn(counterColumn);
            ArrayList<UnitEventStatisticsDto> dtoList = new ArrayList<UnitEventStatisticsDto>();
            long eventSum = 0L;
            while (resultSet.next()) {
                UnitEventStatisticsDto dto = new UnitEventStatisticsDto();
                dto.unitId = resultSet.getLong(unitColumnIdx);
                dto.eventCount = resultSet.getLong(countColumnIdx);
                dtoList.add(dto);
                eventSum += dto.eventCount;
            }
            resultSet.close();
            int size = dtoList.size();
            float eventSumFloat = eventSum;
            for (int i = 0; i != size; ++i) {
                UnitEventStatisticsDto currentDto = (UnitEventStatisticsDto)dtoList.get(i);
                currentDto.percent = (float)currentDto.eventCount / eventSumFloat;
            }
            result = new UnitStatisticsResult(dtoList, eventSum);
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        return result;
    }

    protected int getCurrentTimeStamp() {
        return this.unixTime2TimeStamp(System.currentTimeMillis()) - 1;
    }

    protected int unixTime2TimeStamp(long unixTime) {
        return unixTime == -1L ? -1 : (int)(unixTime / this.INTERVAL_DURATION);
    }

    protected long timeStamp2UnixTime(int timeStamp) {
        return timeStamp == -1 ? -1L : (long)timeStamp * this.INTERVAL_DURATION;
    }

    protected class UnitStatisticsResult {
        public List<UnitEventStatisticsDto> eventList;
        public long eventSum;

        public UnitStatisticsResult() {
        }

        public UnitStatisticsResult(List<UnitEventStatisticsDto> eventList, long eventSum) {
            this.eventList = eventList;
            this.eventSum = eventSum;
        }
    }
}

