/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.EventReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.NotifyDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class NotificationFastLaneReader
extends EventReportFastLaneReader<NotificationDTO, NotifyDefinitions> {
    protected Long messageId;

    public NotificationFastLaneReader() {
        super(new NotifyDefinitions());
    }

    protected void init(Long messageId, DTOListBase<NotificationDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order, extendedData);
        this.messageId = messageId;
    }

    public void getHistory(DTOListBase<NotificationDTO> list, Long unitId, Long messageId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        this.init(messageId, list, selectionDTO, FastLaneReaderOrder.ByNothing, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getHistory(DTOListBase<NotificationDTO> list, ReportSelectionDTO selectionDTO, Long messageId, ExtendedDTOData ... extendedData) {
        this.init(messageId, list, selectionDTO, FastLaneReaderOrder.ByNothing, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        Column[] columnArray = new Column[2];
        NotifyDefinitions cfr_ignored_0 = (NotifyDefinitions)this.getDefinitions();
        columnArray[0] = NotifyDefinitions.col_History_MessageId;
        NotifyDefinitions cfr_ignored_1 = (NotifyDefinitions)this.getDefinitions();
        columnArray[1] = NotifyDefinitions.col_History_Remark;
        this.historyQuery.addColumns(columnArray);
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        Column[] columnArray = new Column[2];
        NotifyDefinitions cfr_ignored_0 = (NotifyDefinitions)this.getDefinitions();
        columnArray[0] = NotifyDefinitions.col_Cache_MessageId;
        NotifyDefinitions cfr_ignored_1 = (NotifyDefinitions)this.getDefinitions();
        columnArray[1] = NotifyDefinitions.col_Cache_Remark;
        this.cacheQuery.addColumns(columnArray);
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        return 0;
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((NotifyDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((NotifyDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_createTime = resultSet.findColumn(((NotifyDefinitions)this.getDefinitions()).getHistoryCreateTimeColumn().getName());
        int idx_receiveTime = resultSet.findColumn(((NotifyDefinitions)this.getDefinitions()).getHistoryReceiveTimeColumn().getName());
        NotifyDefinitions cfr_ignored_0 = (NotifyDefinitions)this.getDefinitions();
        int idx_messageId = resultSet.findColumn(NotifyDefinitions.col_History_MessageId.getName());
        NotifyDefinitions cfr_ignored_1 = (NotifyDefinitions)this.getDefinitions();
        int idx_remark = resultSet.findColumn(NotifyDefinitions.col_History_Remark.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            long createTime = resultSet.getLong(idx_createTime);
            long receiveTime = resultSet.getLong(idx_receiveTime);
            long messageId = resultSet.getLong(idx_messageId);
            String remark = resultSet.getString(idx_remark);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            if (this.messageId != null && !this.messageId.equals(messageId)) continue;
            NotificationDTO dto = DTOFactory.buildNotificationDTO(id, createTime, receiveTime, messageId, remark, unitDTO);
            this.addExtendedData(false, resultSet, dto, new ExtendedDTOData[0]);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }
}

