/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class MeasurementBaseFastlaneReader
extends FastLaneReader {
    private static final String MEASUREMENT_TYPE_SQL = "SELECT mt.id, mt.name FROM measurement_type mt";
    private static final String MEASUREMENT_DEF_SQL = "SELECT md.id, md.name, md.min_value, md.max_value, md.custom_format_pattern, md.measurement_unit_id FROM measurement_defn md";
    private static final String MEASUREMENT_INTERVAL_SQL = "SELECT md.id, md.name, md.description, md.threshold, md.threshold_duration_min, md.threshold_duration_max, md.enabled, md.measurement_defn_id FROM measurement_interval_defn md";
    private static final String MEASUREMENT_UNIT_SQL = "SELECT * FROM measurement_unit mu";
    protected Map<Integer, MeasurementType> mTypeMap;
    protected Map<Integer, MeasurementDefinition> mDefinitionMap;
    protected Map<Integer, MeasurementIntervalDefn> mIntervalDefinitionMap;
    protected Map<Integer, MeasurementUnit> mUnitMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, MeasurementUnit> getMeasurementUnitsMap() {
        if (this.mUnitMap != null) {
            return this.mUnitMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Integer, MeasurementUnit> measurementUnitMap = new HashMap<Integer, MeasurementUnit>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(MEASUREMENT_UNIT_SQL);
            while (resultSet.next()) {
                MeasurementUnit measurementUnit = new MeasurementUnit();
                measurementUnit.setId(resultSet.getInt("id"));
                measurementUnit.setName(resultSet.getString("name"));
                measurementUnit.setFormatPattern(resultSet.getString("format_pattern"));
                measurementUnit.setMeasurementTypeId(resultSet.getInt("measurement_type_id"));
                measurementUnitMap.put(measurementUnit.getId(), measurementUnit);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.mUnitMap = measurementUnitMap;
        return this.mUnitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, MeasurementType> getMeasurementTypesMap() {
        if (this.mTypeMap != null) {
            return this.mTypeMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Integer, MeasurementType> measurementTypeMap = new HashMap<Integer, MeasurementType>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(MEASUREMENT_TYPE_SQL);
            while (resultSet.next()) {
                MeasurementType measurementType = new MeasurementType();
                measurementType.setId(resultSet.getInt("id"));
                measurementType.setName("name");
                measurementTypeMap.put(measurementType.getId(), measurementType);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.mTypeMap = measurementTypeMap;
        return this.mTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, MeasurementDefinition> getMeasurementDefinitionsMap() {
        if (this.mDefinitionMap != null) {
            return this.mDefinitionMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Integer, MeasurementDefinition> measurementDefinitionMap = new HashMap<Integer, MeasurementDefinition>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(MEASUREMENT_DEF_SQL);
            while (resultSet.next()) {
                MeasurementDefinition measurementDefinition = new MeasurementDefinition();
                measurementDefinition.setId(resultSet.getInt("id"));
                measurementDefinition.setName(resultSet.getString("name"));
                measurementDefinition.setMinValue(Float.valueOf(resultSet.getFloat("min_value")));
                if (resultSet.wasNull()) {
                    measurementDefinition.setMinValue(null);
                }
                measurementDefinition.setMaxValue(Float.valueOf(resultSet.getFloat("max_value")));
                if (resultSet.wasNull()) {
                    measurementDefinition.setMaxValue(null);
                }
                measurementDefinition.setCustomFormatPattern(resultSet.getString("custom_format_pattern"));
                measurementDefinition.setMeasurementUnitId(resultSet.getInt("measurement_unit_id"));
                measurementDefinitionMap.put(measurementDefinition.getId(), measurementDefinition);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.mDefinitionMap = measurementDefinitionMap;
        return this.mDefinitionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, MeasurementIntervalDefn> getMeasurementIntervalDefinitionsMap() {
        if (this.mIntervalDefinitionMap != null) {
            return this.mIntervalDefinitionMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Integer, MeasurementIntervalDefn> measurementDefinitionMap = new HashMap<Integer, MeasurementIntervalDefn>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(MEASUREMENT_INTERVAL_SQL);
            while (resultSet.next()) {
                MeasurementIntervalDefn mid = new MeasurementIntervalDefn();
                mid.setId(resultSet.getInt("id"));
                mid.setName(resultSet.getString("name"));
                mid.setDescription(resultSet.getString("description"));
                mid.setThreshold(resultSet.getDouble("threshold"));
                if (resultSet.wasNull()) {
                    mid.setThreshold(null);
                }
                mid.setThreshold_duration_min(resultSet.getInt("threshold_duration_min"));
                if (resultSet.wasNull()) {
                    mid.setThreshold_duration_min(null);
                }
                mid.setThreshold_duration_max(resultSet.getInt("threshold_duration_max"));
                if (resultSet.wasNull()) {
                    mid.setThreshold_duration_max(null);
                }
                mid.setEnabled(resultSet.getBoolean("enabled"));
                mid.setMeasurementDefnId(resultSet.getInt("measurement_defn_id"));
                measurementDefinitionMap.put(mid.getId(), mid);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.mIntervalDefinitionMap = measurementDefinitionMap;
        return this.mIntervalDefinitionMap;
    }
}

