/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomCondition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.util.database.DatabaseType;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.base.UnitReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.UseDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.UseUserDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UseReplayFastLaneReader
extends UnitReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(UseReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<Long, HashMap> getReplayData(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until, ReplayFastLaneBase.DataType dataType) {
        String method = "getReplayData(" + (Object)((Object)dataType) + ")";
        log.debug((Object)(method + " called"));
        Stopwatch stopwatch = new Stopwatch(UseReplayFastLaneReader.class, method);
        stopwatch.start("Overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)(method + ": maxRowLimit=" + maxRowsLimit));
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = null;
                switch (dataType) {
                    case CACHE: {
                        sql = this.generateCacheSqlForReplay(since, until, maxRowsLimit, unitPermissions);
                        break;
                    }
                    case HISTORY: {
                        sql = this.generateHistorySqlForReplay(since, until, maxRowsLimit);
                        break;
                    }
                    default: {
                        log.error((Object)("Unkown data type: " + (Object)((Object)dataType) + ". Break!"));
                        TreeMap<Long, HashMap> treeMap = retMap;
                        return treeMap;
                    }
                }
                log.debug((Object)(method + ": Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)(method + ": building Maps..."));
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)(method + ": Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long unitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(unitId)) continue;
                    long useBeginTime = resultSet.getLong("BEGIN_TIME");
                    long useBeginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
                    switch (dataType) {
                        case HISTORY: {
                            HashMap valueMapLogin;
                            long useEndTime = resultSet.getLong("END_TIME");
                            long useEndReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
                            if (useBeginTime > since) {
                                while (completeReplayDataMap.containsKey(useBeginTime)) {
                                    ++useBeginTime;
                                }
                                valueMapLogin = this.generateReplayValueMap(unitId, Boolean.TRUE, useBeginTime, useBeginReceiveTime, resultSet);
                                completeReplayDataMap.put(useBeginTime, valueMapLogin);
                                retMap.put(useBeginTime, valueMapLogin);
                            }
                            if (useEndTime > until) break;
                            while (completeReplayDataMap.containsKey(useEndTime)) {
                                ++useEndTime;
                            }
                            HashMap valueMapLogout = this.generateReplayValueMap(unitId, Boolean.FALSE, useEndTime, useEndReceiveTime, resultSet);
                            completeReplayDataMap.put(useEndTime, valueMapLogout);
                            retMap.put(useEndTime, valueMapLogout);
                            break;
                        }
                        case CACHE: {
                            while (completeReplayDataMap.containsKey(useBeginTime)) {
                                ++useBeginTime;
                            }
                            HashMap valueMapLogin = this.generateReplayValueMap(unitId, Boolean.TRUE, useBeginTime, useBeginReceiveTime, resultSet);
                            completeReplayDataMap.put(useBeginTime, valueMapLogin);
                            retMap.put(useBeginTime, valueMapLogin);
                        }
                    }
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)(method + ": runs into"), (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getCacheInitialForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getCacheInitialForReplay()";
        log.debug((Object)"getCacheInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(UseReplayFastLaneReader.class, "getCacheInitialForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getCacheInitialForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getCacheInitialForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("getCacheInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getCacheInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long unitId = resultSet.getLong("UNIT_ID");
                    long useBeginTime = resultSet.getLong("BEGIN_TIME");
                    long useReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
                    HashMap valueMap = this.generateReplayValueMap(unitId, Boolean.TRUE, useBeginTime, useReceiveTime, resultSet);
                    retMap.put(unitId, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getHistoryInitialForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getHistoryInitialForReplay()";
        log.debug((Object)"getHistoryInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(UseReplayFastLaneReader.class, "getHistoryInitialForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getHistoryInitialForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (connection != null) {
                String sql = this.generateHistoryInitialSqlForReplay(since, maxRowsLimit);
                log.debug((Object)("getHistoryInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                connection = this.getConnection();
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getHistoryInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getHistoryInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long unitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(unitId)) continue;
                    long useBeginTime = resultSet.getLong("BEGIN_TIME");
                    long useBeginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
                    long useEndTime = resultSet.getLong("END_TIME");
                    long useEndReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
                    Boolean login = Boolean.FALSE;
                    long timestamp = useEndTime;
                    long receiveTime = useEndReceiveTime;
                    if (useEndTime > since) {
                        login = Boolean.TRUE;
                        timestamp = useBeginTime;
                        receiveTime = useBeginReceiveTime;
                    }
                    HashMap valueMap = this.generateReplayValueMap(unitId, login, timestamp, receiveTime, resultSet);
                    retMap.put(unitId, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getHistoryInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    private HashMap generateReplayValueMap(long unitId, Boolean login, long timestamp, long receiveTime, ResultSet resultSet) throws SQLException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        String useUserKey = resultSet.getString("KEY_ID");
        String useUserName = resultSet.getString("NAME");
        String usePersonalNumber = resultSet.getString("PERSONAL_NUMBER");
        if (login == null) {
            login = Boolean.FALSE;
        }
        valueMap.put("EventType", "UseEvent");
        valueMap.put("UnitId", unitId);
        valueMap.put("UseEventUserKey", useUserKey);
        valueMap.put("UseEventDriverName", useUserName);
        valueMap.put("UseEventPersonalNumber", usePersonalNumber);
        valueMap.put("UseEventTimestamp", timestamp);
        valueMap.put("UseEventReceiveTime", receiveTime);
        valueMap.put("UseEventLogin", login);
        valueMap.put("ServerTime", timestamp);
        return valueMap;
    }

    private String generateCacheSqlForReplay(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{UseDefinitions.col_Cache_UnitId, UseDefinitions.col_Cache_UseUserId, UseDefinitions.col_Cache_BeginTime, UseDefinitions.col_Cache_BeginReceiveTime, UseUserDefinitions.col_UseUser_Name, UseUserDefinitions.col_UseUser_PersonalNumber, UseUserDefinitions.col_UseUser_KeyId});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseDefinitions.tbl_Cache, (Table)UseUserDefinitions.tbl_UseUser, (Column)UseDefinitions.col_Cache_UseUserId, (Column)UseUserDefinitions.col_UseUser_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)UseDefinitions.col_Cache_BeginTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_Cache_BeginTime, (Object)until));
        whereCondition.addCondition((Condition)new InCondition((Object)UseDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateCacheInitialSqlForReplay(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{UseDefinitions.col_Cache_UnitId, UseDefinitions.col_Cache_UseUserId, UseDefinitions.col_Cache_BeginTime, UseDefinitions.col_Cache_BeginReceiveTime, UseUserDefinitions.col_UseUser_Name, UseUserDefinitions.col_UseUser_PersonalNumber, UseUserDefinitions.col_UseUser_KeyId});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseDefinitions.tbl_Cache, (Table)UseUserDefinitions.tbl_UseUser, (Column)UseDefinitions.col_Cache_UseUserId, (Column)UseUserDefinitions.col_UseUser_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_Cache_BeginTime, (Object)since));
        whereCondition.addCondition((Condition)new InCondition((Object)UseDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)UseDefinitions.col_Cache_BeginTime, OrderObject.Dir.DESCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistorySqlForReplay(long since, long until, int maxRowsLimit) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{UseDefinitions.col_History_UnitId, UseDefinitions.col_History_UseUserId, UseDefinitions.col_History_BeginTime, UseDefinitions.col_History_BeginReceiveTime, UseDefinitions.col_History_EndTime, UseDefinitions.col_History_EndReceiveTime, UseUserDefinitions.col_UseUser_Name, UseUserDefinitions.col_UseUser_PersonalNumber, UseUserDefinitions.col_UseUser_KeyId});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseDefinitions.tbl_HistoryHelper, (Table)UseDefinitions.tbl_History, (Column)UseDefinitions.col_HistoryHelper_Id, (Column)UseDefinitions.col_History_Id);
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseDefinitions.tbl_History, (Table)UseUserDefinitions.tbl_UseUser, (Column)UseDefinitions.col_History_UseUserId, (Column)UseUserDefinitions.col_UseUser_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_HistoryHelper_DayStamp, (Object)(until / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)UseDefinitions.col_History_BeginTime, (Object)until));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_History_EndTime, (Object)since));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)UseDefinitions.col_History_BeginTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistoryInitialSqlForReplay(long since, int maxRowsLimit) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{UseDefinitions.col_History_UnitId, UseDefinitions.col_History_UseUserId, UseDefinitions.col_History_BeginTime, UseDefinitions.col_History_BeginReceiveTime, UseDefinitions.col_History_EndTime, UseDefinitions.col_History_EndReceiveTime, UseUserDefinitions.col_UseUser_Name, UseUserDefinitions.col_UseUser_PersonalNumber, UseUserDefinitions.col_UseUser_KeyId});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseDefinitions.tbl_HistoryHelper, (Table)UseDefinitions.tbl_History, (Column)UseDefinitions.col_HistoryHelper_Id, (Column)UseDefinitions.col_History_Id);
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)UseDefinitions.tbl_History, (Table)UseUserDefinitions.tbl_UseUser, (Column)UseDefinitions.col_History_UseUserId, (Column)UseUserDefinitions.col_UseUser_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_History_BeginTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)UseDefinitions.col_History_EndTime, (Object)since));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)UseDefinitions.col_History_BeginTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }
}

