/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.base.UnitReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.StateDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateReplayFastLaneReader
extends UnitReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(StateReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<Long, HashMap> getReplayData(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until, ReplayFastLaneBase.DataType dataType) {
        String method = "getReplayData(" + (Object)((Object)dataType) + ")";
        log.debug((Object)(method + " called"));
        Stopwatch stopwatch = new Stopwatch(StateReplayFastLaneReader.class, method);
        stopwatch.start("Overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)(method + ": No permissions, break."));
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = null;
                switch (dataType) {
                    case CACHE: {
                        sql = this.generateCacheSqlForReplay(since, until, unitPermissions);
                        break;
                    }
                    case HISTORY: {
                        sql = this.generateHistorySqlForReplay(since, until);
                        break;
                    }
                    default: {
                        log.error((Object)("Unkown data type: " + (Object)((Object)dataType) + ". Break!"));
                        TreeMap<Long, HashMap> treeMap = retMap;
                        return treeMap;
                    }
                }
                log.debug((Object)(method + ": Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                log.debug((Object)(method + ": building Maps..."));
                stopwatch.start("Build DTO");
                while (resultSet.next()) {
                    long unitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(unitId)) continue;
                    long beginTime = resultSet.getLong("BEGIN_TIME");
                    while (completeReplayDataMap.containsKey(beginTime)) {
                        ++beginTime;
                    }
                    HashMap valueMap = this.generateValueMapForReplay(unitId, beginTime, resultSet);
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", beginTime);
                    completeReplayDataMap.put(beginTime, valueMap);
                    retMap.put(beginTime, valueMap);
                    ++dataSize;
                }
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)(method + ": runs into"), (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap<Long, HashMap>> getCacheInitialForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getCacheInitialForReplay()";
        log.debug((Object)"getCacheInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(StateReplayFastLaneReader.class, "getCacheInitialForReplay()");
        stopwatch.start("Overall");
        HashMap<Long, HashMap<Long, HashMap>> retMap = new HashMap<Long, HashMap<Long, HashMap>>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getCacheInitialForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(since, unitPermissions);
                log.debug((Object)("getCacheInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                while (resultSet.next()) {
                    HashMap<Object, Object> stateMap;
                    long beginTime;
                    long unitId = resultSet.getLong("UNIT_ID");
                    HashMap valueMap = this.generateValueMapForReplay(unitId, beginTime = resultSet.getLong("BEGIN_TIME"), resultSet);
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", beginTime);
                    long stateModelId = resultSet.getLong("STATE_MODEL_ID");
                    if (!retMap.containsKey(unitId)) {
                        stateMap = new HashMap<Long, HashMap>();
                        stateMap.put(stateModelId, valueMap);
                        retMap.put(unitId, stateMap);
                    } else {
                        HashMap stateModelMap;
                        long currentBeginTime;
                        stateMap = retMap.get(unitId);
                        if (stateMap.containsKey(stateModelId) && (currentBeginTime = ((Long)(stateModelMap = (HashMap)stateMap.get(stateModelId)).get("ServerTime")).longValue()) > beginTime) continue;
                        stateMap.put(stateModelId, valueMap);
                        retMap.put(unitId, stateMap);
                    }
                    ++dataSize;
                }
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    private HashMap generateValueMapForReplay(long unitId, long beginTime, ResultSet resultSet) throws SQLException {
        long stateId = resultSet.getLong("STATE_ID");
        long stateModelId = resultSet.getLong("STATE_MODEL_ID");
        String remark = resultSet.getString("REMARK");
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "StateEvent");
        valueMap.put("UnitId", unitId);
        valueMap.put("StateModelID", stateModelId);
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        stateMap.put("StateId", stateId);
        stateMap.put("StateBegin", beginTime);
        stateMap.put("StateRemark", remark);
        valueMap.put("StateModel_" + stateModelId, stateMap);
        return valueMap;
    }

    private String generateCacheSqlForReplay(long since, long until, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{StateDefinitions.col_Cache_UnitId, StateDefinitions.col_Cache_StateId, StateDefinitions.col_Cache_StateModelId, StateDefinitions.col_Cache_BeginTime, StateDefinitions.col_Cache_BeginReceiveTime, StateDefinitions.col_Cache_Remark});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)StateDefinitions.col_Cache_BeginTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)StateDefinitions.col_Cache_BeginTime, (Object)until));
        whereCondition.addCondition((Condition)new InCondition((Object)StateDefinitions.col_Cache_UnitId, unitPermissions));
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        return sql;
    }

    private String generateHistorySqlForReplay(long since, long until) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{StateDefinitions.col_History_UnitId, StateDefinitions.col_History_StateId, StateDefinitions.col_History_StateModelId, StateDefinitions.col_History_BeginTime, StateDefinitions.col_History_Remark});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)StateDefinitions.tbl_HistoryHelper, (Table)StateDefinitions.tbl_History, (Column)StateDefinitions.col_HistoryHelper_Id, (Column)StateDefinitions.col_History_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)StateDefinitions.col_HistoryHelper_DayStamp, (Object)(until / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)StateDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)StateDefinitions.col_History_BeginTime, (Object)until));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)StateDefinitions.col_History_EndTime, (Object)since));
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)StateDefinitions.col_History_BeginTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        return sql;
    }

    private String generateCacheInitialSqlForReplay(long since, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{StateDefinitions.col_Cache_UnitId, StateDefinitions.col_Cache_StateId, StateDefinitions.col_Cache_StateModelId, StateDefinitions.col_Cache_BeginTime, StateDefinitions.col_Cache_Remark});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)StateDefinitions.col_Cache_BeginTime, (Object)since));
        whereCondition.addCondition((Condition)new InCondition((Object)StateDefinitions.col_Cache_UnitId, unitPermissions));
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        return sql;
    }
}

