/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomCondition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.util.database.DatabaseType;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.base.UnitReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.ScanmanMsgDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScanmanMessageReplayFastLaneReader
extends UnitReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(ScanmanMessageReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<Long, HashMap> getReplayData(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until, ReplayFastLaneBase.DataType dataType) {
        String method = "getReplayData(" + (Object)((Object)dataType) + ")";
        log.debug((Object)(method + " called"));
        Stopwatch stopwatch = new Stopwatch(ScanmanMessageReplayFastLaneReader.class, method);
        stopwatch.start("Overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)(method + ": maxRowLimit=" + maxRowsLimit));
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = null;
                switch (dataType) {
                    case CACHE: {
                        sql = this.generateCacheSqlForReplay(since, until, maxRowsLimit, unitPermissions);
                        break;
                    }
                    case HISTORY: {
                        sql = this.generateHistorySqlForReplay(since, until, maxRowsLimit);
                        break;
                    }
                    default: {
                        log.error((Object)("Unkown data type: " + (Object)((Object)dataType) + ". Break!"));
                        TreeMap<Long, HashMap> treeMap = retMap;
                        return treeMap;
                    }
                }
                log.debug((Object)(method + ": Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)(method + ": building Maps..."));
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    int iType;
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)(method + ": Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long iUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(iUnitId) || (iType = resultSet.getInt("TYPE")) != 9 && iType != 25 && iType != 10) continue;
                    String iMessage = resultSet.getString("MESSAGE");
                    long iCreateTime = resultSet.getLong("CREATE_TIME");
                    while (completeReplayDataMap.containsKey(iCreateTime)) {
                        ++iCreateTime;
                    }
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    valueMap.put("EventType", "data_type_infoman_event");
                    valueMap.put("UnitId", iUnitId);
                    if (iType == 9) {
                        valueMap.put("SmErrorTimestamp", iCreateTime);
                        valueMap.put("SmErrorMessage", iMessage);
                    } else if (iType == 25) {
                        valueMap.put("SmBootTimestamp", iCreateTime);
                        valueMap.put("SmBootMessage", iMessage);
                    } else if (iType == 10) {
                        valueMap.put("SmIpTimestamp", iCreateTime);
                        valueMap.put("SmIpMessage", iMessage);
                    }
                    valueMap.put("ServerTime", iCreateTime);
                    completeReplayDataMap.put(iCreateTime, valueMap);
                    retMap.put(iCreateTime, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)(method + ": runs into"), (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getHistoryInitialBootMsgForReplay(HashSet<Long> unitPermissions, long since, long serverInfomanKeepaliveTimeout) {
        String method = "getHistoryInitialBootMsgForReplay()";
        log.debug((Object)"getHistoryInitialBootMsgForReplay() called");
        Stopwatch stopwatch = new Stopwatch(ScanmanMessageReplayFastLaneReader.class, "getHistoryInitialBootMsgForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getHistoryInitialBootMsgForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getHistoryInitialBootMsgForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        unitPermissions = new HashSet<Long>(unitPermissions);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                HashMap<String, Object> valueMap;
                String iMessage;
                long iCreateTime;
                long iUnitId;
                String sql = this.generateHistoryInitialSqlForReplay(since, maxRowsLimit, serverInfomanKeepaliveTimeout, 25);
                log.debug((Object)("getHistoryInitialBootMsgForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getHistoryInitialBootMsgForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                boolean limitExceeded = false;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getHistoryInitialBootMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                        limitExceeded = true;
                        break;
                    }
                    iUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(iUnitId)) continue;
                    iCreateTime = resultSet.getLong("CREATE_TIME");
                    iMessage = resultSet.getString("MESSAGE");
                    valueMap = new HashMap<String, Object>();
                    valueMap.put("EventType", "data_type_infoman_event");
                    valueMap.put("UnitId", iUnitId);
                    valueMap.put("SmBootTimestamp", iCreateTime);
                    valueMap.put("SmBootMessage", iMessage);
                    valueMap.put("ServerTime", iCreateTime);
                    retMap.put(iUnitId, valueMap);
                }
                if (!limitExceeded) {
                    unitPermissions.removeAll(retMap.keySet());
                    if (unitPermissions.size() > 0) {
                        sql = this.generateHistoryInitialSecureSqlForReplay(since, maxRowsLimit, unitPermissions, 25);
                        log.debug((Object)("getHistoryInitialBootMsgForReplay(): Execute SQL: " + sql));
                        stopwatch.start("Database access");
                        resultSet = statement.executeQuery(sql);
                        stopwatch.stop("Database access", true);
                        log.debug((Object)"getHistoryInitialBootMsgForReplay(): building Maps...");
                        rowCounter = 0;
                        while (resultSet.next()) {
                            if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                                log.debug((Object)("getHistoryInitialBootMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                                break;
                            }
                            iUnitId = resultSet.getLong("UNIT_ID");
                            if (!unitPermissions.contains(iUnitId)) continue;
                            iCreateTime = resultSet.getLong("CREATE_TIME");
                            iMessage = resultSet.getString("MESSAGE");
                            valueMap = new HashMap();
                            valueMap.put("EventType", "data_type_infoman_event");
                            valueMap.put("UnitId", iUnitId);
                            valueMap.put("SmBootTimestamp", iCreateTime);
                            valueMap.put("SmBootMessage", iMessage);
                            valueMap.put("ServerTime", iCreateTime);
                            retMap.put(iUnitId, valueMap);
                        }
                    }
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getHistoryInitialBootMsgForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getHistoryInitialIPMsgForReplay(HashSet<Long> unitPermissions, long since, long serverInfomanKeepaliveTimeout) {
        String method = "getHistoryInitialIPMsgForReplay()";
        log.debug((Object)"getHistoryInitialIPMsgForReplay() called");
        Stopwatch stopwatch = new Stopwatch(ScanmanMessageReplayFastLaneReader.class, "getHistoryInitialIPMsgForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getHistoryInitialIPMsgForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getHistoryInitialIPMsgForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        unitPermissions = new HashSet<Long>(unitPermissions);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                HashMap<String, Object> valueMap;
                String iMessage;
                long iCreateTime;
                long iUnitId;
                String sql = this.generateHistoryInitialSqlForReplay(since, maxRowsLimit, serverInfomanKeepaliveTimeout, 10);
                log.debug((Object)("getHistoryInitialIPMsgForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getHistoryInitialIPMsgForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                boolean limitExceeded = false;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getHistoryInitialIPMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                        limitExceeded = true;
                        break;
                    }
                    iUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(iUnitId)) continue;
                    iCreateTime = resultSet.getLong("CREATE_TIME");
                    iMessage = resultSet.getString("MESSAGE");
                    valueMap = new HashMap<String, Object>();
                    valueMap.put("EventType", "data_type_infoman_event");
                    valueMap.put("UnitId", iUnitId);
                    valueMap.put("SmIpTimestamp", iCreateTime);
                    valueMap.put("SmIpMessage", iMessage);
                    valueMap.put("ServerTime", iCreateTime);
                    retMap.put(iUnitId, valueMap);
                }
                if (!limitExceeded) {
                    unitPermissions.removeAll(retMap.keySet());
                    if (unitPermissions.size() > 0) {
                        sql = this.generateHistoryInitialSecureSqlForReplay(since, maxRowsLimit, unitPermissions, 10);
                        log.debug((Object)("getHistoryInitialIPMsgForReplay(): Execute SQL: " + sql));
                        stopwatch.start("Database access");
                        resultSet = statement.executeQuery(sql);
                        stopwatch.stop("Database access", true);
                        log.debug((Object)"getHistoryInitialIPMsgForReplay(): building Maps...");
                        rowCounter = 0;
                        while (resultSet.next()) {
                            if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                                log.debug((Object)("getHistoryInitialIPMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                                break;
                            }
                            iUnitId = resultSet.getLong("UNIT_ID");
                            if (!unitPermissions.contains(iUnitId)) continue;
                            iCreateTime = resultSet.getLong("CREATE_TIME");
                            iMessage = resultSet.getString("MESSAGE");
                            valueMap = new HashMap();
                            valueMap.put("EventType", "data_type_infoman_event");
                            valueMap.put("UnitId", iUnitId);
                            valueMap.put("SmIpTimestamp", iCreateTime);
                            valueMap.put("SmIpMessage", iMessage);
                            valueMap.put("ServerTime", iCreateTime);
                            retMap.put(iUnitId, valueMap);
                        }
                    }
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getHistoryInitialIPMsgForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getHistoryInitialErrorMsgForReplay(HashSet<Long> unitPermissions, long since, long serverInfomanKeepaliveTimeout) {
        String method = "getHistoryInitialErrorMsgForReplay()";
        log.debug((Object)"getHistoryInitialErrorMsgForReplay() called");
        Stopwatch stopwatch = new Stopwatch(ScanmanMessageReplayFastLaneReader.class, "getHistoryInitialErrorMsgForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getHistoryInitialErrorMsgForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getHistoryInitialErrorMsgForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        unitPermissions = new HashSet<Long>(unitPermissions);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                HashMap<String, Object> valueMap;
                String iMessage;
                long iCreateTime;
                long iUnitId;
                String sql = this.generateHistoryInitialSqlForReplay(since, maxRowsLimit, serverInfomanKeepaliveTimeout, 9);
                log.debug((Object)("getHistoryInitialErrorMsgForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getHistoryInitialErrorMsgForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                boolean limitExceeded = false;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("Row limit exceeded: " + maxRowsLimit));
                        limitExceeded = true;
                        break;
                    }
                    iUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(iUnitId)) continue;
                    iCreateTime = resultSet.getLong("CREATE_TIME");
                    iMessage = resultSet.getString("MESSAGE");
                    valueMap = new HashMap<String, Object>();
                    valueMap.put("EventType", "data_type_infoman_event");
                    valueMap.put("UnitId", iUnitId);
                    valueMap.put("SmErrorTimestamp", iCreateTime);
                    valueMap.put("SmErrorMessage", iMessage);
                    valueMap.put("ServerTime", iCreateTime);
                    retMap.put(iUnitId, valueMap);
                }
                if (!limitExceeded) {
                    unitPermissions.removeAll(retMap.keySet());
                    if (unitPermissions.size() > 0) {
                        sql = this.generateHistoryInitialSecureSqlForReplay(since, maxRowsLimit, unitPermissions, 9);
                        log.debug((Object)("getHistoryInitialErrorMsgForReplay(): Execute SQL: " + sql));
                        stopwatch.start("Database access");
                        resultSet = statement.executeQuery(sql);
                        stopwatch.stop("Database access", true);
                        log.debug((Object)"getHistoryInitialErrorMsgForReplay(): building Maps...");
                        rowCounter = 0;
                        while (resultSet.next()) {
                            if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                                log.debug((Object)("getHistoryInitialErrorMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                                break;
                            }
                            iUnitId = resultSet.getLong("UNIT_ID");
                            if (!unitPermissions.contains(iUnitId)) continue;
                            iCreateTime = resultSet.getLong("CREATE_TIME");
                            iMessage = resultSet.getString("MESSAGE");
                            valueMap = new HashMap();
                            valueMap.put("EventType", "data_type_infoman_event");
                            valueMap.put("UnitId", iUnitId);
                            valueMap.put("SmErrorTimestamp", iCreateTime);
                            valueMap.put("SmErrorMessage", iMessage);
                            valueMap.put("ServerTime", iCreateTime);
                            retMap.put(iUnitId, valueMap);
                        }
                    }
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getHistoryInitialErrorMsgForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getCacheInitialBootMsgForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getCacheInitialBootMsgForReplay()";
        log.debug((Object)"getCacheInitialBootMsgForReplay() called");
        Stopwatch stopwatch = new Stopwatch(ScanmanMessageReplayFastLaneReader.class, "getCacheInitialBootMsgForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getCacheInitialBootMsgForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getCacheInitialBootMsgForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(maxRowsLimit, unitPermissions, 25);
                log.debug((Object)("getCacheInitialBootMsgForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialBootMsgForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getCacheInitialBootMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long iUnitId = resultSet.getLong("UNIT_ID");
                    long iCreateTime = resultSet.getLong("CREATE_TIME");
                    String iMessage = resultSet.getString("MESSAGE");
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    if (iCreateTime <= since) {
                        valueMap.put("EventType", "data_type_infoman_event");
                        valueMap.put("UnitId", iUnitId);
                        valueMap.put("SmBootTimestamp", iCreateTime);
                        valueMap.put("SmBootMessage", iMessage);
                        valueMap.put("ServerTime", iCreateTime);
                    }
                    retMap.put(iUnitId, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialBootMsgForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getCacheInitialIPMsgForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getCacheInitialIPMsgForReplay()";
        log.debug((Object)"getCacheInitialIPMsgForReplay() called");
        Stopwatch stopwatch = new Stopwatch(ScanmanMessageReplayFastLaneReader.class, "getCacheInitialIPMsgForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getCacheInitialIPMsgForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getCacheInitialIPMsgForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(maxRowsLimit, unitPermissions, 10);
                log.debug((Object)("getCacheInitialIPMsgForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialIPMsgForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getCacheInitialIPMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long iUnitId = resultSet.getLong("UNIT_ID");
                    long iCreateTime = resultSet.getLong("CREATE_TIME");
                    String iMessage = resultSet.getString("MESSAGE");
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    if (iCreateTime <= since) {
                        valueMap.put("EventType", "data_type_infoman_event");
                        valueMap.put("UnitId", iUnitId);
                        valueMap.put("SmIpTimestamp", iCreateTime);
                        valueMap.put("SmIpMessage", iMessage);
                        valueMap.put("ServerTime", iCreateTime);
                    }
                    retMap.put(iUnitId, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialIPMsgForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getCacheInitialErrorMsgForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getCacheInitialErrorMsgForReplay()";
        log.debug((Object)"getCacheInitialErrorMsgForReplay() called");
        Stopwatch stopwatch = new Stopwatch(ScanmanMessageReplayFastLaneReader.class, "getCacheInitialErrorMsgForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getCacheInitialErrorMsgForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getCacheInitialErrorMsgForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(maxRowsLimit, unitPermissions, 9);
                log.debug((Object)("getCacheInitialErrorMsgForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialErrorMsgForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getCacheInitialErrorMsgForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long iUnitId = resultSet.getLong("UNIT_ID");
                    long iCreateTime = resultSet.getLong("CREATE_TIME");
                    String iMessage = resultSet.getString("MESSAGE");
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    if (iCreateTime <= since) {
                        valueMap.put("EventType", "data_type_infoman_event");
                        valueMap.put("UnitId", iUnitId);
                        valueMap.put("SmErrorTimestamp", iCreateTime);
                        valueMap.put("SmErrorMessage", iMessage);
                        valueMap.put("ServerTime", iCreateTime);
                    }
                    retMap.put(iUnitId, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialErrorMsgForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    private String generateCacheInitialSqlForReplay(int maxRowsLimit, HashSet<Long> unitPermissions, int msgType) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{ScanmanMsgDefinitions.col_Cache_UnitId, ScanmanMsgDefinitions.col_Cache_CreateTime, ScanmanMsgDefinitions.col_Cache_Message});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)ScanmanMsgDefinitions.col_Cache_Type, (Object)msgType));
        whereCondition.addCondition((Condition)new InCondition((Object)ScanmanMsgDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)ScanmanMsgDefinitions.col_Cache_CreateTime, OrderObject.Dir.DESCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistoryInitialSqlForReplay(long since, int maxRowsLimit, long serverInfomanKeepaliveTimeout, int msgType) {
        int keepaliveInDays = (int)((double)serverInfomanKeepaliveTimeout / 60.0 / 24.0 + 0.9999);
        SelectQuery innerQuery = new SelectQuery(true);
        innerQuery.addColumns(new Column[]{ScanmanMsgDefinitions.col_History_UnitId});
        innerQuery.addAliasedColumn((Object)FunctionCall.max().addColumnParams(new Column[]{ScanmanMsgDefinitions.col_History_CreateTime}), "CREATE_TIME");
        innerQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)ScanmanMsgDefinitions.tbl_HistoryHelper, (Table)ScanmanMsgDefinitions.tbl_History, (Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)ScanmanMsgDefinitions.col_HistoryHelper_Id, (Object)ScanmanMsgDefinitions.col_History_Id));
        ComboCondition innerWhereCondition = new ComboCondition(ComboCondition.Op.AND);
        innerWhereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        innerWhereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L - (long)keepaliveInDays)));
        innerWhereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_History_CreateTime, (Object)since));
        innerWhereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)ScanmanMsgDefinitions.col_History_Type, (Object)msgType));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            innerWhereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        innerQuery.addCondition((Condition)innerWhereCondition);
        innerQuery.addGroupings(new Column[]{ScanmanMsgDefinitions.col_History_UnitId});
        innerQuery.addCustomOrdering((Object)ScanmanMsgDefinitions.col_History_CreateTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)innerQuery.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        SelectQuery query = new SelectQuery(true);
        query.addCustomColumns(new Object[]{new CustomSql((Object)"smh.UNIT_ID"), new CustomSql((Object)"smh.CREATE_TIME"), new CustomSql((Object)"smh.MESSAGE")});
        query.addCustomFromTable((Object)new CustomSql((Object)"scanman_msg_history smh"));
        sql = ScanmanMessageReplayFastLaneReader.appendStrings(((SelectQuery)query.validate()).toString(), ", (", sql, ") res");
        String sqlWhereClause = ScanmanMessageReplayFastLaneReader.appendStrings(" WHERE smh.UNIT_ID = res.UNIT_ID", " AND smh.CREATE_TIME = res.CREATE_TIME", " AND smh.Type = ", Integer.toString(msgType));
        sql = ScanmanMessageReplayFastLaneReader.appendStrings(sql, sqlWhereClause);
        return sql;
    }

    private String generateHistoryInitialSecureSqlForReplay(long since, int maxRowsLimit, HashSet<Long> unitPermissions, int msgType) {
        SelectQuery innerQuery = new SelectQuery(true);
        innerQuery.addColumns(new Column[]{ScanmanMsgDefinitions.col_History_UnitId});
        innerQuery.addAliasedColumn((Object)FunctionCall.max().addColumnParams(new Column[]{ScanmanMsgDefinitions.col_History_CreateTime}), "CREATE_TIME");
        innerQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)ScanmanMsgDefinitions.tbl_HistoryHelper, (Table)ScanmanMsgDefinitions.tbl_History, (Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)ScanmanMsgDefinitions.col_HistoryHelper_Id, (Object)ScanmanMsgDefinitions.col_History_Id));
        ComboCondition innerWhereCondition = new ComboCondition(ComboCondition.Op.AND);
        innerWhereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)ScanmanMsgDefinitions.col_History_Type, (Object)msgType));
        innerWhereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_History_CreateTime, (Object)since));
        innerWhereCondition.addCondition((Condition)new InCondition((Object)ScanmanMsgDefinitions.col_History_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            innerWhereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        innerQuery.addCondition((Condition)innerWhereCondition);
        innerQuery.addGroupings(new Column[]{ScanmanMsgDefinitions.col_History_UnitId});
        innerQuery.addCustomOrdering((Object)ScanmanMsgDefinitions.col_History_CreateTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)innerQuery.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        SelectQuery query = new SelectQuery(true);
        query.addCustomColumns(new Object[]{new CustomSql((Object)"smh.UNIT_ID"), new CustomSql((Object)"smh.CREATE_TIME"), new CustomSql((Object)"smh.MESSAGE")});
        query.addCustomFromTable((Object)new CustomSql((Object)"scanman_msg_history smh"));
        sql = ScanmanMessageReplayFastLaneReader.appendStrings(((SelectQuery)query.validate()).toString(), ", (", sql, ") res");
        String sqlWhereClause = ScanmanMessageReplayFastLaneReader.appendStrings(" WHERE smh.UNIT_ID = res.UNIT_ID", " AND smh.CREATE_TIME = res.CREATE_TIME", " AND smh.Type = ", Integer.toString(msgType));
        sql = ScanmanMessageReplayFastLaneReader.appendStrings(sql, sqlWhereClause);
        return sql;
    }

    private String generateCacheSqlForReplay(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{ScanmanMsgDefinitions.col_Cache_UnitId, ScanmanMsgDefinitions.col_Cache_CreateTime, ScanmanMsgDefinitions.col_Cache_Type, ScanmanMsgDefinitions.col_Cache_Message});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)ScanmanMsgDefinitions.col_Cache_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_Cache_CreateTime, (Object)until));
        whereCondition.addCondition((Condition)new InCondition((Object)ScanmanMsgDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)ScanmanMsgDefinitions.col_Cache_CreateTime, OrderObject.Dir.DESCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistorySqlForReplay(long since, long until, int maxRowsLimit) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{ScanmanMsgDefinitions.col_History_UnitId, ScanmanMsgDefinitions.col_History_CreateTime, ScanmanMsgDefinitions.col_History_Type, ScanmanMsgDefinitions.col_History_Message});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)ScanmanMsgDefinitions.tbl_HistoryHelper, (Table)ScanmanMsgDefinitions.tbl_History, (Column)ScanmanMsgDefinitions.col_HistoryHelper_Id, (Column)ScanmanMsgDefinitions.col_History_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_HistoryHelper_DayStamp, (Object)(until / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)ScanmanMsgDefinitions.col_History_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)ScanmanMsgDefinitions.col_History_CreateTime, (Object)until));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)ScanmanMsgDefinitions.col_History_CreateTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }
}

