/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.base;

import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.image.ImageType;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastLaneReader
extends FastLaneBase {
    protected static final Log log = LogFactory.getLog(FastLaneReader.class);
    protected static final int DEFAULT_ROW_LIMIT = 100001;
    private ConfigurationClient configurationClient = new ConfigurationClient();
    private static final String UNIT_MODEL_SQL = "SELECT um.is_basic, um.unit_id, um.serial_number, um.device_type, um.imei, ui.name, ui.image_name, ut.name AS type_name, ut.img_type_id AS img_type_id, ut.image_name AS type_image_name, itd.name AS img_type_name, um.body_number, um.registration_number, um.brand, um.model_type, um.airportmap_visible, um.deleted FROM unit_model um LEFT JOIN unit_identity ui ON um.unit_id = ui.unit_id LEFT JOIN unit_typeidentity ut ON um.unit_type_id = ut.id LEFT JOIN img_type_defn itd ON ut.img_type_id = itd.id";
    private static final String AREA_SQL = "SELECT a.area_id, a.area, a.description as area_desc FROM area a";
    private static final String USE_USER_SQL = "SELECT uu.id as useuser_id, uu.name as useuser_name, uu.personal_number, uu.key_id FROM use_user uu";
    private static final String USE_GROUP_SQL = "SELECT ug.id as usegroup_id, uu.name as usegroup_name FROM use_group ug";
    private Map<Long, UnitDTO> unitMap;
    private Map<Long, UseUser> useUserMap;
    private Map<Long, UseGroup> useGroupMap;
    private Map<Integer, Area> areaMap;

    protected int getRowLimit() {
        int maxRowsLimit = 100001;
        try {
            maxRowsLimit = Integer.parseInt(this.configurationClient.getParameter("maxRowsFetchLimit"));
        }
        catch (Exception e) {
            log.warn((Object)("Error retrieving row limit for FastLaneReader. Defaulting to " + String.valueOf(100001)));
        }
        return maxRowsLimit;
    }

    public int getMaxRowLimit() {
        return this.getRowLimit();
    }

    protected UnitDTO buildUnitDTO(ResultSet rst) {
        UnitDTO unitDTO = null;
        try {
            long shUnitId = rst.getLong("UNIT_ID");
            String unitName = rst.getString("NAME");
            String unitImageName = rst.getString("IMAGE_NAME");
            String typeName = rst.getString("TYPE_NAME");
            String typeImageName = rst.getString("TYPE_IMAGE_NAME");
            String bodyNumber = rst.getString("BODY_NUMBER");
            String regNumber = rst.getString("REGISTRATION_NUMBER");
            String brand = rst.getString("BRAND");
            String modelType = rst.getString("MODEL_TYPE");
            String serialNumber = rst.getString("SERIAL_NUMBER");
            String imei = rst.getString("IMEI");
            String deviceType = rst.getString("DEVICE_TYPE");
            int imageTypeId = rst.getInt("img_type_id");
            String imageTypeName = rst.getString("img_type_name");
            boolean deleted = rst.getBoolean("DELETED");
            boolean basic = rst.getBoolean("IS_BASIC");
            boolean airportMapVisible = rst.getBoolean("AIRPORTMAP_VISIBLE");
            UnitModel unitModel = new UnitModel();
            unitModel.setUnitId(shUnitId);
            unitModel.setBasic(basic);
            unitModel.setBodyNumber(bodyNumber);
            unitModel.setRegistrationNumber(regNumber);
            unitModel.setSerialNumber(serialNumber);
            unitModel.setIMEI(imei);
            unitModel.setDeviceType(deviceType);
            unitModel.setBrand(brand);
            unitModel.setModelType(modelType);
            unitModel.setDeleted(deleted);
            unitModel.setAirportmapVisible(airportMapVisible);
            UnitIdentity unitIdentity = new UnitIdentity();
            unitIdentity.setName(unitName);
            unitIdentity.setImageName(unitImageName);
            UnitTypeIdentity unitTypeIdentity = new UnitTypeIdentity();
            unitTypeIdentity.setName(typeName);
            unitTypeIdentity.setImageName(typeImageName);
            unitTypeIdentity.setImageTypeId(imageTypeId);
            ImageType imgType = new ImageType();
            imgType.setId(imageTypeId);
            imgType.setName(imageTypeName);
            unitTypeIdentity.setImageType(imgType);
            unitDTO = DTOFactory.buildUnitDTO(unitModel, unitIdentity, unitTypeIdentity);
        }
        catch (SQLException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return unitDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, UnitDTO> getUnitDTOMap() {
        if (this.unitMap != null) {
            return this.unitMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Long, UnitDTO> unitDtoMap = new HashMap<Long, UnitDTO>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(UNIT_MODEL_SQL);
            while (resultSet.next()) {
                UnitDTO unitDto = this.buildUnitDTO(resultSet);
                unitDtoMap.put(unitDto.getUnitId(), unitDto);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.unitMap = unitDtoMap;
        return this.unitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Area> getAreaMap() {
        if (this.areaMap != null) {
            return this.areaMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Integer, Area> areaMap = new HashMap<Integer, Area>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(AREA_SQL);
            while (resultSet.next()) {
                Area area = new Area();
                area.setAreaId(resultSet.getInt("AREA_ID"));
                area.setArea(resultSet.getString("AREA"));
                area.setDescription(resultSet.getString("AREA_DESC"));
                areaMap.put(area.getAreaId(), area);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.areaMap = areaMap;
        return this.areaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, UseUser> getUseUserMap() {
        if (this.useUserMap != null) {
            return this.useUserMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Long, UseUser> map = new HashMap<Long, UseUser>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(USE_USER_SQL);
            while (resultSet.next()) {
                UseUser entity = new UseUser();
                entity.setId(resultSet.getLong("USEUSER_ID"));
                entity.setPersonalNumber(resultSet.getString("PERSONAL_NUMBER"));
                entity.setName(resultSet.getString("USEUSER_NAME"));
                entity.setKeyId(resultSet.getString("KEY_ID"));
                map.put(entity.getId(), entity);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.useUserMap = map;
        return this.useUserMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, UseGroup> getUseGroupMap() {
        if (this.useGroupMap != null) {
            return this.useGroupMap;
        }
        Connection connection = null;
        Statement statement = null;
        HashMap<Long, UseGroup> map = new HashMap<Long, UseGroup>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            ResultSet resultSet = statement.executeQuery(USE_GROUP_SQL);
            while (resultSet.next()) {
                UseGroup entity = new UseGroup();
                entity.setId(resultSet.getLong("USEGROUP_ID"));
                entity.setName(resultSet.getString("USEGROUP_NAME"));
                map.put(entity.getId(), entity);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        this.useGroupMap = map;
        return this.useGroupMap;
    }
}

