/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader;

import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.tto.StateTTO;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.query.interfaces.IReportTableDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelemetryFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(TelemetryFastLaneReader.class);
    private static TDIConfiguration config = TDIConfiguration.getInstance();
    protected static final int MSEC_PER_DEGREE = 3600000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PositionDTO> getGdataHistory(long historyIdBegin, long historyIdEnd) {
        log.debug((Object)"getGdataHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getGdataHistoryForBasicDataInterface");
        stopwatch.start("Overall");
        ArrayList<PositionDTO> list = new ArrayList<PositionDTO>();
        Connection connection = null;
        Statement statement = null;
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            String sql = TelemetryFastLaneReader.generateGdataHistorySql(historyIdBegin, historyIdEnd);
            log.debug((Object)("Executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            stopwatch.stop("Database access", true);
            log.debug((Object)"building DTOs...");
            stopwatch.start("Build DTO");
            HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
            while (resultSet.next()) {
                long gdataUnitId = resultSet.getLong("UNIT_ID");
                UnitDTO unitDTO = (UnitDTO)unitModelMap.get(gdataUnitId);
                if (unitDTO == null) {
                    unitDTO = this.buildUnitDTO(resultSet);
                    unitModelMap.put(gdataUnitId, unitDTO);
                }
                PositionDTO positionDto = TelemetryFastLaneReader.getPositionDTO(unitDTO, resultSet);
                list.add(positionDto);
            }
            stopwatch.stop("Build DTO", true, list.size());
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return list;
    }

    private static final PositionDTO getPositionDTO(UnitDTO unitDto, ResultSet resultSet) throws SQLException {
        long historyId = resultSet.getLong(((IReportTableDefinitions)tableMap.get((Object)FastLaneBase.HistoryTable.GDATA_HISTORY)).getHistoryIdColumn().getName());
        long gdataBeginTime = resultSet.getLong("BEGIN_TIME");
        long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
        long gdataEndTime = resultSet.getLong("END_TIME");
        long endReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
        String ggaRec = resultSet.getString("GGA_REC");
        String rmcRec = resultSet.getString("RMC_REC");
        boolean trusted = resultSet.getBoolean("TRUSTED");
        String area = resultSet.getString("AREA");
        String areaDescr = resultSet.getString("AREA_DESCRIPTION");
        String reason = null;
        int latMSEC = 0;
        int longMSEC = 0;
        PositionDTO positionDTO = DTOFactory.buildPositionDTO(historyId, gdataBeginTime, gdataEndTime, beginReceiveTime, endReceiveTime, gdataBeginTime, gdataEndTime, trusted, ggaRec, latMSEC, longMSEC, rmcRec, reason, area, areaDescr, unitDto);
        return positionDTO;
    }

    private static final PositionDTO getPositionDTOFromCache(UnitDTO unitDto, ResultSet resultSet) throws SQLException {
        long historyId = resultSet.getLong(((IReportTableDefinitions)tableMap.get((Object)FastLaneBase.HistoryTable.GDATA_HISTORY)).getHistoryIdColumn().getName());
        long gdataBeginTime = resultSet.getLong("BEGIN_TIME");
        long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
        String ggaRec = resultSet.getString("GGA_REC");
        String rmcRec = resultSet.getString("RMC_REC");
        boolean trusted = resultSet.getBoolean("TRUSTED");
        String area = resultSet.getString("AREA");
        String areaDescr = resultSet.getString("AREA_DESCRIPTION");
        String reason = null;
        int latMSEC = 0;
        int longMSEC = 0;
        PositionDTO positionDTO = DTOFactory.buildPositionDTO(historyId, gdataBeginTime, 0L, beginReceiveTime, 0L, gdataBeginTime, 0L, trusted, ggaRec, latMSEC, longMSEC, rmcRec, reason, area, areaDescr, unitDto);
        return positionDTO;
    }

    private static final String generateGdataHistorySql(long historyIdBegin, long historyIdEnd) {
        String sql = TelemetryFastLaneReader.appendStrings("SELECT ", " g.", ((IReportTableDefinitions)tableMap.get((Object)FastLaneBase.HistoryTable.GDATA_HISTORY)).getHistoryIdColumn().getName(), ", g.UNIT_ID, g.BEGIN_TIME, g.BEGIN_RECEIVE_TIME, g.END_TIME, g.END_RECEIVE_TIME, ", " g.RMC_REC, g.GGA_REC, g.TRUSTED, ", " ui.NAME, ui.IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.CUSTOMER_UNIT_ID, um.BRAND, um.MODEL_TYPE, um.DELETED, a.AREA, a.DESCRIPTION as AREA_DESCRIPTION ", " FROM gdata_history g ", " LEFT JOIN unit_model um ON g.UNIT_ID = um.UNIT_ID ", " LEFT JOIN unit_identity ui ON g.UNIT_ID = ui.UNIT_ID", " LEFT JOIN area a ON g.AREA_ID = a.AREA_ID ", " WHERE " + ((IReportTableDefinitions)tableMap.get((Object)FastLaneBase.HistoryTable.GDATA_HISTORY)).getHistoryIdColumn().getName() + " BETWEEN ", String.valueOf(historyIdBegin), " AND ", String.valueOf(historyIdEnd), " ORDER BY id");
        return sql.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationDTO> getNotifyHistory(long historyIdBegin, long historyIdEnd) {
        log.debug((Object)"getNotifyHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getNotifyHistoryForBasicDataInterface");
        stopwatch.start("Overall");
        ArrayList<NotificationDTO> list = new ArrayList<NotificationDTO>();
        Connection connection = null;
        Statement statement = null;
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            String sql = TelemetryFastLaneReader.generateNotifyHistorySql(historyIdBegin, historyIdEnd);
            log.debug((Object)("Executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            int dataSize = 0;
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
            while (resultSet.next()) {
                long notificationUnitId = resultSet.getLong("UNIT_ID");
                UnitDTO unitDTO = (UnitDTO)unitModelMap.get(notificationUnitId);
                if (unitDTO == null) {
                    unitDTO = this.buildUnitDTO(resultSet);
                    unitModelMap.put(notificationUnitId, unitDTO);
                }
                NotificationDTO notificationDTO = TelemetryFastLaneReader.getNotificationDTO(unitDTO, resultSet);
                list.add(notificationDTO);
                ++dataSize;
            }
            stopwatch.stop("Build DTO", true, dataSize);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return list;
    }

    private static final NotificationDTO getNotificationDTO(UnitDTO unitDto, ResultSet resultSet) throws SQLException {
        long id = resultSet.getLong("ID");
        long messageId = resultSet.getLong("MESSAGE_ID");
        long createTime = resultSet.getLong("CREATE_TIME");
        long receiveTime = resultSet.getLong("RECEIVE_TIME");
        String remark = resultSet.getString("REMARK");
        NotificationDTO notificationDTO = DTOFactory.buildNotificationDTO(id, createTime, receiveTime, messageId, remark, unitDto);
        return notificationDTO;
    }

    private static final String generateNotifyHistorySql(long historyIdBegin, long historyIdEnd) {
        String sql = TelemetryFastLaneReader.appendStrings("SELECT nh.ID, nh.UNIT_ID, nh.MESSAGE_ID, nh.CREATE_TIME, nh.ENTRY, nh.RECEIVE_TIME, nh.REMARK, ", " um.CUSTOMER_UNIT_ID, um.MODEL_TYPE, ui.NAME, um.DELETED", " FROM notify_history nh ", " LEFT JOIN unit_model um ON nh.UNIT_ID = um.UNIT_ID ", " LEFT JOIN unit_identity ui ON nh.UNIT_ID = ui.UNIT_ID ", " WHERE ID BETWEEN ", String.valueOf(historyIdBegin), " AND ", String.valueOf(historyIdEnd), " ORDER BY id");
        return sql.toLowerCase();
    }

    public List<StateTTO> getStateHistory(long historyIdBegin, long historyIdEnd) {
        log.debug((Object)"getStateHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getStateHistoryForBasicDataInterface");
        stopwatch.start("Overall");
        ArrayList<StateTTO> list = new ArrayList<StateTTO>();
        try {
            log.debug((Object)"database access...");
            stopwatch.start("Database access");
            Connection connection = this.getConnection();
            if (connection != null) {
                String sql = TelemetryFastLaneReader.generateStateHistorySql(historyIdBegin, historyIdEnd);
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = this.createReadOnlyForwardOnlyStatement(connection);
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                stopwatch.start("Build DTO");
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    long stateUnitId = resultSet.getLong("UNIT_ID");
                    UnitDTO unitDTO = (UnitDTO)unitModelMap.get(stateUnitId);
                    if (unitDTO == null) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(stateUnitId, unitDTO);
                    }
                    StateDTO stateDTO = TelemetryFastLaneReader.getStateDTO(unitDTO, resultSet);
                    StateTTO stateTTO = this.getStateTTO(stateDTO, resultSet);
                    list.add(stateTTO);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("Overall", true);
        return list;
    }

    public List<PositionDTO> getCurrentGeoCache() {
        log.debug((Object)"getCurrentGeoCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getCurrentGeoCache");
        stopwatch.start("Overall");
        ArrayList<PositionDTO> list = new ArrayList<PositionDTO>();
        try {
            log.debug((Object)"database access...");
            stopwatch.start("Database access");
            Connection connection = this.getConnection();
            if (connection != null) {
                String sql = TelemetryFastLaneReader.generateCurrentGeoCacheSql();
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                stopwatch.start("Build DTO");
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    long stateUnitId = resultSet.getLong("UNIT_ID");
                    UnitDTO unitDTO = (UnitDTO)unitModelMap.get(stateUnitId);
                    if (unitDTO == null) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(stateUnitId, unitDTO);
                    }
                    PositionDTO positionDTO = TelemetryFastLaneReader.getPositionDTOFromCache(unitDTO, resultSet);
                    list.add(positionDTO);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("Overall", true);
        return list;
    }

    public List<StateTTO> getCurrentStateCache() {
        log.debug((Object)"getCurrentStateCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getCurrentStateCache");
        stopwatch.start("Overall");
        ArrayList<StateTTO> list = new ArrayList<StateTTO>();
        try {
            log.debug((Object)"database access...");
            stopwatch.start("Database access");
            Connection connection = this.getConnection();
            if (connection != null) {
                String sql = TelemetryFastLaneReader.generateCurrentStateCacheSql();
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = this.createReadOnlyForwardOnlyStatement(connection);
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("Database access", true);
                stopwatch.start("Build DTO");
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    long stateUnitId = resultSet.getLong("UNIT_ID");
                    UnitDTO unitDTO = (UnitDTO)unitModelMap.get(stateUnitId);
                    if (unitDTO == null) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(stateUnitId, unitDTO);
                    }
                    StateDTO stateDTO = TelemetryFastLaneReader.getStateDTO(unitDTO, resultSet);
                    StateTTO stateTTO = this.getStateTTO(stateDTO, resultSet);
                    list.add(stateTTO);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("Build DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("Overall", true);
        return list;
    }

    private StateTTO getStateTTO(StateDTO stateDTO, ResultSet resultSet) throws SQLException {
        StateTTO stateTTO = new StateTTO(stateDTO);
        if (config.getBoolean("xml.telemetryDataMessage.stateField.currArea.active")) {
            String currArea = resultSet.getString("CURR_AREA_HISTORY");
            stateTTO.setCurrArea(currArea);
        }
        if (config.getBoolean("xml.telemetryDataMessage.stateField.currCoords.active")) {
            double currLatitude;
            double currLongitude = resultSet.getLong("CURR_LONG_MSEC_HISTORY");
            if (currLongitude != 0.0) {
                stateTTO.setCurrLongitude(currLongitude / 3600000.0);
            }
            if ((currLatitude = (double)resultSet.getLong("CURR_LAT_MSEC_HISTORY")) != 0.0) {
                stateTTO.setCurrLatitude(currLatitude / 3600000.0);
            }
        }
        if (config.getBoolean("xml.telemetryDataMessage.stateField.prevArea.active")) {
            String prevArea = resultSet.getString("PREV_AREA_HISTORY");
            stateTTO.setPrevArea(prevArea);
        }
        if (config.getBoolean("xml.telemetryDataMessage.stateField.prevCoords.active")) {
            double beginLatitude;
            double prevLongitude = resultSet.getLong("PREV_LONG_MSEC_HISTORY");
            if (prevLongitude != 0.0) {
                stateTTO.setPrevLongitude(prevLongitude / 3600000.0);
            }
            if ((beginLatitude = (double)resultSet.getLong("PREV_LAT_MSEC_HISTORY")) != 0.0) {
                stateTTO.setPrevLatitude(beginLatitude / 3600000.0);
            }
        }
        if (config.getBoolean("xml.telemetryDataMessage.stateField.currFlights.active")) {
            stateTTO.setCurrFLNInb(resultSet.getString("CURR_INB"));
            stateTTO.setCurrFLNOutb(resultSet.getString("CURR_OUTB"));
        }
        if (config.getBoolean("xml.telemetryDataMessage.stateField.prevFlights.active")) {
            stateTTO.setPrevFLNInb(resultSet.getString("PREV_INB"));
            stateTTO.setPrevFLNOutb(resultSet.getString("PREV_OUTB"));
        }
        return stateTTO;
    }

    private static final StateDTO getStateDTO(UnitDTO unitDto, ResultSet resultSet) throws SQLException {
        long id = resultSet.getLong("ID");
        int stateId = resultSet.getInt("STATE_ID");
        int stateIdNext = resultSet.getInt("state_id_next");
        int stateModelId = resultSet.getInt("STATE_MODEL_ID");
        long shBeginTime = resultSet.getLong("BEGIN_TIME");
        long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
        long shEndTime = resultSet.getLong("END_TIME");
        long endReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
        String remark = resultSet.getString("REMARK");
        StateDTO stateDTO = DTOFactory.buildStateDTO(id, shBeginTime, shEndTime, beginReceiveTime, endReceiveTime, shBeginTime, shEndTime, stateId, stateModelId, stateIdNext, remark, null, null, false, false, unitDto);
        return stateDTO;
    }

    private static final String generateStateHistorySql(long historyIdBegin, long historyIdEnd) {
        if (TelemetryFastLaneReader.enhanceStateWithFis()) {
            String sql = TelemetryFastLaneReader.appendStrings("select sh.id, sh.unit_id, sh.state_id, sh.state_model_id, sh.state_id_next, sh.begin_time, sh.begin_receive_time, sh.end_time, sh.end_receive_time, sh.duration, sh.remark, um.customer_unit_id, um.model_type, ui.name, um.deleted, gh0.long_msec as prev_long_msec_history, gh0.lat_msec as prev_lat_msec_history, ah0.area as prev_area_history, gh1.long_msec as curr_long_msec_history, gh1.lat_msec as curr_lat_msec_history, ah1.area as curr_area_history, ff1.fln as prev_inb, ff2.fln as curr_inb, ff3.fln as prev_outb, ff4.fln as curr_outb ", "from state_history sh ", "left join unit_model um on sh.unit_id = um.unit_id ", "left join unit_identity ui on sh.unit_id = ui.unit_id ", "left join gdata_history gh0 on sh.begin_time = gh0.begin_time and sh.unit_id = gh0.unit_id ", "left join gdata_history gh1 on sh.end_time = gh1.begin_time and sh.unit_id = gh1.unit_id ", "left join area ah0 on gh0.area_id=ah0.area_id ", "left join area ah1 on gh1.area_id=ah1.area_id ", "left join stand_state_history ssh1 on ssh1.stand = ah0.area and ssh1.state_id = 1011 and ssh1.begin_time < sh.begin_time and (ssh1.end_time > sh.begin_time or ssh1.end_time = 0) ", "left join stand_state_history ssh2 on ssh2.stand = ah1.area and ssh2.state_id = 1011 and ssh2.begin_time < sh.end_time and (ssh2.end_time > sh.end_time or ssh2.end_time = 0) ", "left join fis_flight ff1 on ssh1.flight_id = ff1.id ", "left join fis_flight ff2 on ssh2.flight_id = ff2.id ", "left join fis_flight ff3 on ff1.pkey = ff3.pkey and ff3.mov_type in ('D', 'F') and ff3.curr = 1 and ff3.deleted = 0 ", "left join fis_flight ff4 on ff2.pkey = ff4.pkey and ff4.mov_type in ('D', 'F') and ff4.curr = 1 and ff4.deleted = 0 ", "where sh.id between ", String.valueOf(historyIdBegin), " and ", String.valueOf(historyIdEnd), " ORDER BY id");
            return sql;
        }
        if (TelemetryFastLaneReader.enhanceStateWithGeo()) {
            String sql = TelemetryFastLaneReader.appendStrings("SELECT sh.ID, sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.state_id_next, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, ", "sh.END_TIME, sh.END_RECEIVE_TIME, sh.DURATION, sh.REMARK, um.CUSTOMER_UNIT_ID, um.MODEL_TYPE, ", "ui.NAME, um.DELETED, ", "gh0.LONG_MSEC AS PREV_LONG_MSEC_HISTORY, gh0.LAT_MSEC AS PREV_LAT_MSEC_HISTORY, ah0.AREA AS PREV_AREA_HISTORY, ", "gh1.LONG_MSEC AS CURR_LONG_MSEC_HISTORY, gh1.LAT_MSEC AS CURR_LAT_MSEC_HISTORY, ah1.AREA AS CURR_AREA_HISTORY ", "FROM state_history sh ", "LEFT JOIN unit_model um ON sh.UNIT_ID = um.UNIT_ID ", "LEFT JOIN unit_identity ui ON sh.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN gdata_history gh0 ON sh.begin_time = gh0.begin_time AND sh.unit_id = gh0.unit_id ", "LEFT JOIN gdata_history gh1 ON sh.end_time = gh1.begin_time AND sh.unit_id = gh1.unit_id ", "LEFT JOIN area ah0 on gh0.area_id=ah0.area_id ", "LEFT JOIN area ah1 on gh1.area_id=ah1.area_id ", "WHERE sh.ID BETWEEN ", String.valueOf(historyIdBegin), " AND ", String.valueOf(historyIdEnd), " ORDER BY id");
            return sql.toLowerCase();
        }
        String sql = TelemetryFastLaneReader.appendStrings("SELECT sh.ID, sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.state_id_next, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, ", "sh.END_TIME, sh.END_RECEIVE_TIME, sh.DURATION, sh.REMARK, um.CUSTOMER_UNIT_ID, um.MODEL_TYPE, ", "ui.NAME, um.DELETED", " from state_history sh ", " LEFT JOIN unit_model um ON sh.UNIT_ID = um.UNIT_ID ", " LEFT JOIN unit_identity ui ON sh.UNIT_ID = ui.UNIT_ID ", " WHERE sh.ID BETWEEN ", String.valueOf(historyIdBegin), " AND ", String.valueOf(historyIdEnd), " ORDER BY id");
        return sql.toLowerCase();
    }

    private static boolean enhanceStateWithGeo() {
        return config.getBoolean("xml.telemetryDataMessage.stateField.currCoords.active") || config.getBoolean("xml.telemetryDataMessage.stateField.currArea.active") || config.getBoolean("xml.telemetryDataMessage.stateField.prevCoords.active") || config.getBoolean("xml.telemetryDataMessage.stateField.prevArea.active");
    }

    private static boolean enhanceStateWithFis() {
        return config.getBoolean("xml.telemetryDataMessage.stateField.currFlights.active") || config.getBoolean("xml.telemetryDataMessage.stateField.prevFlights.active");
    }

    private static final String generateCurrentGeoCacheSql() {
        String sql = TelemetryFastLaneReader.appendStrings("select gc.HISTORY_ID as ID, gc.UNIT_ID, gc.BEGIN_TIME, gc.BEGIN_RECEIVE_TIME, gc.RMC_REC, gc.GGA_REC, gc.TRUSTED, ui.NAME, ui.IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.CUSTOMER_UNIT_ID, um.BRAND, um.MODEL_TYPE, um.DELETED, a.AREA, a.DESCRIPTION as AREA_DESCRIPTION ", "from gdata_cache gc ", "LEFT JOIN unit_model um ON gc.UNIT_ID = um.UNIT_ID ", "LEFT JOIN unit_identity ui ON gc.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN area a ON gc.AREA_ID = a.AREA_ID ", "order by gc.HISTORY_ID");
        return sql.toLowerCase();
    }

    private static final String generateCurrentStateCacheSql() {
        if (TelemetryFastLaneReader.enhanceStateWithFis()) {
            String sql = TelemetryFastLaneReader.appendStrings("SELECT sh.id, sh.unit_id, sh.state_id, sh.state_model_id, sh.state_id_next, sh.begin_time, sh.begin_receive_time, sh.end_time, sh.end_receive_time, sh.duration, sh.remark, um.customer_unit_id, um.model_type, ui.name, um.deleted, gh1.long_msec as prev_long_msec_history, gh1.lat_msec as prev_lat_msec_history, gh1.area_id as prev_area_id, a1.area as prev_area_history, gh2.long_msec as curr_long_msec_history, gh2.lat_msec as curr_lat_msec_history, gh2.area_id as curr_area_id, a2.area as curr_area_history, ff1.fln as prev_inb, ff2.fln as curr_inb, ff3.fln as prev_outb, ff4.fln as curr_outb ", "from state_cache csc ", "join state_history sh on csc.unit_id=sh.unit_id and csc.state_model_id = sh.state_model_id and csc.begin_time = sh.end_time ", "left join unit_model um on sh.unit_id = um.unit_id ", "left join unit_identity ui on sh.unit_id = ui.unit_id ", "left join gdata_history gh1 on sh.unit_id = gh1.unit_id and sh.begin_time = gh1.begin_time ", "left join gdata_history gh2 on sh.unit_id = gh2.unit_id and sh.end_time = gh2.begin_time ", "left join area a1 on gh1.area_id = a1.area_id ", "left join area a2 on gh2.area_id = a2.area_id ", "left join stand_state_history ssh1 on ssh1.stand = a1.area and ssh1.state_id = 1011 and ssh1.begin_time < sh.begin_time and (ssh1.end_time > sh.begin_time or ssh1.end_time = 0) ", "left join stand_state_history ssh2 on ssh2.stand = a2.area and ssh2.state_id = 1011 and ssh2.begin_time < sh.end_time and (ssh2.end_time > sh.end_time or ssh2.end_time = 0) ", "left join fis_flight ff1 on ssh1.flight_id = ff1.id ", "left join fis_flight ff2 on ssh2.flight_id = ff2.id ", "left join fis_flight ff3 on ff1.pkey = ff3.pkey and ff3.mov_type in ('D', 'F') and ff3.curr = 1 and ff3.deleted = 0 ", "left join fis_flight ff4 on ff2.pkey = ff4.pkey and ff4.mov_type in ('D', 'F') and ff4.curr = 1 and ff4.deleted = 0 ");
            return sql;
        }
        if (TelemetryFastLaneReader.enhanceStateWithGeo()) {
            String sql = TelemetryFastLaneReader.appendStrings("select sh.ID, sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.state_id_next, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, sh.END_TIME, sh.END_RECEIVE_TIME, sh.DURATION, sh.REMARK, um.CUSTOMER_UNIT_ID, um.MODEL_TYPE, ui.NAME, um.DELETED, gh1.LONG_MSEC as PREV_LONG_MSEC_HISTORY, gh1.LAT_MSEC as PREV_LAT_MSEC_HISTORY, gh1.AREA_ID as PREV_AREA_ID, a1.AREA as PREV_AREA_HISTORY, gh2.LONG_MSEC as CURR_LONG_MSEC_HISTORY, gh2.LAT_MSEC as CURR_LAT_MSEC_HISTORY, gh2.AREA_ID as CURR_AREA_ID, a2.AREA as CURR_AREA_HISTORY ", "from state_cache csc ", "JOIN state_history sh ON csc.unit_id=sh.unit_id AND csc.state_model_id = sh.state_model_id AND csc.begin_time = sh.end_time ", "LEFT JOIN unit_model um ON sh.UNIT_ID = um.UNIT_ID ", "LEFT JOIN unit_identity ui ON sh.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN gdata_history gh1 ON sh.UNIT_ID = gh1.UNIT_ID and sh.begin_time = gh1.begin_time ", "LEFT JOIN gdata_history gh2 ON sh.UNIT_ID = gh2.UNIT_ID and sh.end_time = gh2.begin_time ", "LEFT JOIN area a1 ON gh1.AREA_ID = a1.AREA_ID ", "LEFT JOIN area a2 ON gh2.AREA_ID = a2.AREA_ID ");
            return sql.toLowerCase();
        }
        String sql = TelemetryFastLaneReader.appendStrings("select sh.ID, sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.state_id_next, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, sh.END_TIME, sh.END_RECEIVE_TIME, sh.DURATION, sh.REMARK, um.CUSTOMER_UNIT_ID, um.MODEL_TYPE, ui.NAME, um.DELETED ", "from state_cache csc ", "JOIN state_history sh ON csc.unit_id=sh.unit_id AND csc.state_model_id = sh.state_model_id AND csc.begin_time = sh.end_time ", "LEFT JOIN unit_model um ON sh.UNIT_ID = um.UNIT_ID ", "LEFT JOIN unit_identity ui ON sh.UNIT_ID = ui.UNIT_ID ");
        return sql.toLowerCase();
    }

    @Override
    protected UnitDTO buildUnitDTO(ResultSet resultSet) {
        UnitDTO unitDTO = null;
        try {
            long unitId = resultSet.getLong("UNIT_ID");
            String unitName = resultSet.getString("NAME");
            String customerUnitId = resultSet.getString("CUSTOMER_UNIT_ID");
            String modelType = resultSet.getString("MODEL_TYPE");
            boolean deleted = resultSet.getBoolean("DELETED");
            UnitModel unitModel = new UnitModel();
            unitModel.setUnitId(unitId);
            unitModel.setCustomerUnitId(customerUnitId);
            unitModel.setModelType(modelType);
            unitModel.setBasic(true);
            unitModel.setDeleted(deleted);
            UnitIdentity unitIdentity = new UnitIdentity();
            unitIdentity.setName(unitName);
            UnitTypeIdentity unitTypeIdentity = new UnitTypeIdentity();
            unitDTO = DTOFactory.buildUnitDTO(unitModel, unitIdentity, unitTypeIdentity);
        }
        catch (SQLException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return unitDTO;
    }
}

