/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.currentData.dto;

import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgCache;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.Collection;
import java.util.List;

public class InfomanReportDTO
extends UnitDTO {
    private KeepAliveCache keepAlive = null;
    private List<ScanmanMsgCache> scanmanMsgs = null;

    public InfomanReportDTO(UnitDTO unitDTO, KeepAliveCache keepAlive, Collection<ScanmanMsgCache> scanmanMsgs) {
        super(unitDTO);
        this.setKeepAlive(keepAlive);
        this.setScanmanMsgs((List)scanmanMsgs);
    }

    public Long getLastKeepAlive() {
        if (this.keepAlive == null) {
            return null;
        }
        return this.keepAlive.getReceiveTime();
    }

    public Long getUptime() {
        if (this.keepAlive == null || this.scanmanMsgs == null) {
            return null;
        }
        Long uptime = null;
        for (ScanmanMsgCache cache : this.scanmanMsgs) {
            if (cache == null || cache.getType() != 25) continue;
            uptime = this.getLastKeepAlive() - cache.getReceiveTime();
        }
        return uptime;
    }

    public Long getInterrupt() {
        if (this.scanmanMsgs == null) {
            return null;
        }
        Long interrupt = null;
        Long type8 = null;
        Long type9 = null;
        for (ScanmanMsgCache cache : this.scanmanMsgs) {
            if (cache == null) continue;
            if (cache.getType() == 8) {
                type8 = cache.getReceiveTime();
                continue;
            }
            if (cache.getType() != 9) continue;
            type9 = cache.getReceiveTime();
        }
        if (type8 != null && type9 != null) {
            interrupt = type8 - type9;
        }
        return interrupt;
    }

    public void setKeepAlive(KeepAliveCache keepAlive) {
        this.keepAlive = keepAlive;
    }

    public KeepAliveCache getKeepAlive() {
        return this.keepAlive;
    }

    public void setScanmanMsgs(List<ScanmanMsgCache> scanmanMsgs) {
        this.scanmanMsgs = scanmanMsgs;
    }

    public List<ScanmanMsgCache> getScanmanMsgs() {
        return this.scanmanMsgs;
    }
}

