/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;

public abstract class StateReportDTO
extends ReportDTOBase {
    protected long beginTime;
    protected long endTime;
    protected long actualBeginTime;
    protected long actualEndTime;
    protected long beginReceiveTime;
    protected long endReceiveTime;

    public abstract <T extends StateReportDTO> T copy();

    public StateReportDTO(long id, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime, long actualBeginTime, long actualEndTime) {
        super(id);
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.beginReceiveTime = beginReceiveTime;
        this.endReceiveTime = endReceiveTime;
        this.actualBeginTime = actualBeginTime;
        this.actualEndTime = actualEndTime;
    }

    public boolean correctTimes(long beginTime, long endTime) {
        if (this.beginTime < beginTime || this.endTime > endTime || this.endTime <= 0L) {
            if (this.beginTime < beginTime) {
                this.beginTime = beginTime;
            }
            if (this.endTime > endTime || this.endTime <= 0L) {
                this.endTime = endTime;
                if (endTime > System.currentTimeMillis()) {
                    this.endTime = System.currentTimeMillis();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public long getDuration() {
        if (this.endTime > 0L) {
            return this.endTime - this.beginTime;
        }
        return System.currentTimeMillis() - this.beginTime;
    }

    @Override
    public long getBeginDelay() {
        return this.beginReceiveTime - this.actualBeginTime;
    }

    @Override
    public long getEndDelay() {
        return this.endReceiveTime - this.actualEndTime;
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getBeginReceiveTime() {
        return this.beginReceiveTime;
    }

    public void setBeginReceiveTime(long beginReceiveTime) {
        this.beginReceiveTime = beginReceiveTime;
    }

    public long getEndReceiveTime() {
        return this.endReceiveTime;
    }

    public void setEndReceiveTime(long endReceiveTime) {
        this.endReceiveTime = endReceiveTime;
    }

    public long getActualBeginTime() {
        return this.actualBeginTime;
    }

    public void setActualBeginTime(long actualBeginTime) {
        this.actualBeginTime = actualBeginTime;
    }

    public long getActualEndTime() {
        return this.actualEndTime;
    }

    public void setActualEndTime(long actualEndTime) {
        this.actualEndTime = actualEndTime;
    }
}

