/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin.dto.permission;

import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class UnitPermissionDTO
extends UnitDTO {
    private static final long serialVersionUID = -5852166449478994927L;
    private boolean userPermission = false;
    private boolean groupPermission = false;
    private boolean rolePermission = false;
    private Set<String> roleNameSet;
    private Set<String> groupNameSet;
    private boolean roleNamesDirty = true;
    private boolean groupNamesDirty = true;
    private String roleNames;
    private String groupNames;
    private String userName;

    public UnitPermissionDTO(UnitDTO unitDto) {
        super(unitDto);
    }

    public boolean isGroupPermission() {
        return this.groupPermission;
    }

    public void setGroupPermission(boolean groupPermission) {
        this.groupPermission = groupPermission;
    }

    public boolean isRolePermission() {
        return this.rolePermission;
    }

    public void setRolePermission(boolean rolePermission) {
        this.rolePermission = rolePermission;
    }

    public boolean isUserPermission() {
        return this.userPermission;
    }

    public void setUserPermission(boolean userPermission) {
        this.userPermission = userPermission;
    }

    public String getRoleNames() {
        Set<String> set = this.getRoleNameSet();
        if (this.roleNamesDirty && set.size() != 0) {
            this.roleNamesDirty = false;
            this.roleNames = UnitPermissionDTO.setToString(set);
        }
        return this.roleNames;
    }

    public void setRoleNames(String roleNames) {
        this.roleNames = roleNames;
    }

    private Set<String> getRoleNameSet() {
        if (this.roleNameSet == null) {
            this.roleNameSet = new TreeSet<String>();
        }
        return this.roleNameSet;
    }

    public void addRoleName(String roleName) {
        Set<String> set = this.getRoleNameSet();
        set.add(roleName);
        this.roleNamesDirty = true;
    }

    public void removeRoleName(String roleName) {
        Set<String> set = this.getRoleNameSet();
        set.remove(roleName);
        this.roleNamesDirty = true;
    }

    public void clearRoleNames() {
        this.getRoleNameSet().clear();
        this.roleNamesDirty = true;
    }

    public String getGroupNames() {
        Set<String> set = this.getGroupNameSet();
        if (this.groupNamesDirty && set.size() != 0) {
            this.groupNamesDirty = false;
            this.groupNames = UnitPermissionDTO.setToString(set);
        }
        return this.groupNames;
    }

    public void setGroupNames(String groupNames) {
        this.groupNames = groupNames;
    }

    private Set<String> getGroupNameSet() {
        if (this.groupNameSet == null) {
            this.groupNameSet = new TreeSet<String>();
        }
        return this.groupNameSet;
    }

    public void addGroupName(String groupName) {
        Set<String> set = this.getGroupNameSet();
        set.add(groupName);
        this.groupNamesDirty = true;
    }

    public void removeGroupName(String groupName) {
        Set<String> set = this.getGroupNameSet();
        set.remove(groupName);
        this.groupNamesDirty = true;
    }

    public void clearGroupNames() {
        this.getGroupNameSet().clear();
        this.groupNamesDirty = true;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private static String setToString(Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        int size = list.size();
        int lastIdx = size - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != size; ++i) {
            sb.append((String)list.get(i));
            if (i == lastIdx) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

