/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.container.ContainerUtil;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsRemote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;

@Stateless(name="PermissionUpdateTools")
@Remote(value={PermissionUpdateToolsRemote.class})
@Local(value={PermissionUpdateToolsLocal.class})
@JndiLocalBinding(localJndiBinding="rts/PermissionUpdateTools")
@JndiRemoteBinding(remoteJndiBinding="rts/PermissionUpdateTools")
public class PermissionUpdateToolsBean
implements PermissionUpdateToolsLocal,
PermissionUpdateToolsRemote {
    @PostConstruct
    public void ejbCreate() {
    }

    @Override
    @Business(viewType="both")
    public <T> Collection<T> getDiffOfCollection(Collection<T> col1, Collection<T> col2) {
        ArrayList<T> colTmp = new ArrayList<T>();
        ArrayList<T> colDiff = new ArrayList<T>();
        colTmp.addAll(col1);
        colTmp.removeAll(col2);
        colDiff.addAll(col2);
        colDiff.removeAll(col1);
        colDiff.addAll(colTmp);
        return colDiff;
    }

    @Override
    @Business(viewType="both")
    public boolean isAirportMapRoleAffected(Collection<String> col1, Collection<String> col2) {
        Collection<String> diffCollection = this.getDiffOfCollection(col1, col2);
        for (String roleName : diffCollection) {
            if (!roleName.startsWith("section.airportmap") || roleName.startsWith("section.airportmapgenerator") || roleName.equals("section.airportmap.replay")) continue;
            return true;
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public String[] getDifferentUsers(Collection<Account> currentUsers, String[] newUserList) {
        ArrayList<String> currentUserNames = new ArrayList<String>();
        ArrayList newUserNames = ContainerUtil.asArrayList((Object[])newUserList);
        for (Account account : currentUsers) {
            currentUserNames.add(account.getUsername());
        }
        Collection myCollection = this.getDiffOfCollection(currentUserNames, newUserNames);
        return myCollection.toArray(new String[myCollection.size()]);
    }

    @Override
    @Business(viewType="both")
    public String[] getDifferentUsersByAccountValueList(List<Account> currentUsers, List<Account> newAccounts) {
        ArrayList<String> currentUserNames = new ArrayList<String>(currentUsers.size());
        ArrayList<String> newUserNames = new ArrayList<String>(newAccounts.size());
        for (Account account : currentUsers) {
            currentUserNames.add(account.getUsername());
        }
        for (Account account : newAccounts) {
            newUserNames.add(account.getUsername());
        }
        Collection myCollection = this.getDiffOfCollection(currentUserNames, newUserNames);
        return myCollection.toArray(new String[myCollection.size()]);
    }

    @Override
    @Business(viewType="both")
    public List<String> getAffectedUsersByRolesChanges(Map<String, String[]> oldAccounts, Map<String, String[]> newAccounts, String[] usernames) {
        ArrayList<String> affectedUsers = new ArrayList<String>(usernames.length);
        for (int i = 0; i < usernames.length; ++i) {
            String userName = usernames[i];
            Object[] oldRoles = oldAccounts.get(userName);
            Object[] newRoles = newAccounts.get(userName);
            ArrayList oldRolesList = ContainerUtil.asArrayList((Object[])oldRoles);
            ArrayList newRolesList = ContainerUtil.asArrayList((Object[])newRoles);
            if (!this.isAirportMapRoleAffected(newRolesList, oldRolesList)) continue;
            affectedUsers.add(userName);
        }
        return affectedUsers;
    }

    @Override
    @Business(viewType="both")
    public List<String> getAffectedUsersByVisibleUnitChanges(Map<String, HashSet<Long>> oldUnitPermissions, Map<String, HashSet<Long>> newUnitPermissions, String[] usernames) {
        ArrayList<String> affectedUsers = new ArrayList<String>(usernames.length);
        for (int i = 0; i < usernames.length; ++i) {
            HashSet<Long> newUnitIDs;
            String userName = usernames[i];
            HashSet<Long> oldUnitIDs = oldUnitPermissions.get(userName);
            if (this.getDiffOfCollection(oldUnitIDs, newUnitIDs = newUnitPermissions.get(userName)).size() == 0) continue;
            affectedUsers.add(userName);
        }
        return affectedUsers;
    }

    @Override
    @Business(viewType="both")
    public List<Account> getSameAccountInBothLists(List<String> userNames, List<Account> accounts) {
        ArrayList<Account> filteredAccounts = new ArrayList<Account>();
        for (Account account : accounts) {
            if (!userNames.contains(account.getUsername())) continue;
            filteredAccounts.add(account);
        }
        return filteredAccounts;
    }

    @Override
    @Business(viewType="both")
    public String[] getUserNames(List<Account> accounts) {
        int count = accounts.size();
        String[] affectedUserNames = new String[count];
        for (int i = 0; i != count; ++i) {
            affectedUserNames[i] = accounts.get(i).getUsername();
        }
        return affectedUserNames;
    }
}

