/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.stateModel;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.datamodel.stateModel.StateInterpretation;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeLocal;
import de.proveo.wwt.logic.ejb.stateModel.StateDAO;
import de.proveo.wwt.logic.ejb.stateModel.StateInterpretationDAO;
import de.proveo.wwt.logic.ejb.stateModel.StateModelDAO;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeLocal;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeRemote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;

@Stateless(name="StateModelFacade")
@Remote(value={StateModelFacadeRemote.class})
@Local(value={StateModelFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/StateModelFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/StateModelFacade")
public class StateModelFacadeBean {
    private static final Log log = LogFactory.getLog(StateModelFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private StateDAO stateDAO;
    private StateModelDAO stateModelDAO;
    private StateInterpretationDAO stateInterpretationDAO;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade = null;
    @EJB
    private StateOutFacadeLocal stateOutFacade = null;

    @PostConstruct
    public void initialize() {
        this.stateDAO = StateDAO.newInstance(this.entityManager);
        this.stateModelDAO = StateModelDAO.newInstance(this.entityManager);
        this.stateInterpretationDAO = StateInterpretationDAO.newInstance(this.entityManager);
    }

    @Business(viewType="both")
    public void createState(State state) {
        this.stateDAO.createEntity(state);
    }

    @Business(viewType="both")
    public void updateState(State state) {
        this.stateDAO.updateEntity(state);
    }

    @Business(viewType="both")
    public void removeState(int stateId, int stateModelId) {
        State state = this.getState(stateId, stateModelId);
        this.stateDAO.removeEntity(state);
    }

    @Business(viewType="both")
    public State getState(int stateId, int stateModelId) {
        return (State)this.stateDAO.findByPrimaryKey(new State.PK(stateId, stateModelId));
    }

    @Business(viewType="both")
    public List<State> getStates(int stateModelId) {
        return this.stateDAO.findStates(stateModelId);
    }

    @Business(viewType="both")
    public List<Integer> getStateIds(int stateModelId) {
        List<State> states = this.getStates(stateModelId);
        ArrayList<Integer> stateIds = new ArrayList<Integer>(states.size());
        for (State state : states) {
            stateIds.add(state.getPk().getId());
        }
        return stateIds;
    }

    @Business(viewType="both")
    public void createStateModel(StateModel stateModel) {
        this.stateModelDAO.createEntity(stateModel);
    }

    @Business(viewType="both")
    public void updateStateModel(StateModel stateModel) {
        this.stateModelDAO.updateEntity(stateModel);
    }

    @Business(viewType="both")
    public void removeStateModel(int stateModelId) {
        StateModel stateModel = (StateModel)this.stateModelDAO.findByPrimaryKey(stateModelId);
        this.stateModelDAO.removeEntity(stateModel);
    }

    @Business(viewType="both")
    public StateModel getStateModel(int stateModelId) {
        return (StateModel)this.stateModelDAO.findByPrimaryKey(stateModelId);
    }

    @Business(viewType="both")
    public List<StateModel> getStateModels() {
        return this.stateModelDAO.findAll();
    }

    @Business(viewType="both")
    public List<StateModel> getActiveStateModels() {
        return this.stateModelDAO.findActive();
    }

    @Business(viewType="both")
    public Map<Integer, List<Integer>> getStateModelMap() {
        List<StateModel> stateModels = this.stateModelDAO.findAllIncludingStates();
        HashMap<Integer, List<Integer>> stateModelMap = new HashMap<Integer, List<Integer>>();
        for (StateModel stateModel : stateModels) {
            List<State> states = stateModel.getStates();
            ArrayList<Integer> stateIds = new ArrayList<Integer>(states.size());
            for (State state : states) {
                stateIds.add(state.getPk().getId());
            }
            stateModelMap.put(stateModel.getId(), stateIds);
        }
        return stateModelMap;
    }

    @Business(viewType="both")
    public void createStateInterpretation(StateInterpretation stateInterpretation) {
        this.stateInterpretationDAO.createEntity(stateInterpretation);
    }

    @Business(viewType="both")
    public void updateStateInterpretation(StateInterpretation stateInterpretation) {
        this.stateInterpretationDAO.updateEntity(stateInterpretation);
    }

    @Business(viewType="both")
    public void removeStateInterpretation(int stateInterpretationId) {
        StateInterpretation stateInterpretation = (StateInterpretation)this.stateInterpretationDAO.findByPrimaryKey(stateInterpretationId);
        this.stateInterpretationDAO.removeEntity(stateInterpretation);
    }

    @Business(viewType="both")
    public StateInterpretation getStateInterpretation(int stateInterpretationId) {
        return (StateInterpretation)this.stateInterpretationDAO.findByPrimaryKey(stateInterpretationId);
    }

    public List<StateInterpretation> getStateInterpretations() {
        return this.stateInterpretationDAO.findAll();
    }

    @Business(viewType="both")
    public boolean isStateModelDataAvailable(int stateModelId) {
        return this.currentStateFacade.isStateModelDataInCache(stateModelId) || this.stateOutFacade.isStateModelDataInHistory(stateModelId);
    }

    @Business(viewType="both")
    public boolean isStateModelActive(int stateModelId) {
        StateModel stateModel = this.getStateModel(stateModelId);
        if (stateModel != null) {
            return stateModel.isActive();
        }
        return false;
    }

    @Business(viewType="both")
    public boolean isStateDataAvailable(int stateId) {
        return this.currentStateFacade.isStateDataInCache(stateId) || this.stateOutFacade.isStateDataInHistory(stateId);
    }

    @Business(viewType="both")
    @TransactionTimeout(value=900)
    public void deleteStateModelData(int stateModelId) {
        int i;
        StateModel stateModel = (StateModel)this.stateModelDAO.findByPrimaryKey(stateModelId);
        StateModel stateModelCopy = new StateModel(stateModel);
        List<Object> states = new ArrayList();
        states = stateModel.getStates();
        ArrayList<State> stateCopies = new ArrayList<State>();
        for (i = 0; i != states.size(); ++i) {
            stateCopies.add(new State((State)((Object)states.get(i))));
        }
        this.stateModelDAO.removeEntity(stateModel);
        this.stateModelDAO.createEntity(stateModelCopy);
        for (i = 0; i != stateCopies.size(); ++i) {
            this.stateDAO.createEntity((EntityBase)stateCopies.get(i));
        }
    }
}

