/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.keepalive;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.keepalive.KeepAliveHistory;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveCacheDAO;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveHistoryDAO;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeRemote;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveStamp;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="KeepAliveOutFacade")
@Remote(value={KeepAliveOutFacadeRemote.class})
@Local(value={KeepAliveOutFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/KeepAliveOutFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/KeepAliveOutFacade")
public class KeepAliveOutFacadeBean
implements KeepAliveOutFacadeLocal,
KeepAliveOutFacadeRemote {
    private static final Log log = LogFactory.getLog(KeepAliveOutFacadeBean.class);
    private static final String CONFIG_PARAM_NAME_TIMEOUT = "infoman.keepalive.timeout";
    private static final long DEFAULT_TIMEOUT = 300L;
    @PersistenceContext(unitName="rts")
    private EntityManager em = null;
    private KeepAliveCacheDAO keepAliveCacheDAO;
    private KeepAliveHistoryDAO keepAliveHistoryDAO;
    @EJB
    private UnitFacadeLocal unitFacadeLocal = null;
    @EJB
    private ConfigurationLocal configuration = null;
    private long timeout;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.keepAliveCacheDAO = KeepAliveCacheDAO.newInstance(this.em);
        this.keepAliveHistoryDAO = KeepAliveHistoryDAO.newInstance(this.em);
        this.initKeepAliveTimeOut();
    }

    protected UnitIdentity getUnitIdentity(long unitId) {
        UnitIdentity unit = this.unitFacadeLocal.getUnitIdentity(unitId);
        if (unit != null) {
            return unit;
        }
        UnitIdentity value = new UnitIdentity();
        value.setUnitId(unitId);
        value.setName("(n/a)");
        return value;
    }

    protected void initKeepAliveTimeOut() {
        try {
            String timeOutStr = this.configuration.getParameter(CONFIG_PARAM_NAME_TIMEOUT);
            this.timeout = Long.parseLong(timeOutStr);
        }
        catch (ConfigurationParameterNotFoundException ex) {
            log.debug((Object)"configuration parameter 'infoman.keepalive.timeout' not found. User default.", (Throwable)ex);
            this.timeout = 300L;
        }
        catch (NumberFormatException ex) {
            log.error((Object)"wrong value for 'infoman.keepalive.timeout'. Runs into", (Throwable)ex);
            this.timeout = 300L;
        }
        this.timeout *= 60000L;
    }

    @Override
    @Business(viewType="both")
    public long getKeepAliveTimeout() {
        return this.timeout;
    }

    @Override
    @Business(viewType="both")
    public Set getKeepAliveMessages(long basicUnitId, long requestedBeginTime, long requestedEndTime) {
        HashSet<KeepAliveStamp> allStamps;
        block7: {
            long currentTime;
            UnitIdentity unitIdentityData;
            block6: {
                allStamps = new HashSet<KeepAliveStamp>();
                unitIdentityData = this.getUnitIdentity(basicUnitId);
                this.initKeepAliveTimeOut();
                currentTime = requestedEndTime;
                try {
                    KeepAliveStamp cache = this.getKeepAliveMessageFromCache(unitIdentityData, currentTime);
                    if (cache.getTimeStamp() <= requestedEndTime) {
                        allStamps.add(cache);
                    }
                    if (cache.getTimeStamp() <= requestedBeginTime) {
                        return allStamps;
                    }
                }
                catch (FinderException ex) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("nothing found in cache for unitId: " + basicUnitId + " from: " + new Date(requestedBeginTime).toString() + " (" + requestedBeginTime + ") to: " + new Date(requestedEndTime).toString() + " (" + requestedEndTime + ")"));
                }
            }
            try {
                allStamps.addAll(this.getKeepAliveMessagesFromHistory(requestedBeginTime, requestedEndTime, unitIdentityData, currentTime));
            }
            catch (FinderException ex) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("nothing found in history for unitId: " + basicUnitId + " from: " + new Date(requestedBeginTime).toString() + " (" + requestedBeginTime + ") to: " + new Date(requestedEndTime).toString() + " (" + requestedEndTime + ")"));
            }
        }
        return allStamps;
    }

    @Override
    @Business(viewType="local")
    public Long getLastKeepAliveTimestamp(long basicUnitId) {
        KeepAliveCache keepAliveCache = (KeepAliveCache)this.keepAliveCacheDAO.findByPrimaryKey(basicUnitId);
        if (keepAliveCache != null) {
            return keepAliveCache.getBeginTime();
        }
        return null;
    }

    protected KeepAliveStamp getKeepAliveMessageFromCache(UnitIdentity unitIdentityData, long currentTime) throws FinderException {
        KeepAliveCache keepAliveCache = (KeepAliveCache)this.keepAliveCacheDAO.findByPrimaryKey(unitIdentityData.getUnitId());
        KeepAliveEvent evt = new KeepAliveEvent();
        evt.setUnitId(keepAliveCache.getUnitId());
        evt.setReceiveTimestamp(keepAliveCache.getReceiveTime());
        evt.setCreateTimestamp(keepAliveCache.getCreateTime());
        return this.createStamp(evt, unitIdentityData, currentTime);
    }

    protected Collection getKeepAliveMessagesFromHistory(long requestedBeginTime, long requestedEndTime, UnitIdentity unitIdentityData, long currentTime) throws FinderException {
        ArrayList<KeepAliveStamp> stamps = new ArrayList<KeepAliveStamp>();
        List<KeepAliveHistory> historyRecords = this.keepAliveHistoryDAO.findByUnitAndPeriod(unitIdentityData.getUnitId(), requestedBeginTime, requestedEndTime);
        for (KeepAliveHistory historyRecord : historyRecords) {
            KeepAliveEvent evt = new KeepAliveEvent();
            evt.setUnitId(historyRecord.getUnitId());
            evt.setReceiveTimestamp(historyRecord.getReceiveTime());
            evt.setCreateTimestamp(historyRecord.getCreateTime());
            stamps.add(this.createStamp(evt, unitIdentityData, currentTime));
        }
        return stamps;
    }

    protected KeepAliveStamp createStamp(KeepAliveEvent keepAliveEvent, UnitIdentity unitIdentityData, long currentTime) {
        long duration = currentTime - keepAliveEvent.getReceiveTimestamp();
        CurrentStateFacadeStruct state = this.currentStateFacade.getCurrentState(unitIdentityData.getUnitId(), 2110);
        return new KeepAliveStamp(keepAliveEvent.getReceiveTimestamp(), duration, state.getStateId(), unitIdentityData);
    }

    @Override
    @Business(viewType="both")
    public Collection<KeepAliveCache> findAll() {
        return this.keepAliveCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public Collection<KeepAliveCache> findByUnitGroupId(long unitGroupId) {
        return this.keepAliveCacheDAO.findByUnitGroupId(unitGroupId);
    }

    @Override
    @Business(viewType="both")
    public Collection<KeepAliveHistory> findByUnitAndPeriod(long unitId, long beginTime, long endTime) {
        return this.keepAliveHistoryDAO.findByUnitAndPeriod(unitId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public Collection<KeepAliveHistory> findByUnitGroupAndPeriod(long unitGroupId, long beginTime, long endTime) {
        return this.keepAliveHistoryDAO.findByUnitAndPeriod(unitGroupId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public Collection<KeepAliveHistory> findAllByPeriod(long beginTime, long endTime) {
        return this.keepAliveHistoryDAO.findAllByPeriod(beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public KeepAliveCache findByUnitId(long unitId) {
        return this.keepAliveCacheDAO.findByUnitId(unitId);
    }
}

