/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.AbstractHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.BeginStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.EndStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessages;
import de.proveo.wwt.logic.web.data.fastlanereader.TelemetryFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.util.List;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeoHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(GeoHandler.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    private static GeoHandler geoHandler = null;
    private static long lastPkGdataHistory = 0L;
    private boolean discardOldMessages = false;
    private boolean synchronizing = false;
    private long lastSentMessageId = -1L;
    private GdataFacadeLocal gdataFacadeLocal;
    private TelemetryFastLaneReader fastLaneTelemetry = new TelemetryFastLaneReader();

    private GeoHandler() {
        try {
            InitialContext context = new InitialContext();
            this.gdataFacadeLocal = (GdataFacadeLocal)context.lookup("rts/GdataFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public static GeoHandler getInstance() {
        if (geoHandler == null) {
            geoHandler = new GeoHandler();
        }
        return geoHandler;
    }

    @Override
    public void handleEvent(SerializableEventWrapper wrapper) throws MessageNotSentException {
        log.debug((Object)"handle event");
        long startTime = System.currentTimeMillis();
        if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
            long pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
            if (pkGdataHistoryPre < lastPkGdataHistory) {
                log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + lastPkGdataHistory + ")"));
            }
            lastPkGdataHistory = pkGdataHistoryPre;
        }
        GdataCache geo = null;
        if (wrapper.get_cacheValue() instanceof GdataCache) {
            geo = (GdataCache)wrapper.get_cacheValue();
        }
        if (geo != null) {
            boolean sendData = UnitHelper.isSendData(geo.getUnitId());
            if (sendData) {
                try {
                    TelemetryDataMessage xmlMsg = new TelemetryDataMessage(geo);
                    long messageID = geo.getHistoryId();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("handleEvent() - messageId: " + messageID + " unitId: " + geo.getUnitId()));
                    }
                    this.sendTextMessage(xmlMsg.toString());
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    throw new MessageNotSentException();
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("geo event " + geo.getHistoryId() + " not sent for unit " + geo.getUnitId()));
            }
        } else {
            log.error((Object)"geoStruct is null");
        }
        long duration = System.currentTimeMillis() - startTime;
        log.trace((Object)("handle event finished after " + duration + " ms"));
    }

    public void pushCache(long minId) throws TOWhileSyncException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"pushCache()");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"beginGeoStock");
        }
        BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.GEO);
        this.sendTextMessage(beginStockPart.toString());
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.GEO);
        long maxId = 0L;
        List<PositionDTO> list = this.fastLaneTelemetry.getCurrentGeoCache();
        for (PositionDTO positionDTO : list) {
            if (positionDTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(positionDTO.getUnitId());
                if (!sendData) continue;
                maxId = positionDTO.getId();
                xmlMsgs.add(new TelemetryDataMessage(positionDTO));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (!xmlMsgs.isEmpty()) {
            this.sendTextMessage(xmlMsgs.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setLastSentMessageId('" + maxId + "')"));
        }
        this.setLastSentMessageId(maxId);
        this.setSynchronizing(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)"endGeoStock: ");
        }
        EndStockPart endStockPart = new EndStockPart(Enums.EventType.GEO);
        this.sendTextMessage(endStockPart.toString());
    }

    public long getMaxHistoryId() throws TOWhileSyncException {
        try {
            log.debug((Object)"try getMaxHistoryId...");
            return this.gdataFacadeLocal.getMaxId();
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getMaxHistoryId runs into", (Throwable)e);
            return -1L;
        }
    }

    public TelemetryDataMessages getStockPart(long from, long until) throws TOWhileSyncException {
        long requestedUntil = until;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGeoStockPart from " + from + " until " + until));
        }
        long maxHistoryId = this.getMaxHistoryId();
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.GEO);
        until = requestedUntil;
        int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
        if (until > from + (long)maxMessageCount - 1L) {
            until = from + (long)maxMessageCount - 1L;
        }
        if (until > maxHistoryId) {
            until = maxHistoryId;
        }
        List<PositionDTO> list = this.fastLaneTelemetry.getGdataHistory(from, until);
        for (PositionDTO positionDTO : list) {
            if (positionDTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(positionDTO.getUnitId());
                if (sendData) {
                    xmlMsgs.add(new TelemetryDataMessage(positionDTO));
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("geo event " + positionDTO.getId() + " not sent for unit: " + positionDTO.getUnitId()));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        xmlMsgs.setFrom(from);
        xmlMsgs.setUntil(until);
        return xmlMsgs;
    }

    public TelemetryDataMessages getGeosForUnit(String unitName, TDITimestamp startTime, TDITimestamp endTime) throws TOWhileSyncException, TooMuchDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGeosForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        }
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.GEO);
        try {
            long unitId = UnitHelper.getUnitId(unitName);
            log.debug((Object)("unitId: " + unitId));
            List<GdataHistory> gdataHistoryCol = this.gdataFacadeLocal.findByUnitBeginEnd(unitId, startTime.getTimestamp(), endTime.getTimestamp());
            int size = gdataHistoryCol.size();
            log.debug((Object)("gdataHistoryCol.size: " + size));
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            if (size > maxMessageCount) {
                throw new TooMuchDataException();
            }
            for (GdataHistory gdataHistory : gdataHistoryCol) {
                if (gdataHistory == null) continue;
                try {
                    boolean sendData;
                    GdataHistory geoEvent = gdataHistory;
                    GeoStruct geoStruct = gdataHistory.getStruct();
                    if (geoEvent == null || !(sendData = UnitHelper.isSendData(geoEvent.getUnitId()))) continue;
                    xmlMsgs.add(new TelemetryDataMessage(geoStruct));
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    if (this.isTimeoutException(e)) {
                        throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                    }
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return xmlMsgs;
    }

    @Override
    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    @Override
    public void setDiscardOldMessages(boolean discardOldMessages) {
        this.discardOldMessages = discardOldMessages;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    @Override
    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    public void setLastSentMessageId(long lastSentMessageId) {
        this.lastSentMessageId = lastSentMessageId;
    }

    public static void undeploy() {
        if (geoHandler != null) {
            geoHandler.shutDownQueue();
            geoHandler = null;
        }
    }
}

