/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataErrorLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataInSessionLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataInSessionRemote;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataRegistrationLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataStockLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.ClientNotRegisteredException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.InterfaceNotActiveExcption;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.TDITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.ErrorMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.SAXDocument;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RegisterTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestGeoStockTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestGeosForUnitTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestNotifiesForUnitTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestNotifyStockTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestStateStockTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestStatesForUnitTelegramHandler;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;
import org.xml.sax.SAXException;

@Stateless(name="TelemetryDataInSession")
@Remote(value={TelemetryDataInSessionRemote.class})
@Local(value={TelemetryDataInSessionLocal.class})
@JndiLocalBinding(localJndiBinding="rts/TelemetryDataInSession")
@JndiRemoteBinding(remoteJndiBinding="rts/TelemetryDataInSession")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class TelemetryDataInSessionBean
implements TelemetryDataInSessionLocal,
TelemetryDataInSessionRemote {
    private static final Log log = LogFactory.getLog(TelemetryDataInSessionBean.class);
    private TDIConfiguration config = TDIConfiguration.getInstance();
    @EJB
    private TelemetryDataErrorLocal errorLocalBean = null;
    @EJB
    private TelemetryDataRegistrationLocal registrationLocalBean = null;
    @EJB
    private TelemetryDataStockLocal stockLocalBean = null;
    @EJB
    private TelemetryPingTimerLocal pingTimer = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
    }

    @Override
    @Business(viewType="both")
    public void parse(String xml) {
        log.debug((Object)("parse XML " + xml));
        SAXDocument document = new SAXDocument(xml);
        try {
            if (xml.contains(this.config.getString("xml.ping.xmlName"))) {
                this.ping();
            } else if (xml.contains(this.config.getString("xml.unregister.xmlName"))) {
                this.unregister();
            } else if (xml.contains(this.config.getString("xml.register.xmlName"))) {
                this.register(document);
            } else if (xml.contains(this.config.getString("xml.requestStateStock.xmlName"))) {
                this.requestStateStock(document, false);
            } else if (xml.contains(this.config.getString("xml.requestStatesForUnit.xmlName"))) {
                this.requestStatesForUnit(document, false);
            } else if (xml.contains(this.config.getString("xml.requestGeoStock.xmlName"))) {
                this.requestGeoStock(document, false);
            } else if (xml.contains(this.config.getString("xml.requestGeosForUnit.xmlName"))) {
                this.requestGeosForUnit(document, false);
            } else if (xml.contains(this.config.getString("xml.requestNotifyStock.xmlName"))) {
                this.requestNotifyStock(document, false);
            } else if (xml.contains(this.config.getString("xml.requestNotifiesForUnit.xmlName"))) {
                this.requestNotifiesForUnit(document, false);
            } else if (xml.contains(this.config.getString("xml.errStateStock.xmlName"))) {
                this.requestStateStock(document, true);
            } else if (xml.contains(this.config.getString("xml.errGeoStock.xmlName"))) {
                this.requestGeoStock(document, true);
            } else if (xml.contains(this.config.getString("xml.errNotifyStock.xmlName"))) {
                this.requestNotifyStock(document, true);
            } else {
                log.warn((Object)"Telegram doesn't contain a valid method name.");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.UNKNOWN_METHOD, "%1s", document);
                this.errorLocalBean.sendErrorMessage(errMsg);
            }
        }
        catch (ClientNotRegisteredException e) {
            log.debug((Object)"client not registered");
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NOT_REGISTERED, "%1s", document);
            this.errorLocalBean.sendErrorMessage(errMsg);
        }
        catch (InterfaceNotActiveExcption e) {
            log.debug((Object)"Telemetry data interface is not active!");
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.INTERFACE_NOT_ACTIVE, "%1s", document);
            this.errorLocalBean.sendErrorMessage(errMsg);
        }
    }

    @Override
    @Business(viewType="both")
    public void ping() {
        this.pingTimer.ping();
    }

    @Override
    @Business(viewType="both")
    public void register(long lastGeo, long lastState, long lastNotify) throws TOWhileSyncException {
        log.debug((Object)("register() - lastGeo=" + lastGeo + " lastState=" + lastState + " lastNotify=" + lastNotify));
        this.registrationLocalBean.register(lastGeo, lastState, lastNotify);
    }

    @Override
    @Business(viewType="both")
    public void register(SAXDocument saxDoc) {
        RegisterTelegramHandler handler = new RegisterTelegramHandler();
        try {
            ErrorMessage errMsg;
            ErrorMessage errMsg2;
            HashMap<String, Object> result = saxDoc.parse(handler);
            long lastGeo = -1L;
            long lastState = -1L;
            long lastNotify = -1L;
            if (this.config.getBoolean("geo.active")) {
                try {
                    if (result.containsKey("lastGeo")) {
                        String lastGeoString = (String)result.get("lastGeo");
                        lastGeo = Long.parseLong(lastGeoString);
                    } else {
                        log.debug((Object)"missing parameter lastGeo");
                        errMsg2 = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s: lastGeo", saxDoc);
                        errMsg2.addParameter(this.config.getString("xml.register.lastGeo.xmlName"), null);
                        this.sendErrorMessage(errMsg2);
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)("incorrect number format of parameter lastGeo:" + result.get("lastGeo")));
                    errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s lastGeo:" + result.get("lastGeo"), saxDoc);
                    errMsg.addParameter(this.config.getString("xml.register.lastGeo.xmlName"), (String)result.get("lastGeo"));
                    this.sendErrorMessage(errMsg);
                }
            }
            if (this.config.getBoolean("state.active")) {
                try {
                    if (result.containsKey("lastState")) {
                        String lastStateString = (String)result.get("lastState");
                        lastState = Long.parseLong(lastStateString);
                    } else {
                        log.debug((Object)"missing parameter lastState");
                        errMsg2 = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s: lastState", saxDoc);
                        errMsg2.addParameter(this.config.getString("xml.register.lastState.xmlName"), null);
                        this.sendErrorMessage(errMsg2);
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)("incorrect number format of parameter lastState:" + result.get("lastState")));
                    errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s lastState:" + result.get("lastState"), saxDoc);
                    errMsg.addParameter(this.config.getString("xml.register.lastState.xmlName"), (String)result.get("lastState"));
                    this.sendErrorMessage(errMsg);
                }
            }
            if (this.config.getBoolean("notify.active")) {
                try {
                    if (result.containsKey("lastNotify")) {
                        String lastNotifyString = (String)result.get("lastNotify");
                        lastNotify = Long.parseLong(lastNotifyString);
                    } else {
                        log.debug((Object)"missing parameter lastNotify");
                        errMsg2 = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s: lastNotify", saxDoc);
                        errMsg2.addParameter(this.config.getString("xml.register.lastNotify.xmlName"), null);
                        this.sendErrorMessage(errMsg2);
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)("incorrect number format of parameter lastNotify:" + result.get("lastNotify")));
                    errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s lastNotify:" + result.get("lastNotify"), saxDoc);
                    errMsg.addParameter(this.config.getString("xml.register.lastNotify.xmlName"), (String)result.get("lastNotify"));
                    this.sendErrorMessage(errMsg);
                }
            }
            try {
                this.register(lastGeo, lastState, lastNotify);
            }
            catch (TOWhileSyncException e) {
                log.error((Object)"register runs into", (Throwable)e);
                errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", saxDoc);
                this.sendErrorMessage(errMsg);
            }
        }
        catch (SAXException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
            errMsg.setExceptionMessage(e.getMessage());
            this.sendErrorMessage(errMsg);
        }
        catch (IOException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
            errMsg.setExceptionMessage(e.getMessage());
            this.sendErrorMessage(errMsg);
        }
    }

    private void sendErrorMessage(ErrorMessage errorMessage) {
        this.errorLocalBean.sendErrorMessage(errorMessage);
    }

    @Override
    @Business(viewType="both")
    public void unregister() throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.registrationLocalBean.unregister();
    }

    @Override
    @Business(viewType="local")
    public void requestStateStock(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        block16: {
            this.checkActiveAndRegistered();
            RequestStateStockTelegramHandler handler = new RequestStateStockTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("whichData")) {
                    try {
                        String whichData = (String)result.get("whichData");
                        if (error) {
                            String errorText = (String)result.get("errorText");
                            this.errStateStock(whichData, errorText);
                            break block16;
                        }
                        this.requestStateStock(whichData);
                    }
                    catch (IllegalArgumentException e) {
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s whichData", saxDoc, e.getMessage(), Enums.EventType.STATE, (String)result.get("whichData"));
                        this.errorLocalBean.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                if (result.containsKey("from") && result.containsKey("until")) {
                    try {
                        long from = Long.parseLong((String)result.get("from"));
                        try {
                            long until = Long.parseLong((String)result.get("until"));
                            if (error) {
                                Range whichData = new Range(from, until);
                                String errorText = (String)result.get("errorText");
                                this.errStateStock(whichData.toString(), errorText);
                            } else {
                                this.requestStateStock(from, until);
                            }
                            break block16;
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)("incorrect number format of parameter until:" + result.get("until")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s until:" + result.get("until"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestStateStock.until.xmlName"), (String)result.get("until"));
                            this.sendErrorMessage(errMsg);
                        }
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("incorrect number format of parameter from:" + result.get("from")));
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s from:" + result.get("from"), saxDoc);
                        errMsg.addParameter(this.config.getString("xml.requestStateStock.from.xmlName"), (String)result.get("from"));
                        this.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                if (!result.containsKey("from")) {
                    errMsg.addParameter(this.config.getString("xml.requestStateStock.from.xmlName"), null);
                }
                if (!result.containsKey("until")) {
                    errMsg.addParameter(this.config.getString("xml.requestStateStock.until.xmlName"), null);
                }
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void requestStateStock(String whichData) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        Range range = new Range(whichData);
        this.requestStateStock(range.getFrom(), range.getUntil());
    }

    @Override
    @Business(viewType="both")
    public void requestStateStock(long from, long until) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        this.stockLocalBean.requestStateStock(from, until);
    }

    @Override
    @Business(viewType="local")
    public void requestStatesForUnit(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        block14: {
            this.checkActiveAndRegistered();
            RequestStatesForUnitTelegramHandler handler = new RequestStatesForUnitTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("unitName")) {
                    String unitName = (String)result.get("unitName");
                    if (result.containsKey("startTime") && result.containsKey("endTime")) {
                        try {
                            TDITimestamp startTimestamp = new TDITimestamp((String)result.get("startTime"));
                            try {
                                TDITimestamp endTimestamp = new TDITimestamp((String)result.get("endTime"));
                                if (error) {
                                    String errorText = (String)result.get("errorText");
                                    this.errStatesForUnit(unitName, startTimestamp, endTimestamp, errorText);
                                } else {
                                    this.requestStatesForUnit(unitName, startTimestamp, endTimestamp);
                                }
                                break block14;
                            }
                            catch (ParseException e) {
                                log.debug((Object)("incorrect number format of parameter endTime:" + result.get("endTime")));
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s endTime:" + result.get("endTime"), saxDoc);
                                errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.endTime.xmlName"), (String)result.get("endTime"));
                                this.sendErrorMessage(errMsg);
                                break block14;
                            }
                            catch (TooMuchDataException e) {
                                log.warn((Object)"too much data");
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TOO_MUCH_DATA, "%1s", saxDoc);
                                errMsg.setSynchronizationDetails(Enums.EventType.STATE, unitName, startTimestamp, startTimestamp);
                                this.sendErrorMessage(errMsg);
                            }
                        }
                        catch (ParseException e) {
                            log.debug((Object)("incorrect number format of parameter startTime:" + result.get("startTime")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s startTime:" + result.get("startTime"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.startTime.xmlName"), (String)result.get("startTime"));
                            this.sendErrorMessage(errMsg);
                        }
                        break block14;
                    }
                    log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                    ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                    if (!result.containsKey("startTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.startTime.xmlName"), null);
                    }
                    if (!result.containsKey("endTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.endTime.xmlName"), null);
                    }
                    this.sendErrorMessage(errMsg);
                    break block14;
                }
                log.debug((Object)"requestStatesForUnit doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.unitName.xmlName"), null);
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void requestStatesForUnit(String unitName, String startTime, String endTime) throws ClientNotRegisteredException, ParseException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        TDITimestamp startTimestamp = new TDITimestamp(startTime);
        TDITimestamp endTimestamp = new TDITimestamp(endTime);
        this.stockLocalBean.requestStatesForUnit(unitName, startTimestamp, endTimestamp);
    }

    @Override
    @Business(viewType="local")
    public void requestStatesForUnit(String unitName, TDITimestamp startTimestamp, TDITimestamp endTimestamp) throws ClientNotRegisteredException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        this.stockLocalBean.requestStatesForUnit(unitName, startTimestamp, endTimestamp);
    }

    @Override
    @Business(viewType="local")
    public void requestGeoStock(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        block16: {
            this.checkActiveAndRegistered();
            RequestGeoStockTelegramHandler handler = new RequestGeoStockTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("whichData")) {
                    try {
                        String whichData = (String)result.get("whichData");
                        if (error) {
                            String errorText = (String)result.get("errorText");
                            this.errGeoStock(whichData, errorText);
                            break block16;
                        }
                        this.requestGeoStock(whichData);
                    }
                    catch (IllegalArgumentException e) {
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s whichData", saxDoc, e.getMessage(), Enums.EventType.GEO, (String)result.get("whichData"));
                        this.errorLocalBean.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                if (result.containsKey("from") && result.containsKey("until")) {
                    try {
                        long from = Long.parseLong((String)result.get("from"));
                        try {
                            long until = Long.parseLong((String)result.get("until"));
                            if (error) {
                                Range whichData = new Range(from, until);
                                String errorText = (String)result.get("errorText");
                                this.errGeoStock(whichData.toString(), errorText);
                            } else {
                                this.requestGeoStock(from, until);
                            }
                            break block16;
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)("incorrect number format of parameter until:" + result.get("until")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s until:" + result.get("until"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestGeoStock.until.xmlName"), (String)result.get("until"));
                            this.sendErrorMessage(errMsg);
                        }
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("incorrect number format of parameter from:" + result.get("from")));
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s from:" + result.get("from"), saxDoc);
                        errMsg.addParameter(this.config.getString("xml.requestGeoStock.from.xmlName"), (String)result.get("from"));
                        this.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                log.debug((Object)"requestGeoStock doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                if (!result.containsKey("from")) {
                    errMsg.addParameter(this.config.getString("xml.requestGeoStock.from.xmlName"), null);
                }
                if (!result.containsKey("until")) {
                    errMsg.addParameter(this.config.getString("xml.requestGeoStock.until.xmlName"), null);
                }
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void requestGeoStock(String whichData) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        Range range = new Range(whichData);
        this.requestGeoStock(range.getFrom(), range.getUntil());
    }

    @Override
    @Business(viewType="both")
    public void requestGeoStock(long from, long until) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        this.stockLocalBean.requestGeoStock(from, until);
    }

    @Override
    @Business(viewType="local")
    public void requestGeosForUnit(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        block14: {
            this.checkActiveAndRegistered();
            RequestGeosForUnitTelegramHandler handler = new RequestGeosForUnitTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("unitName")) {
                    String unitName = (String)result.get("unitName");
                    if (result.containsKey("startTime") && result.containsKey("endTime")) {
                        try {
                            TDITimestamp startTimestamp = new TDITimestamp((String)result.get("startTime"));
                            try {
                                TDITimestamp endTimestamp = new TDITimestamp((String)result.get("endTime"));
                                if (error) {
                                    String errorText = (String)result.get("errorText");
                                    this.errGeosForUnit(unitName, startTimestamp, endTimestamp, errorText);
                                } else {
                                    this.requestGeosForUnit(unitName, startTimestamp, endTimestamp);
                                }
                                break block14;
                            }
                            catch (ParseException e) {
                                log.debug((Object)("incorrect number format of parameter endTime:" + result.get("endTime")));
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s endTime:" + result.get("endTime"), saxDoc);
                                errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.endTime.xmlName"), (String)result.get("endTime"));
                                this.sendErrorMessage(errMsg);
                                break block14;
                            }
                            catch (TooMuchDataException e) {
                                log.warn((Object)"too much data");
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TOO_MUCH_DATA, "%1s", saxDoc);
                                errMsg.setSynchronizationDetails(Enums.EventType.GEO, unitName, startTimestamp, startTimestamp);
                                this.sendErrorMessage(errMsg);
                            }
                        }
                        catch (ParseException e) {
                            log.debug((Object)("incorrect number format of parameter startTime:" + result.get("startTime")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s startTime:" + result.get("startTime"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.startTime.xmlName"), (String)result.get("startTime"));
                            this.sendErrorMessage(errMsg);
                        }
                        break block14;
                    }
                    log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                    ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                    if (!result.containsKey("startTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.startTime.xmlName"), null);
                    }
                    if (!result.containsKey("endTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.endTime.xmlName"), null);
                    }
                    this.sendErrorMessage(errMsg);
                    break block14;
                }
                log.debug((Object)"requestGeosForUnit doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.unitName.xmlName"), null);
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void requestGeosForUnit(String unitName, String startTime, String endTime) throws ClientNotRegisteredException, ParseException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        TDITimestamp startTimestamp = new TDITimestamp(startTime);
        TDITimestamp endTimestamp = new TDITimestamp(endTime);
        this.stockLocalBean.requestGeosForUnit(unitName, startTimestamp, endTimestamp);
    }

    @Override
    @Business(viewType="local")
    public void requestGeosForUnit(String unitName, TDITimestamp startTimestamp, TDITimestamp endTimestamp) throws ClientNotRegisteredException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        this.stockLocalBean.requestGeosForUnit(unitName, startTimestamp, endTimestamp);
    }

    @Override
    @Business(viewType="local")
    public void requestNotifyStock(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        block16: {
            this.checkActiveAndRegistered();
            RequestNotifyStockTelegramHandler handler = new RequestNotifyStockTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("whichData")) {
                    try {
                        String whichData = (String)result.get("whichData");
                        if (error) {
                            String errorText = (String)result.get("errorText");
                            this.errNotifyStock(whichData, errorText);
                            break block16;
                        }
                        this.requestNotifyStock(whichData);
                    }
                    catch (IllegalArgumentException e) {
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s whichData", saxDoc, e.getMessage(), Enums.EventType.NOTIFY, (String)result.get("whichData"));
                        this.errorLocalBean.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                if (result.containsKey("from") && result.containsKey("until")) {
                    try {
                        long from = Long.parseLong((String)result.get("from"));
                        try {
                            long until = Long.parseLong((String)result.get("until"));
                            if (error) {
                                Range whichData = new Range(from, until);
                                String errorText = (String)result.get("errorText");
                                this.errNotifyStock(whichData.toString(), errorText);
                            } else {
                                this.requestNotifyStock(from, until);
                            }
                            break block16;
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)("incorrect number format of parameter until:" + result.get("until")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s until:" + result.get("until"), saxDoc);
                            errMsg.addParameter("until", (String)result.get("until"));
                            this.sendErrorMessage(errMsg);
                        }
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("incorrect number format of parameter from:" + result.get("from")));
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s from:" + result.get("from"), saxDoc);
                        errMsg.addParameter("from", (String)result.get("from"));
                        this.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                log.debug((Object)"requestNotifyStock doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                if (!result.containsKey("from")) {
                    errMsg.addParameter("from", null);
                }
                if (!result.containsKey("until")) {
                    errMsg.addParameter("until", null);
                }
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void requestNotifyStock(String whichData) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        Range range = new Range(whichData);
        this.requestNotifyStock(range.getFrom(), range.getUntil());
    }

    @Override
    @Business(viewType="both")
    public void requestNotifyStock(long from, long until) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        this.stockLocalBean.requestNotifyStock(from, until);
    }

    @Override
    @Business(viewType="local")
    public void requestNotifiesForUnit(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        block14: {
            this.checkActiveAndRegistered();
            RequestNotifiesForUnitTelegramHandler handler = new RequestNotifiesForUnitTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("unitName")) {
                    String unitName = (String)result.get("unitName");
                    if (result.containsKey("startTime") && result.containsKey("endTime")) {
                        try {
                            TDITimestamp startTimestamp = new TDITimestamp((String)result.get("startTime"));
                            try {
                                TDITimestamp endTimestamp = new TDITimestamp((String)result.get("endTime"));
                                if (error) {
                                    String errorText = (String)result.get("errorText");
                                    this.errNotifiesForUnit(unitName, startTimestamp, endTimestamp, errorText);
                                } else {
                                    this.requestNotifiesForUnit(unitName, startTimestamp, endTimestamp);
                                }
                                break block14;
                            }
                            catch (ParseException e) {
                                log.debug((Object)("incorrect number format of parameter endTime:" + result.get("endTime")));
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s endTime:" + result.get("endTime"), saxDoc);
                                errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.endTime.xmlName"), (String)result.get("endTime"));
                                this.sendErrorMessage(errMsg);
                                break block14;
                            }
                            catch (TooMuchDataException e) {
                                log.warn((Object)"too much data");
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TOO_MUCH_DATA, "%1s", saxDoc);
                                errMsg.setSynchronizationDetails(Enums.EventType.NOTIFY, unitName, startTimestamp, startTimestamp);
                                this.sendErrorMessage(errMsg);
                            }
                        }
                        catch (ParseException e) {
                            log.debug((Object)("incorrect number format of parameter startTime:" + result.get("startTime")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s startTime:" + result.get("startTime"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.startTime.xmlName"), (String)result.get("startTime"));
                            this.sendErrorMessage(errMsg);
                        }
                        break block14;
                    }
                    log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                    ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                    if (!result.containsKey("startTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.startTime.xmlName"), null);
                    }
                    if (!result.containsKey("endTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.endTime.xmlName"), null);
                    }
                    this.sendErrorMessage(errMsg);
                    break block14;
                }
                log.debug((Object)"requestNotifiesForUnit doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.unitName.xmlName"), null);
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public void requestNotifiesForUnit(String unitName, String startTime, String endTime) throws ClientNotRegisteredException, ParseException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        TDITimestamp startTimestamp = new TDITimestamp(startTime);
        TDITimestamp endTimestamp = new TDITimestamp(endTime);
        this.stockLocalBean.requestNotifiesForUnit(unitName, startTimestamp, endTimestamp);
    }

    @Override
    @Business(viewType="local")
    public void requestNotifiesForUnit(String unitName, TDITimestamp startTimestamp, TDITimestamp endTimestamp) throws ClientNotRegisteredException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        this.stockLocalBean.requestNotifiesForUnit(unitName, startTimestamp, endTimestamp);
    }

    @Override
    @Business(viewType="both")
    public void errStateStock(String whichData, String errorText) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        int errorCount = this.errorLocalBean.errStateStock(whichData, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestStateStock(whichData);
        } else {
            log.error((Object)"could not get state stock (max. re-tries exceeded)");
        }
    }

    @Override
    @Business(viewType="both")
    public void errGeoStock(String whichData, String errorText) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        int errorCount = this.errorLocalBean.errGeoStock(whichData, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestGeoStock(whichData);
        } else {
            log.error((Object)"could not get geo stock (max. re-tries exceeded)");
        }
    }

    @Override
    @Business(viewType="both")
    public void errNotifyStock(String whichData, String errorText) throws ClientNotRegisteredException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        int errorCount = this.errorLocalBean.errNotifyStock(whichData, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestNotifyStock(whichData);
        } else {
            log.error((Object)"could not get notify stock (max. re-tries exceeded)");
        }
    }

    @Override
    @Business(viewType="both")
    public void errStatesForUnit(String unitName, TDITimestamp startTime, TDITimestamp endTime, String errorText) throws ClientNotRegisteredException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        int errorCount = this.errorLocalBean.errStatesForUnit(unitName, startTime, endTime, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestStatesForUnit(unitName, startTime, endTime);
        } else {
            log.error((Object)"could not get state events for unit (max. re-tries exceeded)");
        }
    }

    @Override
    @Business(viewType="both")
    public void errGeosForUnit(String unitName, TDITimestamp startTime, TDITimestamp endTime, String errorText) throws ClientNotRegisteredException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        int errorCount = this.errorLocalBean.errGeosForUnit(unitName, startTime, endTime, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestGeosForUnit(unitName, startTime, endTime);
        } else {
            log.error((Object)"could not get geo events for unit (max. re-tries exceeded)");
        }
    }

    @Override
    @Business(viewType="both")
    public void errNotifiesForUnit(String unitName, TDITimestamp startTime, TDITimestamp endTime, String errorText) throws ClientNotRegisteredException, TooMuchDataException, InterfaceNotActiveExcption {
        this.checkActiveAndRegistered();
        int errorCount = this.errorLocalBean.errNotifiesForUnit(unitName, startTime, endTime, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestNotifiesForUnit(unitName, startTime, endTime);
        } else {
            log.error((Object)"could not get geo events for unit (max. re-tries exceeded)");
        }
    }

    private void checkActiveAndRegistered() throws InterfaceNotActiveExcption, ClientNotRegisteredException {
        if (!this.isTelemetryDataActive()) {
            throw new InterfaceNotActiveExcption();
        }
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
    }

    @Override
    @Business(viewType="both")
    public boolean isTelemetryDataActive() {
        return this.config.isTelemetryDataActive();
    }

    @Override
    @Business(viewType="both")
    public void init() {
        if (this.config.getBoolean("active")) {
            log.debug((Object)"init()");
        }
    }
}

