/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance.notify;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MessageHelper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.NotifyHandler;
import java.io.Serializable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageDistributor
implements MessageListener {
    private static final Log log = LogFactory.getLog(MessageDistributor.class);
    private MIConfiguration config = MIConfiguration.getInstance();
    private static MessageDistributor instance = null;
    public static final String QUEUE_NAME = "queue/maintenanceBufferQueue";
    private QueueConnectionFactory connectionFactory = null;
    private QueueConnection queueConnection = null;
    private static long lastPkGdataHistory = 0L;
    private QueueSession queueSession = null;

    private MessageDistributor() {
        log.debug((Object)"MessageDistributor() - Constructor");
        this.initialize();
    }

    public static MessageDistributor getInstance() {
        if (instance == null) {
            instance = new MessageDistributor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        log.debug((Object)"initialize");
        try {
            InitialContext ctx = new InitialContext();
            this.connectionFactory = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
            this.queueConnection = this.connectionFactory.createQueueConnection();
            try {
                Queue queue;
                this.queueConnection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
                this.queueSession = this.queueConnection.createQueueSession(false, 1);
                try {
                    log.debug((Object)"lookup queue queue/maintenanceBufferQueue");
                    queue = (Queue)ctx.lookup(QUEUE_NAME);
                }
                catch (NameNotFoundException ex) {
                    log.debug((Object)"queue not found, create new");
                    queue = this.queueSession.createQueue(QUEUE_NAME);
                    ctx.bind(QUEUE_NAME, (Object)queue);
                }
                QueueReceiver queueReceiver = this.queueSession.createReceiver(queue, this.getSelector());
                queueReceiver.setMessageListener((MessageListener)this);
                return true;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                try {
                    this.queueConnection.close();
                }
                catch (JMSException jMSException) {
                }
                finally {
                    ctx.close();
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        this.start();
        return false;
    }

    private String getSelector() {
        String selector = "";
        if (this.config.getBoolean("notify.active")) {
            if (selector.length() > 0) {
                selector = selector + " OR ";
            }
            selector = selector + "TypeOfInterest='InfomanNotifyMessages'";
        }
        log.debug((Object)("selector: " + selector));
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        this.config.setOnMessageRunning(true);
        log.debug((Object)"onMessage()");
        if (this.config.isMessageSenderStopped()) {
            log.warn((Object)"onMessage called although MessageSender is stopped!");
        } else {
            log.trace((Object)"MessageSender is not stopped");
        }
        if (this.config.isIgnoreMessages()) {
            log.debug((Object)"ignore messages");
        }
        if (!this.config.isIgnoreMessages() && !this.config.isMessageSenderStopped()) {
            SerializableEventWrapper wrapper = MessageHelper.getSerializableEventWrapper(msg);
            if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
                long pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
                if (pkGdataHistoryPre < lastPkGdataHistory) {
                    log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + lastPkGdataHistory + ")"));
                }
                lastPkGdataHistory = pkGdataHistoryPre;
            }
            try {
                if (this.isClientRegistered()) {
                    this.distributeMessage(msg);
                }
            }
            catch (MessageNotSentException e) {
                log.error((Object)"runs into", (Throwable)e);
                log.info((Object)"Stopping MessageSender in cause of MessageNotSentException...");
                this.stop();
                log.info((Object)"...MessageSender stopped by itself");
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                log.info((Object)"Stopping MessageSender in cause of Exception...");
                this.stop();
                log.info((Object)"...MessageSender stopped by itself");
            }
            finally {
                this.config.setOnMessageRunning(false);
            }
        }
        this.config.setOnMessageRunning(false);
    }

    public void start() {
        if (this.config.isMessageSenderStopped()) {
            log.debug((Object)"start()");
            this.config.setMessageSenderStopped(false);
            if (this.queueConnection == null) {
                this.initialize();
            }
            try {
                this.queueConnection.start();
            }
            catch (JMSException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        } else {
            log.debug((Object)"MessageDistributor already started.");
        }
    }

    public void stop() {
        if (!this.config.isMessageSenderStopped()) {
            log.debug((Object)"stop()");
            this.config.setMessageSenderStopped(true);
            try {
                if (this.queueConnection != null) {
                    this.queueConnection.stop();
                }
            }
            catch (JMSException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public boolean isStopped() {
        return this.config.isMessageSenderStopped();
    }

    private void distributeMessage(Message msg) throws MessageNotSentException {
        try {
            Serializable object = ((ObjectMessage)msg).getObject();
            SerializableEventWrapper event = (SerializableEventWrapper)object;
            if (log.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("sendMessage() - ");
                stringBuilder.append("event type = ");
                stringBuilder.append(event.get_typeOfEvent());
                log.debug((Object)stringBuilder.toString());
            }
            if (event.get_typeOfEvent().equals("InfomanNotifyMessages") && this.config.getBoolean("notify.active")) {
                log.debug((Object)"handle notify event");
                NotifyHandler notifyHandler = NotifyHandler.getInstance();
                if (notifyHandler.isDiscardOldMessages()) {
                    log.debug((Object)("msgId = " + MessageHelper.getMessageId(msg)));
                    log.debug((Object)("lastSentMessageId = " + notifyHandler.getLastSentMessageId()));
                    if (MessageHelper.getMessageId(msg) > notifyHandler.getLastSentMessageId()) {
                        notifyHandler.handleEvent(event);
                        notifyHandler.setDiscardOldMessages(false);
                    } else {
                        log.debug((Object)("discard old message with id " + MessageHelper.getMessageId(msg)));
                    }
                } else {
                    notifyHandler.handleEvent(event);
                }
            }
        }
        catch (JMSException e) {
            log.error((Object)"sendMessage() runs into", (Throwable)e);
        }
    }

    public void shutDown() {
        try {
            while (this.config.isOnMessageRunning()) {
                log.info((Object)"MessageSender - Wait for finishing JMS activity.");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"MessageSender - Waiting interrupted.");
                }
            }
            if (!this.config.isMessageSenderStopped()) {
                log.info((Object)"MessageSender - Stopping Connection.");
                this.queueConnection.stop();
                this.config.setMessageSenderStopped(true);
            }
            log.info((Object)"MessageSender - Closing QueueConnection.");
            this.queueConnection.close();
            log.info((Object)"MessageSender - Closing Session.");
            this.queueSession.close();
            log.info((Object)"MessageSender - Shutdown finished.");
        }
        catch (Exception e) {
            log.error((Object)"MessageSender - Exception while shutdown.", (Throwable)e);
        }
    }

    public boolean isIgnoreMessages() {
        return this.config.isIgnoreMessages();
    }

    public void setIgnoreMessages(boolean ignoreMessages) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setIgnoreMessages('" + ignoreMessages + "')"));
        }
        this.config.setIgnoreMessages(ignoreMessages);
    }

    public boolean isClientRegistered() {
        return this.config.isClientRegistered();
    }

    public void setClientRegistered(boolean clientRegistered) {
        this.config.setClientRegistered(clientRegistered);
    }

    public static void undeploy() {
        instance.shutDown();
        instance = null;
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                try {
                    MessageDistributor.this.queueConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                boolean setupOK = MessageDistributor.this.initialize();
                if (setupOK) {
                    log.info((Object)"Connection re-established");
                    return;
                }
                log.warn((Object)"Re-creating connection failed, retrying ...");
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

