/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventResponse;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.EngineUsage;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MITimestamp;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenancePingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceRegistrationLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceSessionLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceSessionRemote;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.ClientNotRegisteredException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.InterfaceNotActiveException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.exceptions.UnknownReasonException;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MaintenanceStockLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.EngineHoursResponseWrapper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ErrorCodes;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.ErrorWrapper;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.SuccessfulWrapper;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeLocal;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="MaintenanceSession")
@Remote(value={MaintenanceSessionRemote.class})
@Local(value={MaintenanceSessionLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MaintenanceSession")
@JndiRemoteBinding(remoteJndiBinding="rts/MaintenanceSession")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class MaintenanceSessionBean
implements MaintenanceSessionLocal,
MaintenanceSessionRemote {
    private static final Log log = LogFactory.getLog(MaintenanceSessionBean.class);
    private static MIConfiguration config = MIConfiguration.getInstance();
    @EJB
    private UnitFacadeLocal unitFacade;
    @EJB
    private EventFacadeLocal eventFacade;
    @EJB
    private StateSummaryFacadeLocal stateSummaryFacade;
    @EJB
    private MaintenanceRegistrationLocal registrationBean;
    @EJB
    private MaintenanceStockLocal stockBean;
    @EJB
    private MaintenancePingTimerLocal pingTimer;
    private static final long HOUR = 3600000L;
    private int decimals = config.getInt("engineHours.decimals");

    @PostConstruct
    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate()");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Business(viewType="both")
    public String parseXML(String xml) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Business(viewType="both")
    public Long getUnitId(String unitName) throws FinderException, InterfaceNotActiveException, ClientNotRegisteredException {
        this.checkActiveAndRegistered();
        UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitName);
        Long unitId = unitDTO.getUnitId();
        return unitId;
    }

    @Override
    @Business(viewType="both")
    public String getUnitName(long unitId) throws FinderException, InterfaceNotActiveException, ClientNotRegisteredException {
        this.checkActiveAndRegistered();
        UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitId);
        if (unitDTO != null) {
            return unitDTO.getUnitName();
        }
        throw new FinderException("could not find unit " + unitId);
    }

    @Override
    @Business(viewType="both")
    public boolean setServiceStatus(long unitId, boolean available, String reason, String remark) throws UnknownReasonException, UnitNotFoundException, ClientNotRegisteredException, InterfaceNotActiveException {
        this.checkActiveAndRegistered();
        if (this.unitFacade.getUnitDTO(unitId) == null) {
            throw new UnitNotFoundException(unitId);
        }
        int stateModelId = config.getInt("outOfServiceStateModel");
        Properties event = new Properties();
        event.setProperty("t", Long.toString(System.currentTimeMillis()));
        log.debug((Object)("timestamp: " + System.currentTimeMillis()));
        event.setProperty("u", Long.toString(unitId));
        log.debug((Object)("unitId: " + unitId));
        event.setProperty("m", Long.toString(stateModelId));
        log.debug((Object)("stateModel: " + stateModelId));
        long stateId = this.getStateId(available, reason);
        log.debug((Object)("stateId: " + stateId));
        event.setProperty("s", Long.toString(stateId));
        log.debug((Object)("stateId: " + stateId));
        if (remark != null && !remark.trim().equals("")) {
            event.setProperty("c", remark);
        }
        try {
            EventResponse eventResponse = this.eventFacade.handleEvent(event);
            log.debug((Object)("event response: " + eventResponse));
            return eventResponse.isEventResponse();
        }
        catch (NoSuchElementException e) {
            log.error((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    @Override
    @Business(viewType="both")
    public boolean setServiceStatus(long unitId, long stateId, String remark) throws UnknownReasonException, UnitNotFoundException, ClientNotRegisteredException, InterfaceNotActiveException {
        this.checkActiveAndRegistered();
        if (this.unitFacade.getUnitDTO(unitId) == null) {
            throw new UnitNotFoundException(unitId);
        }
        int stateModelId = config.getInt("outOfServiceStateModel");
        Properties event = new Properties();
        event.setProperty("t", Long.toString(System.currentTimeMillis()));
        log.debug((Object)("timestamp: " + System.currentTimeMillis()));
        event.setProperty("u", Long.toString(unitId));
        log.debug((Object)("unitId: " + unitId));
        event.setProperty("m", Long.toString(stateModelId));
        log.debug((Object)("stateModel: " + stateModelId));
        event.setProperty("s", Long.toString(stateId));
        log.debug((Object)("stateId: " + stateId));
        if (remark != null && !remark.trim().equals("")) {
            event.setProperty("c", remark);
        }
        try {
            EventResponse eventResponse = this.eventFacade.handleEvent(event);
            log.debug((Object)("event response: " + eventResponse));
            return eventResponse.isEventResponse();
        }
        catch (NoSuchElementException e) {
            log.error((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    @Override
    @Business(viewType="both")
    public boolean setServiceStatus(String unitName, boolean available, String reason, String remark) throws UnknownReasonException, UnitNotFoundException, ClientNotRegisteredException, InterfaceNotActiveException {
        this.checkActiveAndRegistered();
        try {
            UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitName);
            long unitId = unitDTO.getUnitId();
            return this.setServiceStatus(unitId, available, reason, remark);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new UnitNotFoundException(unitName);
        }
    }

    private long getStateId(boolean available, String reason) throws UnknownReasonException {
        if (available) {
            return config.getInt("operative");
        }
        if (reason == null) {
            throw new UnknownReasonException(reason);
        }
        String[] reasons = config.getStringArray("reasons");
        for (int i = 0; i < reasons.length; ++i) {
            String[] parts;
            if (reasons[i] == null || !reasons[i].contains(":") || (parts = reasons[i].split(":")).length != 2) continue;
            parts[0] = parts[0].trim();
            parts[1] = parts[1].trim();
            if (!reason.equals(parts[0])) continue;
            try {
                return Long.parseLong(parts[1]);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("cannot parse value for reason " + parts[0]));
            }
        }
        log.warn((Object)("reason (" + reason + ") is unknown."));
        throw new UnknownReasonException(reason);
    }

    private String createEngineHoursResponse(long msgId, Long unitId, MITimestamp startTime, MITimestamp endTime) throws ClientNotRegisteredException {
        EngineUsage engineUsage;
        try {
            engineUsage = this.getEngineUsage(unitId, startTime, endTime);
        }
        catch (UnitNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
            return this.createErrorMessage(msgId, ErrorCodes.UnitNotFound, Long.toString(unitId));
        }
        catch (InterfaceNotActiveException e) {
            log.warn((Object)"runs into", (Throwable)e);
            return this.createErrorMessage(msgId, ErrorCodes.InterfaceNotActive, "");
        }
        try {
            UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitId);
            String unitName = unitDTO.getUnitName();
            EngineHoursResponseWrapper engineHoursResposeWrapper = new EngineHoursResponseWrapper(engineUsage, unitId, unitName);
            engineHoursResposeWrapper.setMsgId(msgId);
            return engineHoursResposeWrapper.toString();
        }
        catch (JAXBException e) {
            log.error((Object)"runs into", (Throwable)e);
            return this.createErrorMessage(msgId, ErrorCodes.XMLResponse, e.getCause().getMessage());
        }
    }

    private String createSuccessResponse(long msgId, boolean successful) {
        return new SuccessfulWrapper(msgId, successful).toString();
    }

    private String createErrorMessage(long msgId, ErrorCodes errorCode, String detail) {
        return new ErrorWrapper(msgId, errorCode, detail).toString();
    }

    private double round(double number, int decimals) {
        double factor = Math.pow(10.0, decimals);
        return (double)Math.round(number * factor) / factor;
    }

    @Override
    @Business(viewType="both")
    public EngineUsage getEngineUsage(long unitId, MITimestamp from, MITimestamp until) throws UnitNotFoundException, ClientNotRegisteredException, InterfaceNotActiveException {
        Long durationNecesary;
        this.checkActiveAndRegistered();
        if (this.unitFacade.getUnitDTO(unitId) == null) {
            throw new UnitNotFoundException(unitId);
        }
        log.debug((Object)("getEngineUseage " + unitId));
        Long minBeginTime = this.stateSummaryFacade.getMinBeginTime(unitId);
        if (minBeginTime == null) {
            minBeginTime = 0L;
        }
        log.debug((Object)("minBeginTime: " + minBeginTime));
        if (from == null) {
            from = new MITimestamp(minBeginTime);
        }
        if (from.getTimestamp() < minBeginTime) {
            from.setTimestamp(minBeginTime);
        }
        if (until == null) {
            until = new MITimestamp(System.currentTimeMillis());
        }
        if (until.getTimestamp() > System.currentTimeMillis() || until.getTimestamp() == 0L) {
            until.setTimestamp(System.currentTimeMillis());
        }
        if ((durationNecesary = this.stateSummaryFacade.getStateSummaryDuration(unitId, 0, 2010, 2012, from.getTimestamp(), until.getTimestamp())) == null) {
            durationNecesary = 0L;
        }
        log.debug((Object)("duration runs necessary: " + durationNecesary));
        Long durationUnNecesary = this.stateSummaryFacade.getStateSummaryDuration(unitId, 0, 2010, 2013, from.getTimestamp(), until.getTimestamp());
        if (durationUnNecesary == null) {
            durationUnNecesary = 0L;
        }
        log.debug((Object)("duration runs unnecessary: " + durationUnNecesary));
        double hours = (double)(durationNecesary + durationUnNecesary) / 3600000.0;
        hours = this.round(hours, this.decimals);
        log.debug((Object)("end getEngineUseage " + unitId));
        return new EngineUsage(hours, from, until);
    }

    @Override
    @Business(viewType="both")
    public EngineUsage getEngineUsage(String unitName, MITimestamp from, MITimestamp until) throws UnitNotFoundException, ClientNotRegisteredException, InterfaceNotActiveException {
        this.checkActiveAndRegistered();
        try {
            UnitDTO unitDTO = this.unitFacade.getUnitDTO(unitName);
            long unitId = unitDTO.getUnitId();
            return this.getEngineUsage(unitId, from, until);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new UnitNotFoundException(unitName);
        }
    }

    @Override
    @Business(viewType="both")
    public void register(long lastNotifyId) throws TOWhileSyncException, InterfaceNotActiveException {
        if (!this.isMaintenanceActive()) {
            throw new InterfaceNotActiveException();
        }
        this.registrationBean.register(lastNotifyId);
    }

    @Override
    @Business(viewType="both")
    public void unregister() throws TOWhileSyncException, ClientNotRegisteredException, InterfaceNotActiveException {
        this.checkActiveAndRegistered();
        this.registrationBean.unregister();
    }

    @Override
    @Business(viewType="both")
    public void ping() {
        this.pingTimer.ping();
    }

    @Override
    @Business(viewType="both")
    public void requestNotifyStock(long from, long until) throws ClientNotRegisteredException, InterfaceNotActiveException {
        this.checkActiveAndRegistered();
        this.stockBean.requestNotifyStock(from, until);
    }

    private void checkActiveAndRegistered() throws InterfaceNotActiveException, ClientNotRegisteredException {
        if (!this.isMaintenanceActive()) {
            throw new InterfaceNotActiveException();
        }
        if (!config.isClientRegistered()) {
            throw new ClientNotRegisteredException();
        }
    }

    @Override
    @Business(viewType="both")
    public boolean isMaintenanceActive() {
        return config.isMaintenanceActive();
    }
}

