/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenanceMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenancePingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.MaintenancePingTimerRemote;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.notify.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.maintenance.xml.PingWrapper;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RunAs;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="MaintenancePingTimer")
@Remote(value={MaintenancePingTimerRemote.class})
@Local(value={MaintenancePingTimerLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MaintenancePingTimer")
@JndiRemoteBinding(remoteJndiBinding="rts/MaintenancePingTimer")
@SecurityDomain(value="rts")
@RunAs(value="nobody")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class MaintenancePingTimerBean
implements MaintenancePingTimerLocal,
MaintenancePingTimerRemote,
TimedObject {
    private static final Log log = LogFactory.getLog(MaintenancePingTimerBean.class);
    private MIConfiguration config = MIConfiguration.getInstance();
    private static final String INFO = "PingTimer Maintenance";
    private Timer timer = null;
    private TimerService timerService;
    @EJB
    private MaintenanceMessageSenderLocal messageSender = null;
    @Resource
    private SessionContext sessionContext;
    private final int MAX_ERROR_COUNT = 3;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.timerService = this.sessionContext.getTimerService();
        log.debug((Object)("timerService: " + this.timerService));
        log.debug((Object)("this: " + this));
    }

    @Override
    @Business(viewType="local")
    public void ejbRemove() {
        log.info((Object)"ejbReomve() invoked in BasicDataPingTimerBean");
    }

    @Override
    @Business(viewType="both")
    public void createTimer(int interval) {
        log.debug((Object)"createTimer() in maintenancePingTimerBean");
        try {
            log.debug((Object)("timerService: " + this.timerService));
            this.timer = this.timerService.createTimer(1000L * (long)interval, 1000L * (long)interval, (Serializable)((Object)INFO));
            log.debug((Object)("this: " + this));
            log.debug((Object)("this.timer: " + this.timer));
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    @Override
    @Business(viewType="both")
    public void cancelOldTimers() {
        log.debug((Object)"cancelOldTimers()s in MaintenancePingTimerBean");
        Collection timers = this.timerService.getTimers();
        for (Timer tempTimer : timers) {
            if (!INFO.equals(tempTimer.getInfo())) continue;
            tempTimer.cancel();
        }
    }

    @Override
    @Business(viewType="both")
    public void stop() {
        log.debug((Object)"stop ping timer");
        log.debug((Object)("this: " + this));
        if (this.timer != null) {
            try {
                this.timer.cancel();
                log.debug((Object)"pingTimer of MaintenanceInterface stopped");
            }
            catch (NoSuchObjectLocalException e) {
                log.debug((Object)"timer is already canceled");
            }
        }
        this.cancelOldTimers();
    }

    @Override
    @Business(viewType="local")
    @PermitAll
    @Timeout
    public void ejbTimeout(Timer timer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbTimeout() " + this));
            if (this.timer != timer) {
                log.debug((Object)("timer:      " + timer));
                log.debug((Object)("this.timer: " + this.timer));
            }
        }
        this.sendPingMessage();
    }

    @PermitAll
    protected void sendPingMessage() {
        log.trace((Object)"send ping ...");
        PingWrapper ping = new PingWrapper();
        log.trace((Object)"ping created");
        this.messageSender.sendTextMessage(ping.toString());
        log.debug((Object)"ping message sent");
        log.debug((Object)"check if maintenance interface has received ping");
        if (!this.config.isPingReceived()) {
            this.config.incPingErrorCount();
            log.debug((Object)("sendPingMessage() - errorCount: " + this.config.getPingErrorCount()));
        } else {
            this.config.setPingErrorCount(0);
        }
        if (this.config.getPingErrorCount() >= 3) {
            log.debug((Object)"errorCount >= MAX_ERROR_COUNT -> reconnect");
            this.unregisterClient();
        }
        this.config.setPingReceived(false);
    }

    @Override
    @Business(viewType="both")
    public void ping() {
        log.debug((Object)"received ping");
        this.config.setPingReceived(true);
        this.config.setPingErrorCount(0);
    }

    @Override
    @Business(viewType="both")
    public void unregisterClient() {
        log.info((Object)"unregisterClient()");
        MessageDistributor.getInstance().setIgnoreMessages(true);
        this.stop();
        this.config.setPingErrorCount(0);
        this.messageSender.removeAllMessages();
        this.config.setClientRegistered(false);
        log.debug((Object)"Client is un-registered.");
    }
}

