/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.fis;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.fis.FISFlight;
import de.proveo.wwt.datamodel.fis.StandStateCache;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFlightDAO;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFlightValue;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISMapFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISMapFacadeRemote;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateCacheValue;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateFacadeLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;

@Stateless(name="FISMapFacade")
@Remote(value={FISMapFacadeRemote.class})
@Local(value={FISMapFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="wwt/FISMapFacade")
@JndiRemoteBinding(remoteJndiBinding="wwt/FISMapFacade")
public class FISMapFacadeBean
implements FISMapFacadeLocal,
FISMapFacadeRemote {
    private static final Log log = LogFactory.getLog(FISMapFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager em;
    private FISFlightDAO fisFlightDAO;
    private Mapper mapper;
    @EJB
    private StandStateFacadeLocal standStateFacade;
    @EJB
    private InformantFacadeLocal informantFacade;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.fisFlightDAO = FISFlightDAO.newInstance(this.em);
        this.mapper = DozerBeanMapperSingletonWrapper.getInstance();
    }

    @Override
    @Business(viewType="both")
    public List<StandStateCacheValue> findAllStandStateCachesWithFlights() {
        List<StandStateCache> standStates = this.standStateFacade.findAllStandStatesCache();
        ArrayList<StandStateCacheValue> standStateCacheValues = new ArrayList<StandStateCacheValue>();
        for (StandStateCache c : standStates) {
            StandStateCacheValue standStateCacheValue = (StandStateCacheValue)this.mapper.map((Object)c, StandStateCacheValue.class);
            if (c.getInbFlight() != null) {
                this.addFlightsToStandStateCacheValue(standStateCacheValue, c.getInbFlight());
            }
            standStateCacheValues.add(standStateCacheValue);
        }
        return standStateCacheValues;
    }

    @Override
    @Business(viewType="both")
    public void sendStandEvent(FISFlight flight) {
        String method = "sendStandEvent(): ";
        log.debug((Object)(method + "Flight: " + flight));
        Collection<StandStateCacheValue> standStates = flight.getCurrentStandStates().values();
        if (standStates.size() < 1) {
            log.debug((Object)(method + "no CurrentStandStates for flight '" + flight.getUniqueFlightNumber() + "' on stand '" + flight.getParkingStand() + "'"));
        }
        for (StandStateCacheValue standStateCacheValue : standStates) {
            standStateCacheValue = this.addFlightsToStandStateCacheValue(standStateCacheValue, flight);
            log.debug((Object)(method + "found StandStateCacheValue: " + standStateCacheValue));
            try {
                SerializableEventWrapper eventWrapper = new SerializableEventWrapper((Serializable)standStateCacheValue);
                eventWrapper.set_typeOfEvent("StandEvent");
                this.informantFacade.notify(eventWrapper, "StandEvent");
                log.debug((Object)(method + "Event sent to JMS!"));
            }
            catch (Exception e) {
                log.error((Object)(method + "runs into"), (Throwable)e);
            }
        }
    }

    private FISFlight findPairFlight(FISFlight flight) {
        List<Object> pairFlights = new ArrayList();
        if (flight.getMovementType().equals("A") || flight.getMovementType().equals("N")) {
            pairFlights = this.fisFlightDAO.findOutboundByPKey(flight.getPairKey());
        }
        if (flight.getMovementType().equals("D") || flight.getMovementType().equals("F")) {
            pairFlights = this.fisFlightDAO.findInboundByPKey(flight.getPairKey());
        }
        if (pairFlights.size() == 0) {
            return null;
        }
        if (pairFlights.size() > 1) {
            log.warn((Object)("flight " + flight.getUniqueFlightNumber() + " has more than one pair flights: " + pairFlights.size()));
        }
        return (FISFlight)pairFlights.get(0);
    }

    private StandStateCacheValue addFlightsToStandStateCacheValue(StandStateCacheValue standStateCacheValue, FISFlight flight) {
        FISFlight pairFlight = this.findPairFlight(flight);
        if (flight.isInbound()) {
            standStateCacheValue.setInbFlight(this.convertFlightToFlightValue(flight));
            standStateCacheValue.setOutbFlight(this.convertFlightToFlightValue(pairFlight));
        } else {
            standStateCacheValue.setOutbFlight(this.convertFlightToFlightValue(flight));
            standStateCacheValue.setInbFlight(this.convertFlightToFlightValue(pairFlight));
        }
        return standStateCacheValue;
    }

    private FISFlightValue convertFlightToFlightValue(FISFlight flight) {
        if (flight == null) {
            return null;
        }
        FISFlightValue value = (FISFlightValue)this.mapper.map((Object)flight, FISFlightValue.class);
        value.setCurrentStandStates(flight.getCurrentStandStates());
        value.setPreviousStandStates(flight.getPreviousStandStates());
        return value;
    }
}

