/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.fis;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.fis.FISFlight;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFacadeRemote;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFlightDAO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="FISFacade")
@Remote(value={FISFacadeRemote.class})
@Local(value={FISFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="wwt/FISFacade")
@JndiRemoteBinding(remoteJndiBinding="wwt/FISFacade")
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class FISFacadeBean
implements FISFacadeLocal,
FISFacadeRemote {
    private static final Log log = LogFactory.getLog(FISFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager em;
    private FISFlightDAO fisFlightDAO;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.fisFlightDAO = FISFlightDAO.newInstance(this.em);
    }

    @Override
    @Business(viewType="both")
    public List<FISFlight> findFlightsByFLNandST(String flightNumber, long scheduledTime) {
        List<FISFlight> flightList = this.fisFlightDAO.findFlightsByFLNandST(flightNumber, scheduledTime);
        return flightList;
    }

    @Override
    @Business(viewType="both")
    public List<FISFlight> findFlightsByFLNandSTandMOVTYPE(String flightNumber, long scheduledTime, String movementType) {
        List<FISFlight> flightList = this.fisFlightDAO.findFlightsByFLNandSTandMOVTYPE(flightNumber, scheduledTime, movementType);
        return flightList;
    }

    @Override
    @Business(viewType="both")
    public List<FISFlight> findFlightsByUFN(String uniqueFlightNumber) {
        return this.fisFlightDAO.findFlightsByUFN(uniqueFlightNumber);
    }

    @Override
    @Business(viewType="both")
    public FISFlight findCurrentFlightByUFN(String uniqueFlightNumber) {
        List<FISFlight> flightList = this.fisFlightDAO.findCurrentFlightByUFN(uniqueFlightNumber);
        if (flightList.isEmpty()) {
            return null;
        }
        if (flightList.size() == 1) {
            return flightList.get(0);
        }
        log.debug((Object)("findLatestFlightByUAFT " + uniqueFlightNumber + " returns more than one flight: " + flightList.size()));
        return flightList.get(flightList.size() - 1);
    }

    @Override
    @Business(viewType="both")
    public FISFlight findPairFlight(FISFlight flight) {
        List<Object> pairFlights = new ArrayList();
        if (flight.getMovementType().equals("A") || flight.getMovementType().equals("N")) {
            pairFlights = this.fisFlightDAO.findOutboundByPKey(flight.getPairKey());
        }
        if (flight.getMovementType().equals("D") || flight.getMovementType().equals("F")) {
            pairFlights = this.fisFlightDAO.findInboundByPKey(flight.getPairKey());
        }
        if (pairFlights.isEmpty()) {
            return null;
        }
        if (pairFlights.size() > 1) {
            log.warn((Object)("flight " + flight.getUniqueFlightNumber() + " has more than one pair flights: " + pairFlights.size()));
        }
        return (FISFlight)pairFlights.get(0);
    }

    @Override
    @Business(viewType="both")
    public FISFlight findOldTowing(FISFlight newTowing) {
        log.debug((Object)("findOldTowing(): " + newTowing));
        FISFlight oldTowing = null;
        List<FISFlight> towings = this.fisFlightDAO.findCurrentFlightByLFLNAndLSTAndMovType(newTowing.getLinkedFlightNumber(), newTowing.getLinkedScheduledTime(), newTowing.getMovementType());
        if (towings.size() > 0) {
            log.debug((Object)("found " + towings.size() + " old towings"));
            for (FISFlight towing : towings) {
                log.debug((Object)("towing: " + towing));
                if (newTowing.getFlightNumber() != null && !newTowing.getFlightNumber().equals(towing.getFlightNumber()) || newTowing.getLinkedFlightNumber() != null && !newTowing.getLinkedFlightNumber().equals(towing.getLinkedFlightNumber()) || newTowing.getLinkedScheduledTime() != towing.getLinkedScheduledTime()) break;
                log.debug((Object)"old towing found!");
                oldTowing = towing;
            }
        }
        return oldTowing;
    }

    @Override
    @Business(viewType="both")
    public boolean saveFlight(FISFlight flight, FISFlight oldFlight) {
        return this.saveFlight(flight, oldFlight, false);
    }

    @Override
    @Business(viewType="both")
    public boolean saveFlight(FISFlight flight, FISFlight oldFlight, boolean debug) {
        boolean flightSaved = false;
        Stopwatch stopwatch = new Stopwatch(FISFacadeBean.class, "saveFlight");
        stopwatch.start("saveFlight");
        if (oldFlight == null) {
            log.debug((Object)"old flight == null -> save new flight");
            this.fisFlightDAO.createEntity(flight);
            flightSaved = true;
        } else if (!flight.equalsWithoutIdAndRecvTime(oldFlight)) {
            log.debug((Object)"oldFlight !equals flight -> update flight");
            this.fisFlightDAO.createEntity(flight);
            oldFlight.setCurrent(false);
            this.fisFlightDAO.updateEntity(oldFlight);
            flightSaved = true;
        } else {
            log.debug((Object)"oldFlight equals to flight");
        }
        if (flight.getSequenceId() == null && flight.getMovementType().equals("A")) {
            flight.setSequenceId(flight.getId());
            this.fisFlightDAO.updateEntity(flight);
            flightSaved = true;
        }
        stopwatch.stop("saveFlight", true);
        return flightSaved;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean saveFlightInNewTX(FISFlight flight, FISFlight oldFlight) {
        Stopwatch stopwatch = new Stopwatch(FISFacadeBean.class, "saveFlight");
        stopwatch.start("saveFlight");
        boolean flightSaved = this.saveFlight(flight, oldFlight);
        this.flushEntityManager();
        stopwatch.stop("saveFlight", true);
        return flightSaved;
    }

    @Override
    @Business(viewType="both")
    public void flushEntityManager() {
        log.debug((Object)"flushEntityManager()");
        this.em.flush();
    }

    @Override
    @Business(viewType="both")
    public List<FISFlight> findCurrentSequence(long sequenceId) {
        return this.fisFlightDAO.findCurrentSequence(sequenceId);
    }

    @Override
    @Business(viewType="both")
    public List<FISFlight> findPairInbound(long sequenceId, long scheduleTime) {
        return this.fisFlightDAO.findPairInbound(sequenceId, scheduleTime);
    }

    @Override
    @Business(viewType="both")
    public FISFlight findFlightById(long id) {
        return (FISFlight)this.fisFlightDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public List<FISFlight> findInboundByPKey(String pairKey) {
        return this.fisFlightDAO.findInboundByPKey(pairKey);
    }

    @Override
    @Business(viewType="both")
    public List<FISFlight> findOutboundByPKey(String pairKey) {
        return this.fisFlightDAO.findOutboundByPKey(pairKey);
    }
}

