/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.accessControl;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UserNotFoundException;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.ACIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.AccessControlSessionLocal;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.InterfaceNotActiveException;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.XMLResponseBuilderLocal;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.XMLResponseBuilderRemote;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.request.AccessControlRequest;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.response.AccessControlResponse;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.response.ObjectFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="XMLResponseBuilder")
@Local(value={XMLResponseBuilderLocal.class})
@Remote(value={XMLResponseBuilderRemote.class})
@JndiLocalBinding(localJndiBinding="rts/XMLResponseBuilder")
@JndiRemoteBinding(remoteJndiBinding="rts/XMLResponseBuilder")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class XMLResponseBuilderBean
implements XMLResponseBuilderLocal,
XMLResponseBuilderRemote {
    private static final Log log = LogFactory.getLog(XMLResponseBuilderBean.class);
    private ACIConfiguration config = ACIConfiguration.getInstance();
    @EJB
    private AccessControlSessionLocal accessControlSessionBean;
    private boolean unitIdActive = false;
    private boolean unitNameActive = false;

    @PostConstruct
    public void initImpl() {
        this.unitIdActive = this.config.getBoolean("units.unitId.active");
        this.unitNameActive = this.config.getBoolean("units.unitName.active");
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.AddGroupResponse buildAddGroupResponse(String groupName, boolean groupAdded) {
        AccessControlResponse.AddGroupResponse addGroupResponse = new ObjectFactory().createAccessControlResponseAddGroupResponse();
        addGroupResponse.setGroupName(groupName);
        addGroupResponse.setGroupAdded(groupAdded);
        return addGroupResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.AddGroupResponse buildAddGroupResponse(String groupName, boolean groupAdded, String errorText) {
        AccessControlResponse.AddGroupResponse addGroupResponse = new ObjectFactory().createAccessControlResponseAddGroupResponse();
        addGroupResponse.setGroupName(groupName);
        addGroupResponse.setGroupAdded(groupAdded);
        addGroupResponse.setErrorText(errorText);
        return addGroupResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UpdateGroupResponse buildUpdateGroupResponse(String groupName, boolean updated) {
        AccessControlResponse.UpdateGroupResponse updateGroupResponse = new ObjectFactory().createAccessControlResponseUpdateGroupResponse();
        updateGroupResponse.setGroupName(groupName);
        updateGroupResponse.setGroupUpdated(updated);
        return updateGroupResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UpdateGroupResponse buildUpdateGroupResponse(String groupName, boolean updated, String errorText) {
        AccessControlResponse.UpdateGroupResponse updateGroupResponse = new ObjectFactory().createAccessControlResponseUpdateGroupResponse();
        updateGroupResponse.setGroupName(groupName);
        updateGroupResponse.setGroupUpdated(updated);
        updateGroupResponse.setErrorText(errorText);
        return updateGroupResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.RemoveGroupResponse buildRemoveGroupResponse(String groupName, boolean removed) {
        AccessControlResponse.RemoveGroupResponse removeGroupResponse = new ObjectFactory().createAccessControlResponseRemoveGroupResponse();
        removeGroupResponse.setGroupName(groupName);
        removeGroupResponse.setGroupRemoved(removed);
        return removeGroupResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.RemoveGroupResponse buildRemoveGroupResponse(String groupName, boolean removed, String errorText) {
        AccessControlResponse.RemoveGroupResponse removeGroupResponse = new ObjectFactory().createAccessControlResponseRemoveGroupResponse();
        removeGroupResponse.setGroupName(groupName);
        removeGroupResponse.setGroupRemoved(removed);
        removeGroupResponse.setErrorText(errorText);
        return removeGroupResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.GroupList buildGroupList(List<UseGroup> list) {
        log.debug((Object)("buildGroupList with " + list.size() + " groups"));
        ObjectFactory objectFactory = new ObjectFactory();
        AccessControlResponse.GroupList groupListObject = objectFactory.createAccessControlResponseGroupList();
        List<AccessControlResponse.GroupList.Group> groupList = groupListObject.getGroup();
        for (UseGroup useGroupValue : list) {
            AccessControlResponse.GroupList.Group group = objectFactory.createAccessControlResponseGroupListGroup();
            group.setGroupId(useGroupValue.getId());
            group.setName(useGroupValue.getName());
            group.setDescription(useGroupValue.getDescription());
            groupList.add(group);
        }
        return groupListObject;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.GroupList buildGroupList(List<UseGroup> list, String errorText) {
        AccessControlResponse.GroupList groupList = this.buildGroupList(list);
        groupList.setErrorText(errorText);
        return groupList;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.AddOperatorResponse buildAddOperatorResponse(String key, String personnelNumber, boolean operatorAdded) {
        AccessControlResponse.AddOperatorResponse addOperatorResponse = new ObjectFactory().createAccessControlResponseAddOperatorResponse();
        if (key != null && key.length() > 0) {
            addOperatorResponse.setKey(key);
        } else if (personnelNumber != null) {
            addOperatorResponse.setPersonnelNumber(personnelNumber);
        }
        addOperatorResponse.setOperatorAdded(operatorAdded);
        return addOperatorResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.AddOperatorResponse buildAddOperatorResponse(String key, String personnelNumber, boolean operatorAdded, String errorText) {
        AccessControlResponse.AddOperatorResponse addOperatorResponse = new ObjectFactory().createAccessControlResponseAddOperatorResponse();
        if (key != null && key.length() > 0) {
            addOperatorResponse.setKey(key);
        } else if (personnelNumber != null) {
            addOperatorResponse.setPersonnelNumber(personnelNumber);
        }
        addOperatorResponse.setOperatorAdded(operatorAdded);
        addOperatorResponse.setErrorText(errorText);
        return addOperatorResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UpdateOperatorResponse buildUpdateOperatorResponse(String key, String personnelNumber, boolean updated) {
        AccessControlResponse.UpdateOperatorResponse updateOperatorResponse = new ObjectFactory().createAccessControlResponseUpdateOperatorResponse();
        if (key != null && key.length() > 0) {
            updateOperatorResponse.setKey(key);
        } else if (personnelNumber != null) {
            updateOperatorResponse.setPersonnelNumber(personnelNumber);
        }
        updateOperatorResponse.setOperatorUpdated(updated);
        return updateOperatorResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UpdateOperatorResponse buildUpdateOperatorResponse(String key, String personnelNumber, boolean updated, String errorText) {
        AccessControlResponse.UpdateOperatorResponse updateOperatorResponse = new ObjectFactory().createAccessControlResponseUpdateOperatorResponse();
        if (key != null && key.length() > 0) {
            updateOperatorResponse.setKey(key);
        } else if (personnelNumber != null) {
            updateOperatorResponse.setPersonnelNumber(personnelNumber);
        }
        updateOperatorResponse.setOperatorUpdated(updated);
        updateOperatorResponse.setErrorText(errorText);
        return updateOperatorResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.RemoveOperatorResponse buildRemoveOperatorResponse(String key, String personnelNumber, boolean removed) {
        AccessControlResponse.RemoveOperatorResponse removeOperatorResponse = new ObjectFactory().createAccessControlResponseRemoveOperatorResponse();
        if (key != null && key.length() > 0) {
            removeOperatorResponse.setKey(key);
        } else if (personnelNumber != null) {
            removeOperatorResponse.setPersonnelNumber(personnelNumber);
        }
        removeOperatorResponse.setOperatorRemoved(removed);
        return removeOperatorResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.RemoveOperatorResponse buildRemoveOperatorResponse(String key, String personnelNumber, boolean removed, String errorText) {
        AccessControlResponse.RemoveOperatorResponse removeOperatorResponse = new ObjectFactory().createAccessControlResponseRemoveOperatorResponse();
        if (key != null && key.length() > 0) {
            removeOperatorResponse.setKey(key);
        } else if (personnelNumber != null) {
            removeOperatorResponse.setPersonnelNumber(personnelNumber);
        }
        removeOperatorResponse.setOperatorRemoved(removed);
        removeOperatorResponse.setErrorText(errorText);
        return removeOperatorResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.OperatorList buildOperatorList(String groupName, List<UseUser> list) {
        log.debug((Object)("buildUserList with " + list.size() + " users"));
        ObjectFactory objectFactory = new ObjectFactory();
        AccessControlResponse.OperatorList operatorListObject = objectFactory.createAccessControlResponseOperatorList();
        operatorListObject.setGroupName(groupName);
        List<AccessControlResponse.OperatorList.Operator> operatorList = operatorListObject.getOperator();
        Iterator<UseUser> it = list.iterator();
        while (it.hasNext()) {
            AccessControlResponse.OperatorList.Operator.GroupList operatorGroupList = objectFactory.createAccessControlResponseOperatorListOperatorGroupList();
            UseUser useUserValue = it.next();
            AccessControlResponse.OperatorList.Operator operator = objectFactory.createAccessControlResponseOperatorListOperator();
            operator.setName(useUserValue.getName());
            operator.setDescription(useUserValue.getDescription());
            operator.setKey(useUserValue.getKeyId());
            operator.setPersonnelNumber(useUserValue.getPersonalNumber());
            for (UseGroup useGroup : useUserValue.getUseGroups()) {
                operatorGroupList.getGroupName().add(useGroup.getName());
            }
            operator.setGroupList(operatorGroupList);
            operatorList.add(operator);
        }
        return operatorListObject;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.OperatorList buildOperatorList(String groupName, List<UseUser> list, String errorText) {
        AccessControlResponse.OperatorList operatorList = this.buildOperatorList(groupName, list);
        operatorList.setErrorText(errorText);
        return operatorList;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.AddUnitPermissionResponse buildAddUnitPermissionResponse(AccessControlRequest.AddUnitPermission addUnitPermission, boolean addedUnitPermission) {
        AccessControlResponse.AddUnitPermissionResponse addUnitPermissionResponse = new ObjectFactory().createAccessControlResponseAddUnitPermissionResponse();
        String key = addUnitPermission.getKey();
        String personnelNumber = addUnitPermission.getPersonnelNumber();
        if (key != null && key.length() > 0) {
            addUnitPermissionResponse.setKey(key);
        } else if (personnelNumber != null && personnelNumber.length() > 0) {
            addUnitPermissionResponse.setPersonnelNumber(personnelNumber);
        }
        String unitName = addUnitPermission.getUnitName();
        Long unitId = addUnitPermission.getUnitId();
        if (unitName != null && unitName.length() > 0) {
            addUnitPermissionResponse.setUnitName(unitName);
        } else if (unitId != null && unitId > 0L) {
            addUnitPermissionResponse.setUnitId(unitId);
        }
        addUnitPermissionResponse.setPermissionAdded(addedUnitPermission);
        return addUnitPermissionResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.AddUnitPermissionResponse buildAddUnitPermissionResponse(AccessControlRequest.AddUnitPermission addUnitPermission, boolean addedUnitPermission, String errorText) {
        AccessControlResponse.AddUnitPermissionResponse addUnitPermissionResponse = new ObjectFactory().createAccessControlResponseAddUnitPermissionResponse();
        String key = addUnitPermission.getKey();
        String personnelNumber = addUnitPermission.getPersonnelNumber();
        if (key != null && key.length() > 0) {
            addUnitPermissionResponse.setKey(key);
        } else if (personnelNumber != null && personnelNumber.length() > 0) {
            addUnitPermissionResponse.setPersonnelNumber(personnelNumber);
        }
        String unitName = addUnitPermission.getUnitName();
        Long unitId = addUnitPermission.getUnitId();
        if (unitName != null && unitName.length() > 0) {
            addUnitPermissionResponse.setUnitName(unitName);
        } else if (unitId != null && unitId > 0L) {
            addUnitPermissionResponse.setUnitId(unitId);
        }
        addUnitPermissionResponse.setPermissionAdded(addedUnitPermission);
        addUnitPermissionResponse.setErrorText(errorText);
        return addUnitPermissionResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.RemoveUnitPermissionResponse buildRemoveUnitPermissionResponse(AccessControlRequest.RemoveUnitPermission removeUnitPermission, boolean removedUnitPermission) {
        AccessControlResponse.RemoveUnitPermissionResponse removeUnitPermissionResponse = new ObjectFactory().createAccessControlResponseRemoveUnitPermissionResponse();
        String key = removeUnitPermission.getKey();
        String personnelNumber = removeUnitPermission.getPersonnelNumber();
        if (key != null && key.length() > 0) {
            removeUnitPermissionResponse.setKey(key);
        } else if (personnelNumber != null && personnelNumber.length() > 0) {
            removeUnitPermissionResponse.setPersonnelNumber(personnelNumber);
        }
        String unitName = removeUnitPermission.getUnitName();
        Long unitId = removeUnitPermission.getUnitId();
        if (unitName != null && unitName.length() > 0) {
            removeUnitPermissionResponse.setUnitName(unitName);
        } else if (unitId != null && unitId > 0L) {
            removeUnitPermissionResponse.setUnitId(unitId);
        }
        removeUnitPermissionResponse.setPermissionRemoved(removedUnitPermission);
        return removeUnitPermissionResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.RemoveUnitPermissionResponse buildRemoveUnitPermissionResponse(AccessControlRequest.RemoveUnitPermission removeUnitPermission, boolean removedUnitPermission, String errorText) {
        AccessControlResponse.RemoveUnitPermissionResponse removeUnitPermissionResponse = new ObjectFactory().createAccessControlResponseRemoveUnitPermissionResponse();
        String key = removeUnitPermission.getKey();
        String personnelNumber = removeUnitPermission.getPersonnelNumber();
        if (key != null && key.length() > 0) {
            removeUnitPermissionResponse.setKey(key);
        } else if (personnelNumber != null && personnelNumber.length() > 0) {
            removeUnitPermissionResponse.setPersonnelNumber(personnelNumber);
        }
        String unitName = removeUnitPermission.getUnitName();
        Long unitId = removeUnitPermission.getUnitId();
        if (unitName != null && unitName.length() > 0) {
            removeUnitPermissionResponse.setUnitName(unitName);
        } else if (unitId != null && unitId > 0L) {
            removeUnitPermissionResponse.setUnitId(unitId);
        }
        removeUnitPermissionResponse.setPermissionRemoved(removedUnitPermission);
        removeUnitPermissionResponse.setErrorText(errorText);
        return removeUnitPermissionResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UnitPermissionList buildUnitPermissionList(AccessControlRequest.GetUnitPermissionsForOperator request, List<UnitPermission> list) {
        log.debug((Object)("buildUnitPermissionList with " + list.size() + " unitPermissions"));
        ObjectFactory objectFactory = new ObjectFactory();
        AccessControlResponse.UnitPermissionList unitPermissionListObject = objectFactory.createAccessControlResponseUnitPermissionList();
        List<AccessControlResponse.UnitPermissionList.UnitPermission> unitPermissionList = unitPermissionListObject.getUnitPermission();
        Iterator<UnitPermission> it = list.iterator();
        HashMap<Long, UnitPermission> permissionsMap = new HashMap<Long, UnitPermission>();
        while (it.hasNext()) {
            UnitPermission unitPermissionValue = it.next();
            if (unitPermissionValue.getUnitId() != null) {
                permissionsMap.put(unitPermissionValue.getUnitId(), unitPermissionValue);
            }
            if (unitPermissionValue.getGroupId() == null) continue;
            for (Long unitId : this.accessControlSessionBean.getUnitsInGroup(unitPermissionValue.getGroupId())) {
                UnitPermission unitPermissionChild = new UnitPermission(unitPermissionValue);
                unitPermissionChild.setUnitId(unitId);
                permissionsMap.put(unitId, unitPermissionChild);
            }
        }
        Iterator it2 = permissionsMap.keySet().iterator();
        while (it2.hasNext()) {
            UnitPermission unitPermissionValue = (UnitPermission)permissionsMap.get(it2.next());
            AccessControlResponse.UnitPermissionList.UnitPermission unitPermission = objectFactory.createAccessControlResponseUnitPermissionListUnitPermission();
            try {
                Long unitId;
                Long userId = unitPermissionValue.getUseUserId();
                UseUser operator = null;
                if (userId != null) {
                    operator = this.accessControlSessionBean.getOperatorById(userId);
                }
                if ((unitId = unitPermissionValue.getUnitId()) != null) {
                    try {
                        if (this.unitNameActive) {
                            unitPermission.setUnitName(this.accessControlSessionBean.getUnitName(unitId));
                        }
                        if (this.unitIdActive) {
                            unitPermission.setUnitId(unitId);
                        }
                        unitPermissionList.add(unitPermission);
                    }
                    catch (UnitNotFoundException e) {
                        log.warn((Object)("unit not found: " + unitId));
                    }
                }
                String requestKey = request.getKey();
                String requestPersonnelNumber = request.getPersonnelNumber();
                if (operator != null && requestKey != null && requestKey.length() > 0) {
                    unitPermission.setKey(operator.getKeyId());
                }
                if (operator == null || requestPersonnelNumber == null || requestPersonnelNumber.length() <= 0) continue;
                unitPermission.setPersonnelNumber(operator.getPersonalNumber());
            }
            catch (UserNotFoundException e) {
                log.error((Object)("user with id " + unitPermissionValue.getUseUser().getId() + " not found"));
            }
            catch (InterfaceNotActiveException e) {
                log.warn((Object)"Access control interface is not active!");
            }
        }
        return unitPermissionListObject;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UnitPermissionList buildUnitPermissionList(AccessControlRequest.GetUnitPermissionsForOperator request, List<UnitPermission> list, String errorText) {
        AccessControlResponse.UnitPermissionList unitPermissionList = this.buildUnitPermissionList(request, list);
        unitPermissionList.setErrorText(errorText);
        return unitPermissionList;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UpdateGroupPermissionResponse buildUpdateGroupPermissionResponse(String useGroup, boolean updated, String errorText) {
        ObjectFactory objectFactory = new ObjectFactory();
        AccessControlResponse.UpdateGroupPermissionResponse updateGroupPermissionResponse = objectFactory.createAccessControlResponseUpdateGroupPermissionResponse();
        updateGroupPermissionResponse.setOperatorGroup(useGroup);
        updateGroupPermissionResponse.setPermissionsUpdated(updated);
        if (errorText != null) {
            updateGroupPermissionResponse.setErrorText(errorText);
        }
        return updateGroupPermissionResponse;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UnitList buildUnitList(UnitDTOList list) {
        List<Object> unitList;
        log.debug((Object)("buildUnitList with " + list.size() + " units"));
        ObjectFactory objectFactory = new ObjectFactory();
        AccessControlResponse.UnitList unitListObject = objectFactory.createAccessControlResponseUnitList();
        if (this.unitNameActive) {
            unitList = unitListObject.getUnitName();
            for (UnitDTO unitDTO : list) {
                unitList.add(unitDTO.getUnitName());
            }
        }
        if (this.unitIdActive) {
            unitList = unitListObject.getUnitId();
            for (UnitDTO unitDTO : list) {
                unitList.add(unitDTO.getUnitId());
            }
        }
        return unitListObject;
    }

    @Override
    @Business(viewType="both")
    public AccessControlResponse.UnitList buildUnitList(UnitDTOList list, String errorText) {
        AccessControlResponse.UnitList unitList = this.buildUnitList(list);
        unitList.setErrorText(errorText);
        return unitList;
    }
}

