/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.accessControl;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.exception.GroupNameAlreadyExistsException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.GroupNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UserNotFoundException;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.ACIConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.AccessControlSessionLocal;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.AccessControlSessionRemote;
import de.proveo.wwt.logic.ejb.interfaces.accessControl.InterfaceNotActiveException;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJB;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="AccessControlSession")
@Remote(value={AccessControlSessionRemote.class})
@Local(value={AccessControlSessionLocal.class})
@JndiLocalBinding(localJndiBinding="rts/AccessControlSession")
@JndiRemoteBinding(remoteJndiBinding="rts/AccessControlSession")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class AccessControlSessionBean
implements AccessControlSessionLocal,
AccessControlSessionRemote {
    private static final Log log = LogFactory.getLog(AccessControlSessionBean.class);
    ACIConfiguration config = ACIConfiguration.getInstance();
    @EJB
    private UseFacadeLocal useFacadeBean = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private UseUserAdminFacadeLocal useUserAdminFacade = null;
    @EJB
    private UseUserGroupAdminFacadeLocal useUserGroupAdminFacade = null;
    @Resource
    private SessionContext sessionContext;

    @PostConstruct
    public void ejbCreate() throws CreateException {
    }

    @Override
    @Business(viewType="both")
    public boolean addGroup(String name, String description) throws CreateException, InterfaceNotActiveException {
        this.login();
        this.useFacadeBean.addGroup(name, description, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean updateGroup(String name, String newName, String description) throws GroupNotFoundException, GroupNameAlreadyExistsException, InterfaceNotActiveException {
        this.login();
        this.useFacadeBean.updateGroup(name, newName, description, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean removeGroup(String name) throws GroupNotFoundException, RemoveException, InterfaceNotActiveException {
        this.login();
        List<UseUser> useUsers = this.useFacadeBean.getUsers(name);
        this.removeUnitPermissions(useUsers);
        this.removeUsers(useUsers);
        this.useFacadeBean.removeGroup(name, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public List<UseGroup> getAllGroups() throws InterfaceNotActiveException {
        this.login();
        return this.useUserGroupAdminFacade.getAllUseGroups();
    }

    @Override
    @Business(viewType="both")
    public boolean addOperator(String name, String description, List<String> groupNames, String key) throws CreateException, GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        this.useFacadeBean.addUser(name, description, groupNames, key, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean addOperator(String name, String description, String personalNumber, List<String> groupNames, String key) throws CreateException, GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        this.useFacadeBean.addUser(name, description, personalNumber, groupNames, key, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean updateOperator(String name, String description, List<String> groupNames, String key) throws UserNotFoundException, GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        this.useFacadeBean.updateUser(name, description, groupNames, key, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean updateOperator(String name, String description, String personalNumber, List<String> groupNames, String key) throws UserNotFoundException, GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        this.useFacadeBean.updateUser(name, description, personalNumber, groupNames, key, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean updateOperator(UseUser useUser) throws InterfaceNotActiveException {
        if (!this.isAccessControlActive()) {
            throw new InterfaceNotActiveException();
        }
        try {
            this.useUserAdminFacade.updateUseUser(useUser);
        }
        catch (DuplicateKeyException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean removeOperator(String key) throws RemoveException, UserNotFoundException, InterfaceNotActiveException {
        this.login();
        UseUser useUserValue = this.useFacadeBean.getUser(key);
        ArrayList<UseUser> al = new ArrayList<UseUser>();
        al.add(useUserValue);
        this.removeUnitPermissions(al);
        this.useFacadeBean.removeUserByExactKey(key, ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public boolean removeOperatorByPersonalNumber(String personalNumber) throws RemoveException, UserNotFoundException, InterfaceNotActiveException {
        this.login();
        log.info((Object)("removeOperatorByPersonalNumber('" + personalNumber + "')"));
        UseUser useUser = this.useFacadeBean.getUserByPersonalNumber(personalNumber);
        ArrayList<UseUser> al = new ArrayList<UseUser>();
        al.add(useUser);
        this.removeUnitPermissions(al);
        this.useUserAdminFacade.deleteUseUser(useUser.getId(), ModuleType.INTERFACE);
        return true;
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> getOperatorsInGroup(String groupName) throws GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        return this.useFacadeBean.getUsers(groupName);
    }

    @Override
    @Business(viewType="both")
    public UseUser getOperatorById(long userId) throws UserNotFoundException, InterfaceNotActiveException {
        this.login();
        return this.useFacadeBean.getUser(userId);
    }

    @Override
    @Business(viewType="both")
    public UseUser getOperatorByKey(String key) throws UserNotFoundException, InterfaceNotActiveException {
        this.login();
        return this.useFacadeBean.getUser(key);
    }

    @Override
    @Business(viewType="both")
    public UseUser getOperatorByKeyLike(String key) throws UserNotFoundException, InterfaceNotActiveException {
        if (!this.isAccessControlActive()) {
            throw new InterfaceNotActiveException();
        }
        UseUser useUser = null;
        List<UseUser> useUsers = this.useUserAdminFacade.findUseUserLikeKey(key);
        if (useUsers.size() == 1) {
            useUser = useUsers.get(0);
        } else {
            if (useUsers.size() == 0) {
                throw new UserNotFoundException("UseUser doesn't exist!");
            }
            if (useUsers.size() > 1) {
                throw new UserNotFoundException("More than 1 user found!");
            }
        }
        return useUser;
    }

    @Override
    @Business(viewType="both")
    public UseUser getDeletedOperatorByKey(String key) throws UserNotFoundException, InterfaceNotActiveException {
        if (!this.isAccessControlActive()) {
            throw new InterfaceNotActiveException();
        }
        return this.useUserAdminFacade.getDeletedByKey(key);
    }

    @Override
    @Business(viewType="both")
    public UseUser getOperatorByPersonalNumber(String personalNumber) throws UserNotFoundException, InterfaceNotActiveException {
        this.login();
        return this.useFacadeBean.getUserByPersonalNumber(personalNumber);
    }

    @Override
    @Business(viewType="both")
    public boolean addUnitPermission(String operatorKey, long unitId) throws UserNotFoundException, UnitNotFoundException, InterfaceNotActiveException {
        this.login();
        try {
            long userId = this.useFacadeBean.getUserIdByKey(operatorKey);
            this.unitFacade.setUnitPermissionForUseUser(userId, unitId, false, true);
            return true;
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (UnitNotFoundException e) {
            throw e;
        }
    }

    @Override
    @Business(viewType="both")
    public boolean addUnitPermissionByPersonalNumber(String personalNumber, long unitId) throws UserNotFoundException, UnitNotFoundException, InterfaceNotActiveException {
        this.login();
        log.debug((Object)("addUnitPermissionByPersonalNumber('" + personalNumber + "', '" + unitId + "')"));
        try {
            long userId = this.getUserIdByPersonalNumber(personalNumber);
            this.unitFacade.setUnitPermissionForUseUser(userId, unitId, false, true);
            return true;
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (UnitNotFoundException e) {
            throw e;
        }
    }

    private long getUserIdByPersonalNumber(String personalNumber) throws UserNotFoundException {
        UseUser userValue = this.useFacadeBean.getUserByPersonalNumber(personalNumber);
        long userId = userValue.getId();
        return userId;
    }

    @Override
    @Business(viewType="both")
    public boolean removeUnitPermission(String operatorKey, long unitId) throws UserNotFoundException, UnitNotFoundException, InterfaceNotActiveException {
        this.login();
        long userId = this.useFacadeBean.getUserIdByKey(operatorKey);
        return this.unitFacade.removeUnitPermissionForUseUser(userId, unitId, false, true);
    }

    @Override
    @Business(viewType="both")
    public boolean removeUnitPermissionByPersonalNumber(String personalNumber, long unitId) throws UserNotFoundException, UnitNotFoundException, InterfaceNotActiveException {
        this.login();
        long userId = this.getUserIdByPersonalNumber(personalNumber);
        return this.unitFacade.removeUnitPermissionForUseUser(userId, unitId, false, true);
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsForOperator(String operatorKey) throws UserNotFoundException, InterfaceNotActiveException {
        this.login();
        long userId = this.useFacadeBean.getUserIdByKey(operatorKey);
        ArrayList<UnitPermission> unitPermissions = this.unitFacade.getUnitPermissionsByUseUserId(userId);
        return unitPermissions;
    }

    @Override
    @Business(viewType="both")
    public ArrayList<UnitPermission> getUnitPermissionsByPersonnelNumber(String personnelNumber) throws UserNotFoundException, InterfaceNotActiveException {
        this.login();
        long userId = this.getUserIdByPersonalNumber(personnelNumber);
        ArrayList<UnitPermission> unitPermissions = this.unitFacade.getUnitPermissionsByUseUserId(userId);
        return unitPermissions;
    }

    @Override
    @Business(viewType="both")
    public List<Long> getUnitsInGroup(Long unitGroupId) {
        ArrayList<Long> groups = new ArrayList<Long>();
        groups.add(unitGroupId);
        ArrayList<Long> unitIds = new ArrayList<Long>();
        for (UnitDTO unitDTO : this.unitFacade.getBasicUnitsByUnitIds(groups, true)) {
            unitIds.add(unitDTO.getUnitId());
        }
        return unitIds;
    }

    @Override
    @Business(viewType="both")
    public UseGroup getOperatorGroupByName(String name) throws GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        UseGroup useGroup = this.useUserGroupAdminFacade.getUseGroupByName(name);
        if (useGroup == null) {
            throw new GroupNotFoundException("group not found:" + name);
        }
        return useGroup;
    }

    @Override
    @Business(viewType="both")
    public Long getUnitGroupIdByName(String name) throws GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        Long unitGroupId = this.unitFacade.getUnitIdByName(name);
        if (unitGroupId == null) {
            throw new GroupNotFoundException("UnitGroup with name " + name + " unknown!");
        }
        return unitGroupId;
    }

    @Override
    @Business(viewType="both")
    public void setUseGroupPermissions(long useGroupId, List<Long> unitGroupIds) throws InterfaceNotActiveException {
        this.login();
        log.debug((Object)("setUseGroupPermissions() - useGroupId: " + useGroupId));
        ArrayList<UnitPermission> unitPermissions = new ArrayList<UnitPermission>(unitGroupIds.size());
        for (Long unitGroupId : unitGroupIds) {
            log.debug((Object)("setUseGroupPermissions() - unitGroupId: " + unitGroupId));
            UnitPermission unitPermission = new UnitPermission();
            unitPermission.setUseGroupId(useGroupId);
            unitPermission.setGroupId(unitGroupId);
            unitPermissions.add(unitPermission);
        }
        this.unitFacade.setUseGroupPermissions(useGroupId, unitPermissions);
    }

    @Override
    @Business(viewType="both")
    public UnitDTOList getAllUnits() throws InterfaceNotActiveException {
        this.login();
        return this.unitFacade.getNonDeletedBasicUnits();
    }

    @Override
    @Business(viewType="both")
    public String getGroupName(long groupId) throws GroupNotFoundException, InterfaceNotActiveException {
        this.login();
        UseGroup useGroup = this.useUserGroupAdminFacade.getUseGroupById(groupId);
        if (useGroup == null) {
            throw new GroupNotFoundException("group not found:" + groupId);
        }
        return useGroup.getName();
    }

    @Override
    @Business(viewType="both")
    public String getOperatorName(long userId) throws UserNotFoundException, InterfaceNotActiveException {
        this.login();
        UseUser user = this.useFacadeBean.getUser(userId);
        return user.getName();
    }

    @Override
    @Business(viewType="both")
    public String getOperatorKey(long userId) throws UserNotFoundException, InterfaceNotActiveException {
        this.login();
        UseUser user = this.useFacadeBean.getUser(userId);
        return user.getKeyId();
    }

    @Override
    @Business(viewType="both")
    public String getUnitName(long unitId) throws UnitNotFoundException, InterfaceNotActiveException {
        this.login();
        UnitDTO unit = this.unitFacade.getUnitDTO(unitId);
        if (unit != null) {
            return unit.getUnitName();
        }
        throw new UnitNotFoundException(unitId);
    }

    @Override
    @Business(viewType="both")
    public long getUnitId(String unitName) throws UnitNotFoundException, InterfaceNotActiveException {
        this.login();
        try {
            UnitDTO unit = this.unitFacade.getUnitDTO(unitName);
            return unit.getUnitId();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new UnitNotFoundException(unitName);
        }
    }

    private void removeUnitPermissions(List<UseUser> useUsers) throws InterfaceNotActiveException {
        this.login();
        for (UseUser useUserValue : useUsers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove UnitPermissions for UseUser " + useUserValue.getName()));
            }
            this.unitFacade.setUseUserPermissions(useUserValue.getId(), new ArrayList<UnitPermission>(), false, true);
        }
    }

    private void removeUsers(List<UseUser> useUsers) throws InterfaceNotActiveException {
        this.login();
        for (UseUser user : useUsers) {
            long userId = user.getId();
            this.useUserAdminFacade.deleteUseUser(userId, ModuleType.INTERFACE);
        }
    }

    @Override
    @Business(viewType="both")
    public boolean isAccessControlActive() {
        return this.config.isAccessControlActive();
    }

    private void login() throws InterfaceNotActiveException {
        if (!this.isAccessControlActive()) {
            throw new InterfaceNotActiveException();
        }
    }
}

