/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.accessControl;

import de.proveo.rts.configuration.interfaces.aci.ACIConfigurationServiceMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.service.ServiceInstantiationException;
import de.proveo.util.service.ServiceNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.interfaces.InterfaceConfiguration;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ACIConfiguration
extends InterfaceConfiguration {
    private static final Log log = LogFactory.getLog(ACIConfiguration.class);
    private static final ACIConfiguration INSTANCE = new ACIConfiguration();
    private static ConfigurationClient configuration = new ConfigurationClient();
    private static ACIConfigurationServiceMBean accessControlConfigurationServiceMBean;
    public static final String ADD_GROUP_ERROR = "addGroupError";
    public static final String UPDATE_GROUP_ERROR = "updateGroupError";
    public static final String DELETE_GROUP_ERROR = "deleteGroupError";
    public static final String GROUP_NOT_FOUND_ERROR = "GroupNotFoundError";
    public static final String OPERATOR_NOT_FOUND_ERROR = "operatorNotFoundError";
    public static final String ADD_OPERATOR_ERROR = "addOperatorError";
    public static final String DELETE_OPERATOR_ERROR = "deleteOperatorError";
    public static final String UNIT_NOT_FOUND_ERROR = "unitNotFoundError";
    public static final String SERVER_CONNECTION_ERROR = "serverConnectionError";
    public static final String REMOTE_ERROR = "remoteError";
    public static final String MARSHAL_ERROR = "marshalError";
    private final String PREFIX_NAME = "accessControlInterfacePrefix";
    private final String DEFAULT_PREFIX = "de.proveo.aci.";
    private String prefix = null;

    private ACIConfiguration() {
        this.init();
    }

    public static ACIConfiguration getInstance() {
        return INSTANCE;
    }

    @Override
    public String getString(String key) {
        try {
            return configuration.getParameter(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return "";
    }

    @Override
    public int getInt(String key) {
        try {
            return configuration.getInteger(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return 0;
    }

    @Override
    public double getDouble(String key) {
        try {
            return Double.parseDouble(configuration.getParameter(this.getPrefix() + key));
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return 0.0;
    }

    @Override
    public String[] getStringArray(String key) {
        try {
            return configuration.getParameterArray(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return new String[0];
    }

    @Override
    public long[] getLongArray(String key) {
        try {
            return configuration.getLongArray(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return new long[0];
    }

    @Override
    public boolean getBoolean(String key) {
        try {
            return configuration.getBoolean(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return false;
    }

    public boolean isAccessControlActive() {
        return accessControlConfigurationServiceMBean.isAccessControlActive();
    }

    @Override
    public boolean isInterfaceActive() {
        return this.isAccessControlActive();
    }

    @Override
    protected String getPrefix() {
        if (this.prefix == null) {
            try {
                this.prefix = configuration.getParameter("accessControlInterfacePrefix");
            }
            catch (RemoteException e) {
                log.error((Object)"runs into", (Throwable)e);
                this.prefix = "de.proveo.aci.";
            }
            catch (ConfigurationParameterNotFoundException e) {
                log.warn((Object)"Could not find parameter accessControlInterfacePrefix. Use default prefix de.proveo.aci.");
                this.prefix = "de.proveo.aci.";
            }
        }
        return this.prefix;
    }

    @Override
    protected void init() {
        try {
            accessControlConfigurationServiceMBean = (ACIConfigurationServiceMBean)ServiceFactory.getInstance().getService(ACIConfigurationServiceMBean.class);
        }
        catch (ServiceNotFoundException e) {
            log.error((Object)"init runs into", (Throwable)e);
        }
        catch (ServiceInstantiationException e) {
            log.error((Object)"init runs into", (Throwable)e);
        }
    }
}

